/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.Objects;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TouchListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_rectangle_int_t;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.GtkWidgetClass;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk3.GdkEventCrossing;
import org.eclipse.swt.internal.gtk3.GdkEventFocus;
import org.eclipse.swt.internal.gtk3.GdkEventMotion;
import org.eclipse.swt.internal.gtk3.GdkWindowAttr;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    static final boolean DISABLE_EMOJI = Boolean.getBoolean("SWT_GTK_INPUT_HINT_NO_EMOJI");
    long fixedHandle;
    long firstFixedHandle = 0L;
    long keyController;
    long redrawWindow;
    long enableWindow;
    long provider;
    int drawCount;
    int backgroundAlpha = 255;
    long dragGesture;
    long zoomGesture;
    long rotateGesture;
    long panGesture;
    Composite parent;
    Cursor cursor;
    Menu menu;
    Image backgroundImage;
    Font font;
    Region region;
    long eventRegion;
    long regionHandle;
    String toolTipText;
    Object layoutData;
    Accessible accessible;
    Control labelRelation;
    String cssBackground;
    String cssForeground = " ";
    boolean drawRegion;
    boolean cachedNoBackground;
    Point lastInput = new Point(0, 0);
    LinkedList<Event> dragDetectionQueue;
    static Callback gestureZoom = new Callback(Control.class, "magnifyProc", Void.TYPE, new Type[]{Long.TYPE, Double.TYPE, Long.TYPE});
    static Callback gestureRotation = new Callback(Control.class, "rotateProc", Void.TYPE, new Type[]{Long.TYPE, Double.TYPE, Double.TYPE, Long.TYPE});
    static Callback gestureSwipe = new Callback(Control.class, "swipeProc", Void.TYPE, new Type[]{Long.TYPE, Double.TYPE, Double.TYPE, Long.TYPE});
    static Callback gestureBegin = new Callback(Control.class, "gestureBeginProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
    static Callback gestureEnd = new Callback(Control.class, "gestureEndProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
    static boolean mouseDown;
    boolean checkScaleFactor = true;
    boolean autoScale = true;

    Control() {
    }

    public Control(Composite composite, int n) {
        super(composite, n);
        this.parent = composite;
        this.createWidget(0);
    }

    Font defaultFont() {
        return this.display.getSystemFont();
    }

    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)22).handle;
    }

    @Override
    void deregister() {
        long l;
        super.deregister();
        if (this.fixedHandle != 0L) {
            this.display.removeWidget(this.fixedHandle);
        }
        if ((l = this.imHandle()) != 0L) {
            this.display.removeWidget(l);
        }
    }

    void drawBackground(Control control, long l, long l2, int n, int n2, int n3, int n4) {
        boolean bl;
        Object object;
        long l3 = 0L;
        long l4 = 0L;
        if (GTK.GTK4) {
            l3 = l2;
            if (l != 0L) {
                cairo_rectangle_int_t cairo_rectangle_int_t2 = new cairo_rectangle_int_t();
                object = new int[1];
                int[] nArray = new int[1];
                if (GTK.GTK4) {
                    this.gdk_surface_get_size(l, nArray, (int[])object);
                } else {
                    this.gdk_window_get_size(l, nArray, (int[])object);
                }
                cairo_rectangle_int_t2.x = 0;
                cairo_rectangle_int_t2.y = 0;
                cairo_rectangle_int_t2.width = nArray[0];
                cairo_rectangle_int_t2.height = object[0];
                l4 = Cairo.cairo_region_create_rectangle(cairo_rectangle_int_t2);
            }
        } else {
            l3 = l2 != 0L ? l2 : GDK.gdk_cairo_create(l);
        }
        boolean bl2 = bl = this.drawRegion && this.hooks(9) && this.cachedNoBackground;
        if (l3 == 0L) {
            this.error(2);
        }
        if (l4 != 0L) {
            GDK.gdk_cairo_region(l3, l4);
            Cairo.cairo_clip(l3);
        }
        if (control.backgroundImage != null) {
            object = this.display.mapInPixels(this, control, 0, 0);
            Cairo.cairo_translate(l3, -object.x, -object.y);
            n += object.x;
            n2 += object.y;
            long l5 = Cairo.cairo_pattern_create_for_surface(control.backgroundImage.surface);
            if (l5 == 0L) {
                this.error(2);
            }
            Cairo.cairo_pattern_set_extend(l5, 1);
            if ((this.style & 0x8000000) != 0) {
                double[] dArray = new double[]{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                Cairo.cairo_pattern_set_matrix(l5, dArray);
            }
            Cairo.cairo_set_source(l3, l5);
            Cairo.cairo_pattern_destroy(l5);
        } else {
            object = control.getBackgroundGdkRGBA();
            if (bl) {
                Cairo.cairo_set_source_rgba(l3, 0.0, 0.0, 0.0, 0.0);
            } else {
                Cairo.cairo_set_source_rgba(l3, object.red, object.green, object.blue, object.alpha);
            }
        }
        Cairo.cairo_rectangle(l3, n, n2, n3, n4);
        Cairo.cairo_fill(l3);
        if (!GTK.GTK4 && l3 != l2) {
            Cairo.cairo_destroy(l3);
        }
    }

    boolean drawGripper(GC gC, int n, int n2, int n3, int n4, boolean bl) {
        long l;
        long l2 = this.paintHandle();
        long l3 = l = GTK.GTK4 ? this.gtk_widget_get_surface(l2) : this.gtk_widget_get_window(l2);
        if (l == 0L) {
            return false;
        }
        if ((this.style & 0x8000000) != 0) {
            n = this.getClientWidth() - n3 - n;
        }
        long l4 = GTK.gtk_widget_get_style_context(l2);
        GTK.gtk_style_context_save(l4);
        GTK.gtk_style_context_add_class(l4, GTK.GTK_STYLE_CLASS_PANE_SEPARATOR);
        GTK.gtk_style_context_set_state(l4, 0L);
        GTK.gtk_render_handle(l4, gC.handle, n, n2, n3, n4);
        GTK.gtk_style_context_restore(l4);
        return true;
    }

    void drawWidget(GC gC) {
    }

    void enableWidget(boolean bl) {
        GTK.gtk_widget_set_sensitive(this.handle, bl);
    }

    long enterExitHandle() {
        return this.eventHandle();
    }

    long eventHandle() {
        return this.handle;
    }

    long eventWindow() {
        long l = this.eventHandle();
        GTK.gtk_widget_realize(l);
        return this.gtk_widget_get_window(l);
    }

    long eventSurface() {
        long l = this.eventHandle();
        GTK.gtk_widget_realize(l);
        return this.gtk_widget_get_surface(l);
    }

    static int fixGdkEventTypeValues(int n) {
        if (GTK.GTK4) {
            switch (n) {
                case 3: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 4;
                }
                case 6: {
                    return 7;
                }
                case 7: {
                    return 8;
                }
                case 9: {
                    return 10;
                }
                case 10: {
                    return 11;
                }
                case 11: {
                    return 12;
                }
                case 12: {
                    return 13;
                }
                case 13: {
                    return 14;
                }
                case 14: {
                    return 15;
                }
            }
        }
        return n;
    }

    void fixFocus(Control control) {
        Shell shell = this.getShell();
        Control control2 = this;
        while (control2 != shell && (control2 = control2.parent) != null) {
            if (!control2.setFocus()) continue;
            return;
        }
        shell.setSavedFocus(control);
        long l = shell.vboxHandle;
        GTK.gtk_widget_set_can_focus(l, true);
        GTK.gtk_widget_grab_focus(l);
        if (this.isDisposed()) {
            return;
        }
        GTK.gtk_widget_set_can_focus(l, false);
    }

    void fixStyle() {
        if (this.fixedHandle != 0L) {
            this.fixStyle(this.fixedHandle);
        }
    }

    void fixStyle(long l) {
        if ((this.state & 0x2000) != 0) {
            return;
        }
        if ((this.state & 0x10000) == 0) {
            return;
        }
    }

    long focusHandle() {
        return this.handle;
    }

    long fontHandle() {
        return this.handle;
    }

    long gestureHandle() {
        return this.handle;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public int getTextDirection() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    boolean hasFocus() {
        return this == this.display.getFocusControl();
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        long l = this.focusHandle();
        this.hookKeyboardAndFocusSignals(l);
        this.hookMouseSignals(this.eventHandle());
        this.hookWidgetSignals(l);
        this.hookPaintSignals();
        this.connectIMSignals();
        this.setZoomGesture();
        this.setDragGesture();
        this.setRotateGesture();
        long l2 = this.eventHandle();
        if (!GTK.GTK4) {
            OS.g_signal_connect_closure_by_id(l2, this.display.signalIds[16], 0, this.display.getClosure(16), false);
            if (l != l2) {
                OS.g_signal_connect_closure_by_id(l, this.display.signalIds[16], 0, this.display.getClosure(16), false);
            }
        }
    }

    private void hookKeyboardAndFocusSignals(long l) {
        if (GTK.GTK4) {
            this.keyController = GTK4.gtk_event_controller_key_new();
            GTK4.gtk_widget_add_controller(l, this.keyController);
            GTK.gtk_event_controller_set_propagation_phase(this.keyController, 1);
            OS.g_signal_connect(this.keyController, OS.key_pressed, this.display.keyPressReleaseProc, 89L);
            OS.g_signal_connect(this.keyController, OS.key_released, this.display.keyPressReleaseProc, 90L);
            long l2 = GTK4.gtk_event_controller_focus_new();
            GTK4.gtk_widget_add_controller(l, l2);
            OS.g_signal_connect(l2, OS.enter, this.display.focusProc, 86L);
            OS.g_signal_connect(l2, OS.leave, this.display.focusProc, 87L);
        } else {
            int n = 19456;
            GTK3.gtk_widget_add_events(l, n);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[27], 0, this.display.getClosure(27), false);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[28], 0, this.display.getClosure(28), false);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[21], 0, this.display.getClosure(21), false);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[22], 0, this.display.getClosure(22), false);
        }
    }

    private void hookMouseSignals(long l) {
        long l2 = this.enterExitHandle();
        if (GTK.GTK4) {
            long l3 = GTK4.gtk_gesture_click_new();
            GTK.gtk_event_controller_set_propagation_phase(l3, 3);
            GTK.gtk_gesture_single_set_button(l3, 0);
            GTK4.gtk_widget_add_controller(l, l3);
            OS.g_signal_connect(l3, OS.pressed, this.display.gesturePressReleaseProc, 100L);
            OS.g_signal_connect(l3, OS.released, this.display.gesturePressReleaseProc, 101L);
            long l4 = GTK4.gtk_event_controller_motion_new();
            GTK.gtk_event_controller_set_propagation_phase(l4, 3);
            GTK4.gtk_widget_add_controller(l, l4);
            OS.g_signal_connect(l4, OS.motion, this.display.enterMotionProc, 97L);
            long l5 = GTK4.gtk_event_controller_scroll_new(5);
            GTK.gtk_event_controller_set_propagation_phase(l5, 3);
            GTK4.gtk_widget_add_controller(l, l5);
            OS.g_signal_connect(l5, OS.scroll, this.display.scrollProc, 92L);
            long l6 = GTK4.gtk_event_controller_motion_new();
            GTK4.gtk_widget_add_controller(l2, l6);
            OS.g_signal_connect(l6, OS.enter, this.display.enterMotionProc, 95L);
            OS.g_signal_connect(l6, OS.leave, this.display.leaveProc, 96L);
        } else {
            int n = 10486532;
            GTK3.gtk_widget_add_events(l, n);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[33], 0, this.display.getClosure(33), false);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[2], 0, this.display.getClosure(2), false);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[4], 0, this.display.getClosure(4), false);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[43], 0, this.display.getClosure(43), false);
            int n2 = 12288;
            GTK3.gtk_widget_add_events(l2, n2);
            OS.g_signal_connect_closure_by_id(l2, this.display.signalIds[14], 0, this.display.getClosure(14), false);
            OS.g_signal_connect_closure_by_id(l2, this.display.signalIds[29], 0, this.display.getClosure(29), false);
            long l7 = this.fixedHandle != 0L ? this.fixedHandle : l;
            OS.g_signal_connect_closure_by_id(l7, this.display.signalIds[2], 0, this.display.getClosure(3), true);
            OS.g_signal_connect_closure_by_id(l7, this.display.signalIds[4], 0, this.display.getClosure(5), true);
            OS.g_signal_connect_closure_by_id(l7, this.display.signalIds[33], 0, this.display.getClosure(34), true);
        }
    }

    private void hookWidgetSignals(long l) {
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[40], 0, this.display.getClosure(40), true);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[56], 0, this.display.getClosure(56), false);
        OS.g_signal_connect_closure_by_id(this.topHandle(), this.display.signalIds[30], 0, this.display.getClosure(30), true);
        if (!GTK.GTK4) {
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[38], 0, this.display.getClosure(38), false);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[46], 0, this.display.getClosure(46), false);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[20], 0, this.display.getClosure(20), false);
        }
    }

    private void hookPaintSignals() {
        long l = this.paintHandle();
        if (GTK.GTK4) {
            long l2 = GTK.GTK_WIDGET_GET_CLASS(this.paintHandle());
            GtkWidgetClass gtkWidgetClass = new GtkWidgetClass();
            OS.memmove(gtkWidgetClass, l2);
            gtkWidgetClass.snapshot = this.display.snapshotDrawProc;
            OS.memmove(l2, gtkWidgetClass);
        } else {
            int n = 2;
            GTK3.gtk_widget_add_events(l, n);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[18], 0, this.display.getClosure(19), false);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[18], 0, this.display.getClosure(18), true);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[48], 0, this.display.getClosure(48), false);
        }
    }

    private void connectIMSignals() {
        long l = this.imHandle();
        if (l != 0L) {
            OS.g_signal_connect_closure(l, OS.commit, this.display.getClosure(9), false);
            OS.g_signal_connect_closure(l, OS.preedit_changed, this.display.getClosure(39), false);
        }
    }

    boolean hooksPaint() {
        return this.hooks(9) || this.filters(9);
    }

    @Override
    long hoverProc(long l) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        if (GTK.GTK4) {
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            this.display.getPointerPosition(dArray, dArray2);
            nArray[0] = (int)dArray[0];
            nArray2[0] = (int)dArray2[0];
        } else {
            this.display.getWindowPointerPosition(0L, nArray, nArray2, nArray3);
        }
        if (this.containedInRegion(nArray[0], nArray2[0])) {
            return 0L;
        }
        this.sendMouseEvent(32, 0, 0, nArray[0], nArray2[0], false, nArray3[0]);
        return 0L;
    }

    @Override
    long topHandle() {
        if (this.fixedHandle != 0L) {
            return this.fixedHandle;
        }
        return super.topHandle();
    }

    long paintHandle() {
        long l = this.topHandle();
        if (GTK.GTK4) {
            return l;
        }
        long l2 = this.handle;
        while (l2 != l && !GTK3.gtk_widget_get_has_window(l2)) {
            l2 = GTK.gtk_widget_get_parent(l2);
        }
        return l2;
    }

    @Override
    long paintWindow() {
        long l = this.paintHandle();
        GTK.gtk_widget_realize(l);
        if (GTK.GTK4) {
            return this.gtk_widget_get_surface(l);
        }
        return this.gtk_widget_get_window(l);
    }

    @Override
    long paintSurface() {
        long l = this.paintHandle();
        GTK.gtk_widget_realize(l);
        return this.gtk_widget_get_surface(l);
    }

    public boolean print(GC gC) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        long l = this.topHandle();
        GTK.gtk_widget_realize(l);
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation);
        GTK.gtk_widget_get_preferred_size(l, null, null);
        GTK3.gtk_widget_size_allocate(l, gtkAllocation);
        GTK3.gtk_widget_draw(l, gC.handle);
        return true;
    }

    void printWidget(GC gC, long l, int n, int n2, int n3) {
        boolean bl = (this.state & 0x40) != 0;
        this.state &= 0xFFFFFFBF;
        long l2 = this.topHandle();
        long l3 = GTK.GTK4 ? this.gtk_widget_get_surface(l2) : this.gtk_widget_get_window(l2);
        this.printWindow(true, this, gC, l, n, l3, n2, n3);
        if (bl) {
            this.state |= 0x40;
        }
    }

    void printWindow(boolean bl, Control control, GC gC, long l, int n, long l2, int n2, int n3) {
    }

    public Point computeSize(int n, int n2) {
        return this.computeSize(n, n2, true);
    }

    Point computeSizeInPixels(int n, int n2) {
        return this.computeSizeInPixels(n, n2, true);
    }

    Widget computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Widget[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Widget[]{this};
        }
        return new Widget[0];
    }

    Control computeTabRoot() {
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            int n;
            for (n = 0; n < controlArray.length && controlArray[n] != this; ++n) {
            }
            if (n == controlArray.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    void checkBuffered() {
        this.style |= 0x20000000;
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.state &= 0xFFFF7FFF;
        Composite composite = this.parent;
        while (true) {
            int n;
            if ((n = composite.backgroundMode) != 0 || this.backgroundAlpha == 0) {
                if (n == 1 || this.backgroundAlpha == 0) {
                    Control control = this;
                    do {
                        if ((control.state & 0x10000) != 0) continue;
                        return;
                    } while ((control = control.parent) != composite);
                }
                this.state |= 0x8000;
                return;
            }
            if (composite == shell) break;
            composite = composite.parent;
        }
    }

    void checkBorder() {
        if (this.getBorderWidthInPixels() == 0) {
            this.style &= 0xFFFFF7FF;
        }
    }

    void checkMirrored() {
        if ((this.style & 0x4000000) != 0) {
            this.style |= 0x8000000;
        }
    }

    boolean containedInRegion(int n, int n2) {
        if (this.drawRegion && this.eventRegion != 0L) {
            return Cairo.cairo_region_contains_point(this.eventRegion, n, n2);
        }
        return false;
    }

    @Override
    void createWidget(int n) {
        this.state |= 0x800000;
        this.checkOrientation(this.parent);
        super.createWidget(n);
        this.checkBackground();
        if ((this.state & 0x8000) != 0) {
            this.setParentBackground();
        }
        this.checkBuffered();
        this.showWidget();
        this.setInitialBounds();
        this.setZOrder(null, false, false);
        if (!GTK.GTK4) {
            this.setRelations();
        }
        this.checkMirrored();
        this.checkBorder();
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        return DPIUtil.autoScaleDown(this.computeSizeInPixels(n, n2, bl));
    }

    Point computeSizeInPixels(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        return this.computeNativeSize(this.handle, n, n2, bl);
    }

    Point computeNativeSize(long l, int n, int n2, boolean bl) {
        int n3 = n;
        int n4 = n2;
        if (n == -1 && n2 == -1) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            GTK.gtk_widget_get_preferred_size(l, null, gtkRequisition);
            n3 = gtkRequisition.width;
            n4 = gtkRequisition.height;
        } else if (n == -1 || n2 == -1) {
            int[] nArray = new int[1];
            if (n == -1) {
                if (GTK.GTK4) {
                    GTK4.gtk_widget_measure(l, 0, n4, null, nArray, null, null);
                } else {
                    GTK3.gtk_widget_get_preferred_width_for_height(l, n4, null, nArray);
                }
                n3 = nArray[0];
            } else {
                if (GTK.GTK4) {
                    GTK4.gtk_widget_measure(l, 1, n3, null, nArray, null, null);
                } else {
                    GTK3.gtk_widget_get_preferred_height_for_width(l, n3, null, nArray);
                }
                n4 = nArray[0];
            }
        }
        return new Point(n3, n4);
    }

    void forceResize() {
        long l = this.topHandle();
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.gtk_widget_get_preferred_size(l, gtkRequisition);
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation);
        this.gtk_widget_size_allocate(l, gtkAllocation, -1);
    }

    public Accessible getAccessible() {
        this.checkWidget();
        return this._getAccessible();
    }

    Accessible _getAccessible() {
        if (this.accessible == null) {
            this.accessible = Accessible.internal_new_Accessible(this);
        }
        return this.accessible;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        int n;
        this.checkWidget();
        long l = this.topHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation);
        int n2 = gtkAllocation.x;
        int n3 = gtkAllocation.y;
        int n4 = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
        int n5 = n = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
        if ((this.parent.style & 0x8000000) != 0) {
            n2 = this.parent.getClientWidth() - n4 - n2;
        }
        return new Rectangle(n2, n3, n4, n);
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            this.error(4);
        }
        rectangle = DPIUtil.autoScaleUp(rectangle);
        this.setBounds(rectangle.x, rectangle.y, Math.max(0, rectangle.width), Math.max(0, rectangle.height), true, true);
    }

    void setBoundsInPixels(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            this.error(4);
        }
        this.setBounds(rectangle.x, rectangle.y, Math.max(0, rectangle.width), Math.max(0, rectangle.height), true, true);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = DPIUtil.autoScaleUp(new Rectangle(n, n2, n3, n4));
        this.setBounds(rectangle.x, rectangle.y, Math.max(0, rectangle.width), Math.max(0, rectangle.height), true, true);
    }

    void setBoundsInPixels(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.setBounds(n, n2, Math.max(0, n3), Math.max(0, n4), true, true);
    }

    void markLayout(boolean bl, boolean bl2) {
    }

    void moveHandle(int n, int n2) {
        long l = this.topHandle();
        long l2 = this.parent.parentingHandle();
        OS.swt_fixed_move(l2, l, n, n2);
    }

    void resizeHandle(int n, int n2) {
        long l = this.topHandle();
        OS.swt_fixed_resize(GTK.gtk_widget_get_parent(l), l, n, n2);
        if (l != this.handle) {
            Point point = this.resizeCalculationsGTK3(this.handle, n, n2);
            n = point.x;
            n2 = point.y;
            OS.swt_fixed_resize(GTK.gtk_widget_get_parent(this.handle), this.handle, n, n2);
        }
    }

    Point resizeCalculationsGTK3(long l, int n, int n2) {
        Point point = new Point(n, n2);
        GtkRequisition gtkRequisition = new GtkRequisition();
        GtkRequisition gtkRequisition2 = new GtkRequisition();
        GTK.gtk_widget_get_preferred_size(l, gtkRequisition, gtkRequisition2);
        int n3 = Math.min(gtkRequisition.width, gtkRequisition2.width);
        int n4 = Math.min(gtkRequisition.height, gtkRequisition2.height);
        point.x = n - (n3 - n) < 0 ? n3 : n;
        point.y = n2 - (n4 - n2) < 0 ? n4 : n2;
        return point;
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5;
        int n6;
        int n7;
        int n8;
        n3 = Math.min(n3, Short.MAX_VALUE);
        n4 = Math.min(n4, Short.MAX_VALUE);
        long l = this.topHandle();
        boolean bl3 = bl;
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation);
        if ((this.parent.style & 0x8000000) != 0) {
            n8 = this.parent.getClientWidth();
            n7 = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
            n6 = n8 - n7 - gtkAllocation.x;
            if (bl) {
                bl3 &= n != n6;
                n = n8 - (bl2 ? n3 : n7) - n;
            } else {
                bl = true;
                n = n8 - (bl2 ? n3 : n7) - n6;
                n2 = gtkAllocation.y;
            }
        }
        n8 = 1;
        n7 = 1;
        if (bl) {
            n6 = gtkAllocation.x;
            n5 = gtkAllocation.y;
            int n9 = n8 = n == n6 && n2 == n5 ? 1 : 0;
            if (n8 == 0) {
                if (!GTK.GTK4 && this.enableWindow != 0L) {
                    GDK.gdk_window_move(this.enableWindow, n, n2);
                }
                this.moveHandle(n, n2);
            }
        }
        n6 = 0;
        if (bl2) {
            n5 = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
            int n10 = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
            int n11 = n7 = n3 == n5 && n4 == n10 ? 1 : 0;
            if (n7 == 0 && (this.style & 0x8000000) != 0) {
                n6 = this.getClientWidth();
            }
            if (n7 == 0 && (n3 != 0 || n4 != 0)) {
                int n12 = Math.max(1, n3);
                int n13 = Math.max(1, n4);
                if (!GTK.GTK4) {
                    if (this.redrawWindow != 0L) {
                        GDK.gdk_window_resize(this.redrawWindow, n12, n13);
                    }
                    if (this.enableWindow != 0L) {
                        GDK.gdk_window_resize(this.enableWindow, n12, n13);
                    }
                }
                this.resizeHandle(n12, n13);
            }
        }
        if (n8 == 0 || n7 == 0) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            this.gtk_widget_get_preferred_size(l, gtkRequisition);
            if (bl) {
                gtkAllocation.x = n;
                gtkAllocation.y = n2;
            }
            if (bl2) {
                gtkAllocation.width = n3;
                gtkAllocation.height = n4;
            }
            if (!GTK.gtk_widget_get_visible(l)) {
                Control control = this.display.getFocusControl();
                GTK.gtk_widget_show(l);
                this.gtk_widget_get_preferred_size(l, gtkRequisition);
                this.gtk_widget_size_allocate(l, gtkAllocation, -1);
                GTK.gtk_widget_hide(l);
                if (control != null && this.display.getFocusControl() != control) {
                    control.setFocus();
                }
            } else if (GTK.GTK4) {
                GTK4.gtk_widget_size_allocate(l, gtkAllocation, -1);
            } else {
                GTK.gtk_widget_get_preferred_size(l, null, null);
                GTK3.gtk_widget_size_allocate(l, gtkAllocation);
            }
        }
        if (n7 == 0) {
            this.state = n3 == 0 ? this.state | 0x200 : this.state & 0xFFFFFDFF;
            int n14 = this.state = n4 == 0 ? this.state | 0x400 : this.state & 0xFFFFFBFF;
            if ((this.state & 0x600) != 0) {
                if (!GTK.GTK4 && this.enableWindow != 0L) {
                    GDK.gdk_window_hide(this.enableWindow);
                }
                GTK.gtk_widget_hide(l);
            } else if ((this.state & 0x800) == 0) {
                if (!GTK.GTK4 && this.enableWindow != 0L) {
                    GDK.gdk_window_show_unraised(this.enableWindow);
                }
                GTK.gtk_widget_show(l);
            }
            if ((this.style & 0x8000000) != 0) {
                this.moveChildren(n6);
            }
        }
        int n15 = 0;
        if (bl && n8 == 0) {
            Control control = this.findBackgroundControl();
            if (control != null && control.backgroundImage != null && this.isVisible()) {
                this.redrawWidget(0, 0, 0, 0, true, true, true);
            }
            if (bl3) {
                this.sendEvent(10);
            }
            n15 |= 0x80;
        }
        if (bl2 && n7 == 0) {
            this.sendEvent(11);
            n15 |= 0x100;
        }
        return n15;
    }

    public Point getLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getLocationInPixels());
    }

    Point getLocationInPixels() {
        this.checkWidget();
        long l = this.topHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation);
        int n = gtkAllocation.x;
        int n2 = gtkAllocation.y;
        if ((this.parent.style & 0x8000000) != 0) {
            int n3 = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
            n = this.parent.getClientWidth() - n3 - n;
        }
        return new Point(n, n2);
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        point = DPIUtil.autoScaleUp(point);
        this.setBounds(point.x, point.y, 0, 0, true, false);
    }

    void setLocationInPixels(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setBounds(point.x, point.y, 0, 0, true, false);
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        Point point = DPIUtil.autoScaleUp(new Point(n, n2));
        this.setBounds(point.x, point.y, 0, 0, true, false);
    }

    void setLocationInPixels(int n, int n2) {
        this.checkWidget();
        this.setBounds(n, n2, 0, 0, true, false);
    }

    public Point getSize() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getSizeInPixels());
    }

    Point getSizeInPixels() {
        this.checkWidget();
        long l = this.topHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation);
        int n = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
        int n2 = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
        return new Point(n, n2);
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        point = DPIUtil.autoScaleUp(point);
        this.setBounds(0, 0, Math.max(0, point.x), Math.max(0, point.y), false, true);
    }

    void setSizeInPixels(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setBounds(0, 0, Math.max(0, point.x), Math.max(0, point.y), false, true);
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        long l = region == null ? 0L : region.handle;
        this.region = region;
        long l2 = this.topHandle();
        if (OS.G_OBJECT_TYPE(l2) == GTK.GTK_TYPE_WINDOW()) {
            GTK3.gtk_widget_shape_combine_region(l2, l);
            if (OS.isWayland()) {
                double d = GTK.gtk_widget_get_opacity(l2);
                if (d == 1.0) {
                    d = 0.99;
                }
                GTK.gtk_widget_set_opacity(l2, d);
            }
        } else {
            boolean bl = this.drawRegion = this.region != null && this.region.handle != 0L;
            if (this.drawRegion) {
                this.cairoCopyRegion(this.region);
            } else {
                this.cairoDisposeRegion();
            }
            GTK.gtk_widget_queue_draw(this.topHandle());
        }
    }

    void setRelations() {
        Widget widget;
        long l = this.parent.parentingHandle();
        long l2 = 0L;
        if (GTK.GTK4) {
            int n = 0;
            long l3 = GTK4.gtk_widget_get_first_child(l);
            while (l3 != 0L) {
                ++n;
                l3 = GTK4.gtk_widget_get_next_sibling(l3);
            }
            if (n > 1) {
                l2 = GTK4.gtk_widget_get_prev_sibling(GTK4.gtk_widget_get_last_child(l));
            }
        } else {
            long l4 = GTK3.gtk_container_get_children(l);
            if (l4 == 0L) {
                return;
            }
            int n = OS.g_list_length(l4);
            if (n > 1) {
                l2 = OS.g_list_nth_data(l4, n - 2);
            }
            OS.g_list_free(l4);
        }
        if (l2 != 0L && (widget = this.display.getWidget(l2)) != null && widget != this && widget instanceof Control) {
            Control control = (Control)widget;
            control.addRelation(this);
        }
    }

    public void setSize(int n, int n2) {
        this.checkWidget();
        Point point = DPIUtil.autoScaleUp(new Point(n, n2));
        this.setBounds(0, 0, Math.max(0, point.x), Math.max(0, point.y), false, true);
    }

    void setSizeInPixels(int n, int n2) {
        this.checkWidget();
        this.setBounds(0, 0, Math.max(0, n), Math.max(0, n2), false, true);
    }

    @Override
    boolean isActive() {
        return this.getShell().getModalShell() == null && this.display.getModalDialog() == null;
    }

    @Override
    public boolean isAutoScalable() {
        return this.autoScale;
    }

    boolean isDescribedByLabel() {
        return true;
    }

    boolean isFocusHandle(long l) {
        return l == this.focusHandle();
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            if (this == control) {
                return;
            }
        }
        this.setZOrder(control, true, true);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            if (this == control) {
                return;
            }
        }
        this.setZOrder(control, false, true);
    }

    void moveChildren(int n) {
    }

    public void pack() {
        this.pack(true);
    }

    public void pack(boolean bl) {
        this.setSize(this.computeSize(-1, -1, bl));
    }

    public void setLayoutData(Object object) {
        this.checkWidget();
        this.layoutData = object;
    }

    public Point toControl(int n, int n2) {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (GTK.GTK4) {
            Point point = this.getControlOrigin();
            nArray[0] = point.x;
            nArray2[0] = point.y;
        } else {
            long l = this.eventWindow();
            GDK.gdk_window_get_origin(l, nArray, nArray2);
        }
        n -= DPIUtil.autoScaleDown(nArray[0]);
        n2 -= DPIUtil.autoScaleDown(nArray2[0]);
        if ((this.style & 0x8000000) != 0) {
            n = DPIUtil.autoScaleDown(this.getClientWidth()) - n;
        }
        return new Point(n, n2);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int n, int n2) {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (GTK.GTK4) {
            Point point = this.getControlOrigin();
            nArray[0] = point.x;
            nArray2[0] = point.y;
        } else {
            long l = this.eventWindow();
            GDK.gdk_window_get_origin(l, nArray, nArray2);
        }
        if ((this.style & 0x8000000) != 0) {
            n = DPIUtil.autoScaleDown(this.getClientWidth()) - n;
        }
        return new Point(n += DPIUtil.autoScaleDown(nArray[0]), n2 += DPIUtil.autoScaleDown(nArray2[0]));
    }

    Point toDisplayInPixels(int n, int n2) {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (GTK.GTK4) {
            Point point = this.getControlOrigin();
            nArray[0] = point.x;
            nArray2[0] = point.y;
        } else {
            long l = this.eventWindow();
            GDK.gdk_window_get_origin(l, nArray, nArray2);
        }
        if ((this.style & 0x8000000) != 0) {
            n = this.getClientWidth() - n;
        }
        return new Point(n += nArray[0], n2 += nArray2[0]);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    Point toDisplayInPixels(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplayInPixels(point.x, point.y);
    }

    Point getControlOrigin() {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        boolean bl = GTK4.gtk_widget_translate_coordinates(this.fixedHandle, this.getShell().shellHandle, 0.0, 0.0, dArray, dArray2);
        return bl ? new Point((int)dArray[0], (int)dArray2[0]) : new Point(0, 0);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addDragDetectListener(DragDetectListener dragDetectListener) {
        this.checkWidget();
        if (dragDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(dragDetectListener);
        this.addListener(29, typedListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(focusListener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addGestureListener(GestureListener gestureListener) {
        this.checkWidget();
        if (gestureListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(gestureListener);
        this.addListener(48, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuDetectListener);
        this.addListener(35, typedListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseListener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseMoveListener);
        this.addListener(5, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseTrackListener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.checkWidget();
        if (mouseWheelListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseWheelListener);
        this.addListener(37, typedListener);
    }

    public void addPaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(paintListener);
        this.addListener(9, typedListener);
    }

    void adjustChildClipping(long l) {
    }

    void addRelation(Control control) {
    }

    public void addTouchListener(TouchListener touchListener) {
        this.checkWidget();
        if (touchListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(touchListener);
        this.addListener(47, typedListener);
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(traverseListener);
        this.addListener(31, typedListener);
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeDragDetectListener(DragDetectListener dragDetectListener) {
        this.checkWidget();
        if (dragDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(29, dragDetectListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, focusListener);
        this.eventTable.unhook(16, focusListener);
    }

    public void removeGestureListener(GestureListener gestureListener) {
        this.checkWidget();
        if (gestureListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(48, gestureListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    public void removeMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, menuDetectListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, mouseListener);
        this.eventTable.unhook(4, mouseListener);
        this.eventTable.unhook(8, mouseListener);
    }

    public void removeMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, mouseMoveListener);
    }

    public void removeMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, mouseTrackListener);
        this.eventTable.unhook(7, mouseTrackListener);
        this.eventTable.unhook(32, mouseTrackListener);
    }

    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.checkWidget();
        if (mouseWheelListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(37, mouseWheelListener);
    }

    public void removePaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, paintListener);
    }

    void removeRelation() {
        if (!this.isDescribedByLabel()) {
            return;
        }
        if (this.labelRelation != null) {
            this._getAccessible().removeRelation(9, this.labelRelation._getAccessible());
            this.labelRelation = null;
        }
    }

    public void removeTouchListener(TouchListener touchListener) {
        this.checkWidget();
        if (touchListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(47, touchListener);
    }

    public void removeTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, traverseListener);
    }

    public boolean dragDetect(Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    public boolean dragDetect(MouseEvent mouseEvent) {
        this.checkWidget();
        if (mouseEvent == null) {
            this.error(4);
        }
        return this.dragDetect(mouseEvent.button, mouseEvent.count, mouseEvent.stateMask, mouseEvent.x, mouseEvent.y);
    }

    boolean dragDetect(int n, int n2, int n3, int n4, int n5) {
        if (n != 1 || n2 != 1) {
            return false;
        }
        if (!this.dragDetect(n4, n5, false, true, null)) {
            return false;
        }
        return this.sendDragEvent(n, n3, n4, n5, true);
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean bl2, boolean[] blArray) {
        if (OS.isWayland()) {
            if (!mouseDown) {
                return false;
            }
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            double[] dArray3 = new double[1];
            double[] dArray4 = new double[1];
            if (!GTK.gtk_gesture_drag_get_start_point(this.dragGesture, dArray3, dArray4)) {
                return false;
            }
            GTK.gtk_gesture_drag_get_offset(this.dragGesture, dArray, dArray2);
            return GTK3.gtk_drag_check_threshold(this.handle, (int)dArray3[0], (int)dArray4[0], (int)dArray3[0] + (int)dArray[0], (int)dArray4[0] + (int)dArray2[0]);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        Point point = null;
        Point point2 = null;
        point = this.display.getCursorLocationInPixels();
        while (!bl4) {
            long l = 0L;
            long l2 = System.currentTimeMillis() + 500L;
            this.display.sendPreExternalEventDispatchEvent();
            while (System.currentTimeMillis() < l2) {
                long l3 = l = GTK.GTK4 ? GTK3.gtk_get_current_event() : GDK.gdk_event_get();
                if (l != 0L) break;
                point2 = this.display.getCursorLocationInPixels();
                bl3 = GTK3.gtk_drag_check_threshold(this.handle, point.x, point.y, point2.x, point2.y);
                if (!bl3) continue;
            }
            this.display.sendPostExternalEventDispatchEvent();
            if (bl3) {
                return true;
            }
            if (l == 0L) {
                return bl2;
            }
            int n3 = GDK.gdk_event_get_event_type(l);
            n3 = Control.fixGdkEventTypeValues(n3);
            switch (n3) {
                case 3: {
                    long l4 = this.gdk_event_get_surface_or_window(l);
                    int[] nArray = new int[1];
                    double[] dArray = new double[1];
                    double[] dArray5 = new double[1];
                    if (GTK.GTK4) {
                        nArray[0] = GDK.gdk_event_get_modifier_state(l);
                        GDK.gdk_event_get_position(l, dArray, dArray5);
                    } else {
                        GDK.gdk_event_get_state(l, nArray);
                        GDK.gdk_event_get_coords(l, dArray, dArray5);
                    }
                    if ((nArray[0] & 0x100) != 0) {
                        if (GTK3.gtk_drag_check_threshold(this.handle, n, n2, (int)dArray[0], (int)dArray5[0])) {
                            bl3 = true;
                            bl4 = true;
                        }
                    } else {
                        bl4 = true;
                    }
                    int[] nArray2 = new int[1];
                    int[] nArray3 = new int[1];
                    if (GTK.GTK4) {
                        double[] dArray6 = new double[1];
                        double[] dArray7 = new double[1];
                        this.display.getPointerPosition(dArray6, dArray7);
                        nArray2[0] = (int)dArray6[0];
                        nArray3[0] = (int)dArray7[0];
                        break;
                    }
                    this.display.getWindowPointerPosition(l4, nArray2, nArray3, null);
                    break;
                }
                case 8: 
                case 9: {
                    int[] nArray = new int[1];
                    if (GTK.GTK4) {
                        nArray[0] = GDK.gdk_key_event_get_keyval(l);
                    } else {
                        GDK.gdk_event_get_keyval(l, nArray);
                    }
                    if (nArray[0] != 65307) break;
                    bl4 = true;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    long l4;
                    if (GTK.GTK4) {
                        l4 = GDK.gdk_display_get_default();
                        GDK.gdk_display_put_event(l4, l);
                    } else {
                        GDK.gdk_event_put(l);
                    }
                    bl4 = true;
                    break;
                }
                default: {
                    GTK3.gtk_main_do_event(l);
                }
            }
            this.gdk_event_free(l);
        }
        return bl3;
    }

    boolean filterKey(long l) {
        long l2 = this.imHandle();
        if (l2 != 0L) {
            if (GTK.GTK4) {
                return GTK4.gtk_im_context_filter_keypress(l2, l);
            }
            return GTK3.gtk_im_context_filter_keypress(l2, l);
        }
        return false;
    }

    Control findBackgroundControl() {
        if (((this.state & 0x2000) != 0 || this.backgroundImage != null) && this.backgroundAlpha > 0) {
            return this;
        }
        return this.parent != null && (this.state & 0x8000) != 0 ? this.parent.findBackgroundControl() : null;
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        shell2.fixShell(shell, this);
        decorations2.fixDecorations(decorations, this, menuArray);
    }

    void fixParentGdkResource() {
        this.parent.setParentGdkResource(this);
    }

    static void gtk_widget_reparent(Control control, long l) {
        long l2 = control.topHandle();
        long l3 = GTK.gtk_widget_get_parent(l2);
        assert (l3 != 0L) : "Improper use of Control.gtk_widget_reparent. Widget currently has no parent.";
        if (l3 != 0L) {
            if (GTK.GTK4) {
                OS.g_object_ref(l2);
                OS.swt_fixed_remove(l3, l2);
                OS.swt_fixed_add(l, l2);
                OS.g_object_unref(l2);
            } else {
                GTK3.gtk_widget_reparent(l2, l);
                control.fixParentGdkResource();
            }
        }
    }

    void fixModal(long l, long l2) {
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Shell shell = this.getShell();
        shell.setSavedFocus(this);
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        if (this.display.getActiveShell() != shell && !Display.isActivateShellOnForceFocus()) {
            return false;
        }
        shell.bringToTop(false);
        return this.forceFocus(this.focusHandle());
    }

    boolean forceFocus(long l) {
        if (GTK.gtk_widget_has_focus(l)) {
            return true;
        }
        GTK.gtk_widget_realize(l);
        GTK.gtk_widget_grab_focus(l);
        if (this.isDisposed()) {
            return false;
        }
        Shell shell = this.getShell();
        long l2 = shell.shellHandle;
        long l3 = GTK.gtk_window_get_focus(l2);
        while (l3 != 0L) {
            if (l3 == l) {
                this.display.ignoreFocus = false;
                return true;
            }
            Widget widget = this.display.getWidget(l3);
            if (widget != null && widget instanceof Control) {
                return widget == this;
            }
            l3 = GTK.gtk_widget_get_parent(l3);
        }
        return false;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.backgroundAlpha == 0) {
            Color color = Color.gtk_new(this.display, this.getBackgroundGdkRGBA(), 0);
            return color;
        }
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return Color.gtk_new(this.display, control.getBackgroundGdkRGBA(), this.backgroundAlpha);
    }

    GdkRGBA getBackgroundGdkRGBA() {
        return this.getBgGdkRGBA();
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    GdkRGBA getContextBackgroundGdkRGBA() {
        if ((this.state & 0x2000) == 0) {
            return this.defaultBackground();
        }
        if (this.provider != 0L) {
            return this.display.gtk_css_parse_background(this.display.gtk_css_provider_to_string(this.provider), null);
        }
        return this.defaultBackground();
    }

    GdkRGBA getContextColorGdkRGBA() {
        return this.display.gtk_css_parse_foreground(this.display.gtk_css_provider_to_string(this.provider), null);
    }

    GdkRGBA getBgGdkRGBA() {
        return this.getContextBackgroundGdkRGBA();
    }

    GdkRGBA getBaseGdkRGBA() {
        return this.getContextBackgroundGdkRGBA();
    }

    public int getBorderWidth() {
        return DPIUtil.autoScaleDown(this.getBorderWidthInPixels());
    }

    int getBorderWidthInPixels() {
        this.checkWidget();
        return 0;
    }

    int getClientWidth() {
        if (this.handle == 0L || (this.state & 0x200) != 0) {
            return 0;
        }
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.handle, gtkAllocation);
        return gtkAllocation.width;
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return (this.state & 0x800000) != 0;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font != null ? this.font : this.defaultFont();
    }

    long getFontDescription() {
        long l = this.fontHandle();
        long[] lArray = new long[1];
        long l2 = GTK.gtk_widget_get_style_context(l);
        if ("ppc64le".equals(System.getProperty("os.arch"))) {
            long l3 = GTK3.gtk_style_context_get_font(l2, 0);
            return OS.pango_font_description_copy(l3);
        }
        if (GTK.GTK4) {
            int n;
            long[] lArray2 = new long[1];
            long l4 = GTK.gtk_settings_get_default();
            OS.g_object_get(l4, GTK.gtk_style_property_font, lArray2, 0L);
            if (lArray2[0] != 0L && (n = C.strlen(lArray2[0])) != 0) {
                byte[] byArray = new byte[n + 1];
                C.memmove(byArray, lArray2[0], (long)n);
                OS.g_free(lArray2[0]);
                return OS.pango_font_description_from_string(byArray);
            }
            return 0L;
        }
        GTK.gtk_style_context_save(l2);
        GTK.gtk_style_context_set_state(l2, 0L);
        GTK3.gtk_style_context_get(l2, 0, GTK.gtk_style_property_font, lArray, 0L);
        GTK.gtk_style_context_restore(l2);
        return lArray[0];
    }

    public Color getForeground() {
        this.checkWidget();
        Color color = Color.gtk_new(this.display, this.getForegroundGdkRGBA());
        return color;
    }

    GdkRGBA getForegroundGdkRGBA() {
        return this.getContextColorGdkRGBA();
    }

    Point getIMCaretPos() {
        return new Point(0, 0);
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        Monitor[] monitorArray = this.display.getMonitors();
        long l = GDK.gdk_display_get_default();
        if (l != 0L) {
            long l2 = GTK.GTK4 ? GDK.gdk_display_get_monitor_at_surface(l, this.paintSurface()) : GDK.gdk_display_get_monitor_at_window(l, this.paintWindow());
            for (int i = 0; i < monitorArray.length; ++i) {
                long l3 = GDK.gdk_display_get_monitor(l, i);
                if (l3 != l2) continue;
                return monitorArray[i];
            }
        }
        return this.display.getPrimaryMonitor();
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int n = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++n;
            control = control.parent;
        }
        control = this;
        Control[] controlArray = new Control[n];
        while (control != shell) {
            controlArray[--n] = control;
            control = control.parent;
        }
        return controlArray;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this._getShell();
    }

    Shell _getShell() {
        return this.parent._getShell();
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getTouchEnabled() {
        this.checkWidget();
        return false;
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x800) == 0;
    }

    Point getThickness(long l) {
        int n = 0;
        int n2 = 0;
        GtkBorder gtkBorder = new GtkBorder();
        long l2 = GTK.gtk_widget_get_style_context(l);
        int n3 = GTK.gtk_widget_get_state_flags(l);
        this.gtk_style_context_get_padding(l2, n3, gtkBorder);
        GTK.gtk_style_context_save(l2);
        GTK.gtk_style_context_add_class(l2, GTK.GTK_STYLE_CLASS_FRAME);
        n += gtkBorder.left;
        n2 += gtkBorder.top;
        int n4 = GTK.gtk_widget_get_state_flags(l);
        this.gtk_style_context_get_border(l2, n4, gtkBorder);
        GTK.gtk_style_context_restore(l2);
        return new Point(n += gtkBorder.left, n2 += gtkBorder.top);
    }

    void gtk_style_context_get_padding(long l, int n, GtkBorder gtkBorder) {
        if (GTK.GTK4) {
            GTK4.gtk_style_context_get_padding(l, gtkBorder);
        } else {
            GTK3.gtk_style_context_get_padding(l, n, gtkBorder);
        }
    }

    void gtk_style_context_get_border(long l, int n, GtkBorder gtkBorder) {
        if (GTK.GTK4) {
            GTK4.gtk_style_context_get_border(l, gtkBorder);
        } else {
            GTK3.gtk_style_context_get_border(l, n, gtkBorder);
        }
    }

    @Override
    void gtk_gesture_press_event(long l, int n, double d, double d2, long l2) {
        mouseDown = true;
        int n2 = GDK.gdk_button_event_get_button(l2);
        int n3 = GDK.gdk_event_get_time(l2);
        int n4 = GDK.gdk_event_get_modifier_state(l2);
        this.display.clickCount = n;
        if (n == 1) {
            this.sendMouseEvent(3, n2, n, 0, false, n3, d, d2, false, n4);
            if ((this.state & 0x20) == 0 && n2 == 3) {
                this.showMenu((int)d, (int)d2);
            }
        } else if (n == 2) {
            this.sendMouseEvent(8, n2, n, 0, false, n3, d, d2, false, n4);
        }
    }

    @Override
    void gtk_gesture_release_event(long l, int n, double d, double d2, long l2) {
        mouseDown = false;
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        GDK.gdk_event_get_position(l2, dArray, dArray2);
        int n2 = GDK.gdk_button_event_get_button(l2);
        int n3 = GDK.gdk_event_get_time(l2);
        int n4 = GDK.gdk_event_get_modifier_state(l2);
        this.lastInput.x = (int)dArray[0];
        this.lastInput.y = (int)dArray2[0];
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return;
        }
        this.sendMouseEvent(4, n2, this.display.clickCount, 0, false, n3, 0.0, 0.0, false, n4);
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        return this.gtk_button_press_event(l, l2, true);
    }

    boolean wantDragDropDetection() {
        return this.hooks(29);
    }

    long gtk_button_press_event(long l, long l2, boolean bl) {
        mouseDown = true;
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        GDK.gdk_event_get_coords(l2, dArray, dArray2);
        int n = GDK.gdk_event_get_event_type(l2);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        GDK.gdk_event_get_button(l2, nArray);
        GDK.gdk_event_get_state(l2, nArray2);
        int n2 = GDK.gdk_event_get_time(l2);
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        GDK.gdk_event_get_root_coords(l2, dArray3, dArray4);
        this.lastInput.x = (int)dArray[0];
        this.lastInput.y = (int)dArray2[0];
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0L;
        }
        if (n == 6) {
            return 0L;
        }
        Shell shell = this._getShell();
        if ((shell.style & 0x4000) != 0 && ((shell.style & 0x80000) == 0 || (this.style & 0x80000) == 0)) {
            shell.forceActive();
        }
        long l3 = 0L;
        if (n == 4) {
            int n3;
            boolean bl2 = false;
            this.display.clickCount = 1;
            long l4 = GDK.gdk_event_peek();
            if (l4 != 0L) {
                n3 = GDK.GDK_EVENT_TYPE(l4);
                if (n3 == 5) {
                    this.display.clickCount = 2;
                }
                if (n3 == 6) {
                    this.display.clickCount = 3;
                }
                this.gdk_event_free(l4);
            }
            if (OS.isX11() && (this.state & 0x800000) != 0 && this.wantDragDropDetection() && nArray[0] == 1) {
                boolean[] blArray = new boolean[1];
                if (this.dragDetect((int)dArray[0], (int)dArray2[0], true, true, blArray)) {
                    bl2 = true;
                    if (blArray[0]) {
                        l3 = 1L;
                    }
                }
                if (this.isDisposed()) {
                    return 1L;
                }
            }
            if (bl) {
                int n4 = n3 = !this.sendMouseEvent(3, nArray[0], this.display.clickCount, 0, false, n2, dArray3[0], dArray4[0], false, nArray2[0]) ? 1 : 0;
                if (n3 != 0) {
                    l3 = 1L;
                }
            }
            if (this.isDisposed()) {
                return 1L;
            }
            if (OS.isX11() && bl2) {
                Point point = DPIUtil.autoScaleDown(new Point((int)dArray[0], (int)dArray2[0]));
                this.sendDragEvent(nArray[0], nArray2[0], point.x, point.y, false);
                if (this.isDisposed()) {
                    return 1L;
                }
            }
            if ((this.state & 0x20) != 0 && nArray[0] == 3 && this.showMenu((int)dArray3[0], (int)dArray4[0])) {
                l3 = 1L;
            }
        } else {
            this.display.clickCount = 2;
            long l5 = l3 = this.sendMouseEvent(8, nArray[0], this.display.clickCount, 0, false, n2, dArray3[0], dArray4[0], false, nArray2[0]) ? 0L : 1L;
            if (this.isDisposed()) {
                return 1L;
            }
        }
        if (!shell.isDisposed()) {
            shell.setActiveControl(this, 3);
        }
        return l3;
    }

    @Override
    long gtk_button_release_event(long l, long l2) {
        mouseDown = false;
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        GDK.gdk_event_get_coords(l2, dArray, dArray2);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        GDK.gdk_event_get_button(l2, nArray);
        GDK.gdk_event_get_state(l2, nArray2);
        int n = GDK.gdk_event_get_time(l2);
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        GDK.gdk_event_get_root_coords(l2, dArray3, dArray4);
        this.lastInput.x = (int)dArray[0];
        this.lastInput.y = (int)dArray2[0];
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0L;
        }
        return this.sendMouseEvent(4, nArray[0], this.display.clickCount, 0, false, n, dArray3[0], dArray4[0], false, nArray2[0]) ? 0L : 1L;
    }

    @Override
    long gtk_commit(long l, long l2) {
        if (l2 == 0L) {
            return 0L;
        }
        int n = C.strlen(l2);
        if (n == 0) {
            return 0L;
        }
        byte[] byArray = new byte[n];
        C.memmove(byArray, l2, (long)n);
        char[] cArray = Converter.mbcsToWcs(byArray);
        this.sendIMKeyEvent(1, 0L, cArray);
        return 0L;
    }

    @Override
    void gtk4_enter_event(long l, double d, double d2, long l2) {
        byte[] byArray = null;
        if (this.toolTipText != null && this.toolTipText.length() != 0) {
            char[] cArray = this.fixMnemonic(this.toolTipText, false, true);
            byArray = Converter.wcsToMbcs(cArray, true);
        }
        long l3 = this.getShell().handle;
        GTK.gtk_widget_set_tooltip_text(l3, byArray);
        if (this.display.currentControl == this) {
            return;
        }
        if (this.display.currentControl != null && !this.display.currentControl.isDisposed()) {
            this.display.removeMouseHoverTimeout(this.display.currentControl.handle);
            this.display.currentControl.sendMouseEvent(7, 0, 0, d, d2, false, 0);
        }
        if (!this.isDisposed()) {
            this.display.currentControl = this;
            this.sendMouseEvent(6, 0, 0, d, d2, false, 0);
        }
    }

    @Override
    long gtk_enter_notify_event(long l, long l2) {
        byte[] byArray = null;
        if (this.toolTipText != null && this.toolTipText.length() != 0) {
            char[] cArray = this.fixMnemonic(this.toolTipText, false, true);
            byArray = Converter.wcsToMbcs(cArray, true);
        }
        long l3 = this.getShell().handle;
        GTK.gtk_widget_set_tooltip_text(l3, byArray);
        if (this.display.currentControl == this) {
            return 0L;
        }
        int[] nArray = new int[1];
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        GDK.gdk_event_get_state(l2, nArray);
        GDK.gdk_event_get_coords(l2, dArray, dArray2);
        int n = GDK.gdk_event_get_time(l2);
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        GDK.gdk_event_get_root_coords(l2, dArray3, dArray4);
        this.lastInput.x = (int)dArray[0];
        this.lastInput.y = (int)dArray2[0];
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0L;
        }
        GdkEventCrossing gdkEventCrossing = new GdkEventCrossing();
        long l4 = 0L;
        int[] nArray2 = new int[1];
        GTK3.memmove(gdkEventCrossing, l2, (long)GdkEventCrossing.sizeof);
        nArray2[0] = gdkEventCrossing.mode;
        l4 = gdkEventCrossing.subwindow;
        if (l4 != 0L && this.checkSubwindow()) {
            return 0L;
        }
        if (nArray2[0] != 0 && nArray2[0] != 2) {
            return 0L;
        }
        if ((nArray[0] & 0x700) != 0) {
            return 0L;
        }
        if (this.display.currentControl != null && !this.display.currentControl.isDisposed()) {
            this.display.removeMouseHoverTimeout(this.display.currentControl.handle);
            this.display.currentControl.sendMouseEvent(7, 0, n, dArray3[0], dArray4[0], false, nArray[0]);
        }
        if (!this.isDisposed()) {
            this.display.currentControl = this;
            return this.sendMouseEvent(6, 0, n, dArray3[0], dArray4[0], false, nArray[0]) ? 0L : 1L;
        }
        return 0L;
    }

    boolean checkSubwindow() {
        return false;
    }

    @Override
    long gtk_event_after(long l, long l2) {
        int n = GDK.gdk_event_get_event_type(l2);
        n = Control.fixGdkEventTypeValues(n);
        switch (n) {
            case 4: {
                if (l != this.eventHandle() || (this.state & 0x20) != 0) break;
                double[] dArray = new double[1];
                double[] dArray2 = new double[1];
                GDK.gdk_event_get_root_coords(l2, dArray, dArray2);
                int[] nArray = new int[1];
                GDK.gdk_event_get_button(l2, nArray);
                if (nArray[0] != 3) break;
                this.showMenu((int)dArray[0], (int)dArray2[0]);
                break;
            }
            case 12: {
                if (!this.isFocusHandle(l)) break;
                boolean[] blArray = new boolean[1];
                GdkEventFocus gdkEventFocus = new GdkEventFocus();
                GTK3.memmove(gdkEventFocus, l2, (long)GdkEventFocus.sizeof);
                blArray[0] = gdkEventFocus.in != 0;
                Display display = this.display;
                if (blArray[0]) {
                    if (display.ignoreFocus) {
                        display.ignoreFocus = false;
                        break;
                    }
                } else {
                    display.ignoreFocus = false;
                    long l3 = GTK3.gtk_grab_get_current();
                    if (l3 != 0L && OS.G_OBJECT_TYPE(l3) == GTK3.GTK_TYPE_MENU()) {
                        display.ignoreFocus = true;
                        break;
                    }
                }
                this.sendFocusEvent(blArray[0] ? 15 : 16);
                break;
            }
        }
        return 0L;
    }

    void cairoCopyRegion(Region region) {
        if (region == null || region.isDisposed() || region.handle == 0L) {
            return;
        }
        this.regionHandle = Cairo.cairo_region_copy(region.handle);
    }

    void cairoDisposeRegion() {
        if (this.regionHandle != 0L) {
            Cairo.cairo_region_destroy(this.regionHandle);
        }
        if (this.eventRegion != 0L) {
            Cairo.cairo_region_destroy(this.eventRegion);
        }
        this.regionHandle = 0L;
        this.eventRegion = 0L;
    }

    void cairoClipRegion(long l) {
        GdkRectangle gdkRectangle = new GdkRectangle();
        GDK.gdk_cairo_get_clip_rectangle(l, gdkRectangle);
        long l2 = this.regionHandle;
        if (l2 == 0L) {
            this.drawRegion = false;
            return;
        }
        cairo_rectangle_int_t cairo_rectangle_int_t2 = new cairo_rectangle_int_t();
        cairo_rectangle_int_t2.convertFromGdkRectangle(gdkRectangle);
        long l3 = Cairo.cairo_region_create_rectangle(cairo_rectangle_int_t2);
        Cairo.cairo_region_subtract(l3, l2);
        Shell shell = this.getShell();
        Color color = shell.getBackground();
        if (color != this.getBackground()) {
            GdkRGBA gdkRGBA = color.handle;
            Cairo.cairo_set_source_rgba(l, gdkRGBA.red, gdkRGBA.green, gdkRGBA.blue, gdkRGBA.alpha);
        } else {
            Cairo.cairo_set_source_rgba(l, 0.0, 0.0, 0.0, 0.0);
        }
        GDK.gdk_cairo_region(l, l3);
        Cairo.cairo_clip(l);
        Cairo.cairo_paint(l);
        this.eventRegion = l3;
    }

    @Override
    void gtk4_draw(long l, long l2, Rectangle rectangle) {
        if (!this.hooksPaint()) {
            return;
        }
        GCData gCData = new GCData();
        gCData.cairo = l2;
        GC gC = GC.gtk_new(this, gCData);
        Event event = new Event();
        event.count = 1;
        event.gc = gC;
        event.setBounds(rectangle);
        this.drawWidget(gC);
        this.sendEvent(9, event);
        gC.dispose();
        event.gc = null;
    }

    @Override
    long gtk_draw(long l, long l2) {
        Object object;
        Object object2;
        long l3;
        if (this.checkScaleFactor && (l3 = Cairo.cairo_get_target(l2)) != 0L) {
            object2 = new double[1];
            object = new double[1];
            Cairo.cairo_surface_get_device_scale(l3, object2, object);
            long l4 = GDK.gdk_display_get_default();
            long l5 = GDK.gdk_display_get_monitor_at_point(l4, 0, 0);
            int n = GDK.gdk_monitor_get_scale_factor(l5);
            this.autoScale = (long)n != Math.round(object2[0]);
            this.checkScaleFactor = false;
        }
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        GDK.gdk_cairo_get_clip_rectangle(l2, gdkRectangle);
        if (this.drawRegion) {
            this.cairoClipRegion(l2);
        }
        if (!this.hooksPaint()) {
            return 0L;
        }
        Event event = new Event();
        event.count = 1;
        object2 = DPIUtil.autoScaleDown(new Rectangle(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height));
        if ((this.style & 0x8000000) != 0) {
            object2.x = DPIUtil.autoScaleDown(this.getClientWidth()) - object2.width - object2.x;
        }
        event.setBounds((Rectangle)object2);
        object = new GCData();
        if (this.drawRegion) {
            object.regionSet = this.eventRegion;
        }
        object.cairo = l2;
        GC gC = event.gc = GC.gtk_new(this, (GCData)object);
        gC.setClipping(object2.x, object2.y, object2.width, object2.height);
        this.drawWidget(gC);
        this.sendEvent(9, event);
        gC.dispose();
        event.gc = null;
        return 0L;
    }

    @Override
    long gtk_focus(long l, long l2) {
        return 1L;
    }

    @Override
    long gtk_focus_in_event(long l, long l2) {
        if (this.handle != 0L) {
            long l3;
            Control control = this.display.imControl;
            if (control != this && control != null && !control.isDisposed() && (l3 = control.imHandle()) != 0L) {
                GTK.gtk_im_context_reset(l3);
            }
            if ((this.hooks(1) || this.hooks(2)) && (l3 = this.imHandle()) != 0L) {
                GTK.gtk_im_context_focus_in(l3);
            }
        }
        return 0L;
    }

    @Override
    void gtk4_focus_enter_event(long l, long l2) {
        super.gtk4_focus_enter_event(l, l2);
        this.sendFocusEvent(15);
    }

    @Override
    void gtk4_focus_window_event(long l, long l2) {
        super.gtk4_focus_window_event(l, l2);
        if (this.firstFixedHandle == 0L) {
            long l3 = l;
            for (int i = 0; i < 3; ++i) {
                l3 = GTK4.gtk_widget_get_first_child(l3);
            }
            long l4 = this.firstFixedHandle = l3 != 0L ? l3 : 0L;
        }
        if (this.firstFixedHandle != 0L && GTK.gtk_widget_has_focus(this.firstFixedHandle)) {
            if (l2 == 15L) {
                this.sendFocusEvent(15);
            } else {
                this.sendFocusEvent(16);
            }
        }
    }

    @Override
    long gtk_focus_out_event(long l, long l2) {
        long l3;
        if (this.handle != 0L && (this.hooks(1) || this.hooks(2)) && (l3 = this.imHandle()) != 0L) {
            GTK.gtk_im_context_focus_out(l3);
        }
        return 0L;
    }

    @Override
    void gtk4_focus_leave_event(long l, long l2) {
        super.gtk4_focus_leave_event(l, l2);
        this.sendFocusEvent(16);
    }

    @Override
    boolean gtk4_key_press_event(long l, int n, int n2, int n3, long l2) {
        if (!this.hasFocus()) {
            return false;
        }
        if (this.translateMnemonic(n, l2)) {
            return true;
        }
        if (this.isDisposed()) {
            return false;
        }
        if (this.filterKey(l2)) {
            return true;
        }
        if (this.isDisposed()) {
            return false;
        }
        if (this.translateTraversal(l2)) {
            return true;
        }
        if (this.isDisposed()) {
            return false;
        }
        return super.gtk4_key_press_event(l, n, n2, n3, l2);
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        int[] nArray = new int[1];
        GDK.gdk_event_get_keyval(l2, nArray);
        if (!this.hasFocus()) {
            if (this.display.getActiveShell() == null && this.filterKey(l2)) {
                return 1L;
            }
            return 0L;
        }
        if (this.translateMnemonic(nArray[0], l2)) {
            return 1L;
        }
        if (this.isDisposed()) {
            return 0L;
        }
        if (this.filterKey(l2)) {
            return 1L;
        }
        if (this.isDisposed()) {
            return 0L;
        }
        if (this.translateTraversal(l2)) {
            return 1L;
        }
        if (this.isDisposed()) {
            return 0L;
        }
        return super.gtk_key_press_event(l, l2);
    }

    @Override
    void gtk4_key_release_event(long l, int n, int n2, int n3, long l2) {
        if (!this.hasFocus()) {
            return;
        }
        long l3 = this.imHandle();
        if (l3 != 0L) {
            GTK4.gtk_im_context_filter_keypress(l3, l2);
        }
        super.gtk4_key_release_event(l, n, n2, n3, l2);
    }

    @Override
    long gtk_key_release_event(long l, long l2) {
        if (!this.hasFocus()) {
            return 0L;
        }
        long l3 = this.imHandle();
        if (l3 != 0L && GTK3.gtk_im_context_filter_keypress(l3, l2)) {
            return 1L;
        }
        return super.gtk_key_release_event(l, l2);
    }

    @Override
    void gtk4_leave_event(long l, long l2) {
        if (this.display.currentControl != this) {
            return;
        }
        this.display.removeMouseHoverTimeout(this.handle);
        if (this.sendLeaveNotify() || this.display.getCursorControl() == null) {
            this.sendMouseEvent(7, 0, 0, 0.0, 0.0, false, 0);
        }
    }

    @Override
    long gtk_leave_notify_event(long l, long l2) {
        if (this.display.currentControl != this) {
            return 0L;
        }
        int[] nArray = new int[1];
        GDK.gdk_event_get_state(l2, nArray);
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        GDK.gdk_event_get_coords(l2, dArray, dArray2);
        int n = GDK.gdk_event_get_time(l2);
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        GDK.gdk_event_get_root_coords(l2, dArray3, dArray4);
        this.lastInput.x = (int)dArray[0];
        this.lastInput.y = (int)dArray2[0];
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0L;
        }
        GdkEventCrossing gdkEventCrossing = new GdkEventCrossing();
        int[] nArray2 = new int[1];
        GTK3.memmove(gdkEventCrossing, l2, (long)GdkEventCrossing.sizeof);
        nArray2[0] = gdkEventCrossing.mode;
        this.display.removeMouseHoverTimeout(this.handle);
        int n2 = 0;
        if (this.sendLeaveNotify() || this.display.getCursorControl() == null) {
            if (nArray2[0] != 0 && nArray2[0] != 2) {
                return 0L;
            }
            if ((nArray[0] & 0x700) != 0) {
                return 0L;
            }
            n2 = this.sendMouseEvent(7, 0, n, dArray3[0], dArray4[0], false, nArray[0]) ? 0 : 1;
            this.display.currentControl = null;
        }
        return n2;
    }

    @Override
    long gtk_mnemonic_activate(long l, long l2) {
        int n = 0;
        long l3 = GTK3.gtk_get_current_event();
        if (l3 != 0L) {
            int n2 = GDK.gdk_event_get_event_type(l3);
            if ((n2 = Control.fixGdkEventTypeValues(n2)) == 8) {
                long l4;
                Control control = this.display.getFocusControl();
                long l5 = l4 = control != null ? control.focusHandle() : 0L;
                if (l4 != 0L) {
                    this.display.mnemonicControl = this;
                    GTK3.gtk_widget_event(l4, l3);
                    this.display.mnemonicControl = null;
                }
                n = 1;
            }
            this.gdk_event_free(l3);
        }
        return n;
    }

    @Override
    void gtk4_motion_event(long l, double d, double d2, long l2) {
        if (this == this.display.currentControl && (this.hooks(32) || this.filters(32))) {
            this.display.addMouseHoverTimeout(this.handle);
        }
        int n = GDK.gdk_event_get_time(l2);
        int n2 = GDK.gdk_event_get_modifier_state(l2);
        boolean bl = false;
        if (this != this.display.currentControl) {
            if (this.display.currentControl != null && !this.display.currentControl.isDisposed()) {
                this.display.removeMouseHoverTimeout(this.display.currentControl.handle);
                this.display.currentControl.sendMouseEvent(7, 0, n, d, d2, bl, n2);
            }
            if (!this.isDisposed()) {
                this.display.currentControl = this;
                this.sendMouseEvent(6, 0, n, d, d2, bl, n2);
            }
        }
        this.sendMouseEvent(5, 0, n, d, d2, bl, n2);
    }

    @Override
    long gtk_motion_notify_event(long l, long l2) {
        Object object;
        double d;
        double d2;
        int n;
        int n2;
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        GDK.gdk_event_get_coords(l2, dArray, dArray2);
        this.lastInput.x = (int)dArray[0];
        this.lastInput.y = (int)dArray2[0];
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0L;
        }
        if (this.dragDetectionQueue != null && OS.isWayland()) {
            boolean[] blArray;
            n2 = 0;
            if ((this.state & 0x800000) != 0 && this.wantDragDropDetection() && this.dragDetect((int)dArray[0], (int)dArray2[0], true, true, blArray = new boolean[1])) {
                n2 = 1;
                if (blArray[0]) {
                    n = 1;
                }
                if (this.isDisposed()) {
                    return 1L;
                }
            }
            if (n2 != 0) {
                GTK3.gtk_event_controller_handle_event(this.dragGesture, l2);
                int n3 = GDK.gdk_event_get_event_type(l2);
                if (n3 == 6) {
                    return 0L;
                }
                Point point = DPIUtil.autoScaleDown(new Point((int)dArray[0], (int)dArray2[0]));
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                if (GTK.GTK4) {
                    nArray[0] = GDK.gdk_button_event_get_button(l2);
                    nArray2[0] = GDK.gdk_event_get_modifier_state(l2);
                } else {
                    GDK.gdk_event_get_button(l2, nArray);
                    GDK.gdk_event_get_state(l2, nArray2);
                }
                if (this.sendDragEvent(nArray[0], nArray2[0], point.x, point.y, false)) {
                    return 1L;
                }
            }
        }
        if (this == this.display.currentControl && (this.hooks(32) || this.filters(32))) {
            this.display.addMouseHoverTimeout(this.handle);
        }
        n2 = GDK.gdk_event_get_time(l2);
        int[] nArray = new int[1];
        boolean bl = false;
        if (GTK.GTK4) {
            nArray[0] = GDK.gdk_event_get_modifier_state(l2);
            d2 = dArray[0];
            d = dArray2[0];
        } else {
            object = new double[1];
            double[] dArray3 = new double[1];
            GDK.gdk_event_get_root_coords(l2, object, dArray3);
            d2 = object[0];
            d = dArray3[0];
            GdkEventMotion gdkEventMotion = new GdkEventMotion();
            GTK3.memmove(gdkEventMotion, l2, (long)GdkEventMotion.sizeof);
            nArray[0] = gdkEventMotion.state;
            boolean bl2 = bl = gdkEventMotion.is_hint != 0;
            if (bl) {
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                int[] nArray5 = new int[1];
                long l3 = this.eventWindow();
                this.display.getWindowPointerPosition(l3, nArray3, nArray4, nArray5);
                d2 = nArray3[0];
                d = nArray4[0];
                nArray[0] = nArray5[0];
            }
        }
        if (this != this.display.currentControl) {
            if (this.display.currentControl != null && !this.display.currentControl.isDisposed()) {
                this.display.removeMouseHoverTimeout(this.display.currentControl.handle);
                object = this.display.mapInPixels(this, this.display.currentControl, (int)d2, (int)d);
                this.display.currentControl.sendMouseEvent(7, 0, n2, object.x, object.y, bl, nArray[0]);
            }
            if (!this.isDisposed()) {
                this.display.currentControl = this;
                this.sendMouseEvent(6, 0, n2, d2, d, bl, nArray[0]);
            }
        }
        n = this.sendMouseEvent(5, 0, n2, d2, d, bl, nArray[0]) ? 0 : 1;
        return n;
    }

    @Override
    long gtk_popup_menu(long l) {
        if (!this.hasFocus()) {
            return 0L;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (!GTK.GTK4) {
            this.display.getWindowPointerPosition(0L, nArray, nArray2, null);
        }
        return this.showMenu(nArray[0], nArray2[0], 1) ? 1L : 0L;
    }

    @Override
    long gtk_preedit_changed(long l) {
        this.display.showIMWindow(this);
        return 0L;
    }

    @Override
    long gtk_realize(long l) {
        long l2;
        if (!GTK.GTK4 && (l2 = this.imHandle()) != 0L) {
            long l3 = this.gtk_widget_get_window(this.paintHandle());
            GTK.gtk_im_context_set_client_window(l2, l3);
        }
        if (this.backgroundImage != null) {
            this.setBackgroundSurface(this.backgroundImage);
        }
        return 0L;
    }

    @Override
    boolean gtk4_scroll_event(long l, double d, double d2, long l2) {
        boolean bl;
        boolean bl2 = false;
        int n = GDK.gdk_event_get_time(l2);
        int n2 = GDK.gdk_event_get_modifier_state(l2);
        int n3 = GDK.gdk_scroll_event_get_direction(l2);
        boolean bl3 = bl = n3 != 4;
        if (bl) {
            switch (n3) {
                case 0: {
                    return !this.sendMouseEvent(37, 0, 3, 1, true, n, 0.0, 0.0, false, n2);
                }
                case 1: {
                    return !this.sendMouseEvent(37, 0, -3, 1, true, n, 0.0, 0.0, false, n2);
                }
                case 2: {
                    return !this.sendMouseEvent(38, 0, 3, 0, true, n, 0.0, 0.0, false, n2);
                }
                case 3: {
                    return !this.sendMouseEvent(38, 0, -3, 0, true, n, 0.0, 0.0, false, n2);
                }
            }
        } else {
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            GDK.gdk_scroll_event_get_deltas(l2, dArray, dArray2);
            if (dArray[0] != 0.0) {
                boolean bl4 = bl2 = !this.sendMouseEvent(38, 0, (int)(-3.0 * dArray[0]), 0, true, n, 0.0, 0.0, false, n2);
            }
            if (dArray2[0] != 0.0) {
                bl2 = !this.sendMouseEvent(37, 0, (int)(-3.0 * dArray2[0]), 1, true, n, 0.0, 0.0, false, n2);
            }
            return bl2;
        }
        return false;
    }

    @Override
    long gtk_scroll_event(long l, long l2) {
        long l3 = 0L;
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        GDK.gdk_event_get_coords(l2, dArray, dArray2);
        int[] nArray = new int[1];
        GDK.gdk_event_get_state(l2, nArray);
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        GDK.gdk_event_get_root_coords(l2, dArray3, dArray4);
        int n = GDK.gdk_event_get_time(l2);
        int[] nArray2 = new int[1];
        boolean bl = GDK.gdk_event_get_scroll_direction(l2, nArray2);
        this.lastInput.x = (int)dArray[0];
        this.lastInput.y = (int)dArray2[0];
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0L;
        }
        if (bl) {
            switch (nArray2[0]) {
                case 0: {
                    return this.sendMouseEvent(37, 0, 3, 1, true, n, dArray3[0], dArray4[0], false, nArray[0]) ? 0L : 1L;
                }
                case 1: {
                    return this.sendMouseEvent(37, 0, -3, 1, true, n, dArray3[0], dArray4[0], false, nArray[0]) ? 0L : 1L;
                }
                case 2: {
                    return this.sendMouseEvent(38, 0, 3, 0, true, n, dArray3[0], dArray4[0], false, nArray[0]) ? 0L : 1L;
                }
                case 3: {
                    return this.sendMouseEvent(38, 0, -3, 0, true, n, dArray3[0], dArray4[0], false, nArray[0]) ? 0L : 1L;
                }
            }
        } else {
            double[] dArray5 = new double[1];
            double[] dArray6 = new double[1];
            boolean bl2 = GDK.gdk_event_get_scroll_deltas(l2, dArray5, dArray6);
            if (bl2) {
                if (dArray5[0] != 0.0) {
                    l3 = this.sendMouseEvent(38, 0, (int)(-3.0 * dArray5[0]), 0, true, n, dArray3[0], dArray4[0], false, nArray[0]) ? 0 : 1;
                }
                if (dArray6[0] != 0.0) {
                    l3 = this.sendMouseEvent(37, 0, (int)(-3.0 * dArray6[0]), 1, true, n, dArray3[0], dArray4[0], false, nArray[0]) ? 0 : 1;
                }
            }
        }
        return l3;
    }

    @Override
    long gtk3_show_help(long l, long l2) {
        if (!this.hasFocus()) {
            return 0L;
        }
        return this.sendHelpEvent(l2) ? 1L : 0L;
    }

    @Override
    long gtk_style_updated(long l) {
        if (this.backgroundImage != null) {
            this.setBackgroundSurface(this.backgroundImage);
        }
        return 0L;
    }

    @Override
    long gtk_unrealize(long l) {
        long l2;
        if (!GTK.GTK4 && (l2 = this.imHandle()) != 0L) {
            GTK.gtk_im_context_set_client_window(l2, 0L);
        }
        return 0L;
    }

    @Override
    public long internal_new_GC(GCData gCData) {
        long l;
        long l2;
        this.checkWidget();
        long l3 = l2 = GTK.GTK4 ? this.paintSurface() : this.paintWindow();
        if (l2 == 0L) {
            this.error(2);
        }
        if ((l = gCData.cairo) != 0L) {
            Cairo.cairo_reference(l);
        } else if (GTK.GTK4) {
            long l4 = GDK.gdk_surface_create_similar_surface(l2, 12288, gCData.width, gCData.height);
            l = Cairo.cairo_create(l4);
        } else {
            l = GDK.gdk_cairo_create(l2);
        }
        if (l == 0L) {
            this.error(2);
        }
        if (gCData != null) {
            int n = 0x6000000;
            if ((gCData.style & n) == 0) {
                gCData.style |= this.style & (n | 0x8000000);
            } else if ((gCData.style & 0x4000000) != 0) {
                gCData.style |= 0x8000000;
            }
            gCData.drawable = l2;
            gCData.device = this.display;
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            gCData.font = this.font != null ? this.font : this.defaultFont();
            gCData.foregroundRGBA = this.getForegroundGdkRGBA();
            gCData.backgroundRGBA = control.getBackgroundGdkRGBA();
        }
        return l;
    }

    long imHandle() {
        return 0L;
    }

    @Override
    public void internal_dispose_GC(long l, GCData gCData) {
        this.checkWidget();
        Cairo.cairo_destroy(l);
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point point = control.getSizeInPixels();
            if (point.x == 0 || point.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            for (n = 0; n < controlArray.length; ++n) {
                if (controlArray[n] != this) continue;
                return true;
            }
        }
        if (((n = this.traversalCode(0, 0L)) & 0x60) != 0) {
            return false;
        }
        return (n & 0x18) != 0;
    }

    boolean isTabItem() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            for (n = 0; n < controlArray.length; ++n) {
                if (controlArray[n] != this) continue;
                return false;
            }
        }
        return ((n = this.traversalCode(0, 0L)) & 0x60) != 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        Control control = this.display.focusControl;
        if (control != null && !control.isDisposed()) {
            return this == control;
        }
        return this.hasFocus();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    boolean mnemonicHit(char c) {
        return false;
    }

    boolean mnemonicMatch(char c) {
        return false;
    }

    @Override
    void register() {
        long l;
        super.register();
        if (this.fixedHandle != 0L) {
            this.display.addWidget(this.fixedHandle, this);
        }
        if ((l = this.imHandle()) != 0L) {
            this.display.addWidget(l, this);
        }
    }

    public void requestLayout() {
        this.getShell().layout(new Control[]{this}, 4);
    }

    public void redraw() {
        this.checkWidget();
        this.redraw(false);
    }

    void redraw(boolean bl) {
        if (!GTK.gtk_widget_get_visible(this.topHandle())) {
            return;
        }
        this.redrawWidget(0, 0, 0, 0, true, bl, false);
    }

    public void redraw(int n, int n2, int n3, int n4, boolean bl) {
        this.checkWidget();
        Rectangle rectangle = DPIUtil.autoScaleUp(new Rectangle(n, n2, n3, n4));
        this.redrawInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl);
    }

    void redrawInPixels(int n, int n2, int n3, int n4, boolean bl) {
        this.checkWidget();
        if (!GTK.gtk_widget_get_visible(this.topHandle())) {
            return;
        }
        if ((this.style & 0x8000000) != 0) {
            n = this.getClientWidth() - n3 - n;
        }
        this.redrawWidget(n, n2, n3, n4, false, bl, false);
    }

    void redrawChildren() {
    }

    void redrawWidget(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        if (!GTK.gtk_widget_get_realized(this.handle)) {
            return;
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        if (GTK.GTK4) {
            long l = this.paintSurface();
            if (bl) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                this.gdk_surface_get_size(l, nArray, nArray2);
                gdkRectangle.width = nArray[0];
                gdkRectangle.height = nArray2[0];
            } else {
                gdkRectangle.x = n;
                gdkRectangle.y = n2;
                gdkRectangle.width = Math.max(0, n3);
                gdkRectangle.height = Math.max(0, n4);
            }
        } else {
            long l = this.paintWindow();
            if (bl) {
                int[] nArray = new int[1];
                int[] nArray3 = new int[1];
                this.gdk_window_get_size(l, nArray, nArray3);
                gdkRectangle.width = nArray[0];
                gdkRectangle.height = nArray3[0];
            } else {
                gdkRectangle.x = n;
                gdkRectangle.y = n2;
                gdkRectangle.width = Math.max(0, n3);
                gdkRectangle.height = Math.max(0, n4);
            }
            GDK.gdk_window_invalidate_rect(l, gdkRectangle, bl2);
        }
    }

    @Override
    void release(boolean bl) {
        Control control = null;
        Control control2 = null;
        if (bl && this.parent != null) {
            int n;
            Control[] controlArray = this.parent._getChildren();
            for (n = 0; n < controlArray.length && controlArray[n] != this; ++n) {
            }
            if (n > 0) {
                control2 = controlArray[n - 1];
            }
            if (n + 1 < controlArray.length) {
                control = controlArray[n + 1];
                control.removeRelation();
            }
            this.removeRelation();
        }
        super.release(bl);
        if (bl && control2 != null && control != null) {
            control2.addRelation(control);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.fixedHandle = 0L;
        this.parent = null;
        this.cairoDisposeRegion();
    }

    @Override
    void releaseParent() {
        this.parent.removeControl(this);
    }

    @Override
    void releaseWidget() {
        boolean bl = this.display.getFocusControl() == this;
        super.releaseWidget();
        if (bl) {
            this.fixFocus(this);
        }
        if (this.display.currentControl == this) {
            this.display.currentControl = null;
        }
        this.display.removeMouseHoverTimeout(this.handle);
        if (!GTK.GTK4) {
            long l = this.imHandle();
            if (l != 0L && GTK.GTK_IS_IM_CONTEXT(l)) {
                GTK.gtk_im_context_reset(l);
                GTK.gtk_im_context_set_client_window(l, 0L);
            }
            if (this.enableWindow != 0L) {
                GDK.gdk_window_set_user_data(this.enableWindow, 0L);
                GDK.gdk_window_destroy(this.enableWindow);
                this.enableWindow = 0L;
            }
            this.redrawWindow = 0L;
        }
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        this.cursor = null;
        this.toolTipText = null;
        this.layoutData = null;
        if (this.accessible != null) {
            this.accessible.internal_dispose_Accessible();
        }
        this.accessible = null;
        this.region = null;
        if (this.dragGesture != 0L) {
            OS.g_object_unref(this.dragGesture);
            this.dragGesture = 0L;
        }
        if (this.rotateGesture != 0L) {
            OS.g_object_unref(this.rotateGesture);
            this.rotateGesture = 0L;
        }
        if (this.zoomGesture != 0L) {
            OS.g_object_unref(this.zoomGesture);
            this.zoomGesture = 0L;
        }
    }

    @Override
    void destroyWidget() {
        if (GTK.GTK4) {
            if (this.parent != null) {
                long l = this.topHandle();
                if (GTK.GTK_IS_WINDOW(l)) {
                    GTK4.gtk_window_destroy(l);
                } else {
                    OS.swt_fixed_remove(this.parent.parentingHandle(), this.fixedHandle);
                }
            }
            this.releaseHandle();
        } else {
            super.destroyWidget();
        }
    }

    void restackWindow(long l, long l2, boolean bl) {
        GDK.gdk_window_restack(l, l2, bl);
    }

    void flushQueueOnDnd() {
        Event event = this.dragDetectionQueue.getFirst();
        event.data = true;
        this.dragDetectionQueue = null;
        this.sendOrPost(3, event);
    }

    boolean sendDragEvent(int n, int n2, int n3, int n4, boolean bl) {
        if (OS.isWayland() && this.dragDetectionQueue != null) {
            this.flushQueueOnDnd();
        }
        Event event = new Event();
        event.button = n;
        Rectangle rectangle = new Rectangle(n3, n4, 0, 0);
        event.setBounds(rectangle);
        if ((this.style & 0x8000000) != 0) {
            event.x = DPIUtil.autoScaleDown(this.getClientWidth()) - event.x;
        }
        if (bl) {
            event.stateMask = n2;
        } else {
            this.setInputState(event, n2);
        }
        this.postEvent(29, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    void sendFocusEvent(int n) {
        Shell shell = this._getShell();
        Display display = this.display;
        display.focusControl = this;
        display.focusEvent = n;
        this.sendEvent(n);
        display.focusControl = null;
        display.focusEvent = 0;
        if (!shell.isDisposed()) {
            switch (n) {
                case 15: {
                    shell.setActiveControl(this);
                    break;
                }
                case 16: {
                    if (shell == display.activeShell) break;
                    shell.setActiveControl(null);
                }
            }
        }
    }

    boolean sendGestureEvent(int n, int n2, int n3, int n4, double d) {
        if (this.containedInRegion(n3, n4)) {
            return false;
        }
        switch (n2) {
            case 8: {
                return this.sendGestureEvent(n, n2, n3, n4, d, 0, 0, 0.0);
            }
            case 32: {
                return this.sendGestureEvent(n, n2, n3, n4, 0.0, 0, 0, d);
            }
            case 2: {
                return this.sendGestureEvent(n, n2, n3, n4, 0.0, 0, 0, d);
            }
            case 4: {
                return this.sendGestureEvent(n, n2, 0, 0, 0.0, 0, 0, 0.0);
            }
        }
        return false;
    }

    boolean sendGestureEvent(int n, int n2, int n3, int n4, double d, double d2) {
        if (this.containedInRegion(n3, n4)) {
            return false;
        }
        if (n2 == 16) {
            return this.sendGestureEvent(n, n2, n3, n4, 0.0, (int)d, (int)d2, 0.0);
        }
        return false;
    }

    boolean sendGestureEvent(int n, int n2, int n3, int n4, double d, int n5, int n6, double d2) {
        if (this.containedInRegion(n3, n4)) {
            return false;
        }
        Event event = new Event();
        event.stateMask = n;
        event.detail = n2;
        event.x = n3;
        event.y = n4;
        switch (n2) {
            case 8: {
                event.rotation = d;
                break;
            }
            case 32: {
                event.magnification = d2;
                break;
            }
            case 16: {
                event.xDirection = n5;
                event.yDirection = n6;
                break;
            }
        }
        this.postEvent(48, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    boolean sendHelpEvent(long l) {
        Control control = this;
        while (control != null) {
            if (control.hooks(28)) {
                control.postEvent(28);
                return true;
            }
            control = control.parent;
        }
        return false;
    }

    boolean sendLeaveNotify() {
        return false;
    }

    boolean sendMouseEvent(int n, int n2, int n3, double d, double d2, boolean bl, int n4) {
        if (this.containedInRegion((int)d, (int)d2)) {
            return true;
        }
        return this.sendMouseEvent(n, n2, 0, 0, false, n3, d, d2, bl, n4);
    }

    boolean sendMouseEvent(int n, int n2, int n3, int n4, boolean bl, int n5, double d, double d2, boolean bl2, int n6) {
        Event event2;
        if (this.containedInRegion((int)d, (int)d2)) {
            return true;
        }
        if (!this.hooks(n) && !this.filters(n)) {
            if (OS.isWayland() && this.dragDetectionQueue != null && n == 4 && this.dragDetectionQueue.size() == 1) {
                event2 = this.dragDetectionQueue.getFirst();
                this.dragDetectionQueue = null;
                this.sendOrPost(3, event2);
            }
            if (OS.isX11() || this.dragDetectionQueue == null || n != 5) {
                return true;
            }
        }
        event2 = new Event();
        event2.time = n5;
        event2.button = n2;
        event2.detail = n4;
        event2.count = n3;
        if (bl2) {
            var14_12 = new Rectangle((int)d, (int)d2, 0, 0);
            event2.setBounds(DPIUtil.autoScaleDown((Rectangle)var14_12));
        } else {
            var14_12 = new int[1];
            int[] nArray = new int[1];
            if (GTK.GTK4) {
                Rectangle rectangle = new Rectangle((int)d, (int)d2, 0, 0);
                event2.setBounds(DPIUtil.autoScaleDown(rectangle));
            } else {
                long l = this.eventWindow();
                GDK.gdk_window_get_origin(l, var14_12, nArray);
                Rectangle rectangle = new Rectangle((int)d - var14_12[0], (int)d2 - nArray[0], 0, 0);
                event2.setBounds(DPIUtil.autoScaleDown(rectangle));
            }
        }
        if ((this.style & 0x8000000) != 0) {
            event2.x = DPIUtil.autoScaleDown(this.getClientWidth()) - event2.x;
        }
        this.setInputState(event2, n6);
        event2.data = bl;
        if (OS.isWayland()) {
            if (n == 3) {
                if (this.wantDragDropDetection()) {
                    this.dragDetectionQueue = new LinkedList();
                    this.dragDetectionQueue.add(event2);
                    return true;
                }
            } else if (this.dragDetectionQueue != null) {
                switch (n) {
                    case 5: {
                        if (this.dragDetect(event2.x, event2.y, false, true, null)) {
                            this.flushQueueOnDnd();
                            break;
                        }
                        this.dragDetectionQueue.add(event2);
                        break;
                    }
                    case 4: {
                        mouseDown = false;
                        boolean bl3 = bl ? true : (Boolean)this.dragDetectionQueue.getFirst().data;
                        this.dragDetectionQueue.forEach(event -> {
                            event.data = bl3;
                        });
                        this.sendOrPost(3, this.dragDetectionQueue.removeFirst());
                        this.dragDetectionQueue.forEach(event -> this.sendOrPost(5, (Event)event));
                        this.dragDetectionQueue = null;
                    }
                }
            }
        }
        return this.sendOrPost(n, event2);
    }

    private boolean sendOrPost(int n, Event event) {
        assert (event.data != null) : "event.data should have been a Boolean, but received null";
        boolean bl = (Boolean)event.data;
        event.data = null;
        if (bl) {
            this.sendEvent(n, event);
            if (this.isDisposed()) {
                return false;
            }
        } else {
            this.postEvent(n, event);
        }
        return event.doit;
    }

    void gtk_widget_set_align(long l, int n, int n2) {
        GTK.gtk_widget_set_halign(l, n);
        GTK.gtk_widget_set_valign(l, n2);
    }

    void gtk_label_set_align(long l, float f, float f2) {
        GTK.gtk_label_set_xalign(l, f);
        GTK.gtk_label_set_yalign(l, f2);
    }

    void setBackground() {
        if ((this.state & 0x2000) == 0 && this.backgroundImage == null) {
            if ((this.state & 0x8000) != 0) {
                this.setParentBackground();
            } else {
                this.setWidgetBackground();
            }
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this._setBackground(color);
        if (color != null) {
            this.updateBackgroundMode();
        }
    }

    private void _setBackground(Color color) {
        if ((this.state & 0x2000) == 0 && color == null) {
            return;
        }
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        boolean bl = false;
        GdkRGBA gdkRGBA = null;
        if (color != null) {
            gdkRGBA = color.handle;
            this.backgroundAlpha = color.getAlpha();
        }
        if (bl = true) {
            this.state = color == null ? (this.state &= 0xFFFFDFFF) : (this.state |= 0x2000);
            this.setBackgroundGdkRGBA(gdkRGBA);
        }
        this.redrawChildren();
    }

    void setBackgroundGdkRGBA(long l, long l2, GdkRGBA gdkRGBA) {
        GdkRGBA gdkRGBA2 = this.display.getSystemColor((int)26).handle;
        String string = this.display.gtk_widget_class_get_css_name(l2);
        String string2 = string + " {background-color: " + this.display.gtk_rgba_to_css_string(gdkRGBA) + ";}\n" + string + ":selected {background-color: " + this.display.gtk_rgba_to_css_string(gdkRGBA2) + ";}";
        this.cssBackground = string2;
        String string3 = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(l, string3);
    }

    void gtk_css_provider_load_from_css(long l, String string) {
        if (this.provider == 0L) {
            this.provider = GTK.gtk_css_provider_new();
            GTK.gtk_style_context_add_provider(l, this.provider, 600);
            OS.g_object_unref(this.provider);
        }
        if (GTK.GTK4) {
            GTK4.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs(string, true), -1L);
        } else {
            GTK3.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs(string, true), -1L, null);
        }
    }

    void setBackgroundGdkRGBA(GdkRGBA gdkRGBA) {
        this.setBackgroundGdkRGBA(this.handle, gdkRGBA);
    }

    void setBackgroundGdkRGBA(long l, GdkRGBA gdkRGBA) {
        double d = 1.0;
        if (gdkRGBA == null) {
            if ((this.state & 0x8000) != 0) {
                d = 0.0;
                Control control = this.findBackgroundControl();
                if (control == null) {
                    control = this;
                }
                gdkRGBA = control.getBackgroundGdkRGBA();
            }
        } else {
            d = this.backgroundAlpha;
        }
        if (gdkRGBA != null) {
            gdkRGBA.alpha = d / 255.0;
        }
        long l2 = GTK.gtk_widget_get_style_context(l);
        this.setBackgroundGdkRGBA(l2, l, gdkRGBA);
        if (!GTK.GTK4) {
            GTK3.gtk_style_context_invalidate(l2);
        }
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (image == this.backgroundImage && this.backgroundAlpha > 0) {
            return;
        }
        this.backgroundAlpha = 255;
        this.backgroundImage = image;
        if (this.backgroundImage != null) {
            this.setBackgroundSurface(this.backgroundImage);
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        } else {
            this.setWidgetBackground();
        }
        this.redrawChildren();
    }

    void setBackgroundSurface(Image image) {
    }

    public void setCapture(boolean bl) {
        this.checkWidget();
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        this.setCursor(cursor != null ? cursor.handle : 0L);
    }

    void setCursor(long l) {
        if (GTK.GTK4) {
            long l2 = this.eventHandle();
            GTK4.gtk_widget_set_cursor(l2, l);
        } else {
            long l3 = this.eventWindow();
            if (l3 != 0L) {
                GDK.gdk_window_set_cursor(l3, l);
                this.update(false, true);
            }
        }
    }

    public void setDragDetect(boolean bl) {
        this.checkWidget();
        this.state = bl ? (this.state |= 0x800000) : (this.state &= 0xFF7FFFFF);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if ((this.state & 0x10) == 0 == bl) {
            return;
        }
        Control control = null;
        boolean bl2 = false;
        if (!bl && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        this.state = bl ? (this.state &= 0xFFFFFFEF) : (this.state |= 0x10);
        this.enableWidget(bl);
        if (this.isDisposed()) {
            return;
        }
        if (!GTK.GTK4) {
            if (bl) {
                if (this.enableWindow != 0L) {
                    this.cleanupEnableWindow();
                }
            } else {
                GTK.gtk_widget_realize(this.handle);
                long l = this.parent.eventHandle();
                long l2 = this.parent.eventWindow();
                long l3 = this.topHandle();
                GdkWindowAttr gdkWindowAttr = new GdkWindowAttr();
                GtkAllocation gtkAllocation = new GtkAllocation();
                GTK.gtk_widget_get_allocation(l3, gtkAllocation);
                gdkWindowAttr.x = gtkAllocation.x;
                gdkWindowAttr.y = gtkAllocation.y;
                gdkWindowAttr.width = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
                gdkWindowAttr.height = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
                gdkWindowAttr.event_mask = -32769;
                gdkWindowAttr.wclass = 1;
                gdkWindowAttr.window_type = 2;
                this.enableWindow = GTK3.gdk_window_new(l2, gdkWindowAttr, 12);
                if (this.enableWindow != 0L) {
                    GDK.gdk_window_set_user_data(this.enableWindow, l);
                    this.restackWindow(this.enableWindow, this.gtk_widget_get_window(l3), true);
                    if (GTK.gtk_widget_get_visible(l3)) {
                        GDK.gdk_window_show_unraised(this.enableWindow);
                    }
                }
            }
        }
        if (bl2) {
            this.fixFocus(control);
        }
    }

    void cleanupEnableWindow() {
        GDK.gdk_window_set_user_data(this.enableWindow, 0L);
        GDK.gdk_window_destroy(this.enableWindow);
        this.enableWindow = 0L;
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        long l;
        this.checkWidget();
        if ((this.state & 0x4000) == 0 && font == null) {
            return;
        }
        this.font = font;
        if (font == null) {
            l = this.defaultFont().handle;
        } else {
            if (font.isDisposed()) {
                this.error(5);
            }
            l = font.handle;
        }
        this.state = font == null ? (this.state &= 0xFFFFBFFF) : (this.state |= 0x4000);
        this.setFontDescription(l);
    }

    void setFontDescription(long l) {
        this.setFontDescription(this.handle, l);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if ((this.state & 0x1000) == 0 && color == null) {
            return;
        }
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        boolean bl = false;
        boolean bl2 = bl = !this.getForeground().equals(color);
        if (bl) {
            this.state = color == null ? (this.state &= 0xFFFFEFFF) : (this.state |= 0x1000);
            GdkRGBA gdkRGBA = color == null ? null : color.handle;
            this.setForegroundGdkRGBA(gdkRGBA);
        }
    }

    void setForegroundGdkRGBA(GdkRGBA gdkRGBA) {
        this.setForegroundGdkRGBA(this.handle, gdkRGBA);
    }

    void setForegroundGdkRGBA(long l, GdkRGBA gdkRGBA) {
        GdkRGBA gdkRGBA2 = gdkRGBA != null ? gdkRGBA : this.display.COLOR_WIDGET_FOREGROUND_RGBA;
        long l2 = GTK.gtk_widget_get_style_context(l);
        String string = this.display.gtk_rgba_to_css_string(gdkRGBA2);
        String string2 = this.display.gtk_widget_class_get_css_name(l);
        GdkRGBA gdkRGBA3 = this.display.COLOR_LIST_SELECTION_TEXT_RGBA;
        String string3 = !string2.contains("treeview") ? " selection" : ":selected";
        String string4 = "* {color: " + string + ";}\n" + string2 + string3 + " {color: " + this.display.gtk_rgba_to_css_string(gdkRGBA3) + ";}";
        this.cssForeground = string4;
        String string5 = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 16);
        this.gtk_css_provider_load_from_css(l2, string5);
    }

    void setInitialBounds() {
        if ((this.state & 0x200) != 0 && (this.state & 0x400) != 0) {
            if (!GTK.GTK4) {
                long l = this.topHandle();
                GtkAllocation gtkAllocation = new GtkAllocation();
                gtkAllocation.x = (this.parent.style & 0x8000000) != 0 ? this.parent.getClientWidth() : 0;
                gtkAllocation.y = 0;
                if (this.mustBeVisibleOnInitBounds()) {
                    GTK.gtk_widget_set_visible(l, true);
                }
                GTK.gtk_widget_get_preferred_size(l, null, null);
                GTK3.gtk_widget_size_allocate(l, gtkAllocation);
            }
        } else {
            this.resizeHandle(1, 1);
            this.forceResize();
        }
    }

    boolean mustBeVisibleOnInitBounds() {
        return false;
    }

    private void setDragGesture() {
        this.dragGesture = GTK.gtk_gesture_drag_new(this.handle);
        GTK.gtk_event_controller_set_propagation_phase(this.dragGesture, 2);
        GTK.gtk_gesture_single_set_button(this.dragGesture, 0);
        OS.g_signal_connect(this.dragGesture, OS.begin, gestureBegin.getAddress(), this.handle);
        OS.g_signal_connect(this.dragGesture, OS.end, gestureEnd.getAddress(), this.handle);
    }

    private void setRotateGesture() {
        this.rotateGesture = GTK.gtk_gesture_rotate_new(this.handle);
        GTK.gtk_event_controller_set_propagation_phase(this.rotateGesture, 2);
        OS.g_signal_connect(this.rotateGesture, OS.angle_changed, gestureRotation.getAddress(), this.handle);
        OS.g_signal_connect(this.rotateGesture, OS.begin, gestureBegin.getAddress(), this.handle);
        OS.g_signal_connect(this.rotateGesture, OS.end, gestureEnd.getAddress(), this.handle);
    }

    private void setZoomGesture() {
        this.zoomGesture = GTK.gtk_gesture_zoom_new(this.handle);
        GTK.gtk_event_controller_set_propagation_phase(this.zoomGesture, 2);
        OS.g_signal_connect(this.zoomGesture, OS.scale_changed, gestureZoom.getAddress(), this.handle);
        OS.g_signal_connect(this.zoomGesture, OS.begin, gestureBegin.getAddress(), this.handle);
        OS.g_signal_connect(this.zoomGesture, OS.end, gestureEnd.getAddress(), this.handle);
    }

    static Control getControl(long l) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(l);
        if (widget == null) {
            return null;
        }
        return (Control)widget;
    }

    static void rotateProc(long l, double d, double d2, long l2) {
        if (GTK.gtk_gesture_is_recognized(l)) {
            int[] nArray = new int[1];
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            GTK3.gtk_get_current_event_state(nArray);
            GTK.gtk_gesture_get_point(l, GTK.gtk_gesture_get_last_updated_sequence(l), dArray, dArray2);
            double d3 = -(GTK.gtk_gesture_rotate_get_angle_delta(l) * 100.0);
            Control control = Control.getControl(l2);
            control.sendGestureEvent(nArray[0], 8, (int)dArray[0], (int)dArray2[0], d3);
        }
    }

    static void magnifyProc(long l, double d, long l2) {
        if (GTK.gtk_gesture_is_recognized(l)) {
            int[] nArray = new int[1];
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            GTK3.gtk_get_current_event_state(nArray);
            GTK.gtk_gesture_get_point(l, GTK.gtk_gesture_get_last_updated_sequence(l), dArray, dArray2);
            double d2 = GTK.gtk_gesture_zoom_get_scale_delta(l);
            Control control = Control.getControl(l2);
            control.sendGestureEvent(nArray[0], 32, (int)dArray[0], (int)dArray2[0], d2);
        }
    }

    static void swipeProc(long l, double d, double d2, long l2) {
        double[] dArray;
        double[] dArray2;
        if (GTK.gtk_gesture_is_recognized(l) && GTK.gtk_gesture_swipe_get_velocity(l, dArray2 = new double[1], dArray = new double[1])) {
            int[] nArray = new int[1];
            double[] dArray3 = new double[1];
            double[] dArray4 = new double[1];
            GTK3.gtk_get_current_event_state(nArray);
            GTK.gtk_gesture_get_point(l, GTK.gtk_gesture_get_last_updated_sequence(l), dArray3, dArray4);
            Control control = Control.getControl(l2);
            control.sendGestureEvent(nArray[0], 16, (int)dArray3[0], (int)dArray4[0], dArray2[0], dArray[0]);
        }
    }

    static void gestureBeginProc(long l, long l2, long l3) {
        if (GTK.gtk_gesture_is_recognized(l)) {
            int[] nArray = new int[1];
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            GTK3.gtk_get_current_event_state(nArray);
            GTK.gtk_gesture_get_point(l, l2, dArray, dArray2);
            Control control = Control.getControl(l3);
            control.sendGestureEvent(nArray[0], 2, (int)dArray[0], (int)dArray2[0], 0.0);
        }
    }

    static void gestureEndProc(long l, long l2, long l3) {
        if (GTK.gtk_gesture_is_recognized(l)) {
            int[] nArray = new int[1];
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            GTK3.gtk_get_current_event_state(nArray);
            GTK.gtk_gesture_get_point(l, GTK.gtk_gesture_get_last_updated_sequence(l), dArray, dArray2);
            Control control = Control.getControl(l3);
            control.sendGestureEvent(nArray[0], 4, (int)dArray[0], (int)dArray2[0], 0.0);
        }
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    @Override
    void setOrientation(boolean bl) {
        if ((this.style & 0x4000000) != 0 || !bl) {
            int n;
            int n2 = n = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.handle != 0L) {
                GTK.gtk_widget_set_direction(this.handle, n);
            }
            if (this.fixedHandle != 0L) {
                GTK.gtk_widget_set_direction(this.fixedHandle, n);
            }
        }
    }

    public void setOrientation(int n) {
        this.checkWidget();
        int n2 = 0x6000000;
        if ((n & n2) == 0 || (n & n2) == n2) {
            return;
        }
        this.style &= ~n2;
        this.style |= n & n2;
        this.setOrientation(false);
        this.style &= 0xF7FFFFFF;
        this.checkMirrored();
    }

    public boolean setParent(Composite composite) {
        int n;
        this.checkWidget();
        if (composite == null) {
            this.error(4);
        }
        if (composite.isDisposed()) {
            this.error(5);
        }
        if (this.parent == composite) {
            return true;
        }
        if (!this.isReparentable()) {
            return false;
        }
        GTK.gtk_widget_realize(composite.handle);
        long l = this.topHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation);
        int n2 = gtkAllocation.x;
        int n3 = gtkAllocation.y;
        int n4 = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
        int n5 = n = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
        if ((this.parent.style & 0x8000000) != 0) {
            n2 = this.parent.getClientWidth() - n4 - n2;
        }
        if ((composite.style & 0x8000000) != 0) {
            n2 = composite.getClientWidth() - n4 - n2;
        }
        this.releaseParent();
        Shell shell = composite.getShell();
        Shell shell2 = this.getShell();
        Decorations decorations = composite.menuShell();
        Decorations decorations2 = this.menuShell();
        Menu[] menuArray = shell2.findMenus(this);
        if (shell2 != shell || decorations2 != decorations) {
            this.fixChildren(shell, shell2, decorations, decorations2, menuArray);
            if (!GTK.GTK4) {
                decorations.fixAccelGroup();
                decorations2.fixAccelGroup();
            }
        }
        long l2 = composite.parentingHandle();
        Control.gtk_widget_reparent(this, l2);
        OS.swt_fixed_move(l2, l, n2, n3);
        this.resizeHandle(n4, n);
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.gtk_widget_get_preferred_size(l, gtkRequisition);
        gtkAllocation.x = n2;
        gtkAllocation.y = n3;
        gtkAllocation.width = n4;
        gtkAllocation.height = n;
        this.gtk_widget_size_allocate(l, gtkAllocation, -1);
        this.parent = composite;
        this.setZOrder(null, false, true);
        this.reskin(1);
        return true;
    }

    void setParentBackground() {
        this.setBackgroundGdkRGBA(this.handle, null);
        if (this.fixedHandle != 0L) {
            this.setBackgroundGdkRGBA(this.fixedHandle, null);
        }
    }

    void setParentGdkResource(Control control) {
    }

    boolean setRadioSelection(boolean bl) {
        return false;
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        if (bl) {
            if (--this.drawCount == 0 && !GTK.GTK4 && this.redrawWindow != 0L) {
                long l = this.paintWindow();
                GDK.gdk_window_hide(this.redrawWindow);
                GDK.gdk_window_destroy(this.redrawWindow);
                GDK.gdk_window_set_events(l, GTK3.gtk_widget_get_events(this.paintHandle()));
                this.redrawWindow = 0L;
            }
        } else if (this.drawCount++ == 0 && GTK.gtk_widget_get_realized(this.handle)) {
            Rectangle rectangle = this.getBoundsInPixels();
            if (!GTK.GTK4) {
                long l = this.paintWindow();
                GdkWindowAttr gdkWindowAttr = new GdkWindowAttr();
                gdkWindowAttr.width = rectangle.width;
                gdkWindowAttr.height = rectangle.height;
                gdkWindowAttr.event_mask = 2;
                gdkWindowAttr.window_type = 2;
                this.redrawWindow = GTK3.gdk_window_new(l, gdkWindowAttr, 0);
                if (this.redrawWindow != 0L) {
                    int n = 13308;
                    GDK.gdk_window_set_events(l, GDK.gdk_window_get_events(l) & ~n);
                    GDK.gdk_window_show(this.redrawWindow);
                }
            }
        }
    }

    @Override
    boolean setTabItemFocus(boolean bl) {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setTextDirection(int n) {
        this.checkWidget();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (!Objects.equals(string, this.toolTipText)) {
            this.toolTipText = string;
            this.setToolTipText(this._getShell(), string);
        }
    }

    void setToolTipText(Shell shell, String string) {
        if (this.display.currentControl == this) {
            this.setToolTipText(shell.handle, string);
        }
    }

    public void setTouchEnabled(boolean bl) {
        this.checkWidget();
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if ((this.state & 0x800) == 0 == bl) {
            return;
        }
        long l = this.topHandle();
        if (bl) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            this.state &= 0xFFFFF7FF;
            if ((this.state & 0x600) == 0) {
                if (!GTK.GTK4 && this.enableWindow != 0L) {
                    GDK.gdk_window_show_unraised(this.enableWindow);
                }
                GTK.gtk_widget_show(l);
            }
        } else {
            Control control = null;
            boolean bl2 = false;
            if (this.display.focusEvent != 16) {
                control = this.display.getFocusControl();
                bl2 = this.isFocusAncestor(control);
            }
            this.state |= 0x800;
            if (bl2) {
                GTK.gtk_widget_set_can_focus(l, false);
                this.fixFocus(control);
                if (this.isDisposed()) {
                    return;
                }
                GTK.gtk_widget_set_can_focus(l, true);
            }
            GTK.gtk_widget_hide(l);
            if (this.isDisposed()) {
                return;
            }
            if (!GTK.GTK4 && this.enableWindow != 0L) {
                GDK.gdk_window_hide(this.enableWindow);
            }
            this.sendEvent(23);
        }
    }

    void setZOrder(Control control, boolean bl, boolean bl2) {
        this.setZOrder(control, bl, bl2, true);
    }

    void setZOrder(Control control, boolean bl, boolean bl2, boolean bl3) {
        long l;
        long l2;
        int n;
        int n2 = 0;
        int n3 = -1;
        Control[] controlArray = null;
        if (bl2) {
            controlArray = this.parent._getChildren();
            for (n = 0; n < controlArray.length && controlArray[n] != this; ++n) {
            }
            if (control != null) {
                while (n2 < controlArray.length && controlArray[n2] != control) {
                    ++n2;
                }
            }
            this.removeRelation();
            if (n + 1 < controlArray.length) {
                n3 = n + 1;
                controlArray[n3].removeRelation();
            }
            if (control != null) {
                if (bl) {
                    control.removeRelation();
                } else if (n2 + 1 < controlArray.length) {
                    controlArray[n2 + 1].removeRelation();
                }
            }
        }
        long l3 = this.topHandle();
        long l4 = l2 = control != null ? control.topHandle() : 0L;
        if (!GTK.GTK4 && (l = this.gtk_widget_get_window(l3)) != 0L) {
            long l5;
            long l6 = 0L;
            if (control != null) {
                l6 = bl && control.enableWindow != 0L ? this.enableWindow : GTK3.gtk_widget_get_window(l2);
            }
            long l7 = l5 = bl3 ? this.parent.redrawWindow : 0L;
            if (OS.isWayland() || l6 == 0L && (!bl || l5 == 0L)) {
                if (bl) {
                    GDK.gdk_window_raise(l);
                    if (l5 != 0L) {
                        GDK.gdk_window_raise(l5);
                    }
                    if (this.enableWindow != 0L) {
                        GDK.gdk_window_raise(this.enableWindow);
                    }
                } else {
                    if (this.enableWindow != 0L) {
                        GDK.gdk_window_lower(this.enableWindow);
                    }
                    GDK.gdk_window_lower(l);
                }
            } else {
                long l8 = l6 != 0L ? l6 : l5;
                boolean bl4 = bl;
                if (l5 != 0L && l6 == 0L) {
                    bl4 = false;
                }
                this.restackWindow(l, l8, bl4);
                if (this.enableWindow != 0L) {
                    this.restackWindow(this.enableWindow, l, true);
                }
            }
        }
        if (bl3) {
            if (bl) {
                this.parent.moveAbove(l3, l2);
            } else {
                this.parent.moveBelow(l3, l2);
            }
        }
        if (!bl && bl3) {
            this.parent.fixZOrder();
        }
        if (bl2) {
            n = control != null ? (bl ? n2 - (n < n2 ? 1 : 0) : n2 + (n2 < n ? 1 : 0)) : (bl ? 0 : controlArray.length - 1);
            controlArray = this.parent._getChildren();
            if (0 < n) {
                controlArray[n - 1].addRelation(this);
            }
            if (n + 1 < controlArray.length) {
                this.addRelation(controlArray[n + 1]);
            }
            if (n3 != -1) {
                if (n3 <= n) {
                    --n3;
                }
                if (0 < n3 && n3 != n && n3 != n + 1) {
                    controlArray[n3 - 1].addRelation(controlArray[n3]);
                }
            }
        }
    }

    void setWidgetBackground() {
        GdkRGBA gdkRGBA;
        GdkRGBA gdkRGBA2 = gdkRGBA = (this.state & 0x2000) != 0 ? this.getBackgroundGdkRGBA() : null;
        if (this.fixedHandle != 0L) {
            this.setBackgroundGdkRGBA(this.fixedHandle, gdkRGBA);
        }
        this.setBackgroundGdkRGBA(this.handle, gdkRGBA);
    }

    boolean showMenu(int n, int n2) {
        return this.showMenu(n, n2, 0);
    }

    boolean showMenu(int n, int n2, int n3) {
        Event event = new Event();
        Rectangle rectangle = new Rectangle(n, n2, 0, 0);
        event.setBounds(DPIUtil.autoScaleDown(rectangle));
        event.detail = n3;
        this.sendEvent(35, event);
        if (this.isDisposed()) {
            return false;
        }
        if (event.doit && this.menu != null && !this.menu.isDisposed()) {
            if (GTK.GTK4) {
                long l = 0L;
                if (GTK.gtk_widget_get_parent(this.menu.handle) != 0L) {
                    l = OS.g_object_ref(this.menu.handle);
                    GTK.gtk_widget_unparent(this.menu.handle);
                }
                GTK.gtk_widget_set_parent(this.menu.handle, this.handle);
                if (l != 0L) {
                    OS.g_object_unref(l);
                }
                this.menu.setLocationInPixels(n, n2);
                this.menu.setVisible(true);
                return true;
            }
            Rectangle rectangle2 = DPIUtil.autoScaleUp(event.getBounds());
            if (rectangle2.x != n || rectangle2.y != n2) {
                this.menu.setLocationInPixels(rectangle2.x, rectangle2.y);
            }
            this.menu.setVisible(true);
            return true;
        }
        return false;
    }

    void showWidget() {
        this.state |= 0x600;
        long l = this.topHandle();
        long l2 = this.parent.parentingHandle();
        this.parent.setParentGdkResource(this);
        if (GTK.GTK4) {
            OS.swt_fixed_add(l2, l);
        } else {
            GTK3.gtk_container_add(l2, l);
        }
        if (this.handle != 0L && this.handle != l) {
            GTK.gtk_widget_show(this.handle);
        }
        if ((this.state & 0x600) == 0 && this.fixedHandle != 0L) {
            GTK.gtk_widget_show(this.fixedHandle);
        }
        if (this.fixedHandle != 0L) {
            this.fixStyle(this.fixedHandle);
        }
    }

    void sort(int[] nArray) {
        int n = nArray.length;
        for (int i = n / 2; i > 0; i /= 2) {
            for (int j = i; j < n; ++j) {
                for (int k = j - i; k >= 0; k -= i) {
                    if (nArray[k] > nArray[k + i]) continue;
                    int n2 = nArray[k];
                    nArray[k] = nArray[k + i];
                    nArray[k + i] = n2;
                }
            }
        }
    }

    public boolean traverse(int n) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = n;
        return this.traverse(event);
    }

    public boolean traverse(int n, Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.traverse(n, event.character, event.keyCode, event.keyLocation, event.stateMask, event.doit);
    }

    public boolean traverse(int n, KeyEvent keyEvent) {
        this.checkWidget();
        if (keyEvent == null) {
            this.error(4);
        }
        return this.traverse(n, keyEvent.character, keyEvent.keyCode, keyEvent.keyLocation, keyEvent.stateMask, keyEvent.doit);
    }

    boolean traverse(int n, char c, int n2, int n3, int n4, boolean bl) {
        if (n == 0) {
            switch (n2) {
                case 27: {
                    n = 2;
                    bl = true;
                    break;
                }
                case 13: {
                    n = 4;
                    bl = true;
                    break;
                }
                case 0x1000002: 
                case 0x1000004: {
                    n = 64;
                    bl = false;
                    break;
                }
                case 0x1000001: 
                case 0x1000003: {
                    n = 32;
                    bl = false;
                    break;
                }
                case 9: {
                    n = (n4 & 0x20000) != 0 ? 8 : 16;
                    bl = true;
                    break;
                }
                case 0x1000006: {
                    if ((n4 & 0x40000) == 0) break;
                    n = 512;
                    bl = true;
                    break;
                }
                case 0x1000005: {
                    if ((n4 & 0x40000) == 0) break;
                    n = 256;
                    bl = true;
                    break;
                }
                default: {
                    if (c == '\u0000' || (n4 & 0x50000) != 65536) break;
                    n = 128;
                    bl = true;
                }
            }
        }
        Event event = new Event();
        event.character = c;
        event.detail = n;
        event.doit = bl;
        event.keyCode = n2;
        event.keyLocation = n3;
        event.stateMask = n4;
        Shell shell = this.getShell();
        boolean bl2 = false;
        switch (n) {
            case 2: 
            case 4: 
            case 256: 
            case 512: {
                bl2 = true;
            }
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                break;
            }
            case 128: {
                return this.translateMnemonic(event, null) || shell.translateMnemonic(event, this);
            }
            default: {
                return false;
            }
        }
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (bl2 && control != null);
        return false;
    }

    boolean translateMnemonic(Event event, Control control) {
        if (control == this) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        event.doit = this == this.display.mnemonicControl || this.mnemonicMatch(event.character);
        return this.traverse(event);
    }

    boolean translateMnemonic(int n, long l) {
        Decorations decorations;
        long l2 = GDK.gdk_keyval_to_unicode(n);
        int[] nArray = new int[1];
        if (GTK.GTK4) {
            nArray[0] = GDK.gdk_event_get_modifier_state(l);
        } else {
            GDK.gdk_event_get_state(l, nArray);
        }
        if (l2 < 32L) {
            return false;
        }
        if (nArray[0] == 0) {
            int n2 = this.traversalCode(n, l);
            if ((n2 & 0x80) == 0) {
                return false;
            }
        } else {
            Shell shell = this._getShell();
            int n3 = 13;
            if (GTK.GTK4 ? nArray[0] != 8 : (nArray[0] & n3) != GTK3.gtk_window_get_mnemonic_modifier(shell.shellHandle)) {
                return false;
            }
        }
        if ((decorations = this.menuShell()).isVisible() && decorations.isEnabled()) {
            Event event = new Event();
            event.detail = 128;
            if (this.setKeyState(event, l)) {
                return this.translateMnemonic(event, null) || decorations.translateMnemonic(event, this);
            }
        }
        return false;
    }

    boolean translateTraversal(long l) {
        int n = 0;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (GTK.GTK4) {
            nArray[0] = GDK.gdk_key_event_get_keyval(l);
            nArray2[0] = GDK.gdk_event_get_modifier_state(l);
        } else {
            GDK.gdk_event_get_keyval(l, nArray);
            GDK.gdk_event_get_state(l, nArray2);
        }
        int n2 = nArray[0];
        int n3 = this.traversalCode(n2, l);
        boolean bl = false;
        switch (n2) {
            case 65307: {
                bl = true;
                n = 2;
                break;
            }
            case 65293: 
            case 65421: {
                bl = true;
                n = 4;
                break;
            }
            case 65056: 
            case 65289: {
                boolean bl2 = (nArray2[0] & 1) == 0;
                n = bl2 ? 16 : 8;
                break;
            }
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                boolean bl2;
                boolean bl3 = bl2 = n2 == 65364 || n2 == 65363;
                if (this.parent != null && (this.parent.style & 0x8000000) != 0 && (n2 == 65361 || n2 == 65363)) {
                    bl2 = !bl2;
                }
                n = bl2 ? 64 : 32;
                break;
            }
            case 65365: 
            case 65366: {
                bl = true;
                if ((nArray2[0] & 4) == 0) {
                    return false;
                }
                n = n2 == 65366 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = (n3 & n) != 0;
        event.detail = n;
        event.time = GDK.gdk_event_get_time(l);
        if (!this.setKeyState(event, l)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (bl && control != null);
        return false;
    }

    int traversalCode(int n, long l) {
        int n2 = 796;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            n2 |= 2;
        }
        return n2;
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean bl) {
        int n;
        int n2;
        Control control = this.computeTabRoot();
        Widget widget = this.computeTabGroup();
        Widget[] widgetArray = control.computeTabList();
        int n3 = widgetArray.length;
        for (n2 = 0; n2 < n3 && widgetArray[n2] != widget; ++n2) {
        }
        if (n2 == n3) {
            return false;
        }
        int n4 = n2;
        int n5 = n = bl ? 1 : -1;
        while ((n2 = (n2 + n + n3) % n3) != n4) {
            Widget widget2 = widgetArray[n2];
            if (widget2.isDisposed() || !widget2.setTabGroupFocus(bl)) continue;
            return true;
        }
        if (widget.isDisposed()) {
            return false;
        }
        return widget.setTabGroupFocus(bl);
    }

    boolean traverseItem(boolean bl) {
        int n;
        int n2;
        Control[] controlArray = this.parent._getChildren();
        int n3 = controlArray.length;
        for (n2 = 0; n2 < n3 && controlArray[n2] != this; ++n2) {
        }
        if (n2 == n3) {
            return false;
        }
        int n4 = n2;
        int n5 = n = bl ? 1 : -1;
        while ((n2 = (n2 + n + n3) % n3) != n4) {
            Control control = controlArray[n2];
            if (control.isDisposed() || !control.isTabItem() || !control.setTabItemFocus(bl)) continue;
            return true;
        }
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    boolean traversePage(boolean bl) {
        return false;
    }

    boolean traverseMnemonic(char c) {
        return this.mnemonicHit(c);
    }

    public void update() {
        this.checkWidget();
        this.update(false, true);
    }

    void update(boolean bl, boolean bl2) {
        if (GTK.GTK4) {
            GTK.gtk_widget_queue_draw(this.handle);
        }
        if (!GTK.gtk_widget_get_visible(this.topHandle())) {
            return;
        }
        if (!GTK.gtk_widget_get_realized(this.handle)) {
            return;
        }
        long l = this.paintWindow();
        if (bl2) {
            this.display.flushExposes(l, bl);
        }
    }

    void updateBackgroundMode() {
        int n = this.state & 0x8000;
        this.checkBackground();
        if (n != (this.state & 0x8000)) {
            this.setBackground();
        }
    }

    void updateLayout(boolean bl) {
    }

    @Override
    long windowProc(long l, long l2, long l3) {
        switch ((int)l3) {
            case 19: {
                boolean bl;
                if ((this.state & 0x40) != 0) break;
                Control control = this.findBackgroundControl();
                boolean bl2 = bl = control != null && control.backgroundImage != null;
                if (!bl && (this.state & 2) != 0) {
                    boolean bl3 = bl = (this.state & 0x2000) == 0;
                }
                if (!bl) break;
                long l4 = l2;
                GdkRectangle gdkRectangle = new GdkRectangle();
                GDK.gdk_cairo_get_clip_rectangle(l4, gdkRectangle);
                if (control == null) {
                    control = this;
                }
                if (GTK.GTK4) {
                    long l5 = GTK4.gtk_native_get_surface(GTK4.gtk_widget_get_native(l));
                    this.drawBackground(control, l5, l4, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
                    break;
                }
                long l6 = GTK3.gtk_widget_get_window(l);
                if (l6 != 0L) {
                    this.drawBackground(control, l6, 0L, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
                    break;
                }
                this.drawBackground(control, 0L, l4, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
                break;
            }
            case 18: {
                if (this.paintHandle() != l || !this.drawRegion) break;
                return this.gtk_draw(l, l2);
            }
        }
        return super.windowProc(l, l2, l3);
    }

    Point getWindowOrigin() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        long l = this.eventWindow();
        GDK.gdk_window_get_origin(l, nArray, nArray2);
        return new Point(nArray[0], nArray2[0]);
    }

    Point getSurfaceOrigin() {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        boolean bl = GTK4.gtk_widget_translate_coordinates(this.fixedHandle, this.getShell().shellHandle, 0.0, 0.0, dArray, dArray2);
        return bl ? new Point((int)dArray[0], (int)dArray2[0]) : new Point(0, 0);
    }
}

