/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;

public final class Program {
    String name = "";
    String command;
    String iconPath;
    boolean gioExpectUri;
    static long modTime;
    static Map<String, List<String>> mimeTable;
    static final String PREFIX_HTTP = "http://";
    static final String PREFIX_HTTPS = "https://";

    Program() {
    }

    static String[] parseCommand(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < string.length()) {
            int n2;
            while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
                ++n;
            }
            if (n >= string.length()) continue;
            if (string.charAt(n) == '\"' || string.charAt(n) == '\'') {
                for (n2 = n + 1; n2 < string.length() && string.charAt(n2) != string.charAt(n); ++n2) {
                }
                if (n2 >= string.length()) {
                    arrayList.add(string.substring(n, n2));
                } else {
                    arrayList.add(string.substring(n + 1, n2));
                }
                n = n2 + 1;
                continue;
            }
            for (n2 = n; n2 < string.length() && !Character.isWhitespace(string.charAt(n2)); ++n2) {
            }
            arrayList.add(string.substring(n, n2));
            n = n2 + 1;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static Program findProgram(String object) {
        String string;
        if (object == null) {
            SWT.error(4);
        }
        if (((String)object).length() == 0) {
            return null;
        }
        if (((String)object).charAt(0) != '.') {
            object = "." + (String)object;
        }
        if ((string = Program.gio_getMimeType((String)object)) == null) {
            return null;
        }
        return Program.gio_getProgram(string);
    }

    public ImageData getImageData() {
        return this.getImageData(100);
    }

    public ImageData getImageData(int n) {
        if (this.iconPath == null) {
            return null;
        }
        ImageData imageData = null;
        long l = OS.g_icon_new_for_string(Converter.javaStringToCString(this.iconPath), null);
        if (l != 0L) {
            long l2 = 0L;
            if (GTK.GTK4) {
                var7_5 = GTK4.gtk_icon_theme_get_for_display(GDK.gdk_display_get_default());
                var9_7 = GTK4.gtk_icon_theme_lookup_by_gicon(var7_5, l, 16, 1, 0, 32);
                long l3 = GTK4.gtk_icon_paintable_get_file(var9_7);
                long l4 = GDK.gdk_texture_new_from_file(l3, 0L);
                l2 = GDK.gdk_pixbuf_get_from_texture(l4);
                OS.g_object_unref(l4);
                OS.g_object_unref(l3);
                OS.g_object_unref(var9_7);
            } else {
                var7_5 = GTK3.gtk_icon_theme_get_default();
                var9_7 = GTK3.gtk_icon_theme_lookup_by_gicon(var7_5, l, 16, 0);
                if (var9_7 != 0L) {
                    l2 = GTK3.gtk_icon_info_load_icon(var9_7, null);
                    OS.g_object_unref(var9_7);
                }
            }
            OS.g_object_unref(l);
            if (l2 != 0L) {
                int n2 = GDK.gdk_pixbuf_get_rowstride(l2);
                long l5 = GDK.gdk_pixbuf_get_pixels(l2);
                int n3 = GDK.gdk_pixbuf_get_height(l2);
                int n4 = GDK.gdk_pixbuf_get_width(l2);
                boolean bl = GDK.gdk_pixbuf_get_has_alpha(l2);
                byte[] byArray = new byte[n2 * n3];
                C.memmove(byArray, l5, (long)byArray.length);
                OS.g_object_unref(l2);
                if (bl) {
                    PaletteData paletteData = new PaletteData(-16777216, 0xFF0000, 65280);
                    imageData = new ImageData(n4, n3, 32, paletteData, 4, byArray);
                    imageData.bytesPerLine = n2;
                    int n5 = 3;
                    int n6 = 0;
                    byte[] byArray2 = new byte[n4 * n3];
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n4; ++j) {
                            byArray2[n6++] = byArray[n5];
                            byArray[n5] = 0;
                            n5 += 4;
                        }
                    }
                    imageData.alphaData = byArray2;
                } else {
                    PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
                    imageData = new ImageData(n4, n3, 24, paletteData, 4, byArray);
                    imageData.bytesPerLine = n2;
                }
            }
        }
        return imageData;
    }

    static Map<String, List<String>> gio_getMimeInfo() {
        Path path = Paths.get("/usr/share/mime/globs", new String[0]);
        long l = 0L;
        try {
            l = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (modTime != 0L && modTime == l) {
            return mimeTable;
        }
        try {
            mimeTable = new HashMap<String, List<String>>();
            modTime = l;
            for (String string : Files.readAllLines(path)) {
                int n = string.indexOf(58);
                if (n <= 0) continue;
                ArrayList<String> arrayList = new ArrayList<String>();
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                int n2 = string3.indexOf(46);
                if (n2 <= 0) continue;
                String string4 = string3.substring(n2);
                if (mimeTable.containsKey(string4)) {
                    List<String> list = mimeTable.get(string4);
                    arrayList.addAll(list);
                }
                arrayList.add(string2);
                mimeTable.put(string4, arrayList);
            }
            return mimeTable;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static String gio_getMimeType(String string) {
        String string2 = null;
        Map<String, List<String>> map = Program.gio_getMimeInfo();
        if (map != null && map.containsKey(string)) {
            List<String> list = map.get(string);
            string2 = list.get(0);
        }
        return string2;
    }

    static Program gio_getProgram(String string) {
        Program program = null;
        byte[] byArray = Converter.wcsToMbcs(string, true);
        long l = OS.g_app_info_get_default_for_type(byArray, false);
        if (l != 0L) {
            program = Program.gio_getProgram(l);
        }
        return program;
    }

    static Program gio_getProgram(long l) {
        long l2;
        long l3;
        byte[] byArray;
        int n;
        Program program = new Program();
        long l4 = OS.g_app_info_get_name(l);
        if (l4 != 0L && (n = C.strlen(l4)) > 0) {
            byArray = new byte[n];
            C.memmove(byArray, l4, (long)n);
            program.name = new String(Converter.mbcsToWcs(byArray));
        }
        if ((l3 = OS.g_app_info_get_executable(l)) != 0L && (n = C.strlen(l3)) > 0) {
            byArray = new byte[n];
            C.memmove(byArray, l3, (long)n);
            program.command = new String(Converter.mbcsToWcs(byArray));
        }
        program.gioExpectUri = OS.g_app_info_supports_uris(l);
        long l5 = OS.g_app_info_get_icon(l);
        if (l5 != 0L && (l2 = OS.g_icon_to_string(l5)) != 0L) {
            n = C.strlen(l2);
            if (n > 0) {
                byArray = new byte[n];
                C.memmove(byArray, l2, (long)n);
                program.iconPath = new String(Converter.mbcsToWcs(byArray));
            }
            OS.g_free(l2);
        }
        return program.command != null ? program : null;
    }

    public static Program[] getPrograms() {
        long l;
        long l2 = l = OS.g_app_info_get_all();
        LinkedHashSet<Program> linkedHashSet = new LinkedHashSet<Program>();
        while (l2 != 0L) {
            long l3 = OS.g_list_data(l2);
            if (l3 != 0L) {
                Program program = Program.gio_getProgram(l3);
                if (program != null) {
                    linkedHashSet.add(program);
                }
                OS.g_object_unref(l3);
            }
            l2 = OS.g_list_next(l2);
        }
        if (l != 0L) {
            OS.g_list_free(l);
        }
        return linkedHashSet.toArray(new Program[linkedHashSet.size()]);
    }

    static boolean isExecutable(String string) {
        byte[] byArray = Converter.wcsToMbcs(string, true);
        if (OS.g_file_test(byArray, 4)) {
            return false;
        }
        if (!OS.g_file_test(byArray, 8)) {
            return false;
        }
        long l = OS.g_file_new_for_path(byArray);
        boolean bl = false;
        if (l != 0L) {
            byte[] byArray2 = Converter.wcsToMbcs("*", true);
            long l2 = OS.g_file_query_info(l, byArray2, 0L, 0L, 0L);
            if (l2 != 0L) {
                byte[] byArray3;
                long l3 = OS.g_file_info_get_content_type(l2);
                if (l3 != 0L && !(bl = OS.g_content_type_is_a(l3, byArray3 = Converter.wcsToMbcs("application/x-executable", true)))) {
                    byte[] byArray4 = Converter.wcsToMbcs("application/x-shellscript", true);
                    bl = OS.g_content_type_equals(l3, byArray4);
                }
                OS.g_object_unref(l2);
            }
            OS.g_object_unref(l);
        }
        return bl;
    }

    static boolean gio_launch(String string) {
        boolean bl = false;
        byte[] byArray = Converter.wcsToMbcs(string, true);
        long l = OS.g_file_new_for_commandline_arg(byArray);
        if (l != 0L) {
            long l2 = OS.g_file_get_uri(l);
            if (l2 != 0L) {
                bl = OS.g_app_info_launch_default_for_uri(l2, 0L, 0L);
                OS.g_free(l2);
            }
            OS.g_object_unref(l);
        }
        return bl;
    }

    boolean gio_execute(String string) {
        byte[] byArray;
        boolean bl = false;
        byte[] byArray2 = Converter.wcsToMbcs(this.command, true);
        long l = OS.g_app_info_create_from_commandline(byArray2, byArray = Converter.wcsToMbcs(this.name, true), this.gioExpectUri ? 2L : 0L, 0L);
        if (l != 0L) {
            byte[] byArray3 = Converter.wcsToMbcs(string, true);
            long l2 = 0L;
            if (string.length() > 0) {
                l2 = OS.g_app_info_supports_uris(l) ? OS.g_file_new_for_uri(byArray3) : OS.g_file_new_for_path(byArray3);
            }
            long l3 = 0L;
            if (l2 != 0L) {
                l3 = OS.g_list_append(0L, l2);
            }
            bl = OS.g_app_info_launch(l, l3, 0L, 0L);
            if (l3 != 0L) {
                OS.g_list_free(l3);
                OS.g_object_unref(l2);
            }
            OS.g_object_unref(l);
        }
        return bl;
    }

    public static String[] getExtensions() {
        Map<String, List<String>> map = Program.gio_getMimeInfo();
        if (map == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean launch(String string) {
        return Program.launch(string, null);
    }

    public static boolean launch(String string, String string2) {
        String string3;
        Program program;
        if (string == null) {
            SWT.error(4);
        }
        if (string2 != null && Program.isExecutable(string)) {
            try {
                Compatibility.exec(new String[]{string}, null, string2);
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        if (Program.gio_launch(string)) {
            return true;
        }
        int n = string.lastIndexOf(46);
        if (n != -1 && (program = Program.findProgram(string3 = string.substring(n))) != null && program.execute(string)) {
            return true;
        }
        string3 = string.toLowerCase();
        if (string3.startsWith(PREFIX_HTTP) || string3.startsWith(PREFIX_HTTPS)) {
            program = Program.findProgram(".html");
            if (program == null) {
                program = Program.findProgram(".htm");
            }
            if (program != null && program.execute(string)) {
                return true;
            }
        }
        try {
            Compatibility.exec(new String[]{string}, null, string2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Program)) {
            return false;
        }
        Program program = (Program)object;
        return this.name.equals(program.name) && this.command.equals(program.command) && this.gioExpectUri == program.gioExpectUri;
    }

    public boolean execute(String string) {
        if (string == null) {
            SWT.error(4);
        }
        return this.gio_execute(string);
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

