/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public final class BorderData {
    private final Map<Control, Point> cachedSize = new IdentityHashMap<Control, Point>(1);
    public int hHint = -1;
    public int wHint = -1;
    public int region = 0x1000000;

    public BorderData() {
    }

    public BorderData(int n) {
        this.region = n;
    }

    public BorderData(int n, int n2, int n3) {
        this.region = n;
        this.wHint = n2;
        this.hHint = n3;
    }

    Point getSize(Control control2) {
        return this.cachedSize.computeIfAbsent(control2, control -> control.computeSize(this.wHint, this.hHint, true));
    }

    Point computeSize(Control control, int n, int n2, boolean bl) {
        if (n == -1) {
            n = this.wHint;
        }
        if (n2 == -1) {
            n2 = this.hHint;
        }
        return control.computeSize(n, n2, bl);
    }

    void flushCache(Control control) {
        this.cachedSize.remove(control);
    }

    public String toString() {
        return "BorderData [region=" + BorderData.getRegionString(this.region) + ", hHint=" + this.hHint + ", wHint=" + this.wHint + "]";
    }

    static String getRegionString(int n) {
        return switch (n) {
            case 128 -> "SWT.TOP";
            case 131072 -> "SWT.RIGHT";
            case 1024 -> "SWT.BOTTOM";
            case 16384 -> "SWT.LEFT";
            case 0x1000000 -> "SWT.CENTER";
            default -> "SWT.NONE";
        };
    }

    int getRegion() {
        return switch (this.region) {
            case 128, 1024, 16384, 131072, 0x1000000 -> this.region;
            case 0 -> 0;
            default -> 0;
        };
    }
}

