/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.PngFileReadState;
import org.eclipse.swt.internal.image.PngIdatChunk;
import org.eclipse.swt.internal.image.PngIendChunk;
import org.eclipse.swt.internal.image.PngIhdrChunk;
import org.eclipse.swt.internal.image.PngPlteChunk;
import org.eclipse.swt.internal.image.PngTrnsChunk;

class PngChunk {
    byte[] reference;
    static final int LENGTH_OFFSET = 0;
    static final int TYPE_OFFSET = 4;
    static final int DATA_OFFSET = 8;
    static final int TYPE_FIELD_LENGTH = 4;
    static final int LENGTH_FIELD_LENGTH = 4;
    static final int MIN_LENGTH = 12;
    static final int CHUNK_UNKNOWN = -1;
    static final int CHUNK_IHDR = 0;
    static final int CHUNK_PLTE = 1;
    static final int CHUNK_IDAT = 2;
    static final int CHUNK_IEND = 3;
    static final int CHUNK_tRNS = 5;
    static final byte[] TYPE_IHDR = new byte[]{73, 72, 68, 82};
    static final byte[] TYPE_PLTE = new byte[]{80, 76, 84, 69};
    static final byte[] TYPE_IDAT = new byte[]{73, 68, 65, 84};
    static final byte[] TYPE_IEND = new byte[]{73, 69, 78, 68};
    static final byte[] TYPE_tRNS = new byte[]{116, 82, 78, 83};
    static final int[] CRC_TABLE = new int[256];
    int length;

    PngChunk(byte[] byArray) {
        this.setReference(byArray);
        if (byArray.length < 4) {
            SWT.error(40);
        }
        this.length = this.getInt32(0);
    }

    PngChunk(int n) {
        this(new byte[12 + n]);
        this.setLength(n);
    }

    byte[] getReference() {
        return this.reference;
    }

    void setReference(byte[] byArray) {
        this.reference = byArray;
    }

    int getInt16(int n) {
        int n2 = 0;
        n2 |= (this.reference[n] & 0xFF) << 8;
        return n2 |= this.reference[n + 1] & 0xFF;
    }

    void setInt16(int n, int n2) {
        this.reference[n] = (byte)(n2 >> 8 & 0xFF);
        this.reference[n + 1] = (byte)(n2 & 0xFF);
    }

    int getInt32(int n) {
        int n2 = 0;
        n2 |= (this.reference[n] & 0xFF) << 24;
        n2 |= (this.reference[n + 1] & 0xFF) << 16;
        n2 |= (this.reference[n + 2] & 0xFF) << 8;
        return n2 |= this.reference[n + 3] & 0xFF;
    }

    void setInt32(int n, int n2) {
        this.reference[n] = (byte)(n2 >> 24 & 0xFF);
        this.reference[n + 1] = (byte)(n2 >> 16 & 0xFF);
        this.reference[n + 2] = (byte)(n2 >> 8 & 0xFF);
        this.reference[n + 3] = (byte)(n2 & 0xFF);
    }

    int getLength() {
        return this.length;
    }

    void setLength(int n) {
        this.setInt32(0, n);
        this.length = n;
    }

    byte[] getTypeBytes() {
        byte[] byArray = new byte[4];
        System.arraycopy(this.reference, 4, byArray, 0, 4);
        return byArray;
    }

    void setType(byte[] byArray) {
        if (byArray.length != 4) {
            SWT.error(5);
        }
        System.arraycopy(byArray, 0, this.reference, 4, 4);
    }

    byte[] getData() {
        int n = this.getLength();
        if (this.reference.length < 12 + n) {
            SWT.error(6);
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.reference, 8, byArray, 0, n);
        return byArray;
    }

    void setData(byte[] byArray) {
        this.setLength(byArray.length);
        System.arraycopy(byArray, 0, this.reference, 8, byArray.length);
        this.setCRC(this.computeCRC());
    }

    int getCRC() {
        int n = 8 + this.getLength();
        return this.getInt32(n);
    }

    void setCRC(int n) {
        int n2 = 8 + this.getLength();
        this.setInt32(n2, n);
    }

    int getSize() {
        return 12 + this.getLength();
    }

    boolean checkCRC() {
        int n;
        int n2 = this.computeCRC();
        return n2 == (n = this.getCRC());
    }

    int computeCRC() {
        int n = -1;
        int n2 = 4;
        int n3 = 8 + this.getLength();
        for (int i = n2; i < n3; ++i) {
            int n4 = (n ^ this.reference[i]) & 0xFF;
            n = CRC_TABLE[n4] ^ n >> 8 & 0xFFFFFF;
        }
        return ~n;
    }

    boolean typeMatchesArray(byte[] byArray) {
        for (int i = 0; i < 4; ++i) {
            if (this.reference[4 + i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    boolean isCritical() {
        char c = (char)this.getTypeBytes()[0];
        return 'A' <= c && c <= 'Z';
    }

    int getChunkType() {
        if (this.typeMatchesArray(TYPE_IHDR)) {
            return 0;
        }
        if (this.typeMatchesArray(TYPE_PLTE)) {
            return 1;
        }
        if (this.typeMatchesArray(TYPE_IDAT)) {
            return 2;
        }
        if (this.typeMatchesArray(TYPE_IEND)) {
            return 3;
        }
        if (this.typeMatchesArray(TYPE_tRNS)) {
            return 5;
        }
        return -1;
    }

    static PngChunk readNextFromStream(LEDataInputStream lEDataInputStream) {
        try {
            int n = 8;
            byte[] byArray = new byte[n];
            int n2 = lEDataInputStream.read(byArray, 0, n);
            lEDataInputStream.unread(byArray);
            if (n2 != n) {
                return null;
            }
            PngChunk pngChunk = new PngChunk(byArray);
            int n3 = pngChunk.getSize();
            byte[] byArray2 = new byte[n3];
            n2 = lEDataInputStream.read(byArray2, 0, n3);
            if (n2 != n3) {
                return null;
            }
            return switch (pngChunk.getChunkType()) {
                case 0 -> new PngIhdrChunk(byArray2);
                case 1 -> new PngPlteChunk(byArray2);
                case 2 -> new PngIdatChunk(byArray2);
                case 3 -> new PngIendChunk(byArray2);
                case 5 -> new PngTrnsChunk(byArray2);
                default -> new PngChunk(byArray2);
            };
        }
        catch (IOException iOException) {
            return null;
        }
    }

    void validate(PngFileReadState pngFileReadState, PngIhdrChunk pngIhdrChunk) {
        byte[] byArray;
        char c;
        if (this.reference.length < 12) {
            SWT.error(40);
        }
        if ('A' > (c = (char)(byArray = this.getTypeBytes())[2]) || c > 'Z') {
            SWT.error(40);
        }
        for (int i = 0; i < 4; ++i) {
            c = (char)byArray[i];
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z') continue;
            SWT.error(40);
        }
        if (!this.checkCRC()) {
            SWT.error(40);
        }
    }

    void contributeToString(StringBuilder stringBuilder) {
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append("\n\tLength: ");
        stringBuilder.append(this.getLength());
        stringBuilder.append("\n\tType: ");
        for (byte by : this.getTypeBytes()) {
            stringBuilder.append((char)by);
        }
        this.contributeToString(stringBuilder);
        stringBuilder.append("\n\tCRC: ");
        stringBuilder.append(Integer.toHexString(this.getCRC()));
        stringBuilder.append("\n}");
        return stringBuilder.toString();
    }

    static {
        for (int i = 0; i < 256; ++i) {
            PngChunk.CRC_TABLE[i] = i;
            for (int j = 0; j < 8; ++j) {
                PngChunk.CRC_TABLE[i] = (CRC_TABLE[i] & 1) == 0 ? CRC_TABLE[i] >> 1 & Integer.MAX_VALUE : 0xEDB88320 ^ CRC_TABLE[i] >> 1 & Integer.MAX_VALUE;
            }
        }
    }
}

