/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.dnd.gtk;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;

public class ListDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;
    private List dragList;

    public ListDragSourceEffect(List list) {
        super(list);
        this.dragList = list;
    }

    @Override
    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    @Override
    public void dragStart(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.image = this.getDragSourceImage(dragSourceEvent);
    }

    Image getDragSourceImage(DragSourceEvent dragSourceEvent) {
        long[] lArray;
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        if (this.dragList.isListening(40) || this.dragList.isListening(42)) {
            return null;
        }
        long l = this.dragList.handle;
        long l2 = GTK.gtk_tree_view_get_selection(l);
        long l3 = GTK.gtk_tree_selection_get_selected_rows(l2, lArray = null);
        if (l3 == 0L) {
            return null;
        }
        int n = Math.min(10, OS.g_list_length(l3));
        long l4 = l3;
        Display display = this.dragList.getDisplay();
        if (n == 1) {
            long l5 = OS.g_list_nth_data(l3, 0);
            long l6 = GTK.gtk_tree_view_create_row_drag_icon(l, l5);
            this.dragSourceImage = Image.gtk_new(display, 1, l6, 0L);
            GTK.gtk_tree_path_free(l5);
        } else {
            long l7;
            int n2 = 0;
            int n3 = 0;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            long[] lArray2 = new long[n];
            GdkRectangle gdkRectangle = new GdkRectangle();
            for (int i = 0; i < n; ++i) {
                long l8 = OS.g_list_data(l3);
                GTK.gtk_tree_view_get_cell_area(l, l8, 0L, gdkRectangle);
                lArray2[i] = GTK.gtk_tree_view_create_row_drag_icon(l, l8);
                switch (Cairo.cairo_surface_get_type(lArray2[i])) {
                    case 0: {
                        nArray[0] = Cairo.cairo_image_surface_get_width(lArray2[i]);
                        nArray2[0] = Cairo.cairo_image_surface_get_height(lArray2[i]);
                        break;
                    }
                    case 3: {
                        nArray[0] = Cairo.cairo_xlib_surface_get_width(lArray2[i]);
                        nArray2[0] = Cairo.cairo_xlib_surface_get_height(lArray2[i]);
                    }
                }
                n2 = Math.max(n2, nArray[0]);
                n3 = gdkRectangle.y + nArray2[0] - nArray3[0];
                nArray3[i] = gdkRectangle.y;
                nArray4[i] = nArray2[0];
                l3 = OS.g_list_next(l3);
                GTK.gtk_tree_path_free(l8);
            }
            long l9 = Cairo.cairo_image_surface_create(0, n2, n3);
            if (l9 == 0L) {
                SWT.error(2);
            }
            if ((l7 = Cairo.cairo_create(l9)) == 0L) {
                SWT.error(2);
            }
            Cairo.cairo_set_operator(l7, 1);
            for (int i = 0; i < n; ++i) {
                Cairo.cairo_set_source_surface(l7, lArray2[i], 2.0, nArray3[i] - nArray3[0] + 2);
                Cairo.cairo_rectangle(l7, 0.0, nArray3[i] - nArray3[0], n2, nArray4[i]);
                Cairo.cairo_fill(l7);
                Cairo.cairo_surface_destroy(lArray2[i]);
            }
            Cairo.cairo_destroy(l7);
            this.dragSourceImage = Image.gtk_new(display, 1, l9, 0L);
        }
        OS.g_list_free(l4);
        return this.dragSourceImage;
    }
}

