/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;

public class SessionManagerDBus {
    private List<IListener> listeners = new ArrayList<IListener>();
    private Callback g_signal_callback;
    private long g_signal_callbackid;
    private ShutdownHook shutdownHook = new ShutdownHook(this);
    private long sessionManagerProxy;
    private long clientProxy;
    private String clientObjectPath;
    private boolean isGnome;
    private static int dbusTimeoutMsec = 10000;
    private long endSessionResponseCounter = 1L;
    private long endSessionResponseWanted = 0L;

    public SessionManagerDBus() {
        boolean bl;
        boolean bl2 = bl = System.getProperty("org.eclipse.swt.internal.SessionManagerDBus.disable") != null;
        if (bl) {
            return;
        }
        this.start();
    }

    public void dispose() {
        this.stop();
    }

    public void addListener(IListener iListener) {
        this.listeners.add(iListener);
    }

    public void removeListener(IListener iListener) {
        this.listeners.remove(iListener);
    }

    private boolean start() {
        if (!(this.connectSessionManager() && this.registerClient() && this.connectClientSignal())) {
            this.stop();
            return false;
        }
        this.shutdownHook.install();
        return true;
    }

    private synchronized void stop() {
        if (this.endSessionResponseWanted != 0L) {
            this.sendEndSessionResponse(true, "", this.endSessionResponseWanted);
        }
        if (this.sessionManagerProxy != 0L && this.clientObjectPath != null) {
            long l = OS.g_variant_new(Converter.javaStringToCString("(o)"), Converter.javaStringToCString(this.clientObjectPath));
            long[] lArray = new long[1];
            OS.g_dbus_proxy_call_sync(this.sessionManagerProxy, Converter.javaStringToCString("UnregisterClient"), l, 0, dbusTimeoutMsec, 0L, lArray);
            if (lArray[0] != 0L) {
                System.err.format("SWT SessionManagerDBus: Failed to UnregisterClient: %s%n", SessionManagerDBus.extractFreeGError(lArray[0]));
            }
            this.clientObjectPath = null;
        }
        if (this.clientProxy != 0L) {
            if (this.g_signal_callbackid != 0L) {
                OS.g_signal_handler_disconnect(this.clientProxy, this.g_signal_callbackid);
                this.g_signal_callbackid = 0L;
            }
            OS.g_object_unref(this.clientProxy);
            this.clientProxy = 0L;
        }
        if (this.sessionManagerProxy != 0L) {
            OS.g_object_unref(this.sessionManagerProxy);
            this.sessionManagerProxy = 0L;
        }
        if (this.g_signal_callback != null) {
            this.g_signal_callback.dispose();
            this.g_signal_callback = null;
        }
        this.shutdownHook.remove();
    }

    private long wantEndSessionResponse() {
        long l;
        this.endSessionResponseWanted = l = this.endSessionResponseCounter++;
        return l;
    }

    private void sendEndSessionResponse(boolean bl, String string, long l) {
        if (l != this.endSessionResponseWanted) {
            return;
        }
        this.endSessionResponseWanted = 0L;
        long l2 = OS.g_variant_new(Converter.javaStringToCString("(bs)"), bl, Converter.javaStringToCString(string));
        long[] lArray = new long[1];
        OS.g_dbus_proxy_call(this.clientProxy, Converter.javaStringToCString("EndSessionResponse"), l2, 0, dbusTimeoutMsec, 0L, 0L, lArray);
        if (lArray[0] != 0L) {
            System.err.format("SWT SessionManagerDBus: Failed to EndSessionResponse: %s%n", SessionManagerDBus.extractFreeGError(lArray[0]));
        }
    }

    private boolean queryReadyToExit() {
        boolean bl = true;
        for (int i = 0; i < this.listeners.size(); ++i) {
            IListener iListener = this.listeners.get(i);
            bl = bl && iListener.isReadyToExit();
        }
        return bl;
    }

    private void handleQueryEndSession() {
        long l = this.wantEndSessionResponse();
        boolean bl = this.queryReadyToExit();
        this.sendEndSessionResponse(bl, "", l);
    }

    private void handleEndSession() {
        long l = this.wantEndSessionResponse();
        this.handleStop();
        this.sendEndSessionResponse(true, "", l);
    }

    private void handleStop() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            IListener iListener = this.listeners.get(i);
            iListener.stop();
        }
    }

    private long g_signal_handler(long l, long l2, long l3, long l4, long l5) {
        String string;
        switch (string = Converter.cCharPtrToJavaString(l3, false)) {
            case "QueryEndSession": {
                this.handleQueryEndSession();
                break;
            }
            case "EndSession": {
                this.handleEndSession();
                break;
            }
            case "Stop": {
                this.handleStop();
            }
        }
        return 0L;
    }

    private static String extractVariantTupleS(long l) {
        long l2 = OS.g_variant_get_child_value(l, 0);
        long l3 = OS.g_variant_get_string(l2, null);
        String string = Converter.cCharPtrToJavaString(l3, false);
        OS.g_variant_unref(l2);
        return string;
    }

    private static String extractFreeGError(long l) {
        long l2 = OS.g_error_get_message(l);
        String string = Converter.cCharPtrToJavaString(l2, false);
        OS.g_error_free(l);
        return string;
    }

    private long connectSessionManager(String string, String string2, String string3) {
        int n = 3;
        long[] lArray = new long[1];
        long l = OS.g_dbus_proxy_new_for_bus_sync(2, n, 0L, Converter.javaStringToCString(string), Converter.javaStringToCString(string2), Converter.javaStringToCString(string3), 0L, lArray);
        if (l == 0L) {
            String string4 = SessionManagerDBus.extractFreeGError(lArray[0]);
            System.err.format("SWT SessionManagerDBus: Failed to connect to %s: %s%n", string, string4);
            return 0L;
        }
        long l2 = OS.g_dbus_proxy_get_name_owner(l);
        if (l2 == 0L) {
            OS.g_object_unref(l);
            return 0L;
        }
        OS.g_free(l2);
        return l;
    }

    private boolean connectSessionManager() {
        long l = this.connectSessionManager("org.gnome.SessionManager", "/org/gnome/SessionManager", "org.gnome.SessionManager");
        if (l != 0L) {
            this.sessionManagerProxy = l;
            this.isGnome = true;
            return true;
        }
        long l2 = this.connectSessionManager("org.xfce.SessionManager", "/org/xfce/SessionManager", "org.xfce.Session.Manager");
        if (l2 != 0L) {
            this.sessionManagerProxy = l2;
            this.isGnome = false;
            return true;
        }
        return false;
    }

    private String claimDesktopAutostartID() {
        byte[] byArray = Converter.javaStringToCString("DESKTOP_AUTOSTART_ID");
        long l = OS.g_getenv(byArray);
        if (l == 0L) {
            return null;
        }
        String string = Converter.cCharPtrToJavaString(l, false);
        OS.g_unsetenv(byArray);
        return string;
    }

    private String registerClient(String string, String string2) {
        long l = OS.g_variant_new(Converter.javaStringToCString("(ss)"), Converter.javaStringToCString(string), Converter.javaStringToCString(string2));
        long[] lArray = new long[1];
        long l2 = OS.g_dbus_proxy_call_sync(this.sessionManagerProxy, Converter.javaStringToCString("RegisterClient"), l, 0, dbusTimeoutMsec, 0L, lArray);
        if (l2 == 0L) {
            return SessionManagerDBus.extractFreeGError(lArray[0]);
        }
        if (0L == OS.g_variant_n_children(l2)) {
            return "Session manager's response to 'RegisterClient' is invalid";
        }
        this.clientObjectPath = SessionManagerDBus.extractVariantTupleS(l2);
        OS.g_variant_unref(l2);
        return null;
    }

    private boolean registerClient() {
        String string;
        String string2;
        String string3 = System.getProperty("org.eclipse.swt.internal.SessionManagerDBus.appID");
        if (string3 == null) {
            string3 = "org.eclipse.swt.Application";
        }
        if ((string2 = this.claimDesktopAutostartID()) != null) {
            string = this.registerClient(string3, string2);
            if (string == null) {
                return true;
            }
            boolean bl = string.startsWith("GDBus.Error:org.gnome.SessionManager.AlreadyRegistered:");
            if (!bl) {
                return false;
            }
        }
        if ((string = this.registerClient(string3, "")) == null) {
            return true;
        }
        if (!this.isGnome && string.startsWith("GDBus.Error:org.freedesktop.DBus.Error.UnknownMethod: ")) {
            return false;
        }
        System.err.format("SWT SessionManagerDBus: Failed to RegisterClient: %s%n", string);
        return false;
    }

    private boolean connectClientSignal() {
        String string;
        String string2;
        if (this.isGnome) {
            string2 = "org.gnome.SessionManager";
            string = "org.gnome.SessionManager.ClientPrivate";
        } else {
            string2 = "org.xfce.SessionManager";
            string = "org.xfce.Session.Client";
        }
        long[] lArray = new long[1];
        this.clientProxy = OS.g_dbus_proxy_new_for_bus_sync(2, 0, 0L, Converter.javaStringToCString(string2), Converter.javaStringToCString(this.clientObjectPath), Converter.javaStringToCString(string), 0L, lArray);
        if (this.clientProxy == 0L) {
            System.err.format("SWT SessionManagerDBus: Failed to connect to Client: %s%n", SessionManagerDBus.extractFreeGError(lArray[0]));
            return false;
        }
        this.g_signal_callback = new Callback(this, "g_signal_handler", 5);
        this.g_signal_callbackid = OS.g_signal_connect(this.clientProxy, Converter.javaStringToCString("g-signal"), this.g_signal_callback.getAddress(), 0L);
        return true;
    }

    private static class ShutdownHook
    extends Thread {
        private SessionManagerDBus parent;

        public ShutdownHook(SessionManagerDBus sessionManagerDBus) {
            this.parent = sessionManagerDBus;
        }

        @Override
        public void run() {
            this.parent.stop();
        }

        public void install() {
            try {
                Runtime.getRuntime().addShutdownHook(this);
            }
            catch (IllegalArgumentException | IllegalStateException runtimeException) {
                runtimeException.printStackTrace();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        public void remove() {
            try {
                Runtime.getRuntime().removeShutdownHook(this);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
        }
    }

    public static interface IListener {
        public boolean isReadyToExit();

        public void stop();
    }
}

