/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.jar.Attributes;
import org.eclipse.swt.internal.Platform;

public class Library {
    static int MAJOR_VERSION = 4;
    static int MINOR_VERSION = 964;
    static int REVISION = 8;
    public static final int JAVA_VERSION;
    public static final int SWT_VERSION;
    public static final String USER_HOME;
    static final String SEPARATOR;
    static final String DELIMITER;
    static final String JAVA_LIB_PATH = "java.library.path";
    static final String SWT_LIB_PATH = "swt.library.path";
    static final String SUFFIX_64 = "-64";
    static final String SWT_LIB_DIR;

    static String arch() {
        String string = System.getProperty("os.arch");
        if (string.equals("amd64")) {
            return "x86_64";
        }
        return string;
    }

    static String os() {
        String string = System.getProperty("os.name");
        if (string.equals("Linux")) {
            return "linux";
        }
        if (string.equals("Mac OS X")) {
            return "macosx";
        }
        if (string.startsWith("Win")) {
            return "win32";
        }
        return string;
    }

    static void chmod(String string, String string2) {
        if (Library.os().equals("win32")) {
            return;
        }
        try {
            Runtime.getRuntime().exec(new String[]{"chmod", string, string2}).waitFor();
        }
        catch (Throwable throwable) {
            try {
                new File(string2).setExecutable(true);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    static long longConst() {
        return 0x1FFFFFFFFL;
    }

    static int parseVersion(String string) {
        int n;
        if (string == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        int n6 = 0;
        for (n = 0; n < n5 && Character.isDigit(string.charAt(n)); ++n) {
        }
        try {
            if (n6 < n5) {
                n2 = Integer.parseInt(string.substring(n6, n));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        n6 = ++n;
        while (n < n5 && Character.isDigit(string.charAt(n))) {
            ++n;
        }
        try {
            if (n6 < n5) {
                n3 = Integer.parseInt(string.substring(n6, n));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        n6 = ++n;
        while (n < n5 && Character.isDigit(string.charAt(n))) {
            ++n;
        }
        try {
            if (n6 < n5) {
                n4 = Integer.parseInt(string.substring(n6, n));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Library.JAVA_VERSION(n2, n3, n4);
    }

    public static int JAVA_VERSION(int n, int n2, int n3) {
        return (n << 16) + (n2 << 8) + n3;
    }

    public static int SWT_VERSION(int n, int n2) {
        return n * 1000 + n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean extractResource(String string, File file) {
        try (InputStream inputStream = Library.class.getResourceAsStream(string);){
            if (inputStream == null) {
                boolean bl = false;
                return bl;
            }
            Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static boolean extract(String string, String string2) {
        File file;
        File file2 = new File(string);
        if (file2.exists()) {
            return true;
        }
        try {
            file = File.createTempFile(file2.getName(), ".tmp", file2.getParentFile());
        }
        catch (Throwable throwable) {
            return false;
        }
        String string3 = "/" + string2.replace('\\', '/');
        if (!Library.extractResource(string3, file)) {
            file.delete();
            return false;
        }
        Library.chmod("755", file.getPath());
        try {
            Files.move(file.toPath(), file2.toPath(), new CopyOption[0]);
        }
        catch (Throwable throwable) {
            file.delete();
        }
        return true;
    }

    static boolean isLoadable() {
        Object object;
        Object object2;
        URL uRL = Platform.class.getClassLoader().getResource("org/eclipse/swt/internal/Library.class");
        if (!uRL.getProtocol().equals("jar")) {
            return true;
        }
        Attributes attributes = null;
        try {
            object2 = uRL.openConnection();
            if (!(object2 instanceof JarURLConnection)) {
                return false;
            }
            object = (JarURLConnection)object2;
            attributes = ((JarURLConnection)object).getMainAttributes();
        }
        catch (IOException iOException) {
            return false;
        }
        object2 = Library.os();
        object = Library.arch();
        String string = attributes.getValue("SWT-OS");
        String string2 = attributes.getValue("SWT-Arch");
        return ((String)object).equals(string2) && ((String)object2).equals(string);
    }

    static boolean load(String string, StringBuilder stringBuilder) {
        try {
            if (string.contains(SEPARATOR)) {
                System.load(string);
            } else {
                System.loadLibrary(string);
            }
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (stringBuilder.length() == 0) {
                stringBuilder.append(DELIMITER);
            }
            stringBuilder.append('\t');
            stringBuilder.append(unsatisfiedLinkError.getMessage());
            stringBuilder.append(DELIMITER);
            return false;
        }
    }

    public static void loadLibrary(String string) {
        Library.loadLibrary(string, true);
    }

    public static void loadLibrary(String string, boolean bl) {
        int n;
        int n2;
        CharSequence charSequence;
        String string2 = System.getProperty("sun.arch.data.model");
        if (string2 == null) {
            string2 = System.getProperty("com.ibm.vm.bitmode");
        }
        if (string2 != null && "32".equals(string2)) {
            throw new UnsatisfiedLinkError("Cannot load 64-bit SWT libraries on 32-bit JVM");
        }
        String[] stringArray = new String[3];
        String[] stringArray2 = new String[3];
        if (bl) {
            charSequence = Library.getVersionString();
            stringArray[0] = string + "-gtk-" + (String)charSequence;
            stringArray[1] = string + "-gtk";
            stringArray[2] = string;
            for (int i = 0; i < 3; ++i) {
                stringArray2[i] = Library.mapLibraryName(stringArray[i]);
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                stringArray[i] = stringArray2[i] = string;
            }
        }
        charSequence = new StringBuilder();
        String string3 = System.getProperty(SWT_LIB_PATH);
        if (string3 != null) {
            string3 = new File(string3).getAbsolutePath();
            for (n2 = 0; n2 < 3; ++n2) {
                if (n2 != 0 && !bl || !Library.load(string3 + SEPARATOR + stringArray2[n2], (StringBuilder)charSequence)) continue;
                return;
            }
        }
        for (n2 = 0; n2 < 3; ++n2) {
            if (n2 != 0 && !bl || !Library.load(stringArray[n2], (StringBuilder)charSequence)) continue;
            return;
        }
        String[] stringArray3 = new String[3];
        for (n = 0; n < 3; ++n) {
            stringArray3[n] = stringArray2[n];
        }
        if (string3 == null) {
            int n3;
            string3 = USER_HOME;
            File file = new File(string3, SWT_LIB_DIR);
            if (file.exists() && file.isDirectory() || file.mkdirs()) {
                string3 = file.getAbsolutePath();
            } else {
                for (n3 = 0; n3 < 3; ++n3) {
                    stringArray3[n3] = Library.mapLibraryName(stringArray[n3] + SUFFIX_64);
                }
            }
            for (n3 = 0; n3 < 3; ++n3) {
                if (n3 != 0 && !bl || !Library.load(string3 + SEPARATOR + stringArray3[n3], (StringBuilder)charSequence)) continue;
                return;
            }
        }
        if (string3 != null) {
            for (n = 0; n < 3; ++n) {
                if (n != 0 && !bl || !Library.extract(string3 + SEPARATOR + stringArray3[n], stringArray2[n]) || !Library.load(string3 + SEPARATOR + stringArray3[n], (StringBuilder)charSequence)) continue;
                return;
            }
        }
        throw new UnsatisfiedLinkError("Could not load SWT library. Reasons: " + ((StringBuilder)charSequence).toString());
    }

    static String mapLibraryName(String string) {
        return Library.mapLibraryName(string, true);
    }

    static String mapLibraryName(String object, boolean bl) {
        String string;
        if (((String)(object = System.mapLibraryName((String)object))).endsWith(string = ".dylib") && bl) {
            object = ((String)object).substring(0, ((String)object).length() - string.length()) + ".jnilib";
        }
        return object;
    }

    public static String getVersionString() {
        Object object = System.getProperty("swt.version");
        if (object == null) {
            object = "" + MAJOR_VERSION;
            if (MINOR_VERSION < 10) {
                object = (String)object + "00";
            } else if (MINOR_VERSION < 100) {
                object = (String)object + "0";
            }
            object = (String)object + MINOR_VERSION;
            if (REVISION > 0) {
                object = (String)object + "r" + REVISION;
            }
        }
        return object;
    }

    static {
        DELIMITER = System.lineSeparator();
        SEPARATOR = File.separator;
        USER_HOME = System.getProperty("user.home");
        SWT_LIB_DIR = ".swt" + SEPARATOR + "lib" + SEPARATOR + Library.os() + SEPARATOR + Library.arch();
        JAVA_VERSION = Library.parseVersion(System.getProperty("java.version"));
        SWT_VERSION = Library.SWT_VERSION(MAJOR_VERSION, MINOR_VERSION);
    }
}

