/*
 * Decompiled with CFR 0.152.
 */
package Program_Tabs.Tab_Checklist;

import File_Operations.File_Objects.SCAPRes.Result;
import File_Operations.File_Objects.Vuln;
import Program_Tabs.Tab_Checklist.ChecklistDriver;
import java.util.ArrayList;
import java.util.List;

public class XccdfResHandler {
    private ChecklistDriver CkDriver;

    public XccdfResHandler(ChecklistDriver CkListDrive) {
        this.CkDriver = CkListDrive;
    }

    public ArrayList<String> ImportXCCDF12Results(List<Result> Results) {
        ArrayList<String> resNotFound = new ArrayList<String>();
        for (Vuln v : this.CkDriver.getMasterVulnList()) {
            for (Result xRes : Results) {
                if (!v.getAttr(Vuln.VulnAttr.Rule_ID).equals(xRes.getRuleVersion())) continue;
                switch (xRes.getRuleResult()) {
                    case "pass": {
                        v.setCheckState(Vuln.CheckState.NotAFinding);
                        break;
                    }
                    case "fail": {
                        v.setCheckState(Vuln.CheckState.Open);
                        break;
                    }
                    case "notapplicable": {
                        v.setCheckState(Vuln.CheckState.Not_Applicable);
                    }
                }
            }
        }
        for (Result XRI : Results) {
            boolean trigger = true;
            for (Vuln v : this.CkDriver.getMasterVulnList()) {
                if (!v.getAttr(Vuln.VulnAttr.Rule_ID).equals(XRI.getRuleVersion())) continue;
                trigger = false;
            }
            if (!trigger) continue;
            resNotFound.add(XRI.getRuleVersion());
        }
        return resNotFound;
    }
}

