/*
 * Decompiled with CFR 0.152.
 */
package Program_Tabs.Tab_Checklist;

import File_Operations.File_Objects.STIG;
import File_Operations.File_Objects.Vuln;
import Program_Tabs.Tab_Checklist.ChecklistDriver;
import Program_Tabs.Tab_Checklist.ChecklistMenuBar;
import Program_Tabs.Tab_Checklist.TargetPane;
import Program_Tabs.interfaces.DisplayTab;
import Program_Tabs.interfaces.STIGDisplayTab;
import Shared_Constructs.Filter.GUI.FilterPane;
import Shared_Constructs.Legacy.STIGDataView.Ckl_SDV_Setup;
import Shared_Constructs.Rule_Display.Checklist_Rule_Display;
import Shared_Constructs.STIGList.StigList_Abstract;
import Shared_Constructs.STIGList.StigList_Checklist;
import Shared_Constructs.VulnTable;
import Utility_Code.GlobalSettings.DisplayObject;
import Utility_Code.GlobalSettings.Preferences_Window.PrefSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.PieChart;
import javafx.scene.control.Accordion;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import stigviewer.STIGViewer;

public class ChecklistViewTab
extends DisplayObject
implements DisplayTab,
STIGDisplayTab {
    private final Tab ChecklistTab;
    STIGViewer stigviewer;
    private ChecklistDriver ChecklistDriverParent;
    private final StigList_Abstract STIGView;
    private final VulnTable VDisplay;
    private final FilterPane FilPane;
    private final TargetPane myTargetPane;
    private final TitledPane STIGListTP;
    private int currentTab = 0;
    private final ScrollPane RightColumnScrollPane;
    private Ckl_SDV_Setup SDV_Set;
    private Checklist_Rule_Display RDisplay;
    private final TabPane TotalsTabPane;
    private final Tab TotalsTab;
    private final Tab Cat1Tab;
    private final Tab Cat2Tab;
    private final Tab Cat3Tab;
    private Label overallOpen = new Label("[O]");
    private Label overallNR = new Label("[NR]");
    private Label overallNF = new Label("[NF]");
    private Label overallNA = new Label("[NA]");
    private Label overallTotal = new Label("[Total]");
    private Label cat1Open = new Label("[O]");
    private Label cat2Open = new Label("[O]");
    private Label cat3Open = new Label("[O]");
    private Label cat1NF = new Label("[NF]");
    private Label cat2NF = new Label("[NF]");
    private Label cat3NF = new Label("[NF]");
    private Label cat1NR = new Label("[NR]");
    private Label cat2NR = new Label("[NR]");
    private Label cat3NR = new Label("[NR]");
    private Label cat1NA = new Label("[NA]");
    private Label cat2NA = new Label("[NA]");
    private Label cat3NA = new Label("[NA]");
    private Label cat1Total = new Label("[Total]");
    private Label cat2Total = new Label("[Total]");
    private Label cat3Total = new Label("[Total]");
    private String currentFileDirectory = "";
    private ComboBox technologyArea;
    private final VBox LeftPane;
    private SplitPane RootPane;
    private final PieChart chart;
    private final PieChart cat1Chart;
    private final PieChart cat2Chart;
    private final PieChart cat3Chart;
    private ObservableList<PieChart.Data> pieChartData = FXCollections.observableArrayList((Object[])new PieChart.Data[]{new PieChart.Data("Open", 25.0), new PieChart.Data("Not a Finding", 25.0), new PieChart.Data("Not Reviewed", 25.0), new PieChart.Data("Not Applicable", 25.0)});
    private ObservableList<PieChart.Data> pieChart1Data = FXCollections.observableArrayList((Object[])new PieChart.Data[]{new PieChart.Data("Open", 25.0), new PieChart.Data("Not a Finding", 25.0), new PieChart.Data("Not Reviewed", 25.0), new PieChart.Data("Not Applicable", 25.0)});
    private ObservableList<PieChart.Data> pieChart2Data = FXCollections.observableArrayList((Object[])new PieChart.Data[]{new PieChart.Data("Open", 25.0), new PieChart.Data("Not a Finding", 25.0), new PieChart.Data("Not Reviewed", 25.0), new PieChart.Data("Not Applicable", 25.0)});
    private ObservableList<PieChart.Data> pieChart3Data = FXCollections.observableArrayList((Object[])new PieChart.Data[]{new PieChart.Data("Open", 25.0), new PieChart.Data("Not a Finding", 25.0), new PieChart.Data("Not Reviewed", 25.0), new PieChart.Data("Not Applicable", 25.0)});
    private Vuln CurrentChecklistItem;

    public ChecklistViewTab(STIGViewer sv, ChecklistDriver p) {
        Screen screen = Screen.getPrimary();
        Rectangle2D bounds = screen.getVisualBounds();
        this.stigviewer = sv;
        this.ChecklistDriverParent = p;
        this.CurrentChecklistItem = null;
        this.RightColumnScrollPane = new ScrollPane();
        this.RightColumnScrollPane.setPrefWidth(1000.0);
        this.RightColumnScrollPane.setFitToWidth(true);
        this.RightColumnScrollPane.setFitToHeight(true);
        this.RightColumnScrollPane.setStyle(PrefSet.getPS().getJfxTableDefault());
        this.LeftPane = new VBox(5.0);
        VBox MidPane = new VBox(2.0);
        this.LeftPane.setFillWidth(true);
        MidPane.setMinWidth(5.0);
        ScrollPane MiddlePane = new ScrollPane();
        MiddlePane.setPrefHeight(bounds.getHeight() * 0.9);
        MiddlePane.setContent((Node)MidPane);
        this.RootPane = new SplitPane();
        this.RootPane.setDividerPositions(new double[]{0.3f, 0.5, 0.8f});
        this.RootPane.getItems().addAll((Object[])new Node[]{this.LeftPane, MidPane, this.RightColumnScrollPane});
        this.RootPane.setFocusTraversable(true);
        SplitPane.setResizableWithParent((Node)this.LeftPane, (Boolean)false);
        SplitPane.setResizableWithParent((Node)MidPane, (Boolean)false);
        SplitPane.setResizableWithParent((Node)this.RightColumnScrollPane, (Boolean)false);
        this.LeftPane.setMinWidth(5.0);
        this.LeftPane.setAlignment(Pos.TOP_LEFT);
        ArrayList<VulnTable.DispColumn> ColumnList = new ArrayList<VulnTable.DispColumn>();
        ColumnList.add(VulnTable.DispColumn.CheckState);
        ColumnList.add(VulnTable.DispColumn.VulID);
        ColumnList.add(VulnTable.DispColumn.STIGID);
        ColumnList.add(VulnTable.DispColumn.RuleID);
        ColumnList.add(VulnTable.DispColumn.CCI);
        ColumnList.add(VulnTable.DispColumn.STIGName);
        this.VDisplay = new VulnTable(this, ColumnList);
        TableView myTable = this.VDisplay.createTable();
        VBox ChecklistVulnTableVBox = new VBox(5.0);
        VBox.setVgrow((Node)ChecklistVulnTableVBox, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)myTable, (Priority)Priority.ALWAYS);
        ChecklistVulnTableVBox.getChildren().addAll((Object[])new Node[]{myTable, this.VDisplay.createTableStatusBar()});
        MidPane.getChildren().addAll((Object[])new Node[]{ChecklistVulnTableVBox});
        this.myTargetPane = new TargetPane(this.ChecklistDriverParent);
        TitledPane myTargetTitledPane = this.myTargetPane.createTargetPane();
        this.ChecklistDriverParent.setTargetPane(this.myTargetPane);
        if (!this.ChecklistDriverParent.getChecklist().getIsComputing().isEmpty()) {
            this.myTargetPane.setAssetType(this.ChecklistDriverParent.getChecklist().getIsComputing());
        } else {
            this.ChecklistDriverParent.getChecklist().setIsComputing(this.myTargetPane.getAssetType());
        }
        this.myTargetPane.setHostName(this.ChecklistDriverParent.getChecklist().getHostName());
        this.myTargetPane.setIPAddress(this.ChecklistDriverParent.getChecklist().getIPAddress());
        this.myTargetPane.setMAC(this.ChecklistDriverParent.getChecklist().getMACAddress());
        this.myTargetPane.setGUID(this.ChecklistDriverParent.getChecklist().getGUID());
        TitledPane totalsPane = new TitledPane();
        totalsPane.setText("Totals");
        totalsPane.setPrefHeight(600.0);
        this.TotalsTabPane = new TabPane();
        Label totalsLabel = new Label("Overall Totals");
        totalsLabel.setFont(Font.font((String)"Segoe UI", (FontWeight)FontWeight.BOLD, (double)12.0));
        this.TotalsTab = new Tab();
        this.TotalsTab.setClosable(false);
        GridPane totalsGrid = new GridPane();
        totalsGrid.add((Node)new Label("Open: "), 0, 0);
        totalsGrid.add((Node)this.overallOpen, 1, 0);
        this.overallOpen.setStyle("-fx-font-weight: bold");
        totalsGrid.add((Node)new Label("Not a Finding: "), 0, 1);
        totalsGrid.add((Node)this.overallNF, 1, 1);
        this.overallNF.setStyle("-fx-font-weight: bold");
        totalsGrid.add((Node)new Label("Not Reviewed: "), 3, 0);
        totalsGrid.add((Node)this.overallNR, 4, 0);
        this.overallNR.setStyle("-fx-font-weight: bold");
        totalsGrid.add((Node)new Label("Not Applicable: "), 3, 1);
        totalsGrid.add((Node)this.overallNA, 4, 1);
        this.overallNA.setStyle("-fx-font-weight: bold");
        totalsGrid.add((Node)this.overallTotal, 1, 5);
        this.overallTotal.setStyle("-fx-font-weight: bold");
        this.overallTotal.setVisible(false);
        totalsGrid.setPadding(new Insets(20.0, 5.0, -10.0, 5.0));
        totalsGrid.getColumnConstraints().add((Object)new ColumnConstraints(100.0));
        totalsGrid.setAlignment(Pos.CENTER);
        totalsGrid.setHgap(10.0);
        this.chart = new PieChart(this.pieChartData);
        this.chart.setAnimated(false);
        this.chart.setLabelsVisible(false);
        this.chart.setPadding(new Insets(0.0));
        VBox totalsVBox = new VBox(0.0);
        totalsVBox.getChildren().addAll((Object[])new Node[]{totalsGrid, this.chart});
        this.TotalsTab.setContent((Node)totalsVBox);
        this.TotalsTab.setText(totalsLabel.getText());
        Label cat1Label = new Label("CAT I");
        cat1Label.setFont(Font.font((String)"Segoe UI", (FontWeight)FontWeight.BOLD, (double)12.0));
        this.Cat1Tab = new Tab();
        this.Cat1Tab.setClosable(false);
        GridPane cat1Grid = new GridPane();
        cat1Grid.add((Node)new Label("Open: "), 0, 0);
        cat1Grid.add((Node)this.cat1Open, 1, 0);
        this.cat1Open.setStyle("-fx-font-weight: bold");
        cat1Grid.add((Node)new Label("Not a Finding: "), 0, 1);
        cat1Grid.add((Node)this.cat1NF, 1, 1);
        this.cat1NF.setStyle("-fx-font-weight: bold");
        cat1Grid.add((Node)new Label("Not Reviewed: "), 3, 0);
        cat1Grid.add((Node)this.cat1NR, 4, 0);
        this.cat1NR.setStyle("-fx-font-weight: bold");
        cat1Grid.add((Node)new Label("Not Applicable: "), 3, 1);
        cat1Grid.add((Node)this.cat1NA, 4, 1);
        this.cat1NA.setStyle("-fx-font-weight: bold");
        cat1Grid.add((Node)new Label("Total: "), 0, 6);
        cat1Grid.add((Node)this.cat1Total, 1, 6);
        this.cat1Total.setStyle("-fx-font-weight: bold");
        cat1Grid.setPadding(new Insets(20.0, 5.0, 20.0, 5.0));
        cat1Grid.getColumnConstraints().add((Object)new ColumnConstraints(100.0));
        cat1Grid.setAlignment(Pos.CENTER);
        cat1Grid.setHgap(10.0);
        this.cat1Chart = new PieChart(this.pieChart1Data);
        this.cat1Chart.setAnimated(false);
        this.cat1Chart.setLabelsVisible(false);
        this.cat1Chart.setPadding(new Insets(0.0));
        VBox cat1ChartVBox = new VBox(0.0);
        cat1ChartVBox.getChildren().addAll((Object[])new Node[]{cat1Grid, this.cat1Chart});
        this.Cat1Tab.setContent((Node)cat1ChartVBox);
        this.Cat1Tab.setText(cat1Label.getText());
        Label cat12Label = new Label("CAT II");
        cat12Label.setFont(Font.font((String)"Segoe UI", (FontWeight)FontWeight.BOLD, (double)12.0));
        this.Cat2Tab = new Tab();
        this.Cat2Tab.setClosable(false);
        GridPane cat2Grid = new GridPane();
        cat2Grid.add((Node)new Label("Open: "), 0, 0);
        cat2Grid.add((Node)this.cat2Open, 1, 0);
        this.cat2Open.setStyle("-fx-font-weight: bold");
        cat2Grid.add((Node)new Label("Not a Finding: "), 0, 1);
        cat2Grid.add((Node)this.cat2NF, 1, 1);
        this.cat2NF.setStyle("-fx-font-weight: bold");
        cat2Grid.add((Node)new Label("Not Reviewed: "), 3, 0);
        cat2Grid.add((Node)this.cat2NR, 4, 0);
        this.cat2NR.setStyle("-fx-font-weight: bold");
        cat2Grid.add((Node)new Label("Not Applicable: "), 3, 1);
        cat2Grid.add((Node)this.cat2NA, 4, 1);
        this.cat2NA.setStyle("-fx-font-weight: bold");
        cat2Grid.add((Node)new Label("Total: "), 0, 6);
        cat2Grid.add((Node)this.cat2Total, 1, 6);
        this.cat2Total.setStyle("-fx-font-weight: bold");
        cat2Grid.setPadding(new Insets(20.0, 5.0, 20.0, 5.0));
        cat2Grid.getColumnConstraints().add((Object)new ColumnConstraints(100.0));
        cat2Grid.setAlignment(Pos.CENTER);
        cat2Grid.setHgap(10.0);
        this.cat2Chart = new PieChart(this.pieChart2Data);
        this.cat2Chart.setAnimated(false);
        this.cat2Chart.setLabelsVisible(false);
        this.cat2Chart.setPadding(new Insets(0.0));
        VBox cat2ChartVBox = new VBox(0.0);
        cat2ChartVBox.getChildren().addAll((Object[])new Node[]{cat2Grid, this.cat2Chart});
        this.Cat2Tab.setContent((Node)cat2ChartVBox);
        this.Cat2Tab.setText(cat12Label.getText());
        Label cat3Label = new Label("CAT III");
        cat3Label.setFont(Font.font((String)"Segoe UI", (FontWeight)FontWeight.BOLD, (double)12.0));
        this.Cat3Tab = new Tab();
        this.Cat3Tab.setClosable(false);
        GridPane cat3Grid = new GridPane();
        cat3Grid.add((Node)new Label("Open: "), 0, 0);
        cat3Grid.add((Node)this.cat3Open, 1, 0);
        this.cat3Open.setStyle("-fx-font-weight: bold");
        cat3Grid.add((Node)new Label("Not a Finding: "), 0, 1);
        cat3Grid.add((Node)this.cat3NF, 1, 1);
        this.cat3NF.setStyle("-fx-font-weight: bold");
        cat3Grid.add((Node)new Label("Not Reviewed: "), 3, 0);
        cat3Grid.add((Node)this.cat3NR, 4, 0);
        this.cat3NR.setStyle("-fx-font-weight: bold");
        cat3Grid.add((Node)new Label("Not Applicable: "), 3, 1);
        cat3Grid.add((Node)this.cat3NA, 4, 1);
        this.cat3NA.setStyle("-fx-font-weight: bold");
        cat3Grid.add((Node)new Label("Total: "), 0, 6);
        cat3Grid.add((Node)this.cat3Total, 1, 6);
        this.cat3Total.setStyle("-fx-font-weight: bold");
        cat3Grid.setPadding(new Insets(20.0, 5.0, 20.0, 5.0));
        cat3Grid.getColumnConstraints().add((Object)new ColumnConstraints(100.0));
        cat3Grid.setAlignment(Pos.CENTER);
        cat3Grid.setHgap(10.0);
        this.cat3Chart = new PieChart(this.pieChart3Data);
        this.cat3Chart.setAnimated(false);
        this.cat3Chart.setLabelsVisible(false);
        this.cat3Chart.setPadding(new Insets(0.0));
        VBox cat3ChartVBox = new VBox(0.0);
        cat3ChartVBox.getChildren().addAll((Object[])new Node[]{cat3Grid, this.cat3Chart});
        this.Cat3Tab.setContent((Node)cat3ChartVBox);
        this.Cat3Tab.setText(cat3Label.getText());
        this.TotalsTabPane.getTabs().addAll((Object[])new Tab[]{this.TotalsTab, this.Cat1Tab, this.Cat2Tab, this.Cat3Tab});
        totalsPane.setContent((Node)this.TotalsTabPane);
        ArrayList<StigList_Abstract.STIGDispColumn> ColumnSet = new ArrayList<StigList_Abstract.STIGDispColumn>();
        ColumnSet.add(StigList_Abstract.STIGDispColumn.Check);
        ColumnSet.add(StigList_Abstract.STIGDispColumn.STIGName);
        ColumnSet.add(StigList_Abstract.STIGDispColumn.Score);
        ColumnSet.add(StigList_Abstract.STIGDispColumn.STIGVersion);
        ColumnSet.add(StigList_Abstract.STIGDispColumn.ReleaseID);
        this.STIGView = new StigList_Checklist(this, ColumnSet);
        this.STIGListTP = new TitledPane();
        this.STIGListTP.setText("STIGs");
        TableView STIGTable = this.STIGView.createTable();
        STIGTable.setOpacity(90.0);
        this.STIGListTP.setContent((Node)STIGTable);
        this.FilPane = new FilterPane(this, this.ChecklistDriverParent);
        TitledPane techAreaTP = new TitledPane();
        techAreaTP.setText("Technology Area");
        this.TotalsTabPane.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Tab>(){

            public void changed(ObservableValue<? extends Tab> ov, Tab t, Tab selectedTab) {
                int val = 0;
                ChecklistViewTab.this.currentTab = val;
                switch (selectedTab.getText()) {
                    case "CAT I": {
                        val = 1;
                        break;
                    }
                    case "CAT II": {
                        val = 2;
                        break;
                    }
                    case "CAT III": {
                        val = 3;
                        break;
                    }
                    case "Overall Totals": {
                        val = 0;
                        break;
                    }
                }
                ChecklistViewTab.this.currentTab = val;
                ChecklistViewTab.this.VDisplay.deselectAll();
                ChecklistViewTab.this.changeVulnList(ChecklistViewTab.this.ChecklistDriverParent.UpdateVisibleListBySeverity(val));
                ChecklistViewTab.this.updateDisplay();
                ChecklistViewTab.this.refreshTotals();
                Logger.getLogger(ChecklistViewTab.class.getName()).log(Level.INFO, "INFO: CT: Checklist changed vuln tab to: " + selectedTab.getText());
            }
        });
        StackPane taPane = new StackPane();
        VBox techAreaVBox = new VBox(1.0);
        Label techAreaLabel = new Label("Select Technology Area: ");
        this.technologyArea = new ComboBox();
        ObservableList technologyAreasList = FXCollections.observableArrayList((Object[])new String[]{"Application Review", "Boundary Security", "CDS Admin Review", "CDS Technical Review", "Database Review", "Domain Name System (DNS)", "Exchange Server", "Host Based System Security (HBSS)", "Internal Network", "Mobility", "Releasable Networks (REL)", "Traditional Security", "UNIX OS", "VVOIP Review", "Web Review", "Windows OS", "Other Review"});
        this.technologyArea.setItems(technologyAreasList);
        this.technologyArea.setValue((Object)this.ChecklistDriverParent.getChecklist().getTechnologyArea());
        Separator techSep = new Separator();
        this.technologyArea.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue ov, String t, String t1) {
                ChecklistViewTab.this.ChecklistDriverParent.getChecklist().setTechnologyArea(t1);
                Logger.getLogger(ChecklistViewTab.class.getName()).log(Level.INFO, "INFO: CT: Checklist technology area changed to: " + t1);
            }
        });
        taPane.getChildren().add((Object)this.technologyArea);
        taPane.setPadding(new Insets(10.0));
        StackPane.setAlignment((Node)taPane, (Pos)Pos.CENTER);
        techAreaVBox.getChildren().addAll((Object[])new Node[]{techAreaLabel, techSep, taPane});
        techAreaVBox.setPadding(new Insets(5.0));
        techAreaTP.setContent((Node)techAreaVBox);
        VBox.setVgrow((Node)techAreaTP, (Priority)Priority.ALWAYS);
        TitledPane fPane = this.FilPane.createFilterPane();
        fPane.setPrefHeight(550.0);
        Accordion accordion = new Accordion();
        accordion.getPanes().addAll((Object[])new TitledPane[]{myTargetTitledPane, this.STIGListTP, techAreaTP, fPane});
        this.LeftPane.getChildren().addAll((Object[])new Node[]{totalsPane, accordion});
        VBox.setVgrow((Node)totalsPane, (Priority)Priority.ALWAYS);
        for (Node n : accordion.getPanes()) {
            VBox.setVgrow((Node)n, (Priority)Priority.NEVER);
        }
        this.LeftPane.setMinWidth(5.0);
        this.LeftPane.getStyleClass().add((Object)"LeftPane");
        this.LeftPane.setStyle(PrefSet.getPS().getJfxBackground());
        this.LeftPane.setPrefWidth(300.0);
        this.RDisplay = new Checklist_Rule_Display();
        this.SDV_Set = new Ckl_SDV_Setup(this, true);
        this.swapRDisplay();
        this.ChecklistTab = new Tab();
        this.ChecklistTab.setClosable(true);
        this.ChecklistTab.setText(this.ChecklistDriverParent.getCklName());
        this.ChecklistDriverParent.getChecklist().addChangeListener(() -> {
            String title = this.ChecklistDriverParent.getCklName();
            if (this.ChecklistDriverParent.getChecklist().isChanged()) {
                title = "*" + title;
            }
            this.ChecklistTab.setText(title);
        });
        this.ChecklistTab.setOnCloseRequest(event -> {
            if (this.ChecklistDriverParent.getChecklist().isChanged()) {
                Alert closeConfirmation = new Alert(Alert.AlertType.CONFIRMATION, "There are unsaved changes to Checklist '" + this.ChecklistDriverParent.getCklName() + "'.  Are you sure you want to close the checklist without saving?", new ButtonType[0]);
                Button exitButton = (Button)closeConfirmation.getDialogPane().lookupButton(ButtonType.OK);
                Button cancelButton = (Button)closeConfirmation.getDialogPane().lookupButton(ButtonType.CANCEL);
                exitButton.setText("Close without saving");
                exitButton.setDefaultButton(false);
                cancelButton.setDefaultButton(true);
                closeConfirmation.setHeaderText("Unsaved Changes");
                closeConfirmation.initModality(Modality.APPLICATION_MODAL);
                closeConfirmation.initOwner((Window)this.stigviewer.getPrimaryStage());
                Optional closeResponse = closeConfirmation.showAndWait();
                if (!ButtonType.OK.equals(closeResponse.get())) {
                    event.consume();
                }
            }
        });
        this.ChecklistTab.setContent((Node)this.RootPane);
        accordion.setExpandedPane(myTargetTitledPane);
        this.RDisplay.setDividers();
        this.RootPane.setOnKeyPressed(e -> {
            if (e.isControlDown()) {
                switch (e.getCode()) {
                    case S: {
                        this.ChecklistDriverParent.fireImport();
                        break;
                    }
                    case NUMPAD1: 
                    case DIGIT1: {
                        myTable.requestFocus();
                        break;
                    }
                    case NUMPAD2: 
                    case DIGIT2: {
                        this.SDV_Set.getVulnTabPane().requestFocus();
                        this.RDisplay.getStatusBox().requestFocus();
                        break;
                    }
                    case NUMPAD3: 
                    case DIGIT3: {
                        this.SDV_Set.getFDPanel().requestFocus();
                        this.RDisplay.getFDPanel().requestFocus();
                        break;
                    }
                    case NUMPAD4: 
                    case DIGIT4: {
                        this.SDV_Set.getComPanel().requestFocus();
                        this.RDisplay.getComPanel().requestFocus();
                        break;
                    }
                }
            }
        });
        this.ChecklistTab.setOnSelectionChanged(new EventHandler(){

            public void handle(Event e) {
                STIGViewer.getSV().getMainPane().setTop((Node)ChecklistViewTab.this.ChecklistDriverParent.getMenuBar());
                ChecklistViewTab.this.ChecklistTab.getContent().requestFocus();
                Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.INFO, "INFO: CT: Switched to/from Checklist: " + this.hashCode());
            }
        });
        this.ChecklistTab.setOnClosed(t -> {
            Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.INFO, "INFO: CT: Checklist Closed");
            this.stigviewer.CloseTab(this.ChecklistDriverParent);
        });
    }

    public void nonMatchingResultWindow(ArrayList<String> nonMatched) {
        Stage resultWarning = new Stage();
        resultWarning.initModality(Modality.WINDOW_MODAL);
        resultWarning.initOwner(this.getPrimaryStage().getScene().getWindow());
        String SVids = "";
        for (int i = 0; i < nonMatched.size(); ++i) {
            SVids = SVids + nonMatched.get(i) + "\n";
        }
        TextArea message = new TextArea("Result Reference ID(s) Not Found in the Checklist STIG(s):\n\n" + SVids);
        message.setEditable(false);
        ScrollPane scPane = new ScrollPane();
        scPane.setContent((Node)message);
        scPane.setFitToHeight(true);
        scPane.setFitToWidth(true);
        Scene getJustScene = new Scene((Parent)scPane, 400.0, 300.0);
        resultWarning.setScene(getJustScene);
        resultWarning.setTitle("Warning! Extraneous Result Found!");
        resultWarning.show();
    }

    public void initSTIGList() {
        this.updateSTIGTabGUI();
        ArrayList<STIG> initSTIG = new ArrayList<STIG>();
        for (int i = 0; i < this.ChecklistDriverParent.getSTIGs().size(); ++i) {
            initSTIG.add(this.ChecklistDriverParent.getSTIGs().get(i));
        }
        this.changeCurrentSTIG(initSTIG);
        this.refreshTotals();
    }

    public void updateModelFromTotals(Map m, Label lblOpen, Label lblNF, Label lblNR, Label lblNA, Label lblTotal, int overallId) {
        for (Object key : m.keySet()) {
            if (key.equals("O")) {
                lblOpen.textProperty().set((Object)m.get(key).toString());
                continue;
            }
            if (key.equals("NF")) {
                lblNF.textProperty().set((Object)m.get(key).toString());
                continue;
            }
            if (key.equals("NR")) {
                lblNR.textProperty().set((Object)m.get(key).toString());
                continue;
            }
            if (key.equals("NA")) {
                lblNA.textProperty().set((Object)m.get(key).toString());
                continue;
            }
            if (!key.equals("Total")) continue;
            lblTotal.textProperty().set((Object)m.get(key).toString());
        }
        switch (overallId) {
            case 0: {
                this.updatePieChartDataList(overallId, this.pieChartData, m);
                this.setPieChartColors(this.pieChartData, this.chart.lookupAll("Label.chart-legend-item"));
                break;
            }
            case 1: {
                this.updatePieChartDataList(overallId, this.pieChart1Data, m);
                this.setPieChartColors(this.pieChart1Data, this.cat1Chart.lookupAll("Label.chart-legend-item"));
                break;
            }
            case 2: {
                this.updatePieChartDataList(overallId, this.pieChart2Data, m);
                this.setPieChartColors(this.pieChart2Data, this.cat2Chart.lookupAll("Label.chart-legend-item"));
                break;
            }
            case 3: {
                this.updatePieChartDataList(overallId, this.pieChart3Data, m);
                this.setPieChartColors(this.pieChart3Data, this.cat3Chart.lookupAll("Label.chart-legend-item"));
                break;
            }
        }
    }

    public void updatePieChartDataList(int num, ObservableList<PieChart.Data> data, Map m) {
        data.clear();
        for (Object key : m.keySet()) {
            if (key == "O") {
                data.add((Object)new PieChart.Data("Open", Double.parseDouble(m.get(key).toString())));
                continue;
            }
            if (key == "NF") {
                data.add((Object)new PieChart.Data("Not a Finding", Double.parseDouble(m.get(key).toString())));
                continue;
            }
            if (key == "NR") {
                data.add((Object)new PieChart.Data("Not Reviewed", Double.parseDouble(m.get(key).toString())));
                continue;
            }
            if (key != "NA") continue;
            data.add((Object)new PieChart.Data("Not Applicable", Double.parseDouble(m.get(key).toString())));
        }
    }

    public void updateChecklistWithCurrentFieldValues() {
        this.ChecklistDriverParent.getChecklist().setIsComputing(this.myTargetPane.getAssetType());
        this.ChecklistDriverParent.getChecklist().setHostName(this.myTargetPane.getHostName());
        this.ChecklistDriverParent.getChecklist().setIPAddress(this.myTargetPane.getIPAddress());
        this.ChecklistDriverParent.getChecklist().setMACAddress(this.myTargetPane.getMAC());
        this.ChecklistDriverParent.getChecklist().setFullyQualifiedDN(this.myTargetPane.getFQDN());
        this.ChecklistDriverParent.getChecklist().setGUID(this.myTargetPane.getGUID());
        this.ChecklistDriverParent.getChecklist().setRole(this.myTargetPane.getRole());
        this.ChecklistDriverParent.getChecklist().setBIsWebDB(this.myTargetPane.isWebOrDB());
        this.ChecklistDriverParent.getChecklist().setSite(this.myTargetPane.GetSite());
        this.ChecklistDriverParent.getChecklist().setInstance(this.myTargetPane.GetInstance());
        if (this.CurrentChecklistItem != null) {
            this.ChecklistDriverParent.updateChecklistItem(this.CurrentChecklistItem, this.SDV_Set.getFDPanel().getText(), this.SDV_Set.getComPanel().getText(), Vuln.CheckState.fromInt((Integer)this.SDV_Set.getSDV().getCheckToggleGroup().getSelectedToggle().getUserData()));
        }
    }

    public void setTechAreaType(String tech) {
        this.technologyArea.getSelectionModel().select((Object)tech);
    }

    public void setPieChartColors(ObservableList<PieChart.Data> chartData, Set<Node> pcColor) {
        for (Node leg : pcColor) {
            Label label = (Label)leg;
            switch (label.getText()) {
                case "Open": {
                    label.setGraphic((Node)new Circle(5.0, (Paint)PrefSet.getPS().getSV_FONT_OPEN1_COLOR_RGB_FX()));
                    break;
                }
                case "Not a Finding": {
                    label.setGraphic((Node)new Circle(5.0, (Paint)PrefSet.getPS().getSV_FONT_NAF_COLOR_RGB_FX()));
                    break;
                }
                case "Not Reviewed": {
                    label.setGraphic((Node)new Circle(5.0, (Paint)Color.rgb((int)125, (int)125, (int)125)));
                    break;
                }
                case "Not Applicable": {
                    label.setGraphic((Node)new Circle(5.0, (Paint)PrefSet.getPS().getSV_FONT_NA_COLOR_RGB_FX()));
                }
            }
        }
        for (PieChart.Data data : chartData) {
            String key;
            switch (key = data.getName()) {
                case "Open": {
                    data.getNode().setStyle(PrefSet.getPS().getOpenPieColor());
                    break;
                }
                case "Not a Finding": {
                    data.getNode().setStyle(PrefSet.getPS().getNFPieColor());
                    break;
                }
                case "Not Reviewed": {
                    data.getNode().setStyle("-fx-pie-color: gray;");
                    break;
                }
                case "Not Applicable": {
                    data.getNode().setStyle(PrefSet.getPS().getNAPieColor());
                }
            }
        }
    }

    private File GetSaveFileName() {
        File FileToReturn = null;
        FileChooser fileSelector = new FileChooser();
        fileSelector.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Checklist files(*.ckl)", new String[]{"*.ckl"}));
        if (!this.currentFileDirectory.equals("")) {
            fileSelector.setInitialDirectory(new File(this.currentFileDirectory));
        }
        FileToReturn = fileSelector.showSaveDialog((Window)this.stigviewer.getPrimaryStage());
        return FileToReturn;
    }

    public Checklist_Rule_Display getRDisplay() {
        return this.RDisplay;
    }

    public VulnTable getVulnTable() {
        return this.VDisplay;
    }

    private void swapRDisplay() {
        if (PrefSet.getPS().getStyle().contains("Classic")) {
            this.RightColumnScrollPane.setContent((Node)this.SDV_Set.getRCVBox());
        } else {
            this.RightColumnScrollPane.setContent((Node)this.RDisplay.getRuleDisplay());
        }
    }

    public ChecklistDriver getCklDrive() {
        return this.ChecklistDriverParent;
    }

    public void setMultipleSelections() {
    }

    public int getSevTab() {
        return this.currentTab;
    }

    public final Tab getTab() {
        return this.ChecklistTab;
    }

    public void setTabName() {
        this.ChecklistTab.setText(this.ChecklistDriverParent.getCklName());
    }

    @Override
    public void changeCurrentSTIG(ArrayList<STIG> STIGs) {
        if (STIGs == null) {
            this.changeVulnList(null);
        } else {
            this.ChecklistDriverParent.UpdateCurrentSTIGList(STIGs);
            this.changeVulnList(this.ChecklistDriverParent.UpdateVisibleListBySeverity(this.currentTab));
        }
    }

    @Override
    public void RemoveSTIGs(ArrayList<STIG> STIGs) {
        this.ChecklistDriverParent.getChecklist().setSTIGs(STIGs);
        this.ChecklistDriverParent.UpdateCurrentSTIGList(STIGs);
        this.changeVulnList(this.ChecklistDriverParent.UpdateVisibleListBySeverity(this.currentTab));
        ArrayList<Vuln> VulnList = this.ChecklistDriverParent.getVisibleVulnList();
        this.changeVulnList(VulnList);
    }

    @Override
    public final void updateSTIGTabGUI() {
        ArrayList<STIG> STIGs = this.ChecklistDriverParent.getSTIGs();
        this.STIGView.changeSTIGList(STIGs);
    }

    public void refreshTotals() {
        this.updateModelFromTotals(this.ChecklistDriverParent.getTotalsCount("none"), this.overallOpen, this.overallNF, this.overallNR, this.overallNA, this.overallTotal, 0);
        this.updateModelFromTotals(this.ChecklistDriverParent.getTotalsCount("high"), this.cat1Open, this.cat1NF, this.cat1NR, this.cat1NA, this.cat1Total, 1);
        this.updateModelFromTotals(this.ChecklistDriverParent.getTotalsCount("medium"), this.cat2Open, this.cat2NF, this.cat2NR, this.cat2NA, this.cat2Total, 2);
        this.updateModelFromTotals(this.ChecklistDriverParent.getTotalsCount("low"), this.cat3Open, this.cat3NF, this.cat3NR, this.cat3NA, this.cat3Total, 3);
    }

    @Override
    public void changeVulnList(ArrayList<Vuln> vList) {
        this.ChecklistDriverParent.setVisibleVulnList(vList);
        boolean retB = this.VDisplay.changeVulnList(vList);
        this.VDisplay.selectionMonitor(retB);
        this.refreshTotals();
    }

    @Override
    public void changeCurrentRule(VulnTable.VulnTableItem selectedItem) {
        Vuln currVuln = new Vuln();
        if (selectedItem != null) {
            currVuln = selectedItem.getVuln();
        }
        if (currVuln != null) {
            this.ChecklistDriverParent.setCurrentVuln(currVuln);
            this.ChecklistDriverParent.setCurrentSelectedVuln(currVuln);
            this.updateRuleDisplay(currVuln);
        } else {
            currVuln = new Vuln();
            this.ChecklistDriverParent.setCurrentVuln(currVuln);
            this.ChecklistDriverParent.setCurrentSelectedVuln(currVuln);
            this.updateRuleDisplay(currVuln);
        }
    }

    @Override
    public void updateCurrentSelectedVuls(ArrayList<Vuln> vuls, boolean bool) {
        this.ChecklistDriverParent.setCurrentVulns(vuls);
    }

    public void updateAllVulnListStatus(Vuln upVuln) {
        this.ChecklistDriverParent.updateVulnItem(upVuln);
    }

    @Override
    public void updateDisplay() {
        try {
            this.ChecklistDriverParent.updateScoreMap();
            this.updateSTIGTabGUI();
            this.VDisplay.UpdateDisplay();
        }
        catch (Exception e) {
            Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.SEVERE, "SEVERE: CT: An exception occured while updating the Checklist display");
        }
        this.changeVulnList(this.ChecklistDriverParent.UpdateVisibleListBySeverity(this.currentTab));
        this.updateAllVulnListStatus(this.GetCurrentSelectedVul());
    }

    @Override
    public void updateRuleDisplay(Vuln currVuln) {
        if (PrefSet.getPS().getStyle().contains("Classic")) {
            if (currVuln == null) {
                this.CurrentChecklistItem = null;
                this.SDV_Set.getFDPanel().setText("");
                this.SDV_Set.getComPanel().setText("");
                try {
                    this.SDV_Set.getSDV().getCheckToggleGroup().getSelectedToggle().setSelected(false);
                }
                catch (Exception e) {
                    Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.SEVERE, "SEVERE: CT: Checklist rule display 1 encountered an exception while updating");
                }
            } else {
                try {
                    if (this.CurrentChecklistItem != null && !this.CurrentChecklistItem.equals(currVuln)) {
                        this.ChecklistDriverParent.updateChecklistItem(this.CurrentChecklistItem, this.SDV_Set.getFDPanel().getText(), this.SDV_Set.getComPanel().getText(), Vuln.CheckState.fromInt((Integer)this.SDV_Set.getSDV().getCheckToggleGroup().getSelectedToggle().getUserData()));
                    }
                    this.ChecklistDriverParent.setCurrentVuln(currVuln);
                    this.CurrentChecklistItem = currVuln;
                    this.SDV_Set.getFDPanel().setText(currVuln.getCHK_Notes());
                    this.SDV_Set.getComPanel().setText(currVuln.getCheckComment());
                    ((Toggle)this.SDV_Set.getSDV().getCheckToggleGroup().getToggles().get(Vuln.CheckState.toInt(currVuln.getCheckState()))).setSelected(true);
                    this.ChecklistDriverParent.setCurrentVuln(currVuln);
                }
                catch (Exception e) {
                    Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.SEVERE, "SEVERE: CT: Checklist rule display 2 encountered an exception while updating");
                }
            }
            HashMap<String, ArrayList<String>> ft = new HashMap<String, ArrayList<String>>();
            ft.put("General", (ArrayList<String>)this.FilPane.getFilterText("General"));
            ft.put("RuleTitle", (ArrayList<String>)this.FilPane.getFilterText("RuleTitle"));
            ft.put("STIGID", (ArrayList<String>)this.FilPane.getFilterText("STIGID"));
            ft.put("RuleID", (ArrayList<String>)this.FilPane.getFilterText("RuleID"));
            ft.put("VulnID", (ArrayList<String>)this.FilPane.getFilterText("VulnID"));
            ft.put("Severity", (ArrayList<String>)this.FilPane.getFilterText("Severity"));
            this.SDV_Set.clearVulnDisp();
            if (this.SDV_Set.getSDV().updateSTIGInfoTextArea(currVuln, ft)) {
                this.SDV_Set.addPan(0);
            }
            if (this.SDV_Set.getSDV().updateDiscussionTextArea(currVuln, this.FilPane.getFilterText("Discussion"))) {
                this.SDV_Set.addPan(1);
            }
            if (this.SDV_Set.getSDV().updateCheckContentTextArea(currVuln, this.FilPane.getFilterText("CheckContent"))) {
                this.SDV_Set.addPan(2);
            }
            if (this.SDV_Set.getSDV().updateFixTextTextArea(currVuln, this.FilPane.getFilterText("FixText"))) {
                this.SDV_Set.addPan(3);
            }
            if (this.SDV_Set.getSDV().updateCCITextArea(currVuln, this.FilPane.getFilterText("CCIText"), STIG.STIGArrayHasCCI(this.ChecklistDriverParent.getCurrentSTIGs()))) {
                this.SDV_Set.addPan(4);
            }
            if (this.SDV_Set.getSDV().updateMiscTextArea(currVuln, this.FilPane.getFilterText("MiscText"))) {
                this.SDV_Set.addPan(5);
            }
        }
    }

    @Override
    public Stage getPrimaryStage() {
        return this.stigviewer.getPrimaryStage();
    }

    @Override
    public Vuln GetCurrentSelectedVul() {
        return this.ChecklistDriverParent.getCurrentVuln();
    }

    @Override
    public ArrayList<Vuln> GetCurrentSelectedVuls() {
        return this.ChecklistDriverParent.getCurrentVulns();
    }

    @Override
    public FilterPane getFilterPane() {
        return this.FilPane;
    }

    @Override
    public List<DisplayObject> getChildDisplayObjects() {
        ArrayList<DisplayObject> dispOs = new ArrayList<DisplayObject>();
        dispOs.add(this.STIGView);
        dispOs.add(this.VDisplay);
        dispOs.add(this.FilPane);
        dispOs.add(this.myTargetPane);
        dispOs.add(this.RDisplay);
        return dispOs;
    }

    @Override
    public void graphicsUpdate() {
        this.swapRDisplay();
        this.SDV_Set.getFDPanel().setStyle(PrefSet.getPS().getJfxTextAreaStyle());
        this.SDV_Set.getComPanel().setStyle(PrefSet.getPS().getJfxTextAreaStyle());
        this.LeftPane.setStyle(PrefSet.getPS().getJfxBackground());
        this.RightColumnScrollPane.setStyle(PrefSet.getPS().getJfxBackground());
    }

    @Override
    public Iterable<STIG> getCurrentSTIGs() {
        return this.ChecklistDriverParent.getCurrentSTIGs();
    }
}

