/*
 * Decompiled with CFR 0.152.
 */
package File_Operations.File_Objects;

import File_Operations.File_Objects.Vuln;
import Shared_Constructs.ChangeObserver;
import Shared_Constructs.ChangeProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class STIG
implements Serializable,
ChangeProvider,
ChangeObserver {
    private final ArrayList<Vuln> Vuln_List = new ArrayList();
    private String STIG_Title = "";
    private String STIG_Description = "";
    private String STIG_Release_Info = "";
    private String STIG_Version = "";
    private String STIG_source = "";
    private String STIG_notice = "";
    private String STIG_Classification = "";
    private String STIG_FileName = "";
    private String STIG_CustomName = "";
    private String STIG_OverviewDoc = "";
    private String STIG_Score = "0.0";
    private String STIG_BID = "";
    private float releaseID;
    private boolean bHasCCI = false;
    private UUID UniqueID;
    private Map<String, List<String>> STIG_ProfileMap = new HashMap<String, List<String>>();
    private final List<ChangeObserver> changeListeners;

    public STIG() {
        this.UniqueID = UUID.randomUUID();
        this.changeListeners = new ArrayList<ChangeObserver>();
    }

    public void setClass(String Classification) {
        for (int i = 0; i < this.Vuln_List.size(); ++i) {
            this.Vuln_List.get(i).setAttr(Vuln.VulnAttr.Class, Classification);
        }
        this.STIG_Classification = Classification.equals("FOUO") ? "UNCLASSIFIED//FOR OFFICIAL USE ONLY" : "UNCLASSIFIED";
        this.updateListeners();
    }

    public void addVulnObj(Vuln vuln) {
        this.Vuln_List.add(vuln);
        vuln.addChangeListener(this);
        this.updateListeners();
    }

    public void addSTIG_ProfileMap(String prof, List<String> ruleList) {
        this.STIG_ProfileMap.put(prof, ruleList);
        this.updateListeners();
    }

    public void setSTIG_Title(String sTIG_Title) {
        this.STIG_Title = sTIG_Title;
        this.updateListeners();
    }

    public void setSTIG_Description(String sTIG_Description) {
        this.STIG_Description = sTIG_Description;
        this.updateListeners();
    }

    public void setSTIG_Release_Info(String sTIG_Release_Info) {
        this.STIG_Release_Info = sTIG_Release_Info;
        this.updateListeners();
    }

    public void setSTIG_Version(String sTIG_Version) {
        this.STIG_Version = sTIG_Version;
        this.updateListeners();
    }

    public void setSTIG_notice(String sTIG_notice) {
        this.STIG_notice = sTIG_notice;
        this.updateListeners();
    }

    public void setSTIG_source(String sTIG_source) {
        this.STIG_source = sTIG_source;
        this.updateListeners();
    }

    public void setSTIG_Classification(String STIG_Class) {
        this.STIG_Classification = STIG_Class;
        this.updateListeners();
    }

    public void setSTIG_FileName(String sFileName) {
        this.STIG_FileName = sFileName;
        this.updateListeners();
    }

    public void setHasCCI(boolean hasCCI) {
        this.bHasCCI = hasCCI;
        this.updateListeners();
    }

    public void setSTIG_CustomName(String sName) {
        this.STIG_CustomName = sName;
        this.updateListeners();
    }

    public void setSTIG_OverviewDoc(String sOverview) {
        this.STIG_OverviewDoc = sOverview;
        this.updateListeners();
    }

    public void setReleaseID(float rID) {
        this.releaseID = rID;
        this.updateListeners();
    }

    public void setSTIG_BID(String sBID) {
        this.STIG_BID = sBID;
        this.updateListeners();
    }

    public void setSTIG_Score(String score) {
        if (!this.STIG_Score.equals(score)) {
            this.STIG_Score = score;
            this.updateListeners();
        }
    }

    public int getVulnCount() {
        return this.Vuln_List.size();
    }

    public ArrayList<Vuln> getVulnList() {
        return this.Vuln_List;
    }

    public Vuln getVulnByIndex(int index) {
        return this.Vuln_List.get(index);
    }

    public String getSTIGScore() {
        return this.STIG_Score;
    }

    public String getSTIG_Title() {
        return this.STIG_Title;
    }

    public String getSTIG_Version() {
        return this.STIG_Version;
    }

    public String getSTIG_Description() {
        return this.STIG_Description;
    }

    public String getSTIG_Release_Info() {
        return this.STIG_Release_Info;
    }

    public String getSTIG_source() {
        return this.STIG_source;
    }

    public String getSTIG_notice() {
        return this.STIG_notice;
    }

    public String getSTIG_Classification() {
        return this.STIG_Classification;
    }

    public String getSTIG_FileName() {
        return this.STIG_FileName;
    }

    public String getSTIG_CustomName() {
        return this.STIG_CustomName;
    }

    public String getSTIG_OverviewDoc() {
        return this.STIG_OverviewDoc;
    }

    public String getSTIG_BID() {
        return this.STIG_BID;
    }

    public float getReleaseID() {
        return this.releaseID;
    }

    public UUID getSTIG_UUID() {
        return this.UniqueID;
    }

    public Map getSTIG_ProfileMap() {
        return this.STIG_ProfileMap;
    }

    public String getSTIG_PrettyVersion() {
        String version = this.getSTIG_Version();
        if (version.matches("^(\\d+\\.)*\\d+$")) {
            String[] components = version.split("\\.");
            version = "";
            for (String component : components) {
                version = version + component.replaceFirst("^0+", "") + ".";
            }
            version = version.substring(0, version.length() - 1);
        }
        return version;
    }

    public boolean isUsingCMRSVersioning() {
        return this.getSTIG_PrettyVersion().contains(".") && this.getSTIG_PrettyVersion().equals(this.getRelease());
    }

    public String getInterpretedVersion() {
        if (this.isUsingCMRSVersioning()) {
            return this.getSTIG_PrettyVersion().replaceFirst("\\..*", "");
        }
        return this.getSTIG_PrettyVersion();
    }

    public String getRelease() {
        Pattern p = Pattern.compile("^Release: (.*) Benchmark Date:.*$");
        Matcher m = p.matcher(this.getSTIG_Release_Info());
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    public String getInterpretedRelease() {
        if (this.isUsingCMRSVersioning()) {
            return this.getRelease().replaceFirst("^\\d+\\.", "");
        }
        return this.getRelease();
    }

    public String getInterpretedReleaseInfo() {
        if (this.isUsingCMRSVersioning()) {
            return "Release: " + this.getInterpretedRelease() + this.getSTIG_Release_Info().replaceFirst("^Release: [0-9.]+", "");
        }
        return this.getSTIG_Release_Info();
    }

    public String getSTIG_FileName_NoExt() {
        if (this.STIG_FileName != null) {
            int i = this.STIG_FileName.length() - 1;
            boolean bExtFound = false;
            while (!bExtFound && i > 0) {
                if (this.STIG_FileName.charAt(i) == '.') {
                    bExtFound = true;
                    continue;
                }
                --i;
            }
            if (bExtFound) {
                return this.STIG_FileName.substring(0, i);
            }
        }
        return null;
    }

    public boolean getHasCCI() {
        return this.bHasCCI;
    }

    public static boolean STIGArrayHasCCI(ArrayList<STIG> STIGList) {
        boolean bRet = false;
        if (STIGList != null && STIGList.size() > 0) {
            for (STIG s : STIGList) {
                if (!s.getHasCCI()) continue;
                bRet = true;
            }
        }
        return bRet;
    }

    public STIG DeepCopy() {
        STIG s = new STIG();
        for (Vuln v : this.Vuln_List) {
            s.addVulnObj(v.Clean());
        }
        s.STIG_ProfileMap = s.getSTIG_ProfileMap();
        s.setSTIG_Title(this.STIG_Title);
        s.setSTIG_Description(this.STIG_Description);
        s.setSTIG_Release_Info(this.STIG_Release_Info);
        s.setSTIG_Version(this.STIG_Version);
        s.setSTIG_source(this.STIG_source);
        s.setSTIG_notice(this.STIG_notice);
        s.setSTIG_Classification(this.STIG_Classification);
        s.setSTIG_FileName(this.STIG_FileName);
        s.setSTIG_CustomName(this.STIG_CustomName);
        s.setSTIG_OverviewDoc(this.STIG_OverviewDoc);
        s.setSTIG_BID(this.STIG_BID);
        s.setHasCCI(this.bHasCCI);
        return s;
    }

    public void setUUID(UUID uuid) {
        this.UniqueID = uuid;
        this.updateListeners();
    }

    @Override
    public void addChangeListener(ChangeObserver listener) {
        this.changeListeners.add(listener);
    }

    @Override
    public void removeChangeListener(ChangeObserver listener) {
        this.changeListeners.remove(listener);
    }

    protected void updateListeners() {
        this.changeListeners.forEach(listener -> listener.update());
    }

    @Override
    public void update() {
        this.updateListeners();
    }
}

