# ----------------------------------------------------------------------
# SSLCAUDIT - a tool for automating security audit of SSL clients
# Released under terms of GPLv3, see COPYING.TXT
# Copyright (C) 2012 Alexandre Bezroutchko abb@gremwell.com
# ----------------------------------------------------------------------
SUITES = {
            "sslv2": (
                        'DES-CBC-MD5',
                        'DES-CBC3-MD5',
                        'EXP-RC2-CBC-MD5',
                        'EXP-RC4-MD5'
                        'IDEA-CBC-MD5',
                        'RC2-CBC-MD5',
                        'RC4-MD5'
                     ),

            "sslv3": (
                        "AES128-GCM-SHA256",
                        "AES128-SHA",
                        "AES128-SHA256",
                        "AES256-GCM-SHA384",
                        "AES256-SHA",
                        "AES256-SHA256",
                        "CAMELLIA128-SHA",
                        "CAMELLIA256-SHA",
                        "DES-CBC-SHA",
                        "DES-CBC3-SHA",
                        "DHE-DSS-AES128-GCM-SHA256",
                        "DHE-DSS-AES128-SHA",
                        "DHE-DSS-AES128-SHA256",
                        "DHE-DSS-AES256-GCM-SHA384",
                        "DHE-DSS-AES256-SHA",
                        "DHE-DSS-AES256-SHA256",
                        "DHE-DSS-CAMELLIA128-SHA",
                        "DHE-DSS-CAMELLIA256-SHA",
                        "DHE-DSS-SEED-SHA",
                        "DHE-RSA-AES128-GCM-SHA256",
                        "DHE-RSA-AES128-SHA",
                        "DHE-RSA-AES128-SHA256",
                        "DHE-RSA-AES256-GCM-SHA384",
                        "DHE-RSA-AES256-SHA",
                        "DHE-RSA-AES256-SHA256",
                        "DHE-RSA-CAMELLIA128-SHA",
                        "DHE-RSA-CAMELLIA256-SHA",
                        "DHE-RSA-SEED-SHA",
                        "ECDH-ECDSA-AES128-GCM-SHA256",
                        "ECDH-ECDSA-AES128-SHA",
                        "ECDH-ECDSA-AES128-SHA256",
                        "ECDH-ECDSA-AES256-GCM-SHA384",
                        "ECDH-ECDSA-AES256-SHA",
                        "ECDH-ECDSA-AES256-SHA384",
                        "ECDH-ECDSA-DES-CBC3-SHA",
                        "ECDH-ECDSA-RC4-SHA",
                        "ECDH-RSA-AES128-GCM-SHA256",
                        "ECDH-RSA-AES128-SHA",
                        "ECDH-RSA-AES128-SHA256",
                        "ECDH-RSA-AES256-GCM-SHA384",
                        "ECDH-RSA-AES256-SHA",
                        "ECDH-RSA-AES256-SHA384",
                        "ECDH-RSA-DES-CBC3-SHA",
                        "ECDH-RSA-RC4-SHA",
                        "ECDHE-ECDSA-AES128-GCM-SHA256",
                        "ECDHE-ECDSA-AES128-SHA",
                        "ECDHE-ECDSA-AES128-SHA256",
                        "ECDHE-ECDSA-AES256-GCM-SHA384",
                        "ECDHE-ECDSA-AES256-SHA",
                        "ECDHE-ECDSA-AES256-SHA384",
                        "ECDHE-ECDSA-DES-CBC3-SHA",
                        "ECDHE-ECDSA-RC4-SHA",
                        "ECDHE-RSA-AES128-GCM-SHA256",
                        "ECDHE-RSA-AES128-SHA",
                        "ECDHE-RSA-AES128-SHA256",
                        "ECDHE-RSA-AES256-GCM-SHA384",
                        "ECDHE-RSA-AES256-SHA",
                        "ECDHE-RSA-AES256-SHA384",
                        "ECDHE-RSA-DES-CBC3-SHA",
                        "ECDHE-RSA-RC4-SHA",
                        "EDH-DSS-DES-CBC-SHA",
                        "EDH-DSS-DES-CBC3-SHA",
                        "EDH-RSA-DES-CBC-SHA",
                        "EDH-RSA-DES-CBC3-SHA",
                        "EXP-DES-CBC-SHA",
                        "EXP-EDH-DSS-DES-CBC-SHA",
                        "EXP-EDH-RSA-DES-CBC-SHA",
                        "EXP-RC2-CBC-MD5",
                        "EXP-RC4-MD5",
                        "PSK-3DES-EDE-CBC-SHA",
                        "PSK-AES128-CBC-SHA",
                        "PSK-AES256-CBC-SHA",
                        "PSK-RC4-SHA",
                        "RC4-MD5",
                        "RC4-SHA",
                        "SEED-SHA",
                        "SRP-DSS-3DES-EDE-CBC-SHA",
                        "SRP-DSS-AES-128-CBC-SHA",
                        "SRP-DSS-AES-256-CBC-SHA",
                        "SRP-RSA-3DES-EDE-CBC-SHA",
                        "SRP-RSA-AES-128-CBC-SHA",
                        "SRP-RSA-AES-256-CBC-SHA"
                     ),

            "tlsv1": (
                        "AES128-GCM-SHA256",
                        "AES128-SHA",
                        "AES128-SHA256",
                        "AES256-GCM-SHA384",
                        "AES256-SHA",
                        "AES256-SHA256",
                        "CAMELLIA128-SHA",
                        "CAMELLIA256-SHA",
                        "DES-CBC-SHA",
                        "DES-CBC3-SHA",
                        "DHE-DSS-AES128-GCM-SHA256",
                        "DHE-DSS-AES128-SHA",
                        "DHE-DSS-AES128-SHA256",
                        "DHE-DSS-AES256-GCM-SHA384",
                        "DHE-DSS-AES256-SHA",
                        "DHE-DSS-AES256-SHA256",
                        "DHE-DSS-CAMELLIA128-SHA",
                        "DHE-DSS-CAMELLIA256-SHA",
                        "DHE-DSS-SEED-SHA",
                        "DHE-RSA-AES128-GCM-SHA256",
                        "DHE-RSA-AES128-SHA",
                        "DHE-RSA-AES128-SHA256",
                        "DHE-RSA-AES256-GCM-SHA384",
                        "DHE-RSA-AES256-SHA",
                        "DHE-RSA-AES256-SHA256",
                        "DHE-RSA-CAMELLIA128-SHA",
                        "DHE-RSA-CAMELLIA256-SHA",
                        "DHE-RSA-SEED-SHA",
                        "ECDH-ECDSA-AES128-GCM-SHA256",
                        "ECDH-ECDSA-AES128-SHA",
                        "ECDH-ECDSA-AES128-SHA256",
                        "ECDH-ECDSA-AES256-GCM-SHA384",
                        "ECDH-ECDSA-AES256-SHA",
                        "ECDH-ECDSA-AES256-SHA384",
                        "ECDH-ECDSA-DES-CBC3-SHA",
                        "ECDH-ECDSA-RC4-SHA",
                        "ECDH-RSA-AES128-GCM-SHA256",
                        "ECDH-RSA-AES128-SHA",
                        "ECDH-RSA-AES128-SHA256",
                        "ECDH-RSA-AES256-GCM-SHA384",
                        "ECDH-RSA-AES256-SHA",
                        "ECDH-RSA-AES256-SHA384",
                        "ECDH-RSA-DES-CBC3-SHA",
                        "ECDH-RSA-RC4-SHA",
                        "ECDHE-ECDSA-AES128-GCM-SHA256",
                        "ECDHE-ECDSA-AES128-SHA",
                        "ECDHE-ECDSA-AES128-SHA256",
                        "ECDHE-ECDSA-AES256-GCM-SHA384",
                        "ECDHE-ECDSA-AES256-SHA",
                        "ECDHE-ECDSA-AES256-SHA384",
                        "ECDHE-ECDSA-DES-CBC3-SHA",
                        "ECDHE-ECDSA-RC4-SHA",
                        "ECDHE-RSA-AES128-GCM-SHA256",
                        "ECDHE-RSA-AES128-SHA",
                        "ECDHE-RSA-AES128-SHA256",
                        "ECDHE-RSA-AES256-GCM-SHA384",
                        "ECDHE-RSA-AES256-SHA",
                        "ECDHE-RSA-AES256-SHA384",
                        "ECDHE-RSA-DES-CBC3-SHA",
                        "ECDHE-RSA-RC4-SHA",
                        "EDH-DSS-DES-CBC-SHA",
                        "EDH-DSS-DES-CBC3-SHA",
                        "EDH-RSA-DES-CBC-SHA",
                        "EDH-RSA-DES-CBC3-SHA",
                        "EXP-DES-CBC-SHA",
                        "EXP-EDH-DSS-DES-CBC-SHA",
                        "EXP-EDH-RSA-DES-CBC-SHA",
                        "EXP-RC2-CBC-MD5",
                        "EXP-RC4-MD5",
                        "PSK-3DES-EDE-CBC-SHA",
                        "PSK-AES128-CBC-SHA",
                        "PSK-AES256-CBC-SHA",
                        "PSK-RC4-SHA",
                        "RC4-MD5",
                        "RC4-SHA",
                        "SEED-SHA",
                        "SRP-DSS-3DES-EDE-CBC-SHA",
                        "SRP-DSS-AES-128-CBC-SHA",
                        "SRP-DSS-AES-256-CBC-SHA",
                        "SRP-RSA-3DES-EDE-CBC-SHA",
                        "SRP-RSA-AES-128-CBC-SHA",
                        "SRP-RSA-AES-256-CBC-SHA"
                    )
}