/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationWithSourceLines;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFinder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.CheckForNull;

public class CopyBuggySource {
    private static final String USAGE = "Usage: <cmd>   <bugs.xml> <destinationSrc>";
    SortedBugCollection origCollection;
    File src;
    SrcKind kind;
    ZipOutputStream zOut;
    byte[] buf = new byte[4096];
    Project project;
    SourceFinder sourceFinder;
    HashSet<String> copied = new HashSet();
    HashSet<String> couldNotFind = new HashSet();
    HashSet<String> couldNotCreate = new HashSet();
    int copyCount = 0;
    File dstFile;

    public static void main(String[] args) throws Exception {
        FindBugs.setNoAnalysis();
        DetectorFactoryCollection.instance();
        if (args.length != 2) {
            System.out.println(USAGE);
            return;
        }
        new CopyBuggySource(args).execute();
    }

    public CopyBuggySource(String[] args) throws Exception {
        this.origCollection = new SortedBugCollection();
        this.origCollection.readXML(args[0]);
        this.project = this.origCollection.getProject();
        this.sourceFinder = new SourceFinder(this.project);
        this.src = new File(args[1]);
        this.kind = SrcKind.get(this.src);
        switch (this.kind) {
            case DIR: {
                break;
            }
            case ZIP: {
                this.zOut = new ZipOutputStream(new FileOutputStream(this.src));
                break;
            }
            case Z0P_GZ: {
                this.zOut = new ZipOutputStream(new DeflaterOutputStream(new FileOutputStream(this.src)));
                this.zOut.setLevel(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void copySourceFile(String fullName, SourceFile sourceFile) {
        long lastModified;
        OutputStream out;
        InputStream in;
        block7: {
            in = null;
            out = null;
            lastModified = sourceFile.getLastModified();
            in = sourceFile.getInputStream();
            out = this.getOutputStream(fullName, 0L);
            if (out != null) break block7;
            CopyBuggySource.close(in);
            CopyBuggySource.close(out);
            return;
        }
        try {
            int sz;
            while ((sz = in.read(this.buf)) >= 0) {
                out.write(this.buf, 0, sz);
            }
            if (this.dstFile != null) {
                this.dstFile.setLastModified(lastModified);
            }
            System.out.println("Copied " + fullName);
            ++this.copyCount;
        }
        catch (IOException e) {
            block8: {
                try {
                    if (!this.couldNotFind.add(fullName)) break block8;
                    System.out.println("Problem copying " + fullName);
                    e.printStackTrace(System.out);
                }
                catch (Throwable throwable) {
                    CopyBuggySource.close(in);
                    CopyBuggySource.close(out);
                    throw throwable;
                }
            }
            CopyBuggySource.close(in);
            CopyBuggySource.close(out);
        }
        CopyBuggySource.close(in);
        CopyBuggySource.close(out);
    }

    private void copySourceForAnnotation(BugAnnotation ann) {
        SourceFile sourceFile;
        SourceLineAnnotation sourceAnnotation;
        if (ann instanceof BugAnnotationWithSourceLines) {
            sourceAnnotation = ((BugAnnotationWithSourceLines)ann).getSourceLines();
        } else if (ann instanceof SourceLineAnnotation) {
            sourceAnnotation = (SourceLineAnnotation)ann;
        } else {
            return;
        }
        if (sourceAnnotation == null) {
            return;
        }
        if (sourceAnnotation.isUnknown()) {
            return;
        }
        String fullName = SourceFinder.getPlatformName(sourceAnnotation);
        try {
            sourceFile = this.sourceFinder.findSourceFile(sourceAnnotation);
        }
        catch (IOException e) {
            if (this.couldNotFind.add(fullName)) {
                System.out.println("Did not find " + fullName);
            }
            return;
        }
        if (this.copied.add(fullName)) {
            this.copySourceFile(fullName, sourceFile);
        }
    }

    public void execute() throws IOException {
        for (BugInstance bug : this.origCollection.getCollection()) {
            Iterator<BugAnnotation> i = bug.annotationIterator();
            while (i.hasNext()) {
                this.copySourceForAnnotation(i.next());
            }
        }
        if (this.zOut != null) {
            this.zOut.close();
        }
        System.out.printf("All done. %d files not found, %d files copied%n", this.couldNotFind.size(), this.copyCount);
    }

    @CheckForNull
    private OutputStream getOutputStream(String fullName, long lastModifiedTime) throws IOException {
        if (this.kind == SrcKind.DIR) {
            this.dstFile = new File(this.src, fullName);
            if (this.dstFile.exists()) {
                System.out.println(String.valueOf(this.dstFile) + " already exists");
                return null;
            }
            File parent = this.dstFile.getParentFile();
            Object out = null;
            if (!parent.mkdirs() && !parent.isDirectory()) {
                String path = parent.getPath();
                if (this.couldNotCreate.add(path)) {
                    System.out.println("Can't create directory for " + path);
                }
                return null;
            }
            return new FileOutputStream(this.dstFile);
        }
        ZipEntry e = new ZipEntry(fullName);
        e.setTime(lastModifiedTime);
        this.zOut.putNextEntry(e);
        return this.zOut;
    }

    public static void close(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(OutputStream out) {
        try {
            if (out instanceof ZipOutputStream) {
                ((ZipOutputStream)out).closeEntry();
            } else if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static enum SrcKind {
        DIR,
        ZIP,
        Z0P_GZ;


        static SrcKind get(File f) {
            if (f.exists() && f.isDirectory() && f.canWrite()) {
                return DIR;
            }
            if (!f.exists()) {
                if (f.getName().endsWith(".zip")) {
                    return ZIP;
                }
                if (f.getName().endsWith(".z0p.gz")) {
                    return Z0P_GZ;
                }
            }
            throw new IllegalArgumentException("Invalid src destination: " + String.valueOf(f));
        }
    }
}

