/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.NestHost;
import org.apache.bcel.classfile.NestMembers;

public class NestedAccessUtil {
    private static final int JAVA_11_CLASS_VERSION = 55;

    public static boolean hasNest(JavaClass javaClass) {
        if (NestedAccessUtil.supportsNestedAccess(javaClass)) {
            Attribute[] attributes;
            for (Attribute attribute : attributes = javaClass.getAttributes()) {
                if (!(attribute instanceof NestHost) && !(attribute instanceof NestMembers)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean supportsNestedAccess(JavaClass javaClass) {
        return NestedAccessUtil.hasJava11OrAboveClassVersion(javaClass);
    }

    public static List<String> getNestMateClassNames(JavaClass javaClass, AnalysisContext analysisContext) throws ClassNotFoundException {
        ArrayList<String> nestMateClassNames = new ArrayList<String>();
        String nestHostClassName = NestedAccessUtil.getHostClassName(javaClass);
        if (nestHostClassName != null) {
            JavaClass nestedHostClass = analysisContext.lookupClass(nestHostClassName);
            String[] nestMemberClassNames = NestedAccessUtil.getNestMemberClassNames(nestedHostClass);
            if (nestMemberClassNames != null) {
                nestMateClassNames.addAll(Arrays.asList(nestMemberClassNames));
                nestMateClassNames.add(nestHostClassName);
            }
        } else {
            String[] nestMemberClassNames = NestedAccessUtil.getNestMemberClassNames(javaClass);
            if (nestMemberClassNames != null) {
                nestMateClassNames.addAll(Arrays.asList(nestMemberClassNames));
                String className = javaClass.getClassName();
                nestMateClassNames.add(className);
            }
        }
        return nestMateClassNames;
    }

    private static boolean hasJava11OrAboveClassVersion(JavaClass ... javaClasses) {
        for (JavaClass javaClass : javaClasses) {
            int javaClassVersion = javaClass.getMajor();
            if (javaClassVersion >= 55) continue;
            return false;
        }
        return true;
    }

    @CheckForNull
    private static String[] getNestMemberClassNames(JavaClass javaClass) {
        Attribute[] sourceAttributes;
        for (Attribute sourceAttribute : sourceAttributes = javaClass.getAttributes()) {
            if (!(sourceAttribute instanceof NestMembers)) continue;
            NestMembers nestMembersAttribute = (NestMembers)sourceAttribute;
            return nestMembersAttribute.getClassNames();
        }
        return null;
    }

    @CheckForNull
    private static String getHostDottedClassName(JavaClass javaClass) {
        String hostClassName = NestedAccessUtil.getHostClassName(javaClass);
        if (hostClassName != null) {
            return ClassName.toDottedClassName(hostClassName);
        }
        return null;
    }

    @CheckForNull
    private static String getHostClassName(JavaClass javaClass) {
        Attribute[] attributes;
        for (Attribute attribute : attributes = javaClass.getAttributes()) {
            if (!(attribute instanceof NestHost)) continue;
            NestHost nestHostAttribute = (NestHost)attribute;
            int targetHostClassIndex = nestHostAttribute.getHostClassIndex();
            ConstantPool constantPool = nestHostAttribute.getConstantPool();
            return constantPool.getConstantString(targetHostClassIndex, (byte)7);
        }
        return null;
    }

    public static List<JavaClass> getHostClasses(JavaClass javaClass) throws ClassNotFoundException {
        String hostClassName;
        ArrayList<JavaClass> list = new ArrayList<JavaClass>();
        if (javaClass != null && (hostClassName = NestedAccessUtil.getHostClassName(javaClass)) != null) {
            JavaClass hostClass = Repository.lookupClass((String)hostClassName);
            list.add(hostClass);
            list.addAll(NestedAccessUtil.getHostClasses(hostClass));
        }
        return list;
    }
}

