/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sarif;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.sarif.Level;
import java.util.UUID;

public class Taxon
implements Comparable<Taxon> {
    private final String id;
    private final UUID guid;
    private final String shortDescription;
    private final String fullDescription;
    private final Level severityLevel;

    private Taxon(@NonNull String id, @NonNull UUID guid, @NonNull String shortDescription, @NonNull String fullDescription, @NonNull Level severityLevel) {
        this.id = id;
        this.guid = guid;
        this.shortDescription = shortDescription;
        this.fullDescription = fullDescription;
        this.severityLevel = severityLevel;
    }

    public static Taxon from(@NonNull String id, @NonNull UUID guid, @NonNull String shortDescription, @NonNull String fullDescription, @NonNull Level severityLevel) {
        return new Taxon(id, guid, shortDescription, fullDescription, severityLevel);
    }

    JsonObject toJsonObject() {
        JsonObject taxonJson = new JsonObject();
        JsonObject shortDescriptionJson = new JsonObject();
        shortDescriptionJson.addProperty("text", this.shortDescription);
        JsonObject fullDescriptionJson = new JsonObject();
        fullDescriptionJson.addProperty("text", this.fullDescription);
        JsonObject defaultConfigurationJson = new JsonObject();
        defaultConfigurationJson.addProperty("level", this.severityLevel.toJsonString());
        taxonJson.addProperty("id", this.id);
        taxonJson.addProperty("guid", this.guid.toString());
        taxonJson.add("shortDescription", (JsonElement)shortDescriptionJson);
        taxonJson.add("fullDescription", (JsonElement)fullDescriptionJson);
        taxonJson.add("defaultConfiguration", (JsonElement)defaultConfigurationJson);
        return taxonJson;
    }

    @Override
    public int compareTo(Taxon other) {
        return this.id.compareTo(other.id);
    }
}

