/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sarif;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.sarif.Notification;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

class Invocation {
    private final int exitCode;
    @NonNull
    private final String exitCodeDescription;
    private final boolean executionSuccessful;
    @NonNull
    private final List<Notification> toolExecutionNotifications;
    @NonNull
    private final List<Notification> toolConfigurationNotifications;

    Invocation(int exitCode, @NonNull String exitCodeDescription, boolean executionSuccessful, @NonNull List<Notification> toolExecutionNotifications, @NonNull List<Notification> toolConfigurationNotifications) {
        this.exitCode = exitCode;
        this.exitCodeDescription = Objects.requireNonNull(exitCodeDescription);
        this.executionSuccessful = executionSuccessful;
        this.toolExecutionNotifications = Collections.unmodifiableList(toolExecutionNotifications);
        this.toolConfigurationNotifications = Collections.unmodifiableList(toolConfigurationNotifications);
    }

    @NonNull
    JsonObject toJsonObject() {
        JsonObject result = new JsonObject();
        result.addProperty("exitCode", (Number)this.exitCode);
        result.addProperty("exitCodeDescription", this.exitCodeDescription);
        result.addProperty("executionSuccessful", Boolean.valueOf(this.executionSuccessful));
        JsonArray execNotificationArray = new JsonArray();
        this.toolExecutionNotifications.stream().map(Notification::toJsonObject).forEach(arg_0 -> ((JsonArray)execNotificationArray).add(arg_0));
        if (execNotificationArray.size() > 0) {
            result.add("toolExecutionNotifications", (JsonElement)execNotificationArray);
        }
        JsonArray configNotificationArray = new JsonArray();
        this.toolConfigurationNotifications.stream().map(Notification::toJsonObject).forEach(arg_0 -> ((JsonArray)configNotificationArray).add(arg_0));
        if (configNotificationArray.size() > 0) {
            result.add("toolConfigurationNotifications", (JsonElement)configNotificationArray);
        }
        return result;
    }
}

