/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plan;

import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryChooser;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.graph.DepthFirstSearch;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.plan.AnalysisPass;
import edu.umd.cs.findbugs.plan.ConstraintEdge;
import edu.umd.cs.findbugs.plan.ConstraintGraph;
import edu.umd.cs.findbugs.plan.DetectorFactorySelector;
import edu.umd.cs.findbugs.plan.DetectorNode;
import edu.umd.cs.findbugs.plan.DetectorOrderingConstraint;
import edu.umd.cs.findbugs.plan.OrderingConstraintException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExecutionPlan {
    public static final boolean DEBUG = SystemProperties.getBoolean("findbugs.execplan.debug");
    private List<Plugin> pluginList = new LinkedList<Plugin>();
    private DetectorFactoryChooser factoryChooser = new DetectorFactoryChooser(){

        @Override
        public boolean choose(DetectorFactory factory) {
            return true;
        }

        @Override
        public void enable(DetectorFactory factory) {
        }
    };
    private LinkedList<AnalysisPass> passList = new LinkedList();
    private Map<String, DetectorFactory> factoryMap = new HashMap<String, DetectorFactory>();
    private List<DetectorOrderingConstraint> interPassConstraintList = new LinkedList<DetectorOrderingConstraint>();
    private List<DetectorOrderingConstraint> intraPassConstraintList = new LinkedList<DetectorOrderingConstraint>();
    private Set<DetectorFactory> assignedToPassSet = new HashSet<DetectorFactory>();

    public void dispose() {
        this.pluginList.clear();
        this.factoryChooser = null;
        this.passList.clear();
        this.factoryMap.clear();
        this.interPassConstraintList.clear();
        this.intraPassConstraintList.clear();
        this.assignedToPassSet.clear();
    }

    public void setDetectorFactoryChooser(DetectorFactoryChooser factoryChooser) {
        this.factoryChooser = factoryChooser;
    }

    public boolean isActive(@DottedClassName String detectorClass) {
        return this.factoryMap.containsKey(detectorClass);
    }

    public boolean isActive(Class<? extends Detector> detectorClass) {
        return this.isActive(detectorClass.getName());
    }

    public void addPlugin(Plugin plugin) throws OrderingConstraintException {
        if (DEBUG) {
            System.out.println("Adding plugin " + plugin.getPluginId() + " to execution plan");
        }
        this.pluginList.add(plugin);
        ExecutionPlan.copyTo(plugin.interPassConstraintIterator(), this.interPassConstraintList);
        ExecutionPlan.copyTo(plugin.intraPassConstraintIterator(), this.intraPassConstraintList);
        for (DetectorFactory factory : plugin.getDetectorFactories()) {
            if (DEBUG) {
                System.out.println("  Detector factory " + factory.getShortName());
            }
            if (this.factoryMap.put(factory.getFullName(), factory) == null) continue;
            throw new OrderingConstraintException("Detector " + factory.getFullName() + " is defined by more than one plugin");
        }
    }

    public void build() throws OrderingConstraintException {
        boolean change;
        for (DetectorFactory detectorFactory : this.factoryMap.values()) {
            detectorFactory.setEnabledButNonReporting(false);
        }
        ArrayList<DetectorOrderingConstraint> allConstraints = new ArrayList<DetectorOrderingConstraint>(this.interPassConstraintList.size() + this.intraPassConstraintList.size());
        allConstraints.addAll(this.interPassConstraintList);
        allConstraints.addAll(this.intraPassConstraintList);
        HashMap<String, DetectorNode> nodeMapAll = new HashMap<String, DetectorNode>();
        ConstraintGraph allPassConstraintGraph = this.buildConstraintGraph(nodeMapAll, new HashSet<DetectorFactory>(this.factoryMap.values()), allConstraints);
        do {
            change = false;
            Iterator i = allPassConstraintGraph.vertexIterator();
            while (i.hasNext()) {
                DetectorNode end = (DetectorNode)i.next();
                if (!this.factoryChooser.choose(end.getFactory())) continue;
                Iterator<Object> j = allPassConstraintGraph.incomingEdgeIterator(end);
                while (j.hasNext()) {
                    ConstraintEdge edge = (ConstraintEdge)j.next();
                    DetectorNode start = (DetectorNode)edge.getSource();
                    DetectorFactory startFactory = start.getFactory();
                    if (this.factoryChooser.choose(startFactory) || !edge.isSingleSource()) continue;
                    this.factoryChooser.enable(startFactory);
                    change = true;
                    if (!DEBUG && !FindBugs2.DEBUG) continue;
                    System.out.println("Dependences force enabling of " + startFactory.getFullName());
                }
            }
        } while (change);
        this.factoryMap.entrySet().removeIf(e -> !this.factoryChooser.choose((DetectorFactory)e.getValue()));
        HashMap<String, DetectorNode> nodeMap = new HashMap<String, DetectorNode>();
        ConstraintGraph interPassConstraintGraph = this.buildConstraintGraph(nodeMap, new HashSet<DetectorFactory>(this.factoryMap.values()), this.interPassConstraintList);
        if (DEBUG) {
            System.out.println(interPassConstraintGraph.getNumVertices() + " nodes in inter-pass constraint graph");
        }
        this.buildPassList(interPassConstraintGraph);
        for (AnalysisPass pass : this.passList) {
            this.sortPass(this.intraPassConstraintList, this.factoryMap, pass);
        }
        if (this.factoryMap.size() > this.assignedToPassSet.size()) {
            AnalysisPass lastPass;
            if (this.passList.isEmpty()) {
                lastPass = new AnalysisPass();
                this.addPass(lastPass);
            } else {
                lastPass = this.passList.getLast();
            }
            Set<DetectorFactory> unassignedSet = this.getUnassignedSet();
            for (DetectorFactory factory : unassignedSet) {
                this.assignToPass(factory, lastPass);
            }
            this.appendDetectorsToPass(unassignedSet, lastPass);
        }
        if (DEBUG) {
            this.print();
        }
    }

    public Iterator<AnalysisPass> passIterator() {
        return this.passList.iterator();
    }

    public int getNumPasses() {
        return this.passList.size();
    }

    private static <T> void copyTo(Iterator<T> iter, Collection<T> dest) {
        while (iter.hasNext()) {
            dest.add(iter.next());
        }
    }

    private ConstraintGraph buildConstraintGraph(Map<String, DetectorNode> nodeMap, Set<DetectorFactory> factorySet, List<DetectorOrderingConstraint> constraintList) {
        ConstraintGraph result = new ConstraintGraph();
        for (DetectorOrderingConstraint constraint : constraintList) {
            Set<DetectorNode> earlierSet = this.addOrCreateDetectorNodes(constraint.getEarlier(), nodeMap, factorySet, result);
            Set<DetectorNode> laterSet = this.addOrCreateDetectorNodes(constraint.getLater(), nodeMap, factorySet, result);
            this.createConstraintEdges(result, earlierSet, laterSet, constraint);
        }
        return result;
    }

    private Set<DetectorFactory> selectDetectors(DetectorFactorySelector selector, Set<DetectorFactory> candidateSet) {
        HashSet<DetectorFactory> result = new HashSet<DetectorFactory>();
        for (DetectorFactory factory : candidateSet) {
            if (!selector.selectFactory(factory)) continue;
            result.add(factory);
        }
        return result;
    }

    private Set<DetectorNode> addOrCreateDetectorNodes(DetectorFactorySelector selector, Map<String, DetectorNode> nodeMap, Set<DetectorFactory> factorySet, ConstraintGraph constraintGraph) {
        HashSet<DetectorNode> result = new HashSet<DetectorNode>();
        Set<DetectorFactory> chosenSet = this.selectDetectors(selector, factorySet);
        for (DetectorFactory factory : chosenSet) {
            DetectorNode node = this.addOrCreateDetectorNode(factory, nodeMap, constraintGraph);
            result.add(node);
        }
        return result;
    }

    private DetectorNode addOrCreateDetectorNode(DetectorFactory factory, Map<String, DetectorNode> nodeMap, ConstraintGraph constraintGraph) {
        DetectorNode node = nodeMap.get(factory.getFullName());
        if (node == null) {
            node = new DetectorNode(factory);
            nodeMap.put(factory.getFullName(), node);
            constraintGraph.addVertex(node);
        }
        return node;
    }

    private void createConstraintEdges(ConstraintGraph result, Set<DetectorNode> earlierSet, Set<DetectorNode> laterSet, DetectorOrderingConstraint constraint) {
        if (earlierSet.isEmpty() || laterSet.isEmpty()) {
            return;
        }
        for (DetectorNode earlier : earlierSet) {
            for (DetectorNode later : laterSet) {
                ConstraintEdge edge = (ConstraintEdge)result.createEdge(earlier, later);
                edge.setConstraint(constraint);
            }
        }
    }

    private void buildPassList(ConstraintGraph constraintGraph) throws OrderingConstraintException {
        int passCount = 0;
        while (constraintGraph.getNumVertices() > 0) {
            LinkedList<DetectorNode> inDegreeZeroList = new LinkedList<DetectorNode>();
            Iterator<Object> i = constraintGraph.vertexIterator();
            while (i.hasNext()) {
                DetectorNode node = (DetectorNode)i.next();
                if (constraintGraph.getNumIncomingEdges(node) == 0) {
                    inDegreeZeroList.add(node);
                    continue;
                }
                if (!DEBUG) continue;
                System.out.println("Can't schedule " + node.getFactory().getShortName());
                Iterator incomingEdgeIterator = constraintGraph.incomingEdgeIterator(node);
                while (incomingEdgeIterator.hasNext()) {
                    ConstraintEdge edge = (ConstraintEdge)incomingEdgeIterator.next();
                    System.out.println("  requires " + ((DetectorNode)edge.getSource()).getFactory().getShortName());
                }
            }
            if (inDegreeZeroList.isEmpty()) {
                throw new OrderingConstraintException("Cycle in inter-pass ordering constraints");
            }
            for (DetectorNode node : inDegreeZeroList) {
                constraintGraph.removeVertex(node);
            }
            AnalysisPass pass = new AnalysisPass();
            this.addPass(pass);
            ++passCount;
            for (DetectorNode node : inDegreeZeroList) {
                this.assignToPass(node.getFactory(), pass);
            }
        }
    }

    private void addPass(AnalysisPass pass) {
        if (DEBUG) {
            System.out.println("Adding pass " + this.passList.size());
        }
        this.passList.add(pass);
    }

    private void sortPass(List<DetectorOrderingConstraint> constraintList, Map<String, DetectorFactory> factoryMap, AnalysisPass pass) throws OrderingConstraintException {
        HashSet<DetectorFactory> detectorSet = new HashSet<DetectorFactory>(pass.getMembers());
        if (DEBUG) {
            System.out.println(detectorSet.size() + " detectors currently in this pass");
        }
        LinkedList<DetectorOrderingConstraint> passConstraintList = new LinkedList<DetectorOrderingConstraint>();
        for (DetectorOrderingConstraint constraint : constraintList) {
            if (this.selectDetectors(constraint.getEarlier(), detectorSet).isEmpty() && this.selectDetectors(constraint.getLater(), detectorSet).isEmpty()) continue;
            passConstraintList.add(constraint);
        }
        if (DEBUG) {
            System.out.println(passConstraintList.size() + " constraints are applicable for this pass");
        }
        HashSet<DetectorFactory> availableSet = new HashSet<DetectorFactory>();
        availableSet.addAll(detectorSet);
        availableSet.addAll(this.getUnassignedSet());
        HashMap<String, DetectorNode> nodeMap = new HashMap<String, DetectorNode>();
        ConstraintGraph constraintGraph = this.buildConstraintGraph(nodeMap, availableSet, passConstraintList);
        if (DEBUG) {
            System.out.println("Pass constraint graph:");
            this.dumpGraph(constraintGraph);
        }
        for (DetectorNode node : nodeMap.values()) {
            if (pass.contains(node.getFactory())) continue;
            this.assignToPass(node.getFactory(), pass);
        }
        DepthFirstSearch dfs = new DepthFirstSearch(constraintGraph);
        dfs.search();
        if (dfs.containsCycle()) {
            throw new OrderingConstraintException("Cycle in intra-pass ordering constraints!");
        }
        Iterator i = dfs.topologicalSortIterator();
        while (i.hasNext()) {
            DetectorNode node = (DetectorNode)i.next();
            this.appendToPass(node.getFactory(), pass);
        }
        this.appendDetectorsToPass(pass.getUnpositionedMembers(), pass);
    }

    private Set<DetectorFactory> getUnassignedSet() {
        HashSet<DetectorFactory> unassignedSet = new HashSet<DetectorFactory>(this.factoryMap.values());
        unassignedSet.removeAll(this.assignedToPassSet);
        return unassignedSet;
    }

    private void assignToPass(DetectorFactory factory, AnalysisPass pass) {
        pass.addToPass(factory);
        this.assignedToPassSet.add(factory);
    }

    private void appendToPass(DetectorFactory factory, AnalysisPass pass) {
        pass.append(factory);
    }

    private void appendDetectorsToPass(Collection<DetectorFactory> detectorSet, AnalysisPass pass) {
        DetectorFactory[] unassignedList = detectorSet.toArray(new DetectorFactory[0]);
        Arrays.sort(unassignedList, (a, b) -> {
            int cmp = a.getPlugin().getPluginId().compareTo(b.getPlugin().getPluginId());
            if (cmp != 0) {
                return cmp;
            }
            return a.getPositionSpecifiedInPluginDescriptor() - b.getPositionSpecifiedInPluginDescriptor();
        });
        for (DetectorFactory factory : unassignedList) {
            this.appendToPass(factory, pass);
        }
    }

    private void print() {
        System.out.println("\nExecution plan:");
        int passCount = 0;
        Iterator i = this.passList.iterator();
        while (i.hasNext()) {
            System.out.println("Pass " + passCount);
            AnalysisPass pass = (AnalysisPass)i.next();
            Iterator<DetectorFactory> j = pass.iterator();
            while (j.hasNext()) {
                DetectorFactory factory = j.next();
                System.out.println("  " + factory.getShortName());
            }
            ++passCount;
        }
        System.out.println();
    }

    private void dumpGraph(ConstraintGraph graph) {
        Iterator i = graph.edgeIterator();
        while (i.hasNext()) {
            ConstraintEdge edge = (ConstraintEdge)i.next();
            System.out.println(((DetectorNode)edge.getSource()).getFactory().getShortName() + " ==> " + ((DetectorNode)edge.getTarget()).getFactory().getShortName());
        }
    }

    public static void main(String[] argv) throws Exception {
        DetectorFactoryCollection detectorFactoryCollection = DetectorFactoryCollection.instance();
        ExecutionPlan execPlan = new ExecutionPlan();
        for (String pluginId : argv) {
            Plugin plugin = detectorFactoryCollection.getPluginById(pluginId);
            if (plugin == null) continue;
            execPlan.addPlugin(plugin);
        }
        execPlan.build();
        System.out.println(execPlan.getNumPasses() + " passes in plan");
        execPlan.print();
    }
}

