/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginException;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.gui2.Debug;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.Sortables;
import edu.umd.cs.findbugs.gui2.SorterTableColumnModel;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.lang3.StringUtils;

public class GUISaveState {
    private static GUISaveState instance;
    private static final String SORTERTABLELENGTH = "Sorter Length";
    private static final String PREVCOMMENTSSIZE = "Previous Comments Size";
    private static final String DOCKINGLAYOUT = "Docking Layout";
    private static final String FRAME_BOUNDS = "Frame Bounds";
    private static final String EXTENDED_WINDOW_STATE = "ExtendedWindowState";
    static final int MAXNUMRECENTPROJECTS = 10;
    private static final Sortables[] DEFAULT_COLUMN_HEADERS;
    private static final String[] RECENTPROJECTKEYS;
    private static final int MAXNUMPREVCOMMENTS = 10;
    private static final String[] COMMENTKEYS;
    private static final String NUMPROJECTS = "NumberOfProjectsToLoad";
    private static final String STARTERDIRECTORY = "Starter Directory";
    private static final String SPLIT_MAIN = "MainSplit";
    private static final String SPLIT_TREE_COMMENTS = "TreeCommentsSplit";
    private static final String SPLIT_TOP = "TopSplit";
    private static final String SPLIT_SUMMARY_NEW = "SummarySplitNew";
    private static final String TAB_SIZE = "TabSize";
    private static final String FONT_SIZE = "FontSize";
    private static final String PACKAGE_PREFIX_SEGEMENTS = "PackagePrefixSegments";
    private static final String ENABLED_PLUGINS = "EnabledPlugins";
    private static final String DISABLED_PLUGINS = "DisabledPlugins";
    private static final String CUSTOM_PLUGINS = "CustomPlugins";
    private int splitMain;
    private int splitTreeComments;
    private int splitTop;
    private int splitSummary;
    private File starterDirectoryForLoadBugs;
    private LinkedList<String> previousComments;
    private boolean useDefault = false;
    private SorterTableColumnModel starterTable;
    private Sortables[] sortColumns;
    private ArrayList<File> recentFiles;
    private byte[] dockingLayout;
    private Rectangle frameBounds;
    private int extendedWindowState;
    private int tabSize;
    private float fontSize;
    private int packagePrefixSegments;
    private List<String> enabledPlugins = new ArrayList<String>();
    private List<String> disabledPlugins = new ArrayList<String>();
    private final LinkedHashSet<URI> customPlugins = new LinkedHashSet();

    private static String[] generateSorterKeys(int numSorters) {
        String[] result = new String[numSorters];
        for (int x = 0; x < result.length; ++x) {
            result[x] = "Sorter" + x;
        }
        return result;
    }

    public static synchronized GUISaveState getInstance() {
        if (instance == null) {
            instance = new GUISaveState();
        }
        return instance;
    }

    public static void loadInstance() {
        GUISaveState newInstance = new GUISaveState();
        newInstance.recentFiles = new ArrayList();
        Preferences p = Preferences.userNodeForPackage(GUISaveState.class);
        newInstance.tabSize = p.getInt(TAB_SIZE, 4);
        newInstance.fontSize = p.getFloat(FONT_SIZE, 12.0f);
        newInstance.starterDirectoryForLoadBugs = new File(p.get(STARTERDIRECTORY, SystemProperties.getProperty("user.dir")));
        int prevCommentsSize = p.getInt(PREVCOMMENTSSIZE, 0);
        for (int x = 0; x < prevCommentsSize; ++x) {
            String comment = p.get(COMMENTKEYS[x], "");
            newInstance.previousComments.add(comment);
        }
        int size = Math.min(10, p.getInt(NUMPROJECTS, 0));
        for (int x = 0; x < size; ++x) {
            newInstance.addRecentFile(new File(p.get(RECENTPROJECTKEYS[x], "")));
        }
        int sorterSize = p.getInt(SORTERTABLELENGTH, -1);
        if (sorterSize != -1) {
            ArrayList<Object> sortColumns = new ArrayList<Object>();
            String[] sortKeys = GUISaveState.generateSorterKeys(sorterSize);
            for (int x = 0; x < sorterSize; ++x) {
                String[] s = Sortables.getSortableByPrettyName(p.get(sortKeys[x], "*none*"));
                if (s == null) {
                    if (MainFrame.GUI2_DEBUG) {
                        System.err.println("Sort order was corrupted, using default sort order");
                    }
                    newInstance.useDefault = true;
                    break;
                }
                sortColumns.add(s);
            }
            if (!newInstance.useDefault) {
                HashSet<Sortables> missingSortColumns = new HashSet<Sortables>(Arrays.asList(DEFAULT_COLUMN_HEADERS));
                missingSortColumns.removeAll(sortColumns);
                sortColumns.addAll(missingSortColumns);
                newInstance.sortColumns = sortColumns.toArray(new Sortables[sortColumns.size()]);
            }
        } else {
            newInstance.useDefault = true;
        }
        newInstance.dockingLayout = p.getByteArray(DOCKINGLAYOUT, new byte[0]);
        String boundsString = p.get(FRAME_BOUNDS, null);
        Rectangle r = new Rectangle(0, 0, 800, 650);
        if (boundsString != null) {
            String[] a = boundsString.split(",", 4);
            if (a.length > 0) {
                try {
                    r.x = Math.max(0, Integer.parseInt(a[0]));
                }
                catch (NumberFormatException s) {
                    // empty catch block
                }
            }
            if (a.length > 1) {
                try {
                    r.y = Math.max(0, Integer.parseInt(a[1]));
                }
                catch (NumberFormatException s) {
                    // empty catch block
                }
            }
            if (a.length > 2) {
                try {
                    r.width = Math.max(40, Integer.parseInt(a[2]));
                }
                catch (NumberFormatException s) {
                    // empty catch block
                }
            }
            if (a.length > 3) {
                try {
                    r.height = Math.max(40, Integer.parseInt(a[3]));
                }
                catch (NumberFormatException s) {
                    // empty catch block
                }
            }
        }
        newInstance.frameBounds = r;
        newInstance.extendedWindowState = p.getInt(EXTENDED_WINDOW_STATE, 0);
        newInstance.splitMain = p.getInt(SPLIT_MAIN, 400);
        newInstance.splitSummary = p.getInt(SPLIT_SUMMARY_NEW, 400);
        newInstance.splitTop = p.getInt(SPLIT_TOP, -1);
        newInstance.splitTreeComments = p.getInt(SPLIT_TREE_COMMENTS, 250);
        newInstance.packagePrefixSegments = p.getInt(PACKAGE_PREFIX_SEGEMENTS, 3);
        String plugins = p.get(CUSTOM_PLUGINS, "");
        if (plugins.length() > 0) {
            for (String s : plugins.split(" ")) {
                try {
                    URI u = new URI(s);
                    Plugin.addCustomPlugin(u);
                    newInstance.customPlugins.add(u);
                }
                catch (PluginException pluginException) {
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        String enabledPluginsString = p.get(ENABLED_PLUGINS, "");
        String disabledPluginsString = p.get(DISABLED_PLUGINS, "");
        newInstance.enabledPlugins = new ArrayList<String>(Arrays.asList(enabledPluginsString.split(",")));
        newInstance.disabledPlugins = new ArrayList<String>(Arrays.asList(disabledPluginsString.split(",")));
        instance = newInstance;
    }

    static void clear() {
        Preferences p = Preferences.userNodeForPackage(GUISaveState.class);
        try {
            p.clear();
        }
        catch (BackingStoreException e) {
            Debug.println(e);
        }
        instance = new GUISaveState();
    }

    private GUISaveState() {
        this.recentFiles = new ArrayList();
        this.previousComments = new LinkedList();
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    public int getPackagePrefixSegments() {
        return this.packagePrefixSegments;
    }

    public void setPackagePrefixSegments(int packagePrefixSegments) {
        this.packagePrefixSegments = packagePrefixSegments;
    }

    public byte[] getDockingLayout() {
        return this.dockingLayout;
    }

    public void setDockingLayout(byte[] dockingLayout) {
        this.dockingLayout = dockingLayout;
    }

    public void fileReused(File f) {
        if (!this.recentFiles.contains(f)) {
            throw new IllegalStateException("Selected a recent project that doesn't exist?");
        }
        this.recentFiles.remove(f);
        this.recentFiles.add(f);
    }

    public void addRecentFile(File f) {
        if (null != f) {
            this.recentFiles.add(f);
        }
    }

    public ArrayList<File> getRecentFiles() {
        return this.recentFiles;
    }

    public void fileNotFound(File f) {
        if (!this.recentFiles.contains(f)) {
            throw new IllegalStateException("Well no wonder it wasn't found, its not in the list.");
        }
        this.recentFiles.remove(f);
    }

    public File getStarterDirectoryForLoadBugs() {
        return this.starterDirectoryForLoadBugs;
    }

    public void setStarterDirectoryForLoadBugs(File f) {
        this.starterDirectoryForLoadBugs = f;
    }

    public void save() {
        int x;
        Preferences p = Preferences.userNodeForPackage(GUISaveState.class);
        p.putInt(TAB_SIZE, this.tabSize);
        p.putFloat(FONT_SIZE, this.fontSize);
        try {
            p.put(STARTERDIRECTORY, this.starterDirectoryForLoadBugs.getCanonicalPath());
        }
        catch (IOException e) {
            Debug.println(e);
        }
        int sorterLength = MainFrame.getInstance().getSorter().getColumnCount();
        ArrayList<Sortables> sortables = MainFrame.getInstance().getSorter().getOrder();
        p.putInt(SORTERTABLELENGTH, sorterLength);
        String[] sorterKeys = GUISaveState.generateSorterKeys(sorterLength);
        for (x = 0; x < sorterKeys.length; ++x) {
            p.put(sorterKeys[x], sortables.get((int)x).prettyName);
        }
        p.putInt(PREVCOMMENTSSIZE, this.previousComments.size());
        for (x = 0; x < this.previousComments.size(); ++x) {
            String comment = this.previousComments.get(x);
            p.put(COMMENTKEYS[x], comment);
        }
        int size = this.recentFiles.size();
        while (this.recentFiles.size() > 10) {
            this.recentFiles.remove(0);
        }
        p.putInt(NUMPROJECTS, Math.min(size, 10));
        for (int x2 = 0; x2 < Math.min(size, 10); ++x2) {
            File file = this.recentFiles.get(x2);
            p.put(RECENTPROJECTKEYS[x2], file.getAbsolutePath());
        }
        p.putByteArray(DOCKINGLAYOUT, this.dockingLayout);
        p.put(FRAME_BOUNDS, this.frameBounds.x + "," + this.frameBounds.y + "," + this.frameBounds.width + "," + this.frameBounds.height);
        p.putInt(EXTENDED_WINDOW_STATE, this.extendedWindowState);
        p.putInt(SPLIT_MAIN, this.splitMain);
        p.putDouble(SPLIT_SUMMARY_NEW, this.splitSummary);
        p.putInt(SPLIT_TOP, this.splitTop);
        p.putInt(SPLIT_TREE_COMMENTS, this.splitTreeComments);
        p.putInt(PACKAGE_PREFIX_SEGEMENTS, this.packagePrefixSegments);
        p.put(ENABLED_PLUGINS, StringUtils.join(this.enabledPlugins, (char)','));
        p.put(DISABLED_PLUGINS, StringUtils.join(this.disabledPlugins, (char)','));
        p.put(CUSTOM_PLUGINS, StringUtils.join(this.customPlugins, (char)' '));
    }

    public LinkedList<String> getPreviousComments() {
        return this.previousComments;
    }

    public void setPreviousComments(LinkedList<String> previousComments) {
        this.previousComments = previousComments;
    }

    public Rectangle getFrameBounds() {
        return this.frameBounds;
    }

    public void setFrameBounds(Rectangle frameBounds) {
        this.frameBounds = frameBounds;
    }

    public int getExtendedWindowState() {
        return this.extendedWindowState;
    }

    public void setExtendedWindowState(int extendedWindowState) {
        this.extendedWindowState = extendedWindowState & 0xFFFFFFFE;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public int getSplitMain() {
        return this.splitMain;
    }

    public void setSplitMain(int splitMain) {
        this.splitMain = splitMain;
    }

    public int getSplitSummary() {
        return this.splitSummary;
    }

    public void setSplitSummary(int splitSummary) {
        this.splitSummary = splitSummary;
    }

    public int getSplitTop() {
        return this.splitTop;
    }

    public void setSplitTop(int splitTop) {
        this.splitTop = splitTop;
    }

    public void setPluginsEnabled(List<String> enabledPlugins, List<String> disabledPlugins) {
        this.enabledPlugins = new ArrayList<String>(enabledPlugins);
        this.disabledPlugins = new ArrayList<String>(disabledPlugins);
    }

    public void setPluginEnabled(String url) {
        this.enabledPlugins.add(url);
    }

    public List<String> getEnabledPlugins() {
        return this.enabledPlugins;
    }

    public Collection<URI> getCustomPlugins() {
        return this.customPlugins;
    }

    public boolean addCustomPlugin(URL u) {
        try {
            return this.customPlugins.add(u.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Error converting to uri: " + String.valueOf(u), e);
        }
    }

    public List<String> getDisabledPlugins() {
        return this.disabledPlugins;
    }

    public boolean removeCustomPlugin(URL pluginId) {
        try {
            return this.customPlugins.remove(pluginId.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Error converting to uri: " + String.valueOf(pluginId), e);
        }
    }

    SorterTableColumnModel getStarterTable() {
        if (this.starterTable != null) {
            return this.starterTable;
        }
        this.starterTable = this.useDefault || this.sortColumns == null ? new SorterTableColumnModel(DEFAULT_COLUMN_HEADERS) : new SorterTableColumnModel(this.sortColumns);
        return this.starterTable;
    }

    static {
        int x;
        DEFAULT_COLUMN_HEADERS = new Sortables[]{Sortables.CATEGORY, Sortables.BUGCODE, Sortables.TYPE, Sortables.DIVIDER, Sortables.BUG_RANK};
        RECENTPROJECTKEYS = new String[10];
        COMMENTKEYS = new String[10];
        for (x = 0; x < RECENTPROJECTKEYS.length; ++x) {
            GUISaveState.RECENTPROJECTKEYS[x] = "Project" + x;
        }
        for (x = 0; x < COMMENTKEYS.length; ++x) {
            GUISaveState.COMMENTKEYS[x] = "Comment" + x;
        }
    }
}

