/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.internalAnnotations.StaticConstant;
import java.util.Collections;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantLong;

public class UnnecessaryMath
extends BytecodeScanningDetector
implements StatelessDetector {
    static final int SEEN_NOTHING = 0;
    static final int SEEN_DCONST = 1;
    private final BugReporter bugReporter;
    private int state = 0;
    private double constValue;
    @StaticConstant
    private static final Set<String> zeroMethods = Set.of("acos", "asin", "atan", "atan2", "cbrt", "cos", "cosh", "exp", "expm1", "log", "log10", "pow", "sin", "sinh", "sqrt", "tan", "tanh", "toDegrees", "toRadians");
    @StaticConstant
    private static final Set<String> oneMethods = Set.of("acos", "asin", "atan", "cbrt", "exp", "log", "log10", "pow", "sqrt", "toDegrees");
    @StaticConstant
    private static final Set<String> anyMethods = Set.of("abs", "ceil", "floor", "rint", "round");

    public UnnecessaryMath(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        if (UnnecessaryMath.hasInterestingClass(classContext.getJavaClass().getConstantPool(), Collections.singleton("java/lang/Math"))) {
            super.visitClassContext(classContext);
        }
    }

    @Override
    public void visit(Code obj) {
        if ("<clinit>".equals(this.getMethod().getName())) {
            return;
        }
        this.state = 0;
        super.visit(obj);
    }

    @Override
    public void sawOpcode(int seen) {
        if (this.state == 0) {
            if (seen == 14 || seen == 15) {
                this.constValue = seen - 14;
                this.state = 1;
            } else if (seen == 20 || seen == 19) {
                this.state = 1;
                Constant c = this.getConstantRefOperand();
                if (c instanceof ConstantDouble) {
                    this.constValue = ((ConstantDouble)c).getBytes();
                } else if (c instanceof ConstantFloat) {
                    this.constValue = ((ConstantFloat)c).getBytes();
                } else if (c instanceof ConstantLong) {
                    this.constValue = ((ConstantLong)c).getBytes();
                } else {
                    this.state = 0;
                }
            }
        } else if (this.state == 1) {
            if (seen == 184) {
                this.state = 0;
                if ("java.lang.Math".equals(this.getDottedClassConstantOperand())) {
                    String methodName = this.getNameConstantOperand();
                    if (this.constValue == 0.0 && zeroMethods.contains(methodName) || this.constValue == 1.0 && oneMethods.contains(methodName) || anyMethods.contains(methodName)) {
                        this.bugReporter.reportBug(new BugInstance(this, "UM_UNNECESSARY_MATH", 3).addClassAndMethod(this).addSourceLine(this));
                    }
                }
            }
            this.state = 0;
        }
    }
}

