/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.PruneUnconditionalExceptionThrowerEdges;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueAnalysis;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.vna.AvailableLoad;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.util.ClassName;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class MultipleInstantiationsOfSingletons
extends OpcodeStackDetector {
    private final BugReporter bugReporter;
    private JavaClass cloneableInterface;
    private JavaClass serializableInterface;
    private boolean hasSingletonPostFix;
    private boolean isCloneable;
    private boolean implementsCloneableDirectly;
    private XMethod cloneMethod;
    private boolean cloneOnlyThrowsException;
    private boolean cloneOnlyThrowsCloneNotSupportedException;
    private boolean isSerializable;
    private boolean isInstanceAssignOk;
    private boolean hasNoFactoryMethod;
    private boolean isInstanceFieldLazilyInitialized;
    private XField instanceField;
    private final Set<XField> eagerlyInitializedFields = new HashSet<XField>();
    private final Map<XField, XMethod> instanceGetterMethods = new HashMap<XField, XMethod>();
    private final List<XMethod> methodsUsingMonitor = new ArrayList<XMethod>();
    private final Map<XMethod, List<XMethod>> calledMethodsByMethods = new HashMap<XMethod, List<XMethod>>();

    public MultipleInstantiationsOfSingletons(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        try {
            this.cloneableInterface = Repository.getInterfaces((String)"java.lang.Cloneable")[0];
            this.serializableInterface = Repository.getInterfaces((String)"java.io.Serializable")[0];
        }
        catch (ClassNotFoundException e) {
            bugReporter.reportMissingClass(e);
        }
    }

    @Override
    public void visit(JavaClass obj) {
        this.hasSingletonPostFix = false;
        this.isCloneable = false;
        this.implementsCloneableDirectly = false;
        this.cloneOnlyThrowsException = false;
        this.cloneOnlyThrowsCloneNotSupportedException = false;
        this.isSerializable = false;
        this.isInstanceAssignOk = false;
        this.hasNoFactoryMethod = true;
        this.isInstanceFieldLazilyInitialized = false;
        this.instanceField = null;
        this.cloneMethod = null;
        this.eagerlyInitializedFields.clear();
        this.instanceGetterMethods.clear();
        this.methodsUsingMonitor.clear();
        this.calledMethodsByMethods.clear();
        if (obj.getClassName().endsWith("Singleton")) {
            this.hasSingletonPostFix = true;
        }
        try {
            JavaClass[] interfaces = obj.getAllInterfaces();
            this.isCloneable = Stream.of(interfaces).anyMatch(i -> i.equals((Object)this.cloneableInterface));
            this.isSerializable = Stream.of(interfaces).anyMatch(i -> i.equals((Object)this.serializableInterface));
            this.implementsCloneableDirectly = Stream.of(obj.getInterfaces()).anyMatch(i -> i.equals((Object)this.cloneableInterface));
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
        super.visit(obj);
    }

    @Override
    public void visit(Method obj) {
        if ("clone".equals(this.getMethodName()) && "()Ljava/lang/Object;".equals(this.getMethodSig())) {
            this.cloneOnlyThrowsException = PruneUnconditionalExceptionThrowerEdges.doesMethodUnconditionallyThrowException(this.getXMethod());
            this.cloneMethod = this.getXMethod();
        }
        super.visit(obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void sawOpcode(int seen) {
        if (seen == 179) {
            OpcodeStack.Item item;
            XMethod calledMethod;
            XField field = this.getXFieldOperand();
            if (!this.isInstanceField(field, this.getClassName())) return;
            if ("<clinit>".equals(this.getMethodName())) {
                this.eagerlyInitializedFields.add(field);
            }
            if (this.stack.getStackDepth() <= 0 || (calledMethod = (item = this.stack.getStackItem(0)).getReturnValueOf()) == null || !"<init>".equals(calledMethod.getName()) || !calledMethod.getClassName().equals(this.getDottedClassName())) return;
            this.isInstanceAssignOk = true;
            this.instanceField = field;
            try {
                ValueNumberDataflow vnaDataflow = this.getClassContext().getValueNumberDataflow(this.getMethod());
                IsNullValueDataflow invDataflow = this.getClassContext().getIsNullValueDataflow(this.getMethod());
                ValueNumberFrame vFrame = (ValueNumberFrame)((ValueNumberAnalysis)vnaDataflow.getAnalysis()).getFactAtPC(vnaDataflow.getCFG(), this.getPC());
                IsNullValueFrame iFrame = (IsNullValueFrame)((IsNullValueAnalysis)invDataflow.getAnalysis()).getFactAtPC(invDataflow.getCFG(), this.getPC());
                AvailableLoad l = new AvailableLoad(field);
                ValueNumber[] availableLoads = vFrame.getAvailableLoad(l);
                if (availableLoads == null || !iFrame.isTrackValueNumbers()) return;
                for (ValueNumber v : availableLoads) {
                    IsNullValue knownValue = iFrame.getKnownValue(v);
                    if (knownValue == null || !knownValue.isDefinitelyNull()) continue;
                    this.isInstanceFieldLazilyInitialized = true;
                }
                return;
            }
            catch (CFGBuilderException | DataflowAnalysisException e) {
                this.bugReporter.logError(String.format("Detector %s caught an exception while analyzing %s.", this.getClass().getName(), this.getClassContext().getJavaClass().getClassName()), e);
                return;
            }
        } else if (seen == 191 && "clone".equals(this.getMethodName()) && this.stack.getStackDepth() > 0) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            if (item == null || !this.cloneOnlyThrowsException || !"Ljava/lang/CloneNotSupportedException;".equals(item.getSignature())) return;
            this.cloneOnlyThrowsCloneNotSupportedException = true;
            return;
        } else if (seen == 176 && this.stack.getStackDepth() > 0) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            XMethod method = this.getXMethod();
            XField field = item.getXField();
            if (method.isPublic() && method.isStatic() && this.isInstanceField(field, this.getClassName())) {
                this.instanceGetterMethods.put(field, method);
                return;
            } else {
                XMethod calledMethod = item.getReturnValueOf();
                SignatureParser parser = new SignatureParser(this.getMethodSig());
                String calledMethodReturnType = ClassName.fromFieldSignature(parser.getReturnTypeSignature());
                if (calledMethod == null || method.isPrivate() || !method.isStatic() || !"<init>".equals(calledMethod.getName()) || !calledMethod.getClassName().equals(this.getDottedClassName()) || !this.getClassName().equals(calledMethodReturnType) || "<init>".equals(this.getMethodName()) || "<clinit>".equals(this.getMethodName()) || "clone".equals(this.getMethodName()) && "()Ljava/lang/Object;".equals(this.getMethodSig())) return;
                this.hasNoFactoryMethod = false;
            }
            return;
        } else if (seen == 194) {
            this.methodsUsingMonitor.add(this.getXMethod());
            return;
        } else {
            if (seen != 182 && seen != 183 && seen != 184 && seen != 185) return;
            if (!this.calledMethodsByMethods.containsKey(this.getXMethod())) {
                this.calledMethodsByMethods.put(this.getXMethod(), new ArrayList());
            }
            this.calledMethodsByMethods.get(this.getXMethod()).add(this.getXMethodOperand());
        }
    }

    private boolean isInstanceField(XField field, String clsName) {
        String className = "L" + clsName + ";";
        return field != null && field.isPrivate() && field.isStatic() && className.equals(field.getSignature());
    }

    @Override
    public void visitAfter(JavaClass javaClass) {
        XMethod instanceGetterMethod = this.instanceGetterMethods.get(this.instanceField);
        boolean isInstanceFieldEagerlyInitialized = this.eagerlyInitializedFields.contains(this.instanceField);
        if (!this.hasSingletonPostFix && (!this.isInstanceAssignOk || !this.hasNoFactoryMethod || instanceGetterMethod == null || !isInstanceFieldEagerlyInitialized && !this.isInstanceFieldLazilyInitialized || javaClass.isAbstract() || javaClass.isInterface() || javaClass.isRecord())) {
            return;
        }
        for (Method m : javaClass.getMethods()) {
            if (!"<init>".equals(m.getName()) || m.isPrivate()) continue;
            this.bugReporter.reportBug(new BugInstance(this, "SING_SINGLETON_HAS_NONPRIVATE_CONSTRUCTOR", 2).addClass(this).addMethod(javaClass, m));
            break;
        }
        if (instanceGetterMethod != null && this.isInstanceFieldLazilyInitialized && !this.hasSynchronized(instanceGetterMethod, new HashSet<XMethod>())) {
            this.bugReporter.reportBug(new BugInstance(this, "SING_SINGLETON_GETTER_NOT_SYNCHRONIZED", 2).addClass(this).addMethod(instanceGetterMethod));
        }
        if (!this.cloneOnlyThrowsCloneNotSupportedException) {
            if (this.isCloneable) {
                if (this.implementsCloneableDirectly) {
                    this.bugReporter.reportBug(new BugInstance(this, "SING_SINGLETON_IMPLEMENTS_CLONEABLE", 2).addClass(this).addMethod(this.cloneMethod));
                } else {
                    this.bugReporter.reportBug(new BugInstance(this, "SING_SINGLETON_INDIRECTLY_IMPLEMENTS_CLONEABLE", 2).addClass(this));
                }
            } else if (this.cloneMethod != null) {
                this.bugReporter.reportBug(new BugInstance(this, "SING_SINGLETON_IMPLEMENTS_CLONE_METHOD", 2).addClass(this).addMethod(this.cloneMethod));
            }
        }
        if (this.isSerializable) {
            if (javaClass.isEnum()) {
                int numberOfEnumValues = this.getNumberOfEnumValues(javaClass);
                if (numberOfEnumValues > 1) {
                    this.bugReporter.reportBug(new BugInstance(this, "SING_SINGLETON_IMPLEMENTS_SERIALIZABLE", 2).addClass(this));
                }
            } else {
                this.bugReporter.reportBug(new BugInstance(this, "SING_SINGLETON_IMPLEMENTS_SERIALIZABLE", 2).addClass(this));
            }
        }
        super.visitAfter(javaClass);
    }

    private boolean hasSynchronized(XMethod method, Set<XMethod> visitedMethods) {
        if (!visitedMethods.add(method)) {
            return false;
        }
        if (method.isSynchronized() || this.methodsUsingMonitor.contains(method)) {
            return true;
        }
        if (this.calledMethodsByMethods.containsKey(method)) {
            List<XMethod> calledMethods = this.calledMethodsByMethods.get(method);
            for (XMethod cm : calledMethods) {
                if (!this.hasSynchronized(cm, visitedMethods)) continue;
                return true;
            }
        }
        return false;
    }

    private int getNumberOfEnumValues(JavaClass javaClass) {
        try {
            Class<?> clazz = Class.forName(javaClass.getClassName());
            java.lang.reflect.Method valuesMethod = clazz.getDeclaredMethod("values", new Class[0]);
            Object[] result = (Object[])valuesMethod.invoke(null, new Object[0]);
            return result.length;
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.bugReporter.logError(String.format("Detector %s caught an exception while determining the number of enum values of %s.", this.getClass().getName(), javaClass.getClassName()), e);
        }
        return 0;
    }
}

