/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.bcel.classfile.Method;

public class InefficientInitializationInsideLoop
extends OpcodeStackDetector {
    private static final MethodDescriptor NODELIST_GET_LENGTH = new MethodDescriptor("org/w3c/dom/NodeList", "getLength", "()I");
    private static final MethodDescriptor PATTERN_COMPILE = new MethodDescriptor("java/util/regex/Pattern", "compile", "(Ljava/lang/String;)Ljava/util/regex/Pattern;", true);
    private static final MethodDescriptor PATTERN_COMPILE_2 = new MethodDescriptor("java/util/regex/Pattern", "compile", "(Ljava/lang/String;I)Ljava/util/regex/Pattern;", true);
    private static final MethodDescriptor PATTERN_MATCHES = new MethodDescriptor("java/util/regex/Pattern", "matches", "(Ljava/lang/String;Ljava/lang/CharSequence;)Z", true);
    private static final MethodDescriptor STRING_REPLACEALL = new MethodDescriptor("java/lang/String", "replaceAll", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
    private static final MethodDescriptor STRING_REPLACEFIRST = new MethodDescriptor("java/lang/String", "replaceFirst", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
    private static final MethodDescriptor STRING_MATCHES = new MethodDescriptor("java/lang/String", "matches", "(Ljava/lang/String;)Z");
    private static final MethodDescriptor STRING_SPLIT = new MethodDescriptor("java/lang/String", "split", "(Ljava/lang/String;)[Ljava/lang/String;");
    private static final MethodDescriptor STRING_SPLIT_2 = new MethodDescriptor("java/lang/String", "split", "(Ljava/lang/String;I)[Ljava/lang/String;");
    private static final Set<MethodDescriptor> implicitPatternMethods = Set.of(PATTERN_MATCHES, STRING_MATCHES, STRING_REPLACEALL, STRING_REPLACEFIRST, STRING_SPLIT, STRING_SPLIT_2);
    private static final List<MethodDescriptor> methods = new ArrayList<MethodDescriptor>();
    private SortedMap<Integer, BugInstance> matched;
    private SortedMap<Integer, Integer> conditions;
    private SortedMap<Integer, Integer> sources;
    private final BugReporter bugReporter;

    public InefficientInitializationInsideLoop(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        if (InefficientInitializationInsideLoop.hasInterestingMethod(classContext.getJavaClass().getConstantPool(), methods) || InefficientInitializationInsideLoop.hasInterestingClass(classContext.getJavaClass().getConstantPool(), Collections.singleton("java/sql/Connection"))) {
            super.visitClassContext(classContext);
        }
    }

    @Override
    public void visitMethod(Method obj) {
        this.matched = new TreeMap<Integer, BugInstance>();
        this.conditions = new TreeMap<Integer, Integer>();
        this.sources = new TreeMap<Integer, Integer>();
        super.visitMethod(obj);
    }

    private boolean isFastPath(String regex) {
        char ch;
        return (regex.length() == 1 && ".$|()[{^?*+\\".indexOf(ch = regex.charAt(0)) == -1 || regex.length() == 2 && regex.charAt(0) == '\\' && ((ch = regex.charAt(1)) - 48 | 57 - ch) < 0 && (ch - 97 | 122 - ch) < 0 && (ch - 65 | 90 - ch) < 0) && (ch < '\ud800' || ch > '\udfff');
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 185 && this.getClassConstantOperand().equals("java/sql/Connection") && this.getMethodDescriptorOperand().getName().equals("prepareStatement") && this.hasConstantArguments()) {
            this.matched.put(this.getPC(), new BugInstance(this, "IIL_PREPARE_STATEMENT_IN_LOOP", 2).addClassAndMethod(this).addSourceLine(this, this.getPC()).addCalledMethod(this));
        } else if (seen == 185 && this.getMethodDescriptorOperand().equals(NODELIST_GET_LENGTH)) {
            OpcodeStack.Item item = this.getStack().getStackItem(0);
            XMethod returnValueOf = item.getReturnValueOf();
            if (returnValueOf != null && returnValueOf.getClassName().startsWith("org.w3c.dom.") && returnValueOf.getName().startsWith("getElementsByTagName")) {
                this.matched.put(this.getPC(), new BugInstance(this, "IIL_ELEMENTS_GET_LENGTH_IN_LOOP", 2).addClassAndMethod(this).addSourceLine(this, this.getPC()).addCalledMethod(this));
                this.sources.put(this.getPC(), item.getPC());
            }
        } else if (seen == 184 && (this.getMethodDescriptorOperand().equals(PATTERN_COMPILE) || this.getMethodDescriptorOperand().equals(PATTERN_COMPILE_2)) && this.hasConstantArguments()) {
            String regex = this.getFirstArgument();
            this.matched.put(this.getPC(), new BugInstance(this, "IIL_PATTERN_COMPILE_IN_LOOP", 2).addClassAndMethod(this).addSourceLine(this, this.getPC()).addCalledMethod(this).addString(regex).describe("STRING_REGEX"));
        } else if ((seen == 184 || seen == 182) && implicitPatternMethods.contains(this.getMethodDescriptorOperand())) {
            String regex = this.getFirstArgument();
            if (!(regex == null || this.getNameConstantOperand().equals("split") && this.isFastPath(regex))) {
                BugInstance bug = new BugInstance(this, "IIL_PATTERN_COMPILE_IN_LOOP_INDIRECT", 3).addClassAndMethod(this).addSourceLine(this, this.getPC()).addCalledMethod(this).addString(regex).describe("STRING_REGEX");
                this.matched.put(this.getPC(), bug);
            }
        } else if (InefficientInitializationInsideLoop.isBranch(seen) && this.getBranchOffset() > 0) {
            this.conditions.put(this.getPC(), this.getBranchTarget());
        } else if (!this.matched.isEmpty() && InefficientInitializationInsideLoop.isBranch(seen) && this.getBranchOffset() < 0) {
            for (Map.Entry<Integer, BugInstance> entry : this.matched.tailMap(this.getBranchTarget()).entrySet()) {
                Integer source = (Integer)this.sources.get(entry.getKey());
                if (source != null && source > this.getBranchTarget() && source < this.getPC()) {
                    return;
                }
                for (int target : this.conditions.subMap(this.getBranchTarget(), entry.getKey()).values()) {
                    if (target <= entry.getKey() || target >= this.getPC()) continue;
                    return;
                }
                this.bugReporter.reportBug(entry.getValue());
            }
        }
    }

    private String getFirstArgument() {
        Object value = this.getStack().getStackItem(InefficientInitializationInsideLoop.getNumberArguments(this.getMethodDescriptorOperand().getSignature()) - 1).getConstant();
        return value == null ? null : value.toString();
    }

    private boolean hasConstantArguments() {
        int nArgs = InefficientInitializationInsideLoop.getNumberArguments(this.getMethodDescriptorOperand().getSignature());
        for (int i = 0; i < nArgs; ++i) {
            if (this.getStack().getStackItem(i).getConstant() != null) continue;
            return false;
        }
        return true;
    }

    static {
        methods.add(NODELIST_GET_LENGTH);
        methods.add(PATTERN_COMPILE);
        methods.add(PATTERN_COMPILE_2);
        methods.addAll(implicitPatternMethods);
    }
}

