/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ResourceTrackingDetector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.ResourceTracker;
import edu.umd.cs.findbugs.ba.ResourceValue;
import edu.umd.cs.findbugs.ba.ResourceValueAnalysis;
import edu.umd.cs.findbugs.ba.ResourceValueFrame;
import edu.umd.cs.findbugs.ba.ResourceValueFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.detect.Lock;
import java.util.BitSet;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.RETURN;

public class FindUnreleasedLock
extends ResourceTrackingDetector<Lock, LockResourceTracker> {
    private static final boolean DEBUG = SystemProperties.getBoolean("ful.debug");
    private int numAcquires = 0;

    public FindUnreleasedLock(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        JavaClass jclass = classContext.getJavaClass();
        if (BCELUtil.preTiger(jclass)) {
            return;
        }
        boolean sawUtilConcurrentLocks = false;
        for (Constant c : jclass.getConstantPool().getConstantPool()) {
            if (!(c instanceof ConstantMethodref)) continue;
            ConstantMethodref m = (ConstantMethodref)c;
            ConstantClass cl = (ConstantClass)jclass.getConstantPool().getConstant(m.getClassIndex());
            ConstantUtf8 name = (ConstantUtf8)jclass.getConstantPool().getConstant(cl.getNameIndex());
            String nameAsString = name.getBytes();
            if (!nameAsString.startsWith("java/util/concurrent/locks")) continue;
            sawUtilConcurrentLocks = true;
        }
        if (sawUtilConcurrentLocks) {
            super.visitClassContext(classContext);
        }
    }

    @Override
    public boolean prescreen(ClassContext classContext, Method method, boolean mightClose) {
        if (!mightClose) {
            return false;
        }
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        if (bytecodeSet == null) {
            return false;
        }
        MethodGen methodGen = classContext.getMethodGen(method);
        return methodGen != null && !methodGen.getName().toLowerCase().contains("lock") && (bytecodeSet.get(182) || bytecodeSet.get(185));
    }

    @Override
    public LockResourceTracker getResourceTracker(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        return new LockResourceTracker(this.bugReporter, classContext.getCFG(method), classContext.getValueNumberDataflow(method), classContext.getIsNullValueDataflow(method));
    }

    @Override
    public void inspectResult(ClassContext classContext, MethodGen methodGen, CFG cfg, Dataflow<ResourceValueFrame, ResourceValueAnalysis<Lock>> dataflow, Lock resource) {
        ResourceValueFrame.State exitStatus;
        JavaClass javaClass = classContext.getJavaClass();
        ResourceValueFrame exitFrame = dataflow.getResultFact(cfg.getExit());
        if (DEBUG) {
            System.out.println("Resource value at exit: " + String.valueOf(exitFrame));
        }
        if ((exitStatus = exitFrame.getStatus()) == ResourceValueFrame.State.OPEN || exitStatus == ResourceValueFrame.State.OPEN_ON_EXCEPTION_PATH || exitStatus == ResourceValueFrame.State.CLOSED_WITHOUT_OPENED) {
            int priority;
            String bugType;
            String sourceFile = javaClass.getSourceFileName();
            Location location = resource.getLocation();
            InstructionHandle handle = location.getHandle();
            InstructionHandle nextInstruction = handle.getNext();
            if (nextInstruction.getInstruction() instanceof RETURN) {
                return;
            }
            if (exitStatus == ResourceValueFrame.State.OPEN) {
                bugType = "UL_UNRELEASED_LOCK";
                priority = 1;
            } else if (exitStatus == ResourceValueFrame.State.OPEN_ON_EXCEPTION_PATH) {
                bugType = "UL_UNRELEASED_LOCK_EXCEPTION_PATH";
                priority = 2;
            } else {
                bugType = "CWO_CLOSED_WITHOUT_OPENED";
                priority = 3;
            }
            this.bugAccumulator.accumulateBug(new BugInstance(this, bugType, priority).addClassAndMethod(methodGen, sourceFile), SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, handle));
        }
    }

    @Override
    public void report() {
        if (DEBUG) {
            System.out.println("numAcquires=" + this.numAcquires);
        }
    }

    class LockResourceTracker
    implements ResourceTracker<Lock> {
        private final RepositoryLookupFailureCallback lookupFailureCallback;
        private final CFG cfg;
        private final ValueNumberDataflow vnaDataflow;
        private final IsNullValueDataflow isNullDataflow;

        public LockResourceTracker(RepositoryLookupFailureCallback lookupFailureCallback, CFG cfg, ValueNumberDataflow vnaDataflow, IsNullValueDataflow isNullDataflow) {
            this.lookupFailureCallback = lookupFailureCallback;
            this.cfg = cfg;
            this.vnaDataflow = vnaDataflow;
            this.isNullDataflow = isNullDataflow;
        }

        @Override
        public Lock isResourceCreation(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg) throws DataflowAnalysisException {
            InvokeInstruction inv = this.toInvokeInstruction(handle.getInstruction());
            if (inv == null) {
                return null;
            }
            String className = inv.getClassName(cpg);
            String methodName = inv.getName(cpg);
            String methodSig = inv.getSignature(cpg);
            try {
                if ("lock".equals(methodName) && "()V".equals(methodSig) && Hierarchy.isSubtype(className, "java.util.concurrent.locks.Lock")) {
                    Location location = new Location(handle, basicBlock);
                    ValueNumberFrame frame = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(location);
                    ValueNumber lockValue = (ValueNumber)frame.getTopValue();
                    if (DEBUG) {
                        System.out.println("Lock value is " + lockValue.getNumber() + ", frame=" + String.valueOf(frame));
                        ++FindUnreleasedLock.this.numAcquires;
                    }
                    return new Lock(location, className, lockValue);
                }
            }
            catch (ClassNotFoundException e) {
                this.lookupFailureCallback.reportMissingClass(e);
            }
            return null;
        }

        @Override
        public boolean mightCloseResource(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg) {
            InvokeInstruction inv = this.toInvokeInstruction(handle.getInstruction());
            if (inv == null) {
                return false;
            }
            String className = inv.getClassName(cpg);
            String methodName = inv.getName(cpg);
            String methodSig = inv.getSignature(cpg);
            try {
                if ("unlock".equals(methodName) && "()V".equals(methodSig) && Hierarchy.isSubtype(className, "java.util.concurrent.locks.Lock")) {
                    return true;
                }
            }
            catch (ClassNotFoundException e) {
                this.lookupFailureCallback.reportMissingClass(e);
            }
            return false;
        }

        @Override
        public boolean isResourceClose(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg, Lock resource, ResourceValueFrame frame) throws DataflowAnalysisException {
            if (!this.mightCloseResource(basicBlock, handle, cpg)) {
                return false;
            }
            ResourceValue topValue = (ResourceValue)frame.getTopValue();
            return topValue.isInstance();
        }

        @Override
        public ResourceValueFrameModelingVisitor createVisitor(Lock resource, ConstantPoolGen cpg) {
            return new LockFrameModelingVisitor(cpg, this, resource, this.vnaDataflow);
        }

        @Override
        public boolean ignoreImplicitExceptions(Lock resource) {
            return false;
        }

        @Override
        public boolean ignoreExceptionEdge(Edge edge, Lock resource, ConstantPoolGen cpg) {
            try {
                Instruction ins;
                Location location = this.cfg.getExceptionThrowerLocation(edge);
                if (DEBUG) {
                    System.out.println("Exception thrower location: " + String.valueOf(location));
                }
                if ((ins = location.getHandle().getInstruction()) instanceof GETFIELD) {
                    GETFIELD insGetfield = (GETFIELD)ins;
                    String fieldName = insGetfield.getFieldName(cpg);
                    if (DEBUG) {
                        System.out.println("Inspecting GETFIELD of " + fieldName + " at " + String.valueOf(location));
                    }
                    if ("lock".equals(fieldName)) {
                        return true;
                    }
                    IsNullValueFrame frame = (IsNullValueFrame)this.isNullDataflow.getFactAtLocation(location);
                    if (!frame.isValid()) {
                        return false;
                    }
                    IsNullValue receiver = (IsNullValue)frame.getInstance(ins, cpg);
                    boolean notNull = receiver.isDefinitelyNotNull();
                    if (DEBUG && notNull) {
                        System.out.println("Ignoring exception from non-null GETFIELD");
                    }
                    return notNull;
                }
                if (ins instanceof InvokeInstruction) {
                    InvokeInstruction iins = (InvokeInstruction)ins;
                    String methodName = iins.getMethodName(cpg);
                    if (methodName.startsWith("access$")) {
                        return true;
                    }
                    if ("readLock".equals(methodName) || "writeLock".equals(methodName)) {
                        return true;
                    }
                    if ("lock".equals(methodName) || "unlock".equals(methodName)) {
                        return true;
                    }
                }
                if (DEBUG) {
                    System.out.println("FOUND Exception thrower at: " + String.valueOf(location));
                }
            }
            catch (DataflowAnalysisException e) {
                AnalysisContext.logError("Error while looking for exception edge", e);
            }
            return false;
        }

        @Override
        public boolean isParamInstance(Lock resource, int slot) {
            return false;
        }

        private InvokeInstruction toInvokeInstruction(Instruction ins) {
            short opcode = ins.getOpcode();
            if (opcode != 182 && opcode != 185) {
                return null;
            }
            return (InvokeInstruction)ins;
        }
    }

    private static class LockFrameModelingVisitor
    extends ResourceValueFrameModelingVisitor {
        private final LockResourceTracker resourceTracker;
        private final Lock lock;
        private final ValueNumberDataflow vnaDataflow;

        public LockFrameModelingVisitor(ConstantPoolGen cpg, LockResourceTracker resourceTracker, Lock lock, ValueNumberDataflow vnaDataflow) {
            super(cpg);
            this.resourceTracker = resourceTracker;
            this.lock = lock;
            this.vnaDataflow = vnaDataflow;
        }

        @Override
        public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock) throws DataflowAnalysisException {
            Instruction ins = handle.getInstruction();
            ConstantPoolGen cpg = this.getCPG();
            ResourceValueFrame frame = (ResourceValueFrame)this.getFrame();
            ResourceValueFrame.State status = ResourceValueFrame.State.NONEXISTENT;
            boolean updated = false;
            if (DEBUG) {
                System.out.println("Before transferInstruction status of frame: " + String.valueOf((Object)frame.getStatus()));
                System.out.println("PC : " + handle.getPosition() + " " + String.valueOf(ins));
                if (ins instanceof InvokeInstruction) {
                    System.out.println("  " + ins.toString(cpg.getConstantPool()));
                }
                System.out.println("resource frame before instruction: " + String.valueOf(frame));
            }
            Location creationPoint = this.lock.getLocation();
            if (frame.getStatus() == ResourceValueFrame.State.CLOSED_WITHOUT_OPENED) {
                status = ResourceValueFrame.State.CLOSED_WITHOUT_OPENED;
                if (DEBUG) {
                    System.out.println("CLOSED WITHOUT OPENED");
                }
            } else if (handle == creationPoint.getHandle() && basicBlock == creationPoint.getBasicBlock()) {
                status = ResourceValueFrame.State.OPEN;
                updated = true;
                if (DEBUG) {
                    System.out.println("OPEN");
                }
            } else if (this.resourceTracker.isResourceClose(basicBlock, handle, cpg, this.lock, frame)) {
                if (frame.getStatus() == ResourceValueFrame.State.NOT_OPEN_ON_EXCEPTION_PATH) {
                    status = ResourceValueFrame.State.CLOSED_WITHOUT_OPENED;
                    updated = true;
                    if (DEBUG) {
                        System.out.println("CLOSED WITHOUT OPENED");
                    }
                } else {
                    status = ResourceValueFrame.State.CLOSED;
                    updated = true;
                    if (DEBUG) {
                        System.out.println("CLOSE");
                    }
                }
            }
            this.analyzeInstruction(ins);
            int updatedNumSlots = frame.getNumSlots();
            ValueNumberFrame vnaFrame = (ValueNumberFrame)this.vnaDataflow.getFactAfterLocation(new Location(handle, basicBlock));
            if (DEBUG) {
                System.out.println("vna frame after instruction: " + vnaFrame.toString());
                System.out.println("Lock value number: " + String.valueOf(this.lock.getLockValue()));
                if (this.lock.getLockValue().hasFlag(1)) {
                    System.out.println("is return value");
                }
            }
            for (int i = 0; i < updatedNumSlots; ++i) {
                if (DEBUG) {
                    System.out.println("Slot " + i);
                    System.out.println("  Lock value number: " + String.valueOf(vnaFrame.getValue(i)));
                    if (((ValueNumber)vnaFrame.getValue(i)).hasFlag(1)) {
                        System.out.println("  is return value");
                    }
                }
                if (!vnaFrame.fuzzyMatch(this.lock.getLockValue(), (ValueNumber)vnaFrame.getValue(i))) continue;
                if (DEBUG) {
                    System.out.println("Saw lock value!");
                }
                frame.setValue(i, ResourceValue.instance());
            }
            if (updated) {
                frame.setStatus(status);
            }
            if (DEBUG) {
                System.out.println("resource frame after instruction: " + String.valueOf(frame));
            }
        }

        @Override
        protected boolean instanceEscapes(InvokeInstruction inv, int instanceArgNum) {
            return false;
        }
    }
}

