/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.detect.PublicIdentifiers;
import edu.umd.cs.findbugs.util.ClassName;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class DontReusePublicIdentifiers
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private JavaClass currentClass;

    public DontReusePublicIdentifiers(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        JavaClass obj = classContext.getJavaClass();
        if (PublicIdentifiers.isPartOfStandardLibrary(classContext.getXClass().getClassDescriptor().getPackageName())) {
            return;
        }
        this.currentClass = obj;
        classContext.getJavaClass().accept((Visitor)this);
    }

    @Override
    public void visit(JavaClass obj) {
        String simpleName = ClassName.extractSimpleName(obj.getClassName());
        if (PublicIdentifiers.PUBLIC_IDENTIFIERS.contains(simpleName)) {
            this.bugReporter.reportBug(new BugInstance(this, "PI_DO_NOT_REUSE_PUBLIC_IDENTIFIERS_CLASS_NAMES", 2).addClass(this));
        }
    }

    @Override
    public void visit(Field obj) {
        String name = obj.getName();
        if (PublicIdentifiers.PUBLIC_IDENTIFIERS.contains(name)) {
            this.bugReporter.reportBug(new BugInstance(this, "PI_DO_NOT_REUSE_PUBLIC_IDENTIFIERS_FIELD_NAMES", 2).addClass(this).addField(this));
        }
    }

    private boolean lookUpMethod(Method method, JavaClass[] classes) {
        for (JavaClass cls : classes) {
            Method[] methods;
            for (Method m : methods = cls.getMethods()) {
                if (!method.equals((Object)m)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void visit(Method obj) {
        String name = obj.getName();
        if (PublicIdentifiers.PUBLIC_IDENTIFIERS.contains(name)) {
            try {
                JavaClass[] supers = this.currentClass.getSuperClasses();
                boolean foundInSupers = this.lookUpMethod(obj, supers);
                JavaClass[] interfaces = this.currentClass.getAllInterfaces();
                boolean foundInInterfaces = this.lookUpMethod(obj, interfaces);
                if (!foundInSupers && !foundInInterfaces) {
                    this.bugReporter.reportBug(new BugInstance(this, "PI_DO_NOT_REUSE_PUBLIC_IDENTIFIERS_METHOD_NAMES", 2).addClassAndMethod(this).addSourceLine(SourceLineAnnotation.forEntireMethod(this.currentClass, obj)));
                }
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass(e);
            }
        }
    }

    @Override
    public void visit(LocalVariableTable obj) {
        LocalVariable[] variables;
        for (LocalVariable variable : variables = obj.getLocalVariableTable()) {
            String varName = variable.getName();
            if ("this".equals(varName) || !PublicIdentifiers.PUBLIC_IDENTIFIERS.contains(varName)) continue;
            LocalVariableAnnotation localVariableAnnotation = new LocalVariableAnnotation(varName, variable.getIndex(), this.getPC());
            this.bugReporter.reportBug(new BugInstance(this, "PI_DO_NOT_REUSE_PUBLIC_IDENTIFIERS_LOCAL_VARIABLE_NAMES", 2).addClassAndMethod(this).add(localVariableAnnotation).addSourceLine(this.getClassContext(), this, this.getPC()));
        }
    }
}

