/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.cwe;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import edu.umd.cs.findbugs.cwe.Weakness;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeaknessCatalog {
    private static final Logger logger = LoggerFactory.getLogger(WeaknessCatalog.class);
    private String version;
    private String name;
    private LocalDate releaseDate;
    private static final String FILE_NAME = "CWE_4.10.json";
    private final Map<Integer, Weakness> weaknesses = new HashMap<Integer, Weakness>();
    private static WeaknessCatalog INSTANCE;

    private WeaknessCatalog() {
    }

    public static synchronized WeaknessCatalog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WeaknessCatalog();
            WeaknessCatalog.loadFileAndInitialize();
        }
        return INSTANCE;
    }

    private static void loadFileAndInitialize() {
        InputStream inputStream = WeaknessCatalog.class.getClassLoader().getResourceAsStream(FILE_NAME);
        Gson gson = new Gson();
        String characterEncoding = "UTF-8";
        if (inputStream == null) {
            throw new IllegalArgumentException("file not found! CWE_4.10.json");
        }
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, characterEncoding));){
            JsonElement rootElement = JsonParser.parseReader((JsonReader)reader);
            JsonPrimitive nameElement = rootElement.getAsJsonObject().get("name").getAsJsonPrimitive();
            JsonPrimitive versionElement = rootElement.getAsJsonObject().get("version").getAsJsonPrimitive();
            JsonPrimitive dateElement = rootElement.getAsJsonObject().get("date").getAsJsonPrimitive();
            WeaknessCatalog.INSTANCE.version = versionElement.getAsString();
            WeaknessCatalog.INSTANCE.name = nameElement.getAsString();
            WeaknessCatalog.INSTANCE.releaseDate = LocalDate.parse(dateElement.getAsString());
            JsonElement weaknessElements = rootElement.getAsJsonObject().get("weaknesses");
            for (JsonElement weaknessElement : weaknessElements.getAsJsonArray()) {
                Weakness weakness = (Weakness)gson.fromJson(weaknessElement, Weakness.class);
                WeaknessCatalog.INSTANCE.weaknesses.put(weakness.getCweId(), weakness);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Character encoding '{}' is not supported.", (Object)characterEncoding);
        }
        catch (JsonIOException | JsonSyntaxException | IOException e) {
            logger.error("Unable to read the weakness catalog JSON.");
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public LocalDate getReleaseDate() {
        return this.releaseDate;
    }

    public Weakness getWeaknessByCweIdOrNull(int cweid) {
        Integer cweId = cweid;
        if (this.weaknesses.containsKey(cweId)) {
            Weakness weakness = this.weaknesses.get(cweId);
            return Weakness.of(weakness.getCweId(), weakness.getName(), weakness.getDescription(), weakness.getSeverity());
        }
        return null;
    }
}

