/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.bytecode;

import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.analysis.AnnotatedObject;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.generic.AnnotationEntryGen;
import org.apache.bcel.generic.FieldGenOrMethodGen;
import org.apache.bcel.generic.MethodGen;

public final class MemberUtils {
    private static final String GENERATED_TYPE_SUFFIX = "/Generated;";
    private static final String GENERATED_NAME_SUFFIX = "/Generated";

    private MemberUtils() {
        throw new AssertionError((Object)"Utility classes can't be instantiated");
    }

    private static boolean internalIsSynthetic(FieldOrMethod m) {
        if (m.isSynthetic()) {
            return true;
        }
        for (Attribute a : m.getAttributes()) {
            if (!(a instanceof Synthetic)) continue;
            return true;
        }
        return false;
    }

    private static boolean internalIsSynthetic(FieldGenOrMethodGen m) {
        if (m.isSynthetic()) {
            return true;
        }
        for (Attribute a : m.getAttributes()) {
            if (!(a instanceof Synthetic)) continue;
            return true;
        }
        return false;
    }

    private static boolean isGeneratedMethod(FieldOrMethod m) {
        for (AnnotationEntry a : m.getAnnotationEntries()) {
            String typeName = a.getAnnotationType();
            if (!typeName.endsWith(GENERATED_TYPE_SUFFIX)) continue;
            return true;
        }
        return false;
    }

    private static boolean isGeneratedMethod(FieldGenOrMethodGen m) {
        for (AnnotationEntryGen a : m.getAnnotationEntries()) {
            String typeName = a.getAnnotation().getAnnotationType();
            if (!typeName.endsWith(GENERATED_NAME_SUFFIX)) continue;
            return true;
        }
        return false;
    }

    private static boolean isGenerated(AnnotatedObject o) {
        for (AnnotationValue a : o.getAnnotations()) {
            String typeName = a.getAnnotationClass().getClassName();
            if (!typeName.endsWith(GENERATED_NAME_SUFFIX)) continue;
            return true;
        }
        return false;
    }

    public static boolean couldBeLambda(Method m) {
        return m.isPrivate() && MemberUtils.internalIsSynthetic((FieldOrMethod)m);
    }

    public static boolean couldBeLambda(XMethod m) {
        return m.isPrivate() && m.isSynthetic();
    }

    public static boolean couldBeLambda(MethodGen m) {
        return m.isPrivate() && MemberUtils.internalIsSynthetic((FieldGenOrMethodGen)m);
    }

    public static boolean isUserGenerated(FieldOrMethod m) {
        return (!MemberUtils.internalIsSynthetic(m) || m instanceof Method && MemberUtils.couldBeLambda((Method)m)) && !MemberUtils.isGeneratedMethod(m);
    }

    public static boolean isUserGenerated(ClassMember m) {
        return (!m.isSynthetic() || m instanceof XMethod && MemberUtils.couldBeLambda((XMethod)m)) && (!(m instanceof XMethod) || !MemberUtils.isGenerated((XMethod)m));
    }

    public static boolean isUserGenerated(FieldGenOrMethodGen m) {
        return (!MemberUtils.internalIsSynthetic(m) || m instanceof MethodGen && MemberUtils.couldBeLambda((MethodGen)m)) && !MemberUtils.isGeneratedMethod(m);
    }

    public static boolean isUserGenerated(XClass c) {
        return !MemberUtils.isGenerated(c);
    }

    public static boolean isMainMethod(Method method) {
        return !method.isPrivate() && "main".equals(method.getName()) && ("([Ljava/lang/String;)V".equals(method.getSignature()) || "()V".equals(method.getSignature()));
    }

    public static boolean isMainMethod(XMethod method) {
        return !method.isPrivate() && "main".equals(method.getName()) && ("([Ljava/lang/String;)V".equals(method.getSignature()) || "()V".equals(method.getSignature()));
    }
}

