/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.vna;

import edu.umd.cs.findbugs.ba.AbstractFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Debug;
import edu.umd.cs.findbugs.ba.FieldSummary;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Hierarchy2;
import edu.umd.cs.findbugs.ba.InvalidBytecodeException;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.vna.AvailableLoad;
import edu.umd.cs.findbugs.ba.vna.LoadedFieldSet;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysisFeatures;
import edu.umd.cs.findbugs.ba.vna.ValueNumberCache;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFactory;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.detect.FindNoSideEffectMethods;
import java.util.HashMap;
import java.util.Set;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ArrayInstruction;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.INVOKEDYNAMIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.MONITORENTER;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;

public class ValueNumberFrameModelingVisitor
extends AbstractFrameModelingVisitor<ValueNumber, ValueNumberFrame>
implements Debug,
ValueNumberAnalysisFeatures {
    private final MethodGen methodGen;
    ValueNumberFactory factory;
    private final ValueNumberCache cache;
    private final LoadedFieldSet loadedFieldSet;
    private final HashMap<Object, ValueNumber> constantValueMap;
    private final HashMap<ValueNumber, String> stringConstantMap;
    private InstructionHandle handle;
    private static final ValueNumber[] EMPTY_INPUT_VALUE_LIST = new ValueNumber[0];

    public ValueNumberFrameModelingVisitor(MethodGen methodGen, ValueNumberFactory factory, ValueNumberCache cache, LoadedFieldSet loadedFieldSet, RepositoryLookupFailureCallback lookupFailureCallback) {
        super(methodGen.getConstantPool());
        this.methodGen = methodGen;
        this.factory = factory;
        this.cache = cache;
        this.loadedFieldSet = loadedFieldSet;
        this.constantValueMap = new HashMap();
        this.stringConstantMap = new HashMap();
    }

    @Override
    public ValueNumber getDefaultValue() {
        return this.factory.createFreshValue();
    }

    public void setHandle(InstructionHandle handle) {
        this.handle = handle;
    }

    private boolean doRedundantLoadElimination() {
        if (!REDUNDANT_LOAD_ELIMINATION) {
            return false;
        }
        XField xfield = this.loadedFieldSet.getField(this.handle);
        if (xfield == null) {
            return false;
        }
        return !xfield.getSignature().equals("D") && !xfield.getSignature().equals("J");
    }

    private boolean doForwardSubstitution() {
        if (!REDUNDANT_LOAD_ELIMINATION) {
            return false;
        }
        XField xfield = this.loadedFieldSet.getField(this.handle);
        if (xfield == null) {
            return false;
        }
        if (xfield.getSignature().equals("D") || xfield.getSignature().equals("J")) {
            return false;
        }
        return this.loadedFieldSet.isLoaded(xfield);
    }

    private void checkConsumedAndProducedValues(Instruction ins, ValueNumber[] consumedValueList, ValueNumber[] producedValueList) {
        int numConsumed = ins.consumeStack(this.getCPG());
        int numProduced = ins.produceStack(this.getCPG());
        if (numConsumed == -2) {
            throw new InvalidBytecodeException("Unpredictable stack consumption for " + String.valueOf(ins));
        }
        if (numProduced == -2) {
            throw new InvalidBytecodeException("Unpredictable stack production for " + String.valueOf(ins));
        }
        if (consumedValueList.length != numConsumed) {
            throw new IllegalStateException("Wrong number of values consumed for " + String.valueOf(ins) + ": expected " + numConsumed + ", got " + consumedValueList.length);
        }
        if (producedValueList.length != numProduced) {
            throw new IllegalStateException("Wrong number of values produced for " + String.valueOf(ins) + ": expected " + numProduced + ", got " + producedValueList.length);
        }
    }

    @Override
    public void modelNormalInstruction(Instruction ins, int numWordsConsumed, int numWordsProduced) {
        int flags = 0;
        if (ins instanceof InvokeInstruction) {
            flags = 1;
        } else if (ins instanceof ArrayInstruction) {
            flags = 2;
        } else if (ins instanceof ConstantPushInstruction) {
            flags = 16;
        }
        ValueNumber[] inputValueList = this.popInputValues(numWordsConsumed);
        ValueNumber[] outputValueList = this.getOutputValues(inputValueList, numWordsProduced, flags);
        if (VERIFY_INTEGRITY) {
            this.checkConsumedAndProducedValues(ins, inputValueList, outputValueList);
        }
        this.pushOutputValues(outputValueList);
    }

    @Override
    public void visitGETFIELD(GETFIELD obj) {
        XField xfield = Hierarchy.findXField((FieldInstruction)obj, this.getCPG());
        if (xfield != null) {
            if (xfield.isVolatile()) {
                ((ValueNumberFrame)this.getFrame()).killAllLoads();
            }
            if (this.doRedundantLoadElimination()) {
                this.loadInstanceField(xfield, (Instruction)obj);
                return;
            }
        }
        this.handleNormalInstruction((Instruction)obj);
    }

    @Override
    public void visitPUTFIELD(PUTFIELD obj) {
        XField xfield;
        if (this.doForwardSubstitution() && (xfield = Hierarchy.findXField((FieldInstruction)obj, this.getCPG())) != null) {
            this.storeInstanceField(xfield, (Instruction)obj, false);
            return;
        }
        this.handleNormalInstruction((Instruction)obj);
    }

    @Override
    public void visitGETSTATIC(GETSTATIC obj) {
        ConstantPoolGen cpg = this.getCPG();
        String fieldName = obj.getName(cpg);
        String fieldSig = obj.getSignature(cpg);
        ValueNumberFrame frame = (ValueNumberFrame)this.getFrame();
        if (RLE_DEBUG) {
            System.out.println("GETSTATIC of " + fieldName + " : " + fieldSig);
        }
        if (fieldName.startsWith("class$") && "Ljava/lang/Class;".equals(fieldSig)) {
            String className = fieldName.substring("class$".length()).replace('$', '.');
            if (RLE_DEBUG) {
                System.out.println("[found load of class object " + className + "]");
            }
            ValueNumber value = this.factory.getClassObjectValue(className);
            frame.pushValue(value);
            return;
        }
        XField xfield = Hierarchy.findXField((FieldInstruction)obj, this.getCPG());
        if (xfield != null) {
            if (xfield.isVolatile()) {
                ((ValueNumberFrame)this.getFrame()).killAllLoads();
            }
            if (this.doRedundantLoadElimination()) {
                this.loadStaticField(xfield, (Instruction)obj);
                return;
            }
        }
        this.handleNormalInstruction((Instruction)obj);
    }

    @Override
    public void visitPUTSTATIC(PUTSTATIC obj) {
        XField xfield;
        if (this.doForwardSubstitution() && (xfield = Hierarchy.findXField((FieldInstruction)obj, this.getCPG())) != null) {
            this.storeStaticField(xfield, (Instruction)obj, false);
            return;
        }
        this.handleNormalInstruction((Instruction)obj);
    }

    @Override
    public void visitINVOKESTATIC(INVOKESTATIC obj) {
        block15: {
            if (REDUNDANT_LOAD_ELIMINATION) {
                XField xfield;
                ConstantPoolGen cpg = this.getCPG();
                String targetClassName = obj.getClassName(cpg);
                String methodName = obj.getName(cpg);
                String methodSig = obj.getSignature(cpg);
                if (("forName".equals(methodName) && "java.lang.Class".equals(targetClassName) || "class$".equals(methodName)) && "(Ljava/lang/String;)Ljava/lang/Class;".equals(methodSig)) {
                    ValueNumberFrame frame = (ValueNumberFrame)this.getFrame();
                    try {
                        ValueNumber arg = (ValueNumber)frame.getTopValue();
                        String className = this.stringConstantMap.get(arg);
                        if (className != null) {
                            frame.popValue();
                            if (RLE_DEBUG) {
                                System.out.println("[found access of class object " + className + "]");
                            }
                            frame.pushValue(this.factory.getClassObjectValue(className));
                            return;
                        }
                        break block15;
                    }
                    catch (DataflowAnalysisException e) {
                        throw new InvalidBytecodeException("stack underflow", this.methodGen, this.handle, e);
                    }
                }
                if (Hierarchy.isInnerClassAccess(obj, cpg) && (xfield = this.loadedFieldSet.getField(this.handle)) != null) {
                    if (this.loadedFieldSet.instructionIsLoad(this.handle)) {
                        if (this.doRedundantLoadElimination()) {
                            if (xfield.isStatic()) {
                                this.loadStaticField(xfield, (Instruction)obj);
                            } else {
                                this.loadInstanceField(xfield, (Instruction)obj);
                            }
                            return;
                        }
                    } else if (this.doForwardSubstitution()) {
                        boolean pushValue;
                        boolean bl = pushValue = !methodSig.endsWith(")V");
                        if (xfield.isStatic()) {
                            this.storeStaticField(xfield, (Instruction)obj, pushValue);
                        } else {
                            this.storeInstanceField(xfield, (Instruction)obj, pushValue);
                        }
                        return;
                    }
                }
            }
        }
        this.handleNormalInstruction((Instruction)obj);
    }

    private void killLoadsOfObjectsPassed(INVOKEDYNAMIC ins) {
        try {
            int passed = this.getNumWordsConsumed((Instruction)ins);
            ValueNumber[] arguments = ValueNumberFrameModelingVisitor.allocateValueNumberArray(passed);
            ((ValueNumberFrame)this.getFrame()).getTopStackWords(arguments);
            for (ValueNumber v : arguments) {
                ((ValueNumberFrame)this.getFrame()).killAllLoadsOf(v);
            }
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError("Error in killLoadsOfObjectsPassed", e);
        }
    }

    private void killLoadsOfObjectsPassed(InvokeInstruction ins) {
        try {
            FindNoSideEffectMethods.NoSideEffectMethodsDatabase nse;
            XMethod called = Hierarchy2.findExactMethod(ins, this.methodGen.getConstantPool(), Hierarchy.ANY_METHOD);
            if (called != null && (nse = Global.getAnalysisCache().getOptionalDatabase(FindNoSideEffectMethods.NoSideEffectMethodsDatabase.class)) != null && !nse.is(called.getMethodDescriptor(), FindNoSideEffectMethods.MethodSideEffectStatus.SE, FindNoSideEffectMethods.MethodSideEffectStatus.OBJ)) {
                return;
            }
            FieldSummary fieldSummary = AnalysisContext.currentAnalysisContext().getFieldSummary();
            Set<XField> touched = fieldSummary.getFieldsWritten(called);
            if (!touched.isEmpty()) {
                ((ValueNumberFrame)this.getFrame()).killLoadsOf(touched);
            }
            int passed = this.getNumWordsConsumed((Instruction)ins);
            ValueNumber[] arguments = ValueNumberFrameModelingVisitor.allocateValueNumberArray(passed);
            ((ValueNumberFrame)this.getFrame()).killLoadsWithSimilarName(ins.getClassName(this.cpg), ins.getMethodName(this.cpg));
            ((ValueNumberFrame)this.getFrame()).getTopStackWords(arguments);
            for (ValueNumber v : arguments) {
                ((ValueNumberFrame)this.getFrame()).killAllLoadsOf(v);
            }
            ((ValueNumberFrame)this.getFrame()).killAllLoads(true);
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError("Error in killLoadsOfObjectsPassed", e);
        }
    }

    @Override
    public void visitMONITORENTER(MONITORENTER obj) {
        ValueNumber topValue = null;
        try {
            topValue = (ValueNumber)((ValueNumberFrame)this.getFrame()).getStackValue(0);
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError("error handling monitor enter in value numbering", e);
        }
        ((ValueNumberFrame)this.getFrame()).killAllLoadsExceptFor(topValue);
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitInvokeOnException(Instruction obj) {
        String methodName;
        if (!REDUNDANT_LOAD_ELIMINATION || !((ValueNumberFrame)this.getFrame()).hasAvailableLoads()) {
            return;
        }
        if (obj instanceof INVOKEDYNAMIC) {
            this.killLoadsOfObjectsPassed((INVOKEDYNAMIC)obj);
            return;
        }
        InvokeInstruction inv = (InvokeInstruction)obj;
        if ((inv instanceof INVOKEINTERFACE || inv instanceof INVOKEVIRTUAL) && inv.getMethodName(this.cpg).toLowerCase().indexOf("lock") >= 0) {
            ((ValueNumberFrame)this.getFrame()).killAllLoads();
            return;
        }
        if (inv instanceof INVOKEVIRTUAL && "cast".equals(inv.getMethodName(this.cpg)) && "java.lang.Class".equals(inv.getClassName(this.cpg))) {
            return;
        }
        if (inv instanceof INVOKESTATIC && (("forName".equals(methodName = inv.getName(this.cpg)) && "java.lang.Class".equals(inv.getClassName(this.cpg)) || "class$".equals(methodName)) && "(Ljava/lang/String;)Ljava/lang/Class;".equals(inv.getSignature(this.cpg)) || Hierarchy.isInnerClassAccess((INVOKESTATIC)inv, this.cpg) && this.loadedFieldSet.getField(this.handle) != null)) {
            return;
        }
        this.killLoadsOfObjectsPassed(inv);
        if (inv instanceof INVOKESTATIC) {
            ((ValueNumberFrame)this.getFrame()).killAllLoadsOf(null);
        }
    }

    @Override
    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL obj) {
        if ("cast".equals(obj.getMethodName(this.cpg)) && "java.lang.Class".equals(obj.getClassName(this.cpg))) {
            try {
                ValueNumberFrame frame = (ValueNumberFrame)this.getFrame();
                ValueNumber resultType = (ValueNumber)frame.popValue();
                frame.popValue();
                frame.pushValue(resultType);
            }
            catch (DataflowAnalysisException e) {
                AnalysisContext.logError("oops", e);
            }
            return;
        }
        this.handleNormalInstruction((Instruction)obj);
    }

    @Override
    public void visitACONST_NULL(ACONST_NULL obj) {
        ValueNumber[] inputValueList = this.popInputValues(0);
        ValueNumber[] outputValueList = this.getOutputValues(inputValueList, 1, 16);
        if (VERIFY_INTEGRITY) {
            this.checkConsumedAndProducedValues((Instruction)obj, inputValueList, outputValueList);
        }
        this.pushOutputValues(outputValueList);
    }

    @Override
    public void visitLDC(LDC obj) {
        ValueNumber value;
        Object constantValue = obj.getValue(this.cpg);
        if (constantValue instanceof ConstantClass) {
            ConstantClass constantClass = (ConstantClass)constantValue;
            String className = constantClass.getBytes(this.cpg.getConstantPool());
            value = this.factory.getClassObjectValue(className);
        } else if (constantValue instanceof ObjectType) {
            ObjectType objectType = (ObjectType)constantValue;
            String className = objectType.getClassName();
            value = this.factory.getClassObjectValue(className);
        } else {
            value = this.constantValueMap.get(constantValue);
            if (value == null) {
                value = this.factory.createFreshValue(16);
                this.constantValueMap.put(constantValue, value);
                if (constantValue instanceof String) {
                    this.stringConstantMap.put(value, (String)constantValue);
                }
            }
        }
        ((ValueNumberFrame)this.getFrame()).pushValue(value);
    }

    @Override
    public void visitIINC(IINC obj) {
        if (obj.getIncrement() == 0) {
            return;
        }
        int local = obj.getIndex();
        ValueNumber[] input = new ValueNumber[]{(ValueNumber)((ValueNumberFrame)this.getFrame()).getValue(local)};
        ValueNumberCache.Entry entry = new ValueNumberCache.Entry(this.handle, input);
        ValueNumber[] output = this.cache.lookupOutputValues(entry);
        if (output == null) {
            output = new ValueNumber[]{this.factory.createFreshValue()};
            this.cache.addOutputValues(entry, output);
        }
        ((ValueNumberFrame)this.getFrame()).setValue(local, output[0]);
    }

    @Override
    public void visitCHECKCAST(CHECKCAST obj) {
    }

    private ValueNumber[] popInputValues(int numWordsConsumed) {
        ValueNumberFrame frame = (ValueNumberFrame)this.getFrame();
        ValueNumber[] inputValueList = ValueNumberFrameModelingVisitor.allocateValueNumberArray(numWordsConsumed);
        try {
            frame.getTopStackWords(inputValueList);
            while (numWordsConsumed-- > 0) {
                frame.popValue();
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException("Error getting input operands", e);
        }
        return inputValueList;
    }

    private void pushOutputValues(ValueNumber[] outputValueList) {
        ValueNumberFrame frame = (ValueNumberFrame)this.getFrame();
        for (ValueNumber aOutputValueList : outputValueList) {
            frame.pushValue(aOutputValueList);
        }
    }

    private ValueNumber[] getOutputValues(ValueNumber[] inputValueList, int numWordsProduced) {
        return this.getOutputValues(inputValueList, numWordsProduced, 0);
    }

    private ValueNumber[] getOutputValues(ValueNumber[] inputValueList, int numWordsProduced, int flags) {
        ValueNumberCache.Entry entry = new ValueNumberCache.Entry(this.handle, inputValueList);
        ValueNumber[] outputValueList = this.cache.lookupOutputValues(entry);
        if (outputValueList == null) {
            outputValueList = ValueNumberFrameModelingVisitor.allocateValueNumberArray(numWordsProduced);
            for (int i = 0; i < numWordsProduced; ++i) {
                ValueNumber freshValue;
                outputValueList[i] = freshValue = this.factory.createFreshValue(flags);
            }
            this.cache.addOutputValues(entry, outputValueList);
        }
        return outputValueList;
    }

    private static ValueNumber[] allocateValueNumberArray(int size) {
        if (size == 0) {
            return EMPTY_INPUT_VALUE_LIST;
        }
        return new ValueNumber[size];
    }

    private static String vlts(ValueNumber[] vl) {
        StringBuilder buf = new StringBuilder();
        for (ValueNumber aVl : vl) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(aVl.getNumber());
        }
        return buf.toString();
    }

    private void loadInstanceField(XField instanceField, Instruction obj) {
        if (RLE_DEBUG) {
            System.out.println("[loadInstanceField for field " + String.valueOf(instanceField) + " in instruction " + String.valueOf(this.handle));
        }
        ValueNumberFrame frame = (ValueNumberFrame)this.getFrame();
        try {
            ValueNumber[] loadedValue;
            ValueNumber reference = (ValueNumber)frame.popValue();
            AvailableLoad availableLoad = new AvailableLoad(reference, instanceField);
            if (RLE_DEBUG) {
                System.out.println("[getfield of " + String.valueOf(availableLoad) + "]");
            }
            if ((loadedValue = frame.getAvailableLoad(availableLoad)) == null) {
                ValueNumber[] inputValueList = new ValueNumber[]{reference};
                loadedValue = this.getOutputValues(inputValueList, this.getNumWordsProduced(obj));
                frame.addAvailableLoad(availableLoad, loadedValue);
                if (RLE_DEBUG) {
                    System.out.println("[Making load available " + String.valueOf(availableLoad) + " <- " + ValueNumberFrameModelingVisitor.vlts(loadedValue) + "]");
                }
            } else if (RLE_DEBUG) {
                System.out.println("[Found available load " + String.valueOf(availableLoad) + " <- " + ValueNumberFrameModelingVisitor.vlts(loadedValue) + "]");
            }
            this.pushOutputValues(loadedValue);
            if (VERIFY_INTEGRITY) {
                this.checkConsumedAndProducedValues(obj, new ValueNumber[]{reference}, loadedValue);
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException("Error loading from instance field", e);
        }
    }

    private void loadStaticField(XField staticField, Instruction obj) {
        AvailableLoad availableLoad;
        ValueNumberFrame frame;
        ValueNumber[] loadedValue;
        if (RLE_DEBUG) {
            System.out.println("[loadStaticField for field " + String.valueOf(staticField) + " in instruction " + String.valueOf(this.handle));
        }
        if ((loadedValue = (frame = (ValueNumberFrame)this.getFrame()).getAvailableLoad(availableLoad = new AvailableLoad(staticField))) == null) {
            int numWordsProduced = this.getNumWordsProduced(obj);
            loadedValue = this.getOutputValues(EMPTY_INPUT_VALUE_LIST, numWordsProduced);
            frame.addAvailableLoad(availableLoad, loadedValue);
            if (RLE_DEBUG) {
                System.out.println("[making load of " + String.valueOf(staticField) + " available]");
            }
        } else if (RLE_DEBUG) {
            System.out.println("[found available load of " + String.valueOf(staticField) + "]");
        }
        if (VERIFY_INTEGRITY) {
            this.checkConsumedAndProducedValues(obj, EMPTY_INPUT_VALUE_LIST, loadedValue);
        }
        this.pushOutputValues(loadedValue);
    }

    private void storeInstanceField(XField instanceField, Instruction obj, boolean pushStoredValue) {
        if (RLE_DEBUG) {
            System.out.println("[storeInstanceField for field " + String.valueOf(instanceField) + " in instruction " + String.valueOf(this.handle));
        }
        ValueNumberFrame frame = (ValueNumberFrame)this.getFrame();
        int numWordsConsumed = this.getNumWordsConsumed(obj);
        ValueNumber[] inputValueList = this.popInputValues(numWordsConsumed);
        ValueNumber reference = inputValueList[0];
        ValueNumber[] storedValue = ValueNumberFrameModelingVisitor.allocateValueNumberArray(inputValueList.length - 1);
        System.arraycopy(inputValueList, 1, storedValue, 0, inputValueList.length - 1);
        if (pushStoredValue) {
            this.pushOutputValues(storedValue);
        }
        frame.killLoadsOfField(instanceField);
        frame.addAvailableLoad(new AvailableLoad(reference, instanceField), storedValue);
        if (RLE_DEBUG) {
            System.out.println("[making store of " + String.valueOf(instanceField) + " available]");
        }
        if (VERIFY_INTEGRITY) {
            this.checkConsumedAndProducedValues(obj, inputValueList, pushStoredValue ? storedValue : EMPTY_INPUT_VALUE_LIST);
        }
    }

    private void storeStaticField(XField staticField, Instruction obj, boolean pushStoredValue) {
        if (RLE_DEBUG) {
            System.out.println("[storeStaticField for field " + String.valueOf(staticField) + " in instruction " + String.valueOf(this.handle));
        }
        ValueNumberFrame frame = (ValueNumberFrame)this.getFrame();
        AvailableLoad availableLoad = new AvailableLoad(staticField);
        int numWordsConsumed = this.getNumWordsConsumed(obj);
        ValueNumber[] inputValueList = this.popInputValues(numWordsConsumed);
        if (pushStoredValue) {
            this.pushOutputValues(inputValueList);
        }
        frame.killLoadsOfField(staticField);
        frame.addAvailableLoad(availableLoad, inputValueList);
        if (RLE_DEBUG) {
            System.out.println("[making store of " + String.valueOf(staticField) + " available]");
        }
        if (VERIFY_INTEGRITY) {
            this.checkConsumedAndProducedValues(obj, inputValueList, pushStoredValue ? inputValueList : EMPTY_INPUT_VALUE_LIST);
        }
    }
}

