/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.generic;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.generic.GenericObjectType;
import edu.umd.cs.findbugs.ba.generic.GenericSignatureParser;
import edu.umd.cs.findbugs.ba.type.NullType;
import edu.umd.cs.findbugs.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class GenericUtilities {
    public static final TypeCategory getTypeCategory(Type type) {
        if (type instanceof GenericObjectType) {
            return ((GenericObjectType)type).getTypeCategory();
        }
        if (type instanceof ObjectType || type instanceof NullType) {
            return TypeCategory.PLAIN_OBJECT_TYPE;
        }
        if (type instanceof ArrayType) {
            return TypeCategory.ARRAY_TYPE;
        }
        throw new IllegalArgumentException("Not a reference type: " + String.valueOf(type));
    }

    public static final boolean isPlainObject(Type type) {
        return GenericUtilities.getTypeCategory(type) == TypeCategory.PLAIN_OBJECT_TYPE;
    }

    public static final String getString(Type type) {
        if (type instanceof GenericObjectType) {
            return ((GenericObjectType)type).toString(true);
        }
        if (type instanceof ArrayType) {
            return TypeCategory.asString((ArrayType)type);
        }
        return type.toString();
    }

    static String stripAngleBrackets(String s) {
        if (s.indexOf(60) == -1) {
            return s;
        }
        StringBuilder result = new StringBuilder(s.length());
        int nesting = 0;
        boolean seenLeftBracket = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<') {
                ++nesting;
                seenLeftBracket = true;
                continue;
            }
            if (c == '>') {
                --nesting;
                continue;
            }
            if (nesting != 0) continue;
            if (seenLeftBracket && c == '.') {
                result.append('$');
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static GenericObjectType getType(String className, List<? extends ReferenceType> parameters) {
        return new GenericObjectType(className, parameters);
    }

    @CheckForNull
    public static Type getType(String signature) {
        try {
            Iterator<String> signatureIterator = new GenericSignatureParser("(" + signature + ")V").parameterSignatureIterator();
            signature = signatureIterator.next();
            if (signatureIterator.hasNext()) {
                throw new IllegalArgumentException("the following signature does not contain exactly one type: " + signature);
            }
            int index = 0;
            if (signature.startsWith("L")) {
                index = GenericUtilities.lastMatchedLeftAngleBracket(signature);
                if (index < 0) {
                    return Type.getType((String)GenericUtilities.stripAngleBrackets(signature));
                }
                String typeParameters = signature.substring(index + 1, GenericUtilities.nextUnmatchedRightAngleBracket(signature, index + 1));
                List<ReferenceType> parameters = GenericUtilities.getTypeParameters(typeParameters);
                if (parameters == null) {
                    return null;
                }
                String baseType = GenericUtilities.removeMatchedAngleBrackets(signature.substring(1, index)).replace('.', '$');
                return new GenericObjectType(baseType, parameters);
            }
            if (signature.startsWith("T")) {
                String var;
                int i = signature.indexOf(59);
                if (i > 0 && (var = signature.substring(1, i)).indexOf(60) == -1) {
                    return new GenericObjectType(var);
                }
                return null;
            }
            if (signature.startsWith("[")) {
                ++index;
                while (signature.charAt(index) == '[') {
                    ++index;
                }
                Type componentType = GenericUtilities.getType(signature.substring(index));
                if (componentType == null) {
                    return null;
                }
                return new ArrayType(componentType, index);
            }
            if (signature.startsWith("*")) {
                return new GenericObjectType("*");
            }
            if (signature.startsWith("+") || signature.startsWith("-")) {
                Type baseType = GenericUtilities.getType(signature.substring(1));
                if (baseType == null) {
                    return null;
                }
                return new GenericObjectType(signature.substring(0, 1), (ReferenceType)baseType);
            }
            return Type.getType((String)signature);
        }
        catch (IllegalStateException e) {
            AnalysisContext.logError("Error parsing signature " + signature, e);
            return null;
        }
    }

    public static ObjectType merge(@CheckForNull Type t1, ObjectType t2) {
        if (t1 instanceof GenericObjectType) {
            return GenericUtilities.merge((GenericObjectType)t1, t2);
        }
        return t2;
    }

    public static Type merge(@CheckForNull GenericObjectType t1, Type t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 instanceof ObjectType) {
            return GenericUtilities.merge(t1, (ObjectType)t2);
        }
        if (t2 instanceof NullType) {
            return t1;
        }
        return t2;
    }

    public static ObjectType merge(@CheckForNull GenericObjectType t1, ObjectType t2) {
        if (t1 == null || t2 instanceof GenericObjectType) {
            return t2;
        }
        List<? extends ReferenceType> parameters = t1.getParameters();
        if (parameters == null) {
            return t2;
        }
        return new GenericObjectType(t2.getClassName(), parameters);
    }

    public static String removeMatchedAngleBrackets(String s) {
        int first = s.indexOf(60);
        if (first < 0) {
            return s;
        }
        StringBuilder result = new StringBuilder(s.substring(0, first));
        int pos = first;
        int nesting = 0;
        while (pos < s.length()) {
            char c;
            if ((c = s.charAt(pos++)) == '<') {
                ++nesting;
                continue;
            }
            if (c == '>') {
                --nesting;
                continue;
            }
            if (nesting != 0) continue;
            result.append(c);
        }
        return result.toString();
    }

    public static int nextUnmatchedRightAngleBracket(String s, int startingAt) {
        int nesting = 0;
        int pos = startingAt;
        while (pos >= 0) {
            char c = s.charAt(pos);
            if (c == '>') {
                if (nesting == 0) {
                    return pos;
                }
                --nesting;
            } else if (c == '<') {
                ++nesting;
            }
            ++pos;
        }
        return -1;
    }

    public static int lastMatchedLeftAngleBracket(String s) {
        int nesting = 0;
        int pos = s.length() - 2;
        while (pos >= 0) {
            char c = s.charAt(pos);
            if (c == '<') {
                if (--nesting == 0) {
                    return pos;
                }
            } else if (c == '>') {
                ++nesting;
            } else if (nesting == 0) {
                return -1;
            }
            --pos;
        }
        return -1;
    }

    @CheckForNull
    public static final List<ReferenceType> getTypeParameters(String signature) {
        GenericSignatureParser parser = new GenericSignatureParser("(" + signature + ")V");
        ArrayList<ReferenceType> types = new ArrayList<ReferenceType>();
        Iterator<String> iter = parser.parameterSignatureIterator();
        while (iter.hasNext()) {
            String parameterString = iter.next();
            ReferenceType t = (ReferenceType)GenericUtilities.getType(parameterString);
            if (t == null) {
                return null;
            }
            types.add(t);
        }
        return types;
    }

    public static final List<String> split(String signature, boolean skipInitialAngleBracket) {
        int start;
        ArrayList<String> result = new ArrayList<String>();
        if (signature.charAt(0) != '<') {
            skipInitialAngleBracket = false;
        }
        int depth = 0;
        block5: for (int pos = start = 0; pos < signature.length(); ++pos) {
            switch (signature.charAt(pos)) {
                case '<': {
                    ++depth;
                    continue block5;
                }
                case '>': {
                    if (--depth != 0 || !skipInitialAngleBracket) continue block5;
                    skipInitialAngleBracket = false;
                    start = pos + 1;
                    continue block5;
                }
                case ';': {
                    if (depth > 0) continue block5;
                    String substring = signature.substring(start, pos + 1);
                    result.add(substring);
                    start = pos + 1;
                    continue block5;
                }
            }
        }
        if (depth != 0) {
            throw new IllegalArgumentException("Unbalanced signature: " + signature);
        }
        return result;
    }

    public static enum TypeCategory {
        PLAIN_OBJECT_TYPE{

            @Override
            public ReferenceType produce(GenericObjectType obj) {
                return obj;
            }

            @Override
            public String asString(GenericObjectType obj) {
                return GenericUtilities.getString((Type)obj);
            }
        }
        ,
        ARRAY_TYPE{

            @Override
            public ReferenceType produce(GenericObjectType obj) {
                return obj;
            }

            @Override
            public String asString(GenericObjectType obj) {
                return GenericUtilities.getString((Type)obj);
            }
        }
        ,
        PARAMETERIZED{

            @Override
            public ReferenceType produce(GenericObjectType obj) {
                return obj;
            }

            @Override
            public String asString(GenericObjectType obj) {
                StringBuilder b = new StringBuilder(obj.toPlainString());
                b.append("<");
                boolean first = true;
                for (Type type : obj.parameters) {
                    if (!first) {
                        b.append(",");
                    }
                    first = false;
                    b.append(GenericUtilities.getString(type));
                }
                b.append(">");
                return b.toString();
            }
        }
        ,
        TYPE_VARIABLE{

            @Override
            public ReferenceType produce(GenericObjectType obj) {
                return Type.OBJECT;
            }

            @Override
            public String asString(GenericObjectType obj) {
                return obj.variable;
            }
        }
        ,
        WILDCARD{

            @Override
            public ReferenceType produce(GenericObjectType obj) {
                return Type.OBJECT;
            }

            @Override
            public String asString(GenericObjectType obj) {
                return "?";
            }
        }
        ,
        WILDCARD_EXTENDS{

            @Override
            public ReferenceType produce(GenericObjectType obj) {
                return obj.extension;
            }

            @Override
            public String asString(GenericObjectType obj) {
                ReferenceType extension = obj.extension;
                assert (extension != null);
                return "? extends " + GenericUtilities.getString((Type)extension);
            }
        }
        ,
        WILDCARD_SUPER{

            @Override
            public ReferenceType produce(GenericObjectType obj) {
                return Type.OBJECT;
            }

            @Override
            public String asString(GenericObjectType obj) {
                ReferenceType extension = obj.extension;
                assert (extension != null);
                return "? super " + GenericUtilities.getString((Type)extension);
            }
        };


        public abstract String asString(GenericObjectType var1);

        public abstract ReferenceType produce(GenericObjectType var1);

        public static String asString(ArrayType atype) {
            Type obj = atype.getBasicType();
            String result = GenericUtilities.getString(obj);
            return result + Util.repeat("[]", atype.getDimensions());
        }
    }
}

