/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.AbstractDataflowAnalysis;
import edu.umd.cs.findbugs.ba.BlockOrder;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.ReverseDFSOrder;
import edu.umd.cs.findbugs.ba.ReverseDepthFirstSearch;

public abstract class BackwardDataflowAnalysis<Fact>
extends AbstractDataflowAnalysis<Fact> {
    private final ReverseDepthFirstSearch rdfs;
    private final DepthFirstSearch dfs;

    protected BackwardDataflowAnalysis(ReverseDepthFirstSearch rdfs, DepthFirstSearch dfs) {
        if (rdfs == null || dfs == null) {
            throw new IllegalArgumentException();
        }
        this.rdfs = rdfs;
        this.dfs = dfs;
    }

    protected ReverseDepthFirstSearch getReverseDepthFirstSearch() {
        return this.rdfs;
    }

    @Override
    public boolean isForwards() {
        return false;
    }

    @Override
    public BlockOrder getBlockOrder(CFG cfg) {
        return new ReverseDFSOrder(cfg, this.rdfs, this.dfs);
    }
}

