/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.WarningComparator;
import edu.umd.cs.findbugs.model.ClassNameRewriter;
import edu.umd.cs.findbugs.model.ClassNameRewriterUtil;
import edu.umd.cs.findbugs.model.IdentityClassNameRewriter;

public class SloppyBugComparator
implements WarningComparator {
    private static final boolean DEBUG = SystemProperties.getBoolean("sloppyComparator.debug");
    private ClassNameRewriter classNameRewriter = IdentityClassNameRewriter.instance();

    @Override
    public void setClassNameRewriter(ClassNameRewriter classNameRewriter) {
        this.classNameRewriter = classNameRewriter;
    }

    private int compareNullElements(Object lhs, Object rhs) {
        if (lhs == null && rhs == null) {
            return 0;
        }
        return lhs == null ? -1 : 1;
    }

    private int compareClassesAllowingNull(ClassAnnotation lhs, ClassAnnotation rhs) {
        if (lhs == null || rhs == null) {
            return this.compareNullElements(lhs, rhs);
        }
        String lhsClassName = this.classNameRewriter.rewriteClassName(lhs.getClassName());
        String rhsClassName = this.classNameRewriter.rewriteClassName(rhs.getClassName());
        if (DEBUG) {
            System.err.println("Comparing " + lhsClassName + " and " + rhsClassName);
        }
        int cmp = lhsClassName.compareTo(rhsClassName);
        if (DEBUG) {
            System.err.println("\t==> " + cmp);
        }
        return cmp;
    }

    private int compareMethodsAllowingNull(MethodAnnotation lhs, MethodAnnotation rhs) {
        if (lhs == null || rhs == null) {
            return this.compareNullElements(lhs, rhs);
        }
        lhs = this.convertMethod(lhs);
        rhs = this.convertMethod(rhs);
        return lhs.compareTo(rhs);
    }

    private int compareFieldsAllowingNull(FieldAnnotation lhs, FieldAnnotation rhs) {
        if (lhs == null || rhs == null) {
            return this.compareNullElements(lhs, rhs);
        }
        lhs = this.convertField(lhs);
        rhs = this.convertField(rhs);
        if (DEBUG) {
            System.err.println("Compare fields: " + String.valueOf(lhs) + " and " + String.valueOf(rhs));
        }
        return lhs.compareTo(rhs);
    }

    private MethodAnnotation convertMethod(MethodAnnotation methodAnnotation) {
        return ClassNameRewriterUtil.convertMethodAnnotation(this.classNameRewriter, methodAnnotation);
    }

    private FieldAnnotation convertField(FieldAnnotation fieldAnnotation) {
        return ClassNameRewriterUtil.convertFieldAnnotation(this.classNameRewriter, fieldAnnotation);
    }

    @Override
    public int compare(BugInstance lhs, BugInstance rhs) {
        String rhsAbbrev;
        BugPattern lhsPattern = lhs.getBugPattern();
        BugPattern rhsPattern = rhs.getBugPattern();
        String lhsAbbrev = lhsPattern.getAbbrev();
        int cmp = lhsAbbrev.compareTo(rhsAbbrev = rhsPattern.getAbbrev());
        if (cmp != 0) {
            if (DEBUG) {
                System.err.println("bug abbrevs do not match");
            }
            return cmp;
        }
        cmp = this.compareClassesAllowingNull(lhs.getPrimaryClass(), rhs.getPrimaryClass());
        if (cmp != 0) {
            return cmp;
        }
        boolean havePrimaryMethods = lhs.getPrimaryMethod() != null && rhs.getPrimaryMethod() != null;
        cmp = this.compareMethodsAllowingNull(lhs.getPrimaryMethod(), rhs.getPrimaryMethod());
        if (cmp != 0) {
            if (DEBUG) {
                System.err.println("primary methods do not match");
            }
            return cmp;
        }
        if (!havePrimaryMethods && (cmp = this.compareFieldsAllowingNull(lhs.getPrimaryField(), rhs.getPrimaryField())) != 0) {
            if (DEBUG) {
                System.err.println("primary fields do not match");
            }
            return cmp;
        }
        return 0;
    }
}

