/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.IOException;
import java.io.Serializable;

public class BugProperty
implements XMLWriteable,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String IS_BUG = "isBug";
    public static final String SEVERITY = "severity";
    private final String name;
    private String value;
    private BugProperty next;

    BugProperty(String name, String value) {
        this.name = name.intern();
        this.value = value;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean getValueAsBoolean() {
        return Boolean.parseBoolean(this.getValue());
    }

    public int getValueAsInt() {
        return Integer.parseInt(this.getValue());
    }

    public void setValue(String value) {
        this.value = value;
    }

    void setNext(BugProperty next) {
        this.next = next;
    }

    BugProperty getNext() {
        return this.next;
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        xmlOutput.openCloseTag("Property", new XMLAttributeList().addAttribute("name", this.getName()).addAttribute("value", this.getValue()));
    }
}

