/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Button;
import controlP5.CP;
import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.MultiList;
import controlP5.MultiListInterface;

public class MultiListButton
extends Button
implements MultiListInterface {
    private Controller parent;
    private MultiList root;
    private int[] _myRect = new int[4];
    protected int _myDirection = 39;
    private boolean isUpperCase = true;

    protected MultiListButton(ControlP5 controlP5, String string, float f, int n, int n2, int n3, int n4, Controller controller, MultiList multiList) {
        super(controlP5, (ControllerGroup)multiList.getParent(), string, f, n, n2, n3, n4);
        this.parent = controller;
        this.root = multiList;
        this.updateRect(MultiListButton.x(this.position), MultiListButton.y(this.position), this.getWidth(), this.getHeight());
        this._myCaptionLabel.align(37, 3);
    }

    @Override
    public MultiListButton toUpperCase(boolean bl) {
        this.isUpperCase = bl;
        for (Controller<?> controller : this.getSubelements()) {
            controller.getCaptionLabel().toUpperCase(this.isUpperCase);
        }
        this._myCaptionLabel.toUpperCase(this.isUpperCase);
        return this;
    }

    @Override
    public void remove() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.parent.getSubelements().size(); ++n) {
            if (this.parent.getSubelements().get(n) == this) {
                n2 = this.getHeight() + 1;
            }
            ((MultiListButton)this.parent.getSubelements().get(n)).updateLocation(0.0f, -n2);
        }
        if (this._myParent != null) {
            this.removeListener(this.root);
            this._myParent.remove(this);
        }
        if (this.cp5 != null) {
            this.removeListener(this.root);
            this.cp5.remove(this);
        }
        for (n = 0; n < this.getSubelements().size(); ++n) {
            ((MultiListButton)this.getSubelements().get(n)).remove();
        }
    }

    @Override
    public int getDirection() {
        return this._myDirection;
    }

    protected void setDirection(int n) {
        this._myDirection = n;
    }

    public void updateRect(float f, float f2, float f3, float f4) {
        this._myRect = new int[]{(int)f, (int)f2, (int)f3, (int)f4};
    }

    @Override
    public void updateLocation(float f, float f2) {
        MultiListButton.set(this.position, f, f2);
        this.updateRect(MultiListButton.x(this.position), MultiListButton.y(this.position), this.getWidth(), this.getHeight());
        for (int i = 0; i < this.getSubelements().size(); ++i) {
            ((MultiListInterface)((Object)this.getSubelements().get(i))).updateLocation(f, f2);
        }
    }

    @Override
    public MultiListButton setWidth(int n) {
        int n2 = this._myDirection == 37 ? n - this.getWidth() : 0;
        super.setWidth(n);
        this.updateLocation(-n2, 0.0f);
        return this;
    }

    @Override
    public MultiListButton setHeight(int n) {
        int n2 = this.getHeight();
        super.setHeight(n);
        n2 = this.getHeight() - n2;
        int n3 = 0;
        for (int i = 0; i < this.parent.getSubelements().size(); ++i) {
            if (!(this.parent.getSubelements().get(i) instanceof MultiListInterface)) continue;
            ((MultiListInterface)((Object)this.parent.getSubelements().get(i))).updateLocation(0.0f, n3);
            if (this.parent.getSubelements().get(i) != this) continue;
            n3 = n2;
        }
        this.updateLocation(0.0f, 0.0f);
        return this;
    }

    public MultiListButton add(String string, float f) {
        int n;
        int n2 = -(this.getHeight() + 1);
        for (n = 0; n < this.getSubelements().size(); ++n) {
            n2 += this.getSubelements().get(n).getHeight() + 1;
        }
        n = (int)MultiListButton.x(this.position) + (this.getWidth() + 1);
        MultiListButton multiListButton = new MultiListButton(this.cp5, string, f, n, (int)MultiListButton.y(this.position) + (this.getHeight() + 1) + n2, this.getWidth(), this.getHeight(), this, this.root);
        multiListButton.isMoveable = false;
        multiListButton.toUpperCase(this.isUpperCase);
        multiListButton.hide();
        this.cp5.register(null, "", multiListButton);
        multiListButton.addListener(this.root);
        this.getSubelements().add(multiListButton);
        this.updateRect(n, MultiListButton.y(this.position), this.getWidth(), this.getHeight() + 1 + n2);
        return multiListButton;
    }

    @Override
    protected void onEnter() {
        if (!this.root.isUpdateLocation) {
            this.isActive = true;
            this.root.occupied(true);
            this.root.mostRecent = this;
            if (this.parent instanceof MultiListInterface) {
                ((MultiListInterface)((Object)this.parent)).close(this);
            }
            this.open();
        }
    }

    @Override
    protected void onLeave() {
        if (this.parent instanceof MultiListInterface && !((MultiListInterface)((Object)this.parent)).observe() && !this.root.isUpdateLocation && this.root.mostRecent == this) {
            this.isActive = false;
            this.root.occupied(false);
        }
    }

    @Override
    public void mouseReleasedOutside() {
    }

    @Override
    public boolean observe() {
        return CP.inside(this._myRect, this._myControlWindow.mouseX, this._myControlWindow.mouseY);
    }

    @Override
    public void close(MultiListInterface multiListInterface) {
        for (int i = 0; i < this.getSubelements().size(); ++i) {
            if (multiListInterface == (MultiListInterface)((Object)this.getSubelements().get(i))) continue;
            ((MultiListInterface)((Object)this.getSubelements().get(i))).close();
        }
    }

    @Override
    public void close() {
        for (int i = 0; i < this.getSubelements().size(); ++i) {
            ((MultiListButton)this.getSubelements().get(i)).close();
            ((MultiListButton)this.getSubelements().get(i)).hide();
        }
    }

    @Override
    public void open() {
        for (int i = 0; i < this.getSubelements().size(); ++i) {
            ((MultiListButton)this.getSubelements().get(i)).show();
        }
    }
}

