/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Label;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;

public class ControlFont {
    public static boolean DEBUG = false;
    public static boolean RENDER_2X;
    PFont pfont;
    List<String> txt;
    String s = "";
    private int top;
    private int bottom;
    private int center;
    private int height;
    private int width;
    private int baseline = 0;
    private int _myTextHeight = 1;
    private int[] offset = new int[2];
    private int size;

    public static void sharp() {
        RENDER_2X = true;
    }

    public static void normal() {
        RENDER_2X = false;
    }

    public ControlFont(PFont pFont) {
        this(pFont, ControlFont.checkFontSize(pFont));
    }

    public ControlFont(PFont pFont, int n) {
        this(pFont, n, n + 2);
    }

    public ControlFont(PFont pFont, int n, int n2) {
        this.pfont = pFont;
        this.size = n;
        this.txt = new ArrayList<String>();
    }

    private static int checkFontSize(PFont pFont) {
        try {
            return pFont.getSize();
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("ControlP5: could not find font-size details for font " + pFont.getName() + ", use constructor ControlFont(PFont theFont, int theFontSize) to specify the font size.");
            return 10;
        }
    }

    public void init(Label label) {
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getSize() {
        return this.size;
    }

    public int getOffset(int n) {
        return this.offset[n];
    }

    public int getTextHeight() {
        return this._myTextHeight;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getCenter() {
        return this.center;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getBaseline() {
        return this.baseline;
    }

    public PFont getFont() {
        return this.pfont;
    }

    public void adjust(PGraphics pGraphics, Label label) {
        if (label.isChanged()) {
            pGraphics.textFont(this.pfont, (float)this.size);
            this.top = -((int)pGraphics.textAscent());
            this.bottom = (int)pGraphics.textDescent();
            this.center = -((-this.top - this.bottom) / 2);
            this.height = label.isMultiline() ? label.getHeight() : (int)(pGraphics.textAscent() + pGraphics.textDescent());
            int n = this.width = label.isMultiline() ? label.getWidth() : (int)pGraphics.textWidth(label.getTextFormatted());
            if (label.isMultiline()) {
                this.calculateHeight(pGraphics, label);
            }
            label.setChanged(false);
        }
    }

    private void calculateHeight(PGraphics pGraphics, Label label) {
        this.txt.clear();
        String string = label.getTextFormatted();
        List<String> list = Arrays.asList(string.split("\n"));
        string = "";
        for (String string2 : list) {
            List<String> list2 = Arrays.asList(string2.split("\\s"));
            for (String string3 : list2) {
                StringBuilder stringBuilder = new StringBuilder();
                if (pGraphics.textWidth(stringBuilder.append(string).append(string3).toString()) < (float)this.width) {
                    string = string + string3 + " ";
                    continue;
                }
                this.txt.add(string.substring(0, PApplet.max((int)0, (int)(string.length() - 1))));
                string = string3 + " ";
            }
            this.txt.add(string.substring(0, string.length() - 1));
            string = "";
        }
        if (label.getHeight() % label.getLineHeight() != 0) {
            this.txt.add("");
        }
        this._myTextHeight = PApplet.round((float)(this.txt.size() * label.getLineHeight()));
        int n = PApplet.round((float)(label.getHeight() / label.getLineHeight()));
        int n2 = (int)((float)PApplet.max((int)0, (int)(this.txt.size() - n)) * PApplet.abs((float)label.getOffsetYratio()));
        int n3 = PApplet.min((int)this.txt.size(), (int)n);
        this.s = "";
        for (int i = 0; i < n3; ++i) {
            this.s = this.s + this.txt.get(i + n2) + "\n";
        }
    }

    public int getOverflow() {
        return this._myTextHeight - this.height;
    }

    public void draw(ControlP5 controlP5, Label label) {
        this.draw(controlP5.pg, label);
    }

    public void draw(PGraphics pGraphics, Label label) {
        PFont pFont = pGraphics.textFont;
        float f = pGraphics.textSize;
        if (pFont == null) {
            pGraphics.textSize(f);
            pFont = pGraphics.textFont;
        }
        int n = pGraphics.textAlign;
        pGraphics.textFont(this.pfont, (float)this.size);
        pGraphics.textAlign(label.textAlign);
        pGraphics.fill(label.getColor());
        if (label.isMultiline()) {
            pGraphics.fill(label.getColor());
            pGraphics.textLeading((float)label.getLineHeight());
            pGraphics.text(this.s, 0.0f, 0.0f, (float)label.getWidth(), (float)label.getHeight());
        } else {
            pGraphics.translate(0.0f, (float)(-this.top + 1));
            this.debug(pGraphics, label);
            pGraphics.fill(label.getColor());
            pGraphics.textLeading((float)label.getLineHeight());
            String string = label.getTextFormatted();
            pGraphics.fill(label.getColor());
            pGraphics.text(string.substring(0, label.getSelectedStart()), 0.0f, 0.0f);
            pGraphics.fill(label.getSelectedColor());
            pGraphics.text(string.substring(label.getSelectedStart(), label.getSelectedStop()), pGraphics.textWidth(string.substring(0, label.getSelectedStart())), 0.0f);
            pGraphics.fill(label.getColor());
            pGraphics.text(string.substring(label.getSelectedStop(), string.length()), pGraphics.textWidth(string.substring(0, label.getSelectedStop())), 0.0f);
            if (RENDER_2X) {
                pGraphics.fill(label.getColor());
                pGraphics.text(string.substring(0, label.getSelectedStart()), 0.0f, 0.0f);
                pGraphics.fill(label.getSelectedColor());
                pGraphics.text(string.substring(label.getSelectedStart(), label.getSelectedStop()), pGraphics.textWidth(string.substring(0, label.getSelectedStart())), 0.0f);
                pGraphics.fill(label.getColor());
                pGraphics.text(string.substring(label.getSelectedStop(), string.length()), pGraphics.textWidth(string.substring(0, label.getSelectedStop())), 0.0f);
            }
        }
        pGraphics.textFont(pFont, f);
        pGraphics.textAlign(n);
    }

    private void debug(PGraphics pGraphics, Label label) {
        if (DEBUG) {
            pGraphics.stroke(0.0f, 255.0f, 0.0f);
            pGraphics.line(0.0f, (float)this.getBaseline(), pGraphics.textWidth(label.getText()), (float)this.getBaseline());
            pGraphics.stroke(0.0f, 0.0f, 255.0f);
            pGraphics.line(0.0f, (float)this.getTop(), pGraphics.textWidth(label.getText()), (float)this.getTop());
            pGraphics.stroke(255.0f, 255.0f, 0.0f);
            pGraphics.line(0.0f, (float)this.getBottom(), pGraphics.textWidth(label.getText()), (float)this.getBottom());
            pGraphics.stroke(255.0f, 0.0f, 0.0f);
            pGraphics.line(0.0f, (float)this.getCenter(), pGraphics.textWidth(label.getText()), (float)this.getCenter());
            pGraphics.stroke(255.0f, 128.0f, 0.0f);
            pGraphics.line(0.0f, (float)(this.getTop() / 2), pGraphics.textWidth(label.getText()), (float)(this.getTop() / 2));
            pGraphics.noStroke();
        }
    }

    public static int getWidthFor(String string, Label label, PGraphics pGraphics) {
        pGraphics.textFont(label.getFont().pfont, (float)label.getFont().size);
        return (int)pGraphics.textWidth(string);
    }
}

