/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.internal.JavaRunner;
import org.sonarsource.scanner.lib.internal.JreCacheHit;
import org.sonarsource.scanner.lib.internal.cache.CachedFile;

public class ScannerEngineLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(ScannerEngineLauncher.class);
    private static final String JSON_FIELD_SCANNER_PROPERTIES = "scannerProperties";
    private final JavaRunner javaRunner;
    private final CachedFile scannerEngineJar;

    public ScannerEngineLauncher(JavaRunner javaRunner, CachedFile scannerEngineJar) {
        this.javaRunner = javaRunner;
        this.scannerEngineJar = scannerEngineJar;
    }

    public boolean execute(Map<String, String> properties) {
        return this.javaRunner.execute(this.buildArgs(properties), ScannerEngineLauncher.buildJsonProperties(properties), ScannerEngineLauncher::tryParse);
    }

    static void tryParse(String stdout) {
        try {
            Log log = new Gson().fromJson(stdout, Log.class);
            StringBuilder sb = new StringBuilder();
            if (log.message != null) {
                sb.append(log.message);
            }
            if (log.message != null && log.stacktrace != null) {
                sb.append("\n");
            }
            if (log.stacktrace != null) {
                sb.append(log.stacktrace);
            }
            ScannerEngineLauncher.log(log.level, sb.toString());
        }
        catch (Exception e) {
            LOG.info("[stdout] {}", (Object)stdout);
        }
    }

    private static void log(String level, String msg) {
        switch (level) {
            case "ERROR": {
                LOG.error(msg);
                break;
            }
            case "WARN": {
                LOG.warn(msg);
                break;
            }
            case "DEBUG": {
                LOG.debug(msg);
                break;
            }
            case "TRACE": {
                LOG.trace(msg);
                break;
            }
            default: {
                LOG.info(msg);
            }
        }
    }

    private List<String> buildArgs(Map<String, String> properties) {
        ArrayList<String> args2 = new ArrayList<String>();
        String javaOpts = properties.get("sonar.scanner.javaOpts");
        if (javaOpts != null) {
            args2.addAll(ScannerEngineLauncher.split(javaOpts));
        }
        args2.add("-jar");
        args2.add(this.scannerEngineJar.getPathInCache().toAbsolutePath().toString());
        return args2;
    }

    private static List<String> split(String value) {
        return Arrays.stream(value.split("\\s+")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private static String buildJsonProperties(Map<String, String> properties) {
        JsonArray propertiesArray = new JsonArray();
        properties.entrySet().stream().filter(prop -> prop.getKey() != null).sorted(Map.Entry.comparingByKey()).forEach(prop -> {
            JsonObject property = new JsonObject();
            property.addProperty("key", (String)prop.getKey());
            property.addProperty("value", Optional.ofNullable((String)prop.getValue()).orElse(""));
            propertiesArray.add(property);
        });
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(JSON_FIELD_SCANNER_PROPERTIES, propertiesArray);
        return new Gson().toJson(jsonObject);
    }

    public boolean isEngineCacheHit() {
        return this.scannerEngineJar.isCacheHit();
    }

    public JreCacheHit getJreCacheHit() {
        return this.javaRunner.getJreCacheHit();
    }

    private static class Log {
        @SerializedName(value="level")
        private String level;
        @SerializedName(value="message")
        private String message;
        @SerializedName(value="stacktrace")
        private String stacktrace;

        private Log() {
        }
    }
}

