/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.cli;

import ch.qos.logback.classic.Level;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.cli.Exit;

class Cli {
    private static final Logger LOG = LoggerFactory.getLogger(Cli.class);
    private boolean debugEnabled = false;
    private boolean displayVersionOnly = false;
    private boolean embedded = false;
    private String invokedFrom = "";
    private final Properties props = new Properties();
    private final Exit exit;

    public Cli(Exit exit) {
        this.exit = exit;
    }

    boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    boolean isDisplayVersionOnly() {
        return this.displayVersionOnly;
    }

    boolean isEmbedded() {
        return this.embedded;
    }

    String getInvokedFrom() {
        return this.invokedFrom;
    }

    Properties properties() {
        return this.props;
    }

    Cli parse(String[] args2) {
        this.reset();
        this.props.putAll((Map<?, ?>)System.getProperties());
        if (args2.length > 0) {
            int pos = 0;
            while ((pos = this.processNextArg(args2, pos)) < args2.length) {
            }
        }
        return this;
    }

    private int processNextArg(String[] args2, int pos) {
        String arg = args2[pos];
        if (Arrays.asList("-h", "--help").contains(arg)) {
            Cli.printUsage();
            this.exit.exit(0);
        } else if (Arrays.asList("-v", "--version").contains(arg)) {
            this.displayVersionOnly = true;
        } else if (Arrays.asList("-e", "--errors").contains(arg)) {
            LOG.info("Option -e/--errors is no longer supported and will be ignored");
        } else if (Arrays.asList("-X", "--debug").contains(arg)) {
            this.props.setProperty("sonar.verbose", "true");
            this.debugEnabled = true;
            ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
            rootLogger.setLevel(Level.DEBUG);
        } else {
            if (Arrays.asList("-D", "--define").contains(arg)) {
                return this.processProp(args2, pos);
            }
            if ("--embedded".equals(arg)) {
                LOG.info("Option --embedded is deprecated and will be removed in a future release.");
                this.embedded = true;
            } else if (arg.startsWith("--from")) {
                this.embedded = true;
                if (arg.length() > "--from=".length()) {
                    this.invokedFrom = arg.substring("--from=".length());
                }
            } else if (arg.startsWith("-D")) {
                arg = arg.substring(2);
                Cli.appendPropertyTo(arg, this.props);
            } else {
                this.printErrorAndExit("Unrecognized option: " + arg);
            }
        }
        return pos + 1;
    }

    private int processProp(String[] args2, int pos) {
        int valuePos = pos + 1;
        if (valuePos >= args2.length) {
            this.printErrorAndExit("Missing argument for option -D/--define");
        } else {
            Cli.appendPropertyTo(args2[valuePos], this.props);
        }
        return valuePos + 1;
    }

    private void reset() {
        this.props.clear();
        this.debugEnabled = false;
        this.displayVersionOnly = false;
    }

    private static void appendPropertyTo(String arg, Properties props) {
        String value;
        String key;
        int j = arg.indexOf(61);
        if (j == -1) {
            key = arg;
            value = "true";
        } else {
            key = arg.substring(0, j);
            value = arg.substring(j + 1);
        }
        Object oldValue = props.setProperty(key, value);
        if (oldValue != null) {
            LOG.warn("Property '{}' with value '{}' is overridden with value '{}'", key, oldValue, value);
        }
    }

    private void printErrorAndExit(String message) {
        LOG.error(message);
        Cli.printUsage();
        this.exit.exit(1);
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("usage: sonar-scanner [options]");
        System.out.println();
        System.out.println("Options:");
        System.out.println(" -D,--define <arg>     Define property");
        System.out.println(" -h,--help             Display help information");
        System.out.println(" -v,--version          Display version information");
        System.out.println(" -X,--debug            Produce execution debug output");
    }
}

