/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.analytics.impl;

import com.segment.analytics.Analytics;
import com.segment.analytics.messages.MessageBuilder;
import com.segment.analytics.messages.TrackMessage;
import com.smartbear.analytics.ActionDescription;
import com.smartbear.analytics.OSUserDescription;
import com.smartbear.analytics.api.ProductInfo;
import com.smartbear.analytics.impl.BaseAnalyticsProvider;
import com.smartbear.analytics.impl.SoapUIOSMixpanelProvider;
import com.smartbear.analytics.impl.UserInfoProvider;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoapUIOSUserProvider
extends BaseAnalyticsProvider
implements UserInfoProvider {
    private static final String ANALYTICS_WRITE_KEY = "M8BrkVxsSVZ5TteYXBizvo8EaTSDnWrt";
    private static final String EVENT_NAME = "SoapUI stay tuned invite";
    private static final Logger log = LogManager.getLogger(SoapUIOSMixpanelProvider.class);

    public SoapUIOSUserProvider(ProductInfo productInfo) {
        super(productInfo);
    }

    @Override
    public void trackUserInfo(OSUserDescription osUserDescription) {
        Map<String, String> requestParams = this.prepareRequestParams(osUserDescription);
        this.sendRecord(requestParams);
    }

    @Override
    public void trackAction(ActionDescription actionDescription) {
    }

    private Map<String, String> prepareRequestParams(OSUserDescription osUserDescription) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("firstName", osUserDescription.getFirstName());
        map.put("lastName", osUserDescription.getLastName());
        map.put("email", osUserDescription.getEmail());
        map.put("uuid", osUserDescription.getUuid());
        return map;
    }

    protected boolean sendRecord(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return false;
        }
        try {
            Analytics analytics = Analytics.builder((String)ANALYTICS_WRITE_KEY).build();
            analytics.enqueue((MessageBuilder)((TrackMessage.Builder)TrackMessage.builder((String)EVENT_NAME).anonymousId(parameters.get("uuid"))).properties(parameters));
            analytics.shutdown();
            return true;
        }
        catch (Exception e) {
            log.error("Error when sending request to update user info", (Throwable)e);
            return false;
        }
    }

    protected HttpURLConnection initializeConnection(String connectionURL) {
        try {
            URL url = new URL(connectionURL);
            return (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            log.error("Error when creating the connection", (Throwable)e);
            return null;
        }
    }
}

