/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.analytics.impl;

import com.mixpanel.mixpanelapi.ClientDelivery;
import com.mixpanel.mixpanelapi.MessageBuilder;
import com.mixpanel.mixpanelapi.MixpanelAPI;
import com.smartbear.analytics.ActionDescription;
import com.smartbear.analytics.AnalyticsManager;
import com.smartbear.analytics.api.AnalyticsProvider;
import com.smartbear.analytics.api.ProductInfo;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class MixpanelProvider
implements AnalyticsProvider {
    private static final Logger LOG = LogManager.getLogger(MixpanelProvider.class);
    private MixpanelAPI mixpanelAPI = new MixpanelAPI();
    private MessageBuilder messageBuilder;
    private boolean enabled;
    private ProductInfo productInfo;

    public MixpanelProvider(String projectToken, ProductInfo productInfo, boolean sendAnalytics) {
        this.messageBuilder = new MessageBuilder(projectToken);
        this.enabled = sendAnalytics;
        this.productInfo = productInfo;
    }

    @Override
    public void trackAction(ActionDescription actionDescription) {
        if (this.enabled) {
            if (actionDescription.getCategory().equals((Object)AnalyticsManager.Category.MIXPANEL_PROFILE)) {
                try {
                    JSONObject props = new JSONObject(actionDescription.getParams());
                    JSONObject updateUser = this.messageBuilder.set(this.productInfo.getLicenseId(), props);
                    this.mixpanelAPI.sendMessage(updateUser);
                }
                catch (IOException e) {
                    LOG.debug("Error when updating user profile on Mixpanel");
                }
            } else {
                JSONObject props = new JSONObject(actionDescription.getParams());
                JSONObject event = this.messageBuilder.event(this.productInfo.getLicenseId(), actionDescription.getActionName(), props);
                final ClientDelivery delivery = new ClientDelivery();
                delivery.addMessage(event);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MixpanelProvider.this.mixpanelAPI.deliver(delivery);
                        }
                        catch (IOException e) {
                            LOG.debug("Error when sending event to Mixpanel");
                        }
                    }
                }).start();
            }
        }
    }

    @Override
    public void trackError(Throwable error) {
        throw new UnsupportedOperationException();
    }
}

