/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.analytics.impl;

import com.smartbear.analytics.api.AnalyticsProvider;
import com.smartbear.analytics.api.ProductInfo;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public abstract class BaseAnalyticsProvider
implements AnalyticsProvider {
    private final ProductInfo productInfo;

    public BaseAnalyticsProvider(ProductInfo productInfo) {
        this.productInfo = productInfo;
    }

    @Override
    public void trackError(Throwable error) {
    }

    public final String getOsName() {
        return System.getProperty("os.name", "n/a");
    }

    public final String getOsVersion() {
        return System.getProperty("os.version", "n/a");
    }

    public final String getJavaVersion() {
        return System.getProperty("java.version", "n/a");
    }

    public final String getUserLanguage() {
        return System.getProperty("user.language", "n/a");
    }

    public final String getUserCountry() {
        return System.getProperty("user.country", "n/a");
    }

    public final String getStrScreenSize() {
        try {
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            return String.format("%dx%d", (int)size.getWidth(), (int)size.getHeight());
        }
        catch (Throwable ignore) {
            return "0x0";
        }
    }

    public String getProductVersion() {
        return this.productInfo.getVersion();
    }

    public String getLicenseDescription() {
        String license = "[Unknown]";
        if (this.productInfo.getLicenseType() != null) {
            license = this.productInfo.getLicenseType();
        }
        if (this.productInfo.isLicenseExpired()) {
            license = license + " (expired)";
        }
        return license;
    }

    public ProductInfo getProductInfo() {
        return this.productInfo;
    }

    protected String urlEncodeWithUtf8(String input) {
        try {
            return URLEncoder.encode(input == null ? "" : input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return input;
        }
    }
}

