/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.analytics;

import com.smartbear.analytics.AnalyticsManager;
import java.util.HashMap;
import java.util.Map;

public final class Analytics {
    public static AnalyticsManager getAnalyticsManager() {
        return AnalyticsManager.getInstance();
    }

    public static void clearProviders() {
        AnalyticsManager.getInstance().clearProviders();
    }

    public static void trackAction(String action) {
        Analytics.getAnalyticsManager().trackAction(action);
    }

    public static void trackError(Throwable error) {
        Analytics.getAnalyticsManager().trackError(error);
    }

    public static boolean trackSessionStart() {
        return Analytics.getAnalyticsManager().trackSessionStart();
    }

    public static boolean trackSessionStop() {
        return Analytics.getAnalyticsManager().trackSessionStop();
    }

    public static void trackAction(AnalyticsManager.Category category, String action, String ... args) {
        Map<String, String> params = Analytics.createParameterMap(args);
        Analytics.getAnalyticsManager().trackAction(category, action, params);
    }

    public static void trackStatistics(String name, String ... args) {
        Map<String, String> params = Analytics.createParameterMap(args);
        Analytics.getAnalyticsManager().trackStatistics(name, params);
    }

    @Deprecated
    public static void trackAction(String action, String ... args) {
        Map<String, String> params = Analytics.createParameterMap(args);
        Analytics.getAnalyticsManager().trackAction(action, params);
    }

    public static void trackLicenseData(String actionName, String ... parameters) {
        Map<String, String> parameterMap = Analytics.createParameterMap(parameters);
        Analytics.getAnalyticsManager().trackLicenseData(actionName, parameterMap);
    }

    public static void trackCustomPlugInAction(String actionName, String ... parameters) {
        Map<String, String> parameterMap = Analytics.createParameterMap(parameters);
        Analytics.getAnalyticsManager().trackCustomPlugInAction(actionName, parameterMap);
    }

    public static Map<String, String> createParameterMap(String[] args) {
        HashMap<String, String> params = new HashMap<String, String>();
        int ix = 0;
        while (ix + 1 < args.length) {
            if (args[ix] != null && args[ix].trim().length() > 0 && args[ix + 1] != null) {
                params.put(args[ix], args[ix + 1]);
            }
            ix += 2;
        }
        return params;
    }

    private static boolean hasContent(String string) {
        return string != null && string.trim().length() > 0;
    }
}

