/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.dialog;

import hermes.browser.dialog.PreferencesDialog;
import hermes.config.ConnectionConfig;
import hermes.config.SessionConfig;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.log4j.Category;

public class ConnectionConfigPanel
extends JPanel {
    private static final String CLIENTID = "ClientID: ";
    private static final String PASSWORD = "Password: ";
    private static final String USERNAME = "User: ";
    private static final String REQUIRES_AUTHENTICATION = "Authenticate: ";
    private static final String CONNECTION = "Connection";
    private static final Category cat = Category.getInstance(ConnectionConfigPanel.class);
    private PreferencesDialog dialog;
    private ConnectionConfig connectionConfig;
    private JCheckBox sharedCB = new JCheckBox("Shared");
    private JCheckBox hasPasswordCB = new JCheckBox();
    private JTextField clientIDTF = new JTextField();
    private JTextField usernameTF = new JTextField();
    private JTextField passwordTF = new JPasswordField();

    public ConnectionConfigPanel(PreferencesDialog dialog) {
        this.dialog = dialog;
        this.init();
    }

    public void init() {
        this.setLayout(new GridLayout(1, 7));
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), CONNECTION));
        JLabel l4 = new JLabel(CLIENTID);
        l4.setHorizontalAlignment(4);
        this.add(l4);
        this.add(this.clientIDTF);
        this.hasPasswordCB.setHorizontalAlignment(4);
        this.hasPasswordCB.setText(USERNAME);
        this.add(this.hasPasswordCB);
        this.add(this.usernameTF);
        JLabel l3 = new JLabel(PASSWORD);
        l3.setHorizontalAlignment(4);
        this.add(l3);
        this.add(this.passwordTF);
        this.usernameTF.setEnabled(false);
        this.passwordTF.setEnabled(false);
        this.sharedCB.setHorizontalAlignment(4);
        this.add(this.sharedCB);
        ActionListener dirtyListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ConnectionConfigPanel.this.dialog.setDirty();
            }
        };
        this.usernameTF.addActionListener(dirtyListener);
        this.passwordTF.addActionListener(dirtyListener);
        this.hasPasswordCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ConnectionConfigPanel.this.hasPasswordCB.isSelected()) {
                    ConnectionConfigPanel.this.usernameTF.setEnabled(true);
                    ConnectionConfigPanel.this.passwordTF.setEnabled(true);
                } else {
                    ConnectionConfigPanel.this.usernameTF.setEnabled(false);
                    ConnectionConfigPanel.this.passwordTF.setEnabled(false);
                }
                ConnectionConfigPanel.this.dialog.setDirty();
            }
        });
    }

    public void setConnectionConfig(ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
        if (connectionConfig.getUsername() == null) {
            this.hasPasswordCB.setSelected(false);
        } else {
            this.hasPasswordCB.setSelected(true);
        }
        if (this.hasPasswordCB.isSelected()) {
            this.usernameTF.setEnabled(true);
            this.passwordTF.setEnabled(true);
        } else {
            this.usernameTF.setEnabled(false);
            this.passwordTF.setEnabled(false);
        }
        this.sharedCB.setSelected(!connectionConfig.isConnectionPerThread());
        this.usernameTF.setText(connectionConfig.getUsername());
        this.passwordTF.setText(connectionConfig.getPassword());
        this.clientIDTF.setText(connectionConfig.getClientID());
        if (connectionConfig.getSession().size() == 0) {
            connectionConfig.getSession().add(new SessionConfig());
        }
    }

    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public void updateModel() {
        if (this.connectionConfig != null) {
            this.connectionConfig.setConnectionPerThread(!this.sharedCB.isSelected());
            if (this.hasPasswordCB.isSelected()) {
                this.connectionConfig.setUsername(this.usernameTF.getText());
                this.connectionConfig.setPassword(this.passwordTF.getText());
            } else {
                this.connectionConfig.setUsername(null);
                this.connectionConfig.setPassword(null);
            }
            this.connectionConfig.setClientID(this.clientIDTF.getText());
        }
    }
}

