/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.components;

import com.jidesoft.grid.ExpandablePanel;
import com.jidesoft.grid.HierarchicalTable;
import hermes.browser.model.QueueWatchTableModel;
import hermes.browser.model.WatchInfo;
import hermes.util.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Logger;

public class WatchTable
extends HierarchicalTable {
    private static final Logger log = Logger.getLogger(WatchTable.class);
    private QueueWatchTableModel watchModel;

    public WatchTable(QueueWatchTableModel model, final boolean showAge) {
        super((TableModel)model);
        this.watchModel = model;
        DefaultTableCellRenderer dateRenderer = new DefaultTableCellRenderer(){
            private FastDateFormat formatter = FastDateFormat.getInstance((String)"EEE, d MMM yyyy HH:mm:ss");

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value == null) {
                    this.setText("");
                } else if (value instanceof Date) {
                    if (showAge) {
                        super.setText(TextUtils.getAge((Date)value));
                    } else {
                        String strDate = this.formatter.format((Date)value);
                        super.setText(strDate);
                    }
                }
                return this;
            }

            protected void setValueXXX(Object value) {
                if (value == null) {
                    super.setText("");
                } else if (showAge) {
                    super.setText(TextUtils.getAge((Date)value));
                } else {
                    super.setText(value.toString());
                }
            }
        };
        this.setDefaultRenderer(Date.class, dateRenderer);
    }

    public Component prepareRenderer(TableCellRenderer renderer, int y, int x) {
        Component rval = super.prepareRenderer(renderer, y, x);
        int originalY = y;
        y = this.getActualRowAt(y);
        WatchInfo info = this.watchModel.getRow(y);
        Component c = null;
        if (rval instanceof ExpandablePanel) {
            ExpandablePanel ep = (ExpandablePanel)rval;
            c = ep.getActualRenderer();
        } else {
            c = rval;
        }
        boolean previousInAlert = info.isInAlert();
        if (info != null) {
            if (info.getE() != null) {
                info.setInAlert(true);
                c.setBackground(new Color(255, 255, 153));
                c.setForeground(Color.BLACK);
            } else if (info.getDepthAlert() != 0 && info.getDepth() > info.getDepthAlert()) {
                info.setInAlert(true);
                c.setBackground(new Color(255, 204, 153));
                c.setForeground(Color.BLACK);
            } else if (info.getAgeAlert() != 0L && System.currentTimeMillis() - info.getAgeAlert() > info.getAgeAlert()) {
                info.setInAlert(true);
                c.setBackground(new Color(255, 204, 153));
                c.setForeground(Color.BLACK);
            } else if (originalY % 2 == 0 && !this.isCellSelected(originalY, x)) {
                info.setInAlert(false);
                c.setBackground(Color.LIGHT_GRAY);
                c.setForeground(Color.BLACK);
            } else if (!this.isCellSelected(originalY, x)) {
                info.setInAlert(false);
                c.setBackground(Color.WHITE);
                c.setForeground(Color.BLACK);
            }
        }
        return rval;
    }
}

