/*
 * Decompiled with CFR 0.152.
 */
import com.smartbear.analytics.ActionDescription;
import com.smartbear.analytics.AnalyticsManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.Preferences;

public class TrackOutAppAction {
    public static void main(String[] args) {
        String uniqueUserId = TrackOutAppAction.createUniqueUserId();
        int argsCount = args.length;
        if (argsCount == 0) {
            return;
        }
        if ((argsCount - 1) % 2 != 0) {
            System.err.println("Incorrect number of parameters");
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 1; i < argsCount; i += 2) {
            params.put(args[i], args[i + 1]);
        }
        String productName = "SoapUI";
        String productVersion = "0.0.0";
        Iterator it = params.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (((String)entry.getKey()).equals("Product")) {
                productName = (String)entry.getValue();
                it.remove();
            }
            if (!((String)entry.getKey()).equals("Version")) continue;
            productVersion = (String)entry.getValue();
            it.remove();
        }
        String action = args[0];
        ActionDescription description = new ActionDescription("no_session_id", AnalyticsManager.Category.ACTION, action, params);
        MixpanelAnalyticsProvider mixpanelProvider = new MixpanelAnalyticsProvider(productName, productVersion, uniqueUserId);
        mixpanelProvider.trackAction(description);
    }

    private static String createUniqueUserId() {
        Preferences preferences = Preferences.userRoot().node("com.smartbear.ready.api.UBL");
        String userId = preferences.get("UniqueUserAnalyticsId", "");
        if (userId.equals("")) {
            userId = UUID.randomUUID().toString();
            preferences.put("UniqueUserAnalyticsId", userId);
        }
        return userId;
    }
}

