/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.models;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonPropertyOrder(value={"valid", "swaggerDefinitionMessages", "unimplementedControllerCount", "unimplementedMethodCount", "unimplementedModelCount"})
public class InflectResult {
    private boolean valid;
    private List<String> swaggerDefinitionMessages;
    private Map<String, List<String>> unimplementedControllers;
    private Set<String> unimplementedModels;

    public InflectResult specParseMessage(String message) {
        if (this.swaggerDefinitionMessages == null) {
            this.swaggerDefinitionMessages = new ArrayList<String>();
        }
        this.swaggerDefinitionMessages.add(message);
        return this;
    }

    public InflectResult valid() {
        this.valid = true;
        return this;
    }

    public InflectResult invalid() {
        this.valid = false;
        return this;
    }

    public InflectResult valid(boolean isValid) {
        this.valid = isValid;
        return this;
    }

    public InflectResult unimplementedModel(String model) {
        if (this.unimplementedModels == null) {
            this.unimplementedModels = new HashSet<String>();
        }
        this.unimplementedModels.add(model);
        return this;
    }

    public InflectResult unimplementedControllers(String location, List<String> messages) {
        for (String message : messages) {
            this.unimplementedController(location, message);
        }
        return this;
    }

    public InflectResult unimplementedController(String location, String message) {
        List<String> l;
        if (this.unimplementedControllers == null) {
            this.unimplementedControllers = new HashMap<String, List<String>>();
        }
        if ((l = this.unimplementedControllers.get(location)) == null) {
            l = new ArrayList<String>();
            this.unimplementedControllers.put(location, l);
        }
        l.add(message);
        return this;
    }

    public boolean isValid() {
        return this.swaggerDefinitionMessages == null || this.swaggerDefinitionMessages.size() == 0;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public Map<String, List<String>> getUnimplementedControllers() {
        return this.unimplementedControllers;
    }

    public void setUnimplementedControllers(Map<String, List<String>> unimplementedControllers) {
        this.unimplementedControllers = unimplementedControllers;
    }

    public Set<String> getUnimplementedModels() {
        return this.unimplementedModels;
    }

    public void setUnimplementedModels(Set<String> unimplementedModels) {
        this.unimplementedModels = unimplementedModels;
    }

    public List<String> getSwaggerDefinitionMessages() {
        return this.swaggerDefinitionMessages;
    }

    public void setSwaggerDefinitionMessages(List<String> swaggerDefinitionMessages) {
        this.swaggerDefinitionMessages = swaggerDefinitionMessages;
    }

    public Integer getUnimplementedModelCount() {
        if (this.unimplementedModels == null || this.unimplementedModels.size() == 0) {
            return null;
        }
        return this.unimplementedModels.size();
    }

    public Integer getUnimplementedControllerCount() {
        if (this.unimplementedControllers == null || this.unimplementedControllers.keySet().size() == 0) {
            return null;
        }
        return this.unimplementedControllers.keySet().size();
    }

    public Integer getUnimplementedMethodCount() {
        if (this.unimplementedControllers == null || this.unimplementedControllers.keySet().size() == 0) {
            return null;
        }
        int count = 0;
        for (String key : this.unimplementedControllers.keySet()) {
            count += this.unimplementedControllers.get(key).size();
        }
        return count;
    }
}

