/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.converters;

import io.swagger.inflector.converters.ConversionException;
import io.swagger.inflector.converters.Converter;
import io.swagger.inflector.converters.DefaultConverter;
import io.swagger.inflector.validators.DefaultValidator;
import io.swagger.inflector.validators.NumericValidator;
import io.swagger.inflector.validators.StringTypeValidator;
import io.swagger.inflector.validators.ValidationException;
import io.swagger.inflector.validators.Validator;
import io.swagger.models.Model;
import io.swagger.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputConverter.class);
    private static InputConverter INSTANCE = new InputConverter();
    private List<Validator> validationChain = new ArrayList<Validator>();
    private List<Converter> converterChain = new ArrayList<Converter>();

    public static InputConverter getInstance() {
        return INSTANCE;
    }

    public List<Validator> getValidators() {
        return this.validationChain;
    }

    public List<Converter> getConverters() {
        return this.converterChain;
    }

    public void addConverter(Converter converter) {
        boolean matched = false;
        for (Converter c : this.converterChain) {
            if (!c.getClass().getName().equals(converter.getClass().getName())) continue;
            matched = true;
        }
        if (!matched) {
            LOGGER.debug("adding " + converter.getClass().getName());
            this.converterChain.add(converter);
        } else {
            LOGGER.debug("skipping " + converter.getClass().getName());
        }
    }

    public void addConverter(Converter converter, boolean first) {
        boolean matched = false;
        for (Converter c : this.converterChain) {
            if (!c.getClass().getName().equals(converter.getClass().getName())) continue;
            matched = true;
        }
        if (!matched) {
            this.converterChain.add(0, converter);
        }
    }

    public InputConverter defaultConverters() {
        this.converterChain.clear();
        this.converterChain.add(new DefaultConverter());
        return this;
    }

    public void addValidator(Validator validator) {
        boolean matched = false;
        for (Validator v : this.validationChain) {
            if (!v.getClass().getName().equals(validator.getClass().getName())) continue;
            matched = true;
        }
        if (!matched) {
            this.validationChain.add(validator);
        }
    }

    public void addValidator(Validator validator, boolean first) {
        boolean matched = false;
        for (Validator v : this.validationChain) {
            if (!v.getClass().getName().equals(validator.getClass().getName())) continue;
            matched = true;
        }
        if (!matched) {
            this.validationChain.add(0, validator);
        }
    }

    public InputConverter defaultValidators() {
        this.validationChain.clear();
        this.validationChain.add(new DefaultValidator());
        this.validationChain.add(new NumericValidator());
        this.validationChain.add(new StringTypeValidator());
        return this;
    }

    public Object convertAndValidate(List<String> value, Parameter parameter, Class<?> cls, Map<String, Model> definitions) throws ConversionException, ValidationException {
        Iterator<Converter> itr = this.converterChain.iterator();
        Object o = null;
        if (itr.hasNext()) {
            Converter converter = itr.next();
            LOGGER.debug("using converter `" + converter.getClass().getName() + "`");
            o = converter.convert(value, parameter, cls, definitions, itr);
        }
        this.validate(o, parameter);
        return o;
    }

    public void validate(Object value, Parameter parameter) throws ValidationException {
        Iterator<Validator> itr = this.validationChain.iterator();
        if (itr.hasNext()) {
            Validator validator = itr.next();
            validator.validate(value, parameter, itr);
        }
    }
}

