/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.util.PercentScaler;
import java.io.File;

public class ProgressAdapter
implements ProgressInterface,
FileUtil.CopyProgressListener {
    private ProgressInterface progressInterface;
    private PercentScaler percentScaler;
    private boolean filterProgress = false;
    private long maxCopyProgress;
    private long currentCopyProgress = 0L;

    public ProgressAdapter(ProgressInterface progressInterface, boolean bl) {
        this.progressInterface = progressInterface;
        this.filterProgress = bl;
        this.percentScaler = new PercentScaler(0, 100);
    }

    public ProgressAdapter(ProgressInterface progressInterface, int n, int n2) {
        this.progressInterface = progressInterface;
        this.percentScaler = new PercentScaler(n, n2);
    }

    public void setStatusMessage(String string) {
        if (this.progressInterface != null) {
            this.progressInterface.setStatusMessage(string);
        }
    }

    public void setDetailMessage(String string) {
        if (this.progressInterface != null) {
            this.progressInterface.setDetailMessage(string);
        }
    }

    public void setPercentCompleted(int n) {
        if (!this.filterProgress && this.progressInterface != null) {
            this.progressInterface.setPercentCompleted(n == -1 ? -1 : this.percentScaler.scalePercent(n));
        }
    }

    public int getPercentCompleted() {
        if (!this.filterProgress && this.progressInterface != null) {
            return this.progressInterface.getPercentCompleted();
        }
        return 0;
    }

    public void setSecondaryPercentCompleted(int n) {
        if (!this.filterProgress && this.progressInterface != null) {
            this.progressInterface.setSecondaryPercentCompleted(n);
        }
    }

    public void setIndeterminateProgress(boolean bl) {
        if (!this.filterProgress && this.progressInterface != null) {
            this.progressInterface.setIndeterminateProgress(bl);
        }
    }

    public void showFailure(String string) {
        if (this.progressInterface != null) {
            this.progressInterface.showFailure(string);
        }
    }

    public int askOverwrite(File file) throws UserCanceledException {
        if (this.progressInterface != null) {
            return this.progressInterface.askOverwrite(file);
        }
        return 1;
    }

    public int askRetry(File file) throws UserCanceledException {
        if (this.progressInterface != null) {
            return this.progressInterface.askRetry(file);
        }
        return 1;
    }

    public boolean askContinue(File file) throws UserCanceledException {
        if (this.progressInterface != null) {
            return this.progressInterface.askContinue(file);
        }
        return true;
    }

    public void setMaxCopyProgress(long l) {
        this.maxCopyProgress = l;
    }

    public boolean progressPerformed(long l) {
        this.currentCopyProgress += l;
        this.setPercentCompleted((int)((double)(100L * this.currentCopyProgress) / (double)this.maxCopyProgress));
        ContextInt contextInt = ContextImpl.getSingleContextInt();
        if (contextInt == null) {
            return true;
        }
        return !contextInt.isCancelling();
    }
}

