/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.integrations.swaggerhub.component;

import com.smartbear.integrations.swaggerhub.component.SwaggerHubAPITableModel;
import com.smartbear.integrations.swaggerhub.engine.ApiDescriptor;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;

public class SwaggerHubAPITable
extends TableView {
    private ObservableList<SwaggerHubAPITableModel> tableModels = FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList());

    public SwaggerHubAPITable() {
        this.configure();
    }

    private void configure() {
        this.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.getStyleClass().add((Object)"text-12px");
        TableColumn name = new TableColumn("Name");
        name.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        TableColumn desc = new TableColumn("Description");
        desc.setCellValueFactory((Callback)new PropertyValueFactory("descr"));
        TableColumn oasVersion = new TableColumn("OAS Version");
        oasVersion.setCellValueFactory((Callback)new PropertyValueFactory("oasVersion"));
        TableColumn visibility = new TableColumn("Visibility");
        visibility.setCellValueFactory((Callback)new PropertyValueFactory("visibility"));
        TableColumn owner = new TableColumn("Owner");
        owner.setCellValueFactory((Callback)new PropertyValueFactory("owner"));
        TableColumn versions = new TableColumn("Versions");
        versions.setCellValueFactory((Callback)new PropertyValueFactory("versions"));
        this.setItems(this.tableModels);
        this.getColumns().addAll(new Object[]{name, owner, desc, oasVersion, visibility, versions});
        this.setPlaceholder((Node)new Label("No content in the table"));
    }

    public void clearTable() {
        this.tableModels.clear();
    }

    public void addDescription(ApiDescriptor descriptor) {
        this.tableModels.add((Object)new SwaggerHubAPITableModel(descriptor));
    }
}

