/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.integrations.swaggerhub.component;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.google.common.io.ByteStreams;
import com.smartbear.integrations.swaggerhub.component.SwaggerHubAPITable;
import com.smartbear.integrations.swaggerhub.component.SwaggerHubAPITableModel;
import com.smartbear.integrations.swaggerhub.engine.ApiDescriptor;
import com.smartbear.integrations.swaggerhub.engine.ApisJsonImporter;
import com.smartbear.swagger.Swagger2Importer;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportFromSwaggerHubDialog
extends Dialog {
    private static final String UNSUPPORTED_OAS_VERSION_MESSAGE = "SoapUI OS can work only with OAS version 2.0";
    public static final Logger log = LoggerFactory.getLogger(ImportFromSwaggerHubDialog.class);
    private static final String GETTING_LIST_OF_DEFINITIONS_ERROR = "Cannot get list of definitions from SwaggerHub";
    private static final int CONTENT_PANE_WIDTH = 710;
    private static final int CONTENT_PANE_HEIGHT = 525;
    private static final String SEARCH_LIMIT = "50";
    private final TextField searchField = new TextField();
    private final SwaggerHubAPITable table = new SwaggerHubAPITable();
    private final Button searchButton = new Button("Search");
    private final StackPane stackPane = new StackPane();
    private final WsdlProject project;

    public ImportFromSwaggerHubDialog(WsdlProject project) {
        this.project = project;
        this.buildDialog();
    }

    protected void buildDialog() {
        this.initModality(Modality.APPLICATION_MODAL);
        Scene scene = this.getDialogPane().getScene();
        Stage stage = (Stage)scene.getWindow();
        this.setResizable(false);
        this.setTitle("Import from SwaggerHub");
        String css = ((Object)((Object)this)).getClass().getResource("/css/swaggerhub-plugin.css").toExternalForm();
        scene.getStylesheets().add((Object)css);
        this.createButtons();
        VBox vBox = new VBox();
        BorderPane root = new BorderPane();
        root.setMinSize(710.0, 525.0);
        root.setMaxSize(710.0, 525.0);
        root.setStyle("-fx-background-color: white");
        this.table.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        BorderPane pane = new BorderPane((Node)this.table);
        pane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.searchButton.setOnAction(event -> this.populateList());
        ScrollPane tableScroll = new ScrollPane((Node)pane);
        tableScroll.setFitToHeight(true);
        tableScroll.setFitToWidth(true);
        tableScroll.getStyleClass().add((Object)"white-scroll");
        tableScroll.setMaxHeight(525.0);
        this.stackPane.getChildren().add((Object)tableScroll);
        vBox.getChildren().addAll((Object[])new Node[]{new Separator(), this.buildSearchForm(), this.stackPane});
        root.setCenter((Node)vBox);
        this.getDialogPane().setContent((Node)root);
    }

    private void createButtons() {
        ButtonType okButtonType = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
        ButtonType cancelButtonType = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{okButtonType, cancelButtonType});
        Button okButton = (Button)this.getDialogPane().lookupButton(okButtonType);
        okButton.getStyleClass().add((Object)"ok-button");
        okButton.setOnAction(event -> this.handleOk());
        okButton.addEventFilter(ActionEvent.ACTION, event -> {
            SwaggerHubAPITableModel model = (SwaggerHubAPITableModel)this.table.getSelectionModel().getSelectedItem();
            if (model == null) {
                this.buildAlert("Please select API for import", "Select API", Alert.AlertType.WARNING).showAndWait();
                event.consume();
            }
        });
        Button cancelButton = (Button)this.getDialogPane().lookupButton(cancelButtonType);
        cancelButton.getStyleClass().add((Object)"cancel-button");
    }

    private void populateList() {
        this.searchButton.setDisable(true);
        SoapUI.getThreadPool().execute(() -> {
            ProgressIndicator progressIndicator = new ProgressIndicator(-1.0);
            progressIndicator.setMaxHeight(this.table.getHeight() * 0.7);
            progressIndicator.setMaxWidth(this.table.getWidth() * 0.7);
            Platform.runLater(() -> {
                this.stackPane.getChildren().add((Object)progressIndicator);
                this.table.clearTable();
            });
            boolean importPrivate = false;
            String searchQuery = this.searchField.getText();
            Object uri = "https://api.swaggerhub.com/apis?limit=50";
            if (StringUtils.hasContent(searchQuery)) {
                try {
                    uri = (String)uri + "&query=" + URLEncoder.encode(searchQuery.trim(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            try {
                HttpGet get = new HttpGet((String)uri);
                CloseableHttpResponse response = HttpClientSupport.getHttpClient().execute((HttpUriRequest)get);
                List<ApiDescriptor> descriptors = new ApisJsonImporter().importApis(new String(ByteStreams.toByteArray((InputStream)response.getEntity().getContent())));
                Platform.runLater(() -> {
                    for (ApiDescriptor descriptor : descriptors) {
                        this.table.addDescription(descriptor);
                    }
                });
            }
            catch (Exception e) {
                log.error(GETTING_LIST_OF_DEFINITIONS_ERROR, (Throwable)e);
                Platform.runLater(() -> this.buildAlert(GETTING_LIST_OF_DEFINITIONS_ERROR, "Error", Alert.AlertType.ERROR).showAndWait());
            }
            finally {
                Platform.runLater(() -> {
                    this.stackPane.getChildren().remove((Object)progressIndicator);
                    this.searchButton.setDisable(false);
                });
            }
        });
    }

    private List<RestService> importApis() {
        ArrayList<RestService> result = new ArrayList<RestService>();
        try {
            SwaggerHubAPITableModel model = (SwaggerHubAPITableModel)this.table.getSelectionModel().getSelectedItem();
            ApiDescriptor descriptor = model.getDescriptor();
            String defaultVersionUrl = descriptor.swaggerUrl;
            Swagger2Importer importer = new Swagger2Importer(this.project, "application/json");
            int selectedVersion = model.getVersionCombo().getSelectionModel().getSelectedIndex();
            String oasVersion = descriptor.oasVersion;
            if (StringUtils.hasContent(oasVersion) && !oasVersion.startsWith("2.0")) {
                log.error(UNSUPPORTED_OAS_VERSION_MESSAGE);
                UISupport.showErrorMessage(UNSUPPORTED_OAS_VERSION_MESSAGE);
                return result;
            }
            String version = descriptor.versions[selectedVersion];
            if (version.startsWith("*-")) {
                version = version.substring(2).trim();
            } else if (version.startsWith("*") || version.startsWith("-")) {
                version = version.substring(1).trim();
            }
            String selectedVersionUrl = defaultVersionUrl.substring(0, defaultVersionUrl.lastIndexOf(47)) + "/" + version;
            Collections.addAll(result, importer.importSwagger(selectedVersionUrl));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void handleOk() {
        SoapUI.getThreadPool().execute(() -> {
            List<RestService> result = this.importApis();
            if (CollectionUtils.isNotEmpty(result)) {
                UISupport.selectAndShow(result.get(0));
                this.close();
            }
        });
    }

    private GridPane buildSearchForm() {
        GridPane gridPane = new GridPane();
        gridPane.setVgap(8.0);
        gridPane.setHgap(8.0);
        gridPane.setPadding(new Insets(8.0, 0.0, 8.0, 0.0));
        Label searchLabel = new Label("Search");
        gridPane.add((Node)searchLabel, 0, 0);
        gridPane.add((Node)this.searchField, 1, 0);
        gridPane.add((Node)this.searchButton, 2, 0);
        this.searchField.setPrefColumnCount(25);
        this.searchField.setOnKeyPressed(event -> {
            if (event.getCode().equals((Object)KeyCode.ENTER)) {
                this.populateList();
                event.consume();
            }
        });
        this.setTooltip("Searches on owner, name, swagger.info.title and swagger.info.description of all APIs", (Control)this.searchField);
        return gridPane;
    }

    private Label createLabel(String text) {
        Label label = new Label(text);
        label.getStyleClass().add((Object)"default-text");
        return label;
    }

    private void setTooltip(String text, Control component) {
        Tooltip tooltip = new Tooltip(text);
        component.setTooltip(tooltip);
    }

    private Alert buildAlert(String text, String title, Alert.AlertType alertType) {
        Alert alert = new Alert(alertType, text, new ButtonType[]{ButtonType.OK});
        alert.setHeaderText(title);
        alert.setTitle(title);
        DialogPane dialogPane = alert.getDialogPane();
        dialogPane.setStyle("-fx-background-color: white");
        dialogPane.getStyleClass().add((Object)"default-text");
        Stage stage = (Stage)dialogPane.getScene().getWindow();
        return alert;
    }
}

