/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.ui.support;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class DefaultDesktopPanel
implements DesktopPanel {
    private PropertyChangeSupport propertyChangeSupport;
    private String title;
    private JComponent component;
    private Set<ModelItem> depends = new HashSet<ModelItem>();
    private ImageIcon icon;
    private final String description;

    public DefaultDesktopPanel(String title, String description, JComponent component) {
        this.title = title;
        this.description = description;
        this.component = component;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public void loadIcon(String path) {
        this.icon = UISupport.createImageIcon(path);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setTitle(String title) {
        String oldTitle = this.title;
        this.title = title;
        this.propertyChangeSupport.firePropertyChange(TITLE_PROPERTY, oldTitle, title);
    }

    @Override
    public ModelItem getModelItem() {
        return null;
    }

    @Override
    public boolean onClose(boolean canCancel) {
        return true;
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return this.depends != null && this.depends.contains(modelItem);
    }

    public void addDependency(ModelItem modelItem) {
        this.depends.add(modelItem);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }
}

