/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.ui.support;

import com.eviware.soapui.impl.support.AbstractMockOperation;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatchRegistry;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatcher;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockServiceListener;
import com.eviware.soapui.model.util.ModelItemNames;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.swing.ExtendedComboBoxModel;
import com.eviware.soapui.support.swing.ModelItemListKeyListener;
import com.eviware.soapui.support.swing.ModelItemListMouseListener;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public abstract class AbstractMockOperationDesktopPanel<MockOperationType extends AbstractMockOperation>
extends ModelItemDesktopPanel<MockOperationType> {
    private JList responseList;
    private JComboBox dispatchCombo;
    private JPanel dispatchPanel;
    private JComboBox defaultResponseCombo;
    private ResponseListModel responseListModel;
    private JComponentInspector<JComponent> dispatchInspector;
    private JInspectorPanel inspectorPanel;
    private JPanel defaultResponsePanel;

    public AbstractMockOperationDesktopPanel(MockOperationType mockOperation) {
        super(mockOperation);
        this.buildUI();
        this.setPreferredSize(new Dimension(600, 440));
    }

    private void buildUI() {
        this.add(this.buildToolbar(), "North");
        this.inspectorPanel = JInspectorPanelFactory.build(this.buildResponseList());
        this.inspectorPanel.setDefaultDividerLocation(0.5f);
        this.dispatchInspector = new JComponentInspector<JComponent>(this.buildDispatchEditor(), "Dispatch (" + ((AbstractMockOperation)this.getModelItem()).getDispatchStyle().toString() + ")", "Configures current dispatch style", true);
        this.inspectorPanel.addInspector(this.dispatchInspector);
        this.inspectorPanel.activate(this.dispatchInspector);
        this.add((Component)this.inspectorPanel.getComponent(), "Center");
    }

    private JComponent buildResponseList() {
        this.responseListModel = new ResponseListModel();
        this.responseList = new JList(this.responseListModel);
        this.responseList.addKeyListener(new ModelItemListKeyListener(){

            @Override
            public ModelItem getModelItemAt(int ix) {
                return ((AbstractMockOperation)AbstractMockOperationDesktopPanel.this.getModelItem()).getMockResponseAt(ix);
            }
        });
        this.responseList.addMouseListener(new ModelItemListMouseListener(){
            private DefaultActionList defaultActions;

            @Override
            protected ActionList getDefaultActions() {
                if (this.defaultActions == null) {
                    this.defaultActions = new DefaultActionList();
                    this.defaultActions.addAction(SwingActionDelegate.createDelegate("NewMockResponseAction", (AbstractMockOperation)AbstractMockOperationDesktopPanel.this.getModelItem(), null, AbstractMockOperationDesktopPanel.this.getAddToMockOperationIconPath()));
                }
                return this.defaultActions;
            }
        });
        this.responseList.setCellRenderer(new ResponseListCellRenderer());
        JScrollPane scrollPane = new JScrollPane(this.responseList);
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("MockResponses", UISupport.buildPanelWithToolbar(this.buildMockResponseListToolbar(), scrollPane));
        return UISupport.createTabPanel(tabs, true);
    }

    protected abstract String getAddToMockOperationIconPath();

    private JComponent buildMockResponseListToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.add(UISupport.createToolbarButton(SwingActionDelegate.createDelegate("NewMockResponseAction", (AbstractMockOperation)this.getModelItem(), null, this.getAddToMockOperationIconPath())));
        return toolbar;
    }

    private JComponent buildDispatchEditor() {
        this.dispatchPanel = new JPanel(new BorderLayout());
        this.dispatchPanel.setOpaque(true);
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addFixed((JComponent)new JLabel("Dispatch: "));
        builder.addRelatedGap();
        this.dispatchCombo = new JComboBox<String>(this.getAvailableDispatchTypes());
        this.dispatchCombo.setSelectedItem(null);
        this.dispatchCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (AbstractMockOperationDesktopPanel.this.dispatchPanel.getComponentCount() > 1) {
                    AbstractMockOperationDesktopPanel.this.dispatchPanel.remove(1);
                }
                String item = (String)AbstractMockOperationDesktopPanel.this.dispatchCombo.getSelectedItem();
                MockOperationDispatcher dispatcher = ((AbstractMockOperation)AbstractMockOperationDesktopPanel.this.getModelItem()).setDispatchStyle(item);
                AbstractMockOperationDesktopPanel.this.dispatchPanel.add((Component)dispatcher.getEditorComponent(), "Center");
                AbstractMockOperationDesktopPanel.this.dispatchPanel.revalidate();
                AbstractMockOperationDesktopPanel.this.dispatchPanel.repaint();
                if (AbstractMockOperationDesktopPanel.this.dispatchInspector != null && item != null) {
                    AbstractMockOperationDesktopPanel.this.dispatchInspector.setTitle("Dispatch (" + item + ")");
                }
                AbstractMockOperationDesktopPanel.this.defaultResponsePanel.setVisible(((AbstractMockOperation)AbstractMockOperationDesktopPanel.this.getModelItem()).getDispatcher().hasDefaultResponse());
            }
        });
        builder.addFixed((JComponent)this.dispatchCombo);
        this.defaultResponsePanel = new JPanel(new BorderLayout());
        this.defaultResponsePanel.add((Component)new JLabel("Default Response: "), "West");
        ModelItemNames<MockResponse> names = new ModelItemNames<MockResponse>(((AbstractMockOperation)this.getModelItem()).getMockResponses());
        this.defaultResponseCombo = new JComboBox(new ExtendedComboBoxModel(names.getNames()));
        this.defaultResponseCombo.setPreferredSize(new Dimension(150, 20));
        this.defaultResponseCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object selectedItem = AbstractMockOperationDesktopPanel.this.defaultResponseCombo.getSelectedItem();
                ((AbstractMockOperation)AbstractMockOperationDesktopPanel.this.getModelItem()).setDefaultResponse((String)selectedItem);
            }
        });
        this.defaultResponsePanel.add((Component)this.defaultResponseCombo, "Center");
        builder.addUnrelatedGap();
        builder.addFixed((JComponent)this.defaultResponsePanel);
        this.dispatchPanel.add((Component)builder.getPanel(), "North");
        this.defaultResponseCombo.setSelectedItem(((AbstractMockOperation)this.getModelItem()).getDefaultResponse());
        this.dispatchCombo.setSelectedItem(((AbstractMockOperation)this.getModelItem()).getDispatchStyle());
        return this.dispatchPanel;
    }

    protected String[] getAvailableDispatchTypes() {
        return MockOperationDispatchRegistry.getDispatchTypes();
    }

    protected abstract Component buildToolbar();

    @Override
    public boolean onClose(boolean canCancel) {
        this.responseListModel.release();
        this.inspectorPanel.release();
        if (((AbstractMockOperation)this.getModelItem()).getDispatcher() != null) {
            ((AbstractMockOperation)this.getModelItem()).getDispatcher().releaseEditorComponent();
        }
        return this.release();
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.getModelItem() || modelItem == ((AbstractMockOperation)this.getModelItem()).getMockService() || modelItem == ((AbstractMockOperation)this.getModelItem()).getMockService().getProject();
    }

    public class ResponseListModel
    extends AbstractListModel
    implements ListModel,
    MockServiceListener,
    PropertyChangeListener {
        private List<MockResponse> responses = new ArrayList<MockResponse>();

        public ResponseListModel() {
            for (int c = 0; c < ((AbstractMockOperation)AbstractMockOperationDesktopPanel.this.getModelItem()).getMockResponseCount(); ++c) {
                Object mockResponse = ((AbstractMockOperation)AbstractMockOperationDesktopPanel.this.getModelItem()).getMockResponseAt(c);
                mockResponse.addPropertyChangeListener(this);
                this.responses.add((MockResponse)mockResponse);
            }
            ((AbstractMockOperation)AbstractMockOperationDesktopPanel.this.getModelItem()).getMockService().addMockServiceListener(this);
        }

        public Object getElementAt(int arg0) {
            return this.responses.get(arg0);
        }

        @Override
        public int getSize() {
            return this.responses.size();
        }

        @Override
        public void mockOperationAdded(MockOperation operation) {
        }

        @Override
        public void mockOperationRemoved(MockOperation operation) {
        }

        @Override
        public void mockResponseAdded(MockResponse response) {
            if (response.getMockOperation() != AbstractMockOperationDesktopPanel.this.getModelItem()) {
                return;
            }
            this.responses.add(response);
            response.addPropertyChangeListener(this);
            this.fireIntervalAdded(this, this.responses.size() - 1, this.responses.size() - 1);
            AbstractMockOperationDesktopPanel.this.defaultResponseCombo.addItem(response.getName());
        }

        @Override
        public void mockResponseRemoved(MockResponse response) {
            if (response.getMockOperation() != AbstractMockOperationDesktopPanel.this.getModelItem()) {
                return;
            }
            int ix = this.responses.indexOf(response);
            this.responses.remove(ix);
            response.removePropertyChangeListener(this);
            this.fireIntervalRemoved(this, ix, ix);
            AbstractMockOperationDesktopPanel.this.defaultResponseCombo.removeItem(response.getName());
        }

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            if (arg0.getPropertyName().equals(ModelItem.NAME_PROPERTY)) {
                int ix = this.responses.indexOf(arg0.getSource());
                this.fireContentsChanged(this, ix, ix);
                ExtendedComboBoxModel model = (ExtendedComboBoxModel)AbstractMockOperationDesktopPanel.this.defaultResponseCombo.getModel();
                model.setElementAt(arg0.getNewValue(), ix);
                if (model.getSelectedItem().equals(arg0.getOldValue())) {
                    model.setSelectedItem(arg0.getNewValue());
                }
            }
        }

        public void release() {
            for (MockResponse response : this.responses) {
                response.removePropertyChangeListener(this);
            }
            ((AbstractMockOperation)AbstractMockOperationDesktopPanel.this.getModelItem()).getMockService().removeMockServiceListener(this);
        }
    }

    private static final class ResponseListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ResponseListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            MockResponse testStep = (MockResponse)value;
            this.setText(testStep.getName());
            this.setIcon(testStep.getIcon());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            return this;
        }
    }
}

