/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.ui.navigator.state;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.tree.SoapUITreeModel;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.plugins.factories.navigator.NavigatorNodesExpandStateProvider;
import com.eviware.soapui.plugins.factories.navigator.NavigatroNodeExpandStateProviderFactory;
import com.eviware.soapui.ui.navigator.state.NavigatorTreeExpanedListener;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class NavigatorNodesExpandStateEngine {
    private JTree navigatorTree;
    private NavigatorNodesExpandStateProvider navigatorNodesExpandStateProvider;
    private NavigatorTreeExpanedListener treeExpansionListener;

    private void restoreNodeHistoricalState(SoapUITreeNode currentNode, SoapUITreeModel soapUITreeModel) {
        ModelItem modelItem = currentNode.getModelItem();
        boolean isExpanded = this.navigatorNodesExpandStateProvider.isExpanded(modelItem);
        if (!isExpanded) {
            return;
        }
        TreePath treePath = soapUITreeModel.getPath(currentNode);
        this.navigatorTree.expandPath(treePath);
        int childCount = currentNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.restoreNodeHistoricalState(currentNode.getChildNode(i), soapUITreeModel);
        }
    }

    private void restoreNodeHistoricalState(SoapUITreeNode node) {
        SoapUITreeModel soapUITreeModel = (SoapUITreeModel)this.navigatorTree.getModel();
        this.restoreNodeHistoricalState(node, soapUITreeModel);
    }

    private void restoreExpandedState(JTree tree) {
        TreeModel treeModel = tree.getModel();
        if (treeModel == null || !(treeModel instanceof SoapUITreeModel)) {
            return;
        }
        SoapUITreeModel soapUITreeModel = (SoapUITreeModel)treeModel;
        Object rootObject = treeModel.getRoot();
        if (rootObject == null || !(rootObject instanceof SoapUITreeNode)) {
            return;
        }
        SoapUITreeNode rootNode = (SoapUITreeNode)rootObject;
        int childNodesAmount = rootNode.getChildCount();
        for (int i = 0; i < childNodesAmount; ++i) {
            this.restoreNodeHistoricalState(rootNode.getChildNode(i), soapUITreeModel);
        }
    }

    private NavigatorNodesExpandStateProvider getNavigatorNodesExpandStateProvider() {
        List<NavigatroNodeExpandStateProviderFactory> stateProviderFactoryList = SoapUI.getFactoryRegistry().getFactories(NavigatroNodeExpandStateProviderFactory.class);
        if (stateProviderFactoryList.size() == 0) {
            return null;
        }
        NavigatroNodeExpandStateProviderFactory providerFactory = stateProviderFactoryList.get(0);
        NavigatorNodesExpandStateProvider result = providerFactory.create();
        return result;
    }

    public void initialize(JTree navigatorTree) {
        this.navigatorNodesExpandStateProvider = this.getNavigatorNodesExpandStateProvider();
        if (this.navigatorNodesExpandStateProvider == null) {
            return;
        }
        this.navigatorTree = navigatorTree;
        this.restoreExpandedState(navigatorTree);
        this.treeExpansionListener = new NavigatorTreeExpanedListener(this);
        navigatorTree.addTreeExpansionListener(this.treeExpansionListener);
    }

    void setExpandedState(SoapUITreeNode node, boolean expand) {
        ModelItem modelItem = node.getModelItem();
        this.navigatorNodesExpandStateProvider.setExpandedState(modelItem, expand);
        if (expand) {
            this.restoreNodeHistoricalState(node);
        }
    }
}

