/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.ui.desktop.standalone;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.PanelBuilder;
import com.eviware.soapui.model.util.PanelBuilderRegistry;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.ui.desktop.AbstractSoapUIDesktop;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.eviware.soapui.ui.desktop.SoapUIDesktop;
import com.eviware.soapui.ui.desktop.standalone.MostRecentlyUsedOrderDesktopManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class StandaloneDesktop
extends AbstractSoapUIDesktop {
    private JDesktopPane desktop;
    private Map<ModelItem, JInternalFrame> modelItemToInternalFrameMap = new HashMap<ModelItem, JInternalFrame>();
    private Map<JInternalFrame, DesktopPanel> internalFrameToDesktopPanelMap = new HashMap<JInternalFrame, DesktopPanel>();
    private DesktopPanelPropertyChangeListener desktopPanelPropertyChangeListener = new DesktopPanelPropertyChangeListener();
    private InternalDesktopFrameListener internalFrameListener = new InternalDesktopFrameListener();
    private ActionList actions;
    private DesktopPanel currentPanel;
    private CloseCurrentAction closeCurrentAction = new CloseCurrentAction();
    private CloseOtherAction closeOtherAction = new CloseOtherAction();
    private CloseAllAction closeAllAction = new CloseAllAction();
    private static final int xOffset = 30;
    private static final int yOffset = 30;
    private boolean transferring;
    private List<DesktopPanel> deferredDesktopPanels = new LinkedList<DesktopPanel>();
    private JInspectorPanel inspector;
    private JPanel inspectorPanel;

    public StandaloneDesktop(Workspace workspace) {
        super(workspace);
        this.buildUI();
        this.actions = new DefaultActionList("Desktop");
        this.actions.addAction(this.closeCurrentAction);
        this.actions.addAction(this.closeOtherAction);
        this.actions.addAction(this.closeAllAction);
        this.desktop.setBackground(UISupport.MAC_BACKGROUND_COLOR);
        this.enableWindowActions();
        this.desktop.addComponentListener(new DesktopResizeListener());
        DesktopManager originalDesktopManager = this.desktop.getDesktopManager();
        boolean mruSelectionChosen = SoapUI.isSelectingMostRecentlyUsedDesktopPanelOnClose();
        DesktopManager delegate = mruSelectionChosen ? new MostRecentlyUsedOrderDesktopManager(originalDesktopManager) : originalDesktopManager;
        this.desktop.setDesktopManager(new BoundsAwareDesktopManager(delegate));
    }

    private void enableWindowActions() {
        this.closeCurrentAction.setEnabled(this.currentPanel != null && this.internalFrameToDesktopPanelMap.size() > 0);
        this.closeOtherAction.setEnabled(this.currentPanel != null && this.internalFrameToDesktopPanelMap.size() > 1);
        this.closeAllAction.setEnabled(this.internalFrameToDesktopPanelMap.size() > 0);
    }

    private void buildUI() {
        this.desktop = new SoapUIDesktopPane();
        JScrollPane scrollPane = new JScrollPane(this.desktop);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.inspector = JInspectorPanelFactory.build(scrollPane, 4);
        this.inspectorPanel = new JPanel(new BorderLayout());
        this.inspector.addInspector(new JComponentInspector<JPanel>(this.inspectorPanel, "Inspector", "Object Inspector", true));
        this.inspector.setDefaultDividerLocation(0.75f);
    }

    @Override
    public JComponent getDesktopComponent() {
        return this.inspector.getComponent();
    }

    @Override
    public void showInspector(JComponent component) {
        this.inspectorPanel.removeAll();
        this.inspectorPanel.add((Component)component, "Center");
        this.inspectorPanel.repaint();
        this.inspector.setCurrentInspector("Inspector");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closeDesktopPanel(DesktopPanel desktopPanel) {
        try {
            if (desktopPanel.getModelItem() != null) {
                boolean bl = this.closeDesktopPanel(desktopPanel.getModelItem());
                return bl;
            }
            JInternalFrame frame = this.getFrameForDesktopPanel(desktopPanel);
            if (frame != null) {
                frame.doDefaultCloseAction();
                boolean bl = frame.isClosed();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.enableWindowActions();
        }
    }

    private JInternalFrame getFrameForDesktopPanel(DesktopPanel desktopPanel) {
        for (JInternalFrame frame : this.internalFrameToDesktopPanelMap.keySet()) {
            if (this.internalFrameToDesktopPanelMap.get(frame) != desktopPanel) continue;
            return frame;
        }
        return null;
    }

    @Override
    public boolean hasDesktopPanel(ModelItem modelItem) {
        return this.modelItemToInternalFrameMap.containsKey(modelItem);
    }

    @Override
    public DesktopPanel showDesktopPanel(ModelItem modelItem) {
        PanelBuilder<ModelItem> panelBuilder = PanelBuilderRegistry.getPanelBuilder(modelItem);
        if (this.modelItemToInternalFrameMap.containsKey(modelItem)) {
            JInternalFrame frame = this.modelItemToInternalFrameMap.get(modelItem);
            try {
                this.desktop.getDesktopManager().deiconifyFrame(frame);
                frame.setSelected(true);
                frame.moveToFront();
                this.currentPanel = this.internalFrameToDesktopPanelMap.get(frame);
            }
            catch (PropertyVetoException e) {
                SoapUI.logError(e);
            }
        } else if (panelBuilder != null && panelBuilder.hasDesktopPanel()) {
            DesktopPanel desktopPanel = panelBuilder.buildDesktopPanel(modelItem);
            if (desktopPanel == null) {
                return null;
            }
            JInternalFrame frame = this.createContentFrame(desktopPanel);
            this.desktop.add(frame);
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException e) {
                SoapUI.logError(e);
            }
            this.modelItemToInternalFrameMap.put(modelItem, frame);
            this.internalFrameToDesktopPanelMap.put(frame, desktopPanel);
            this.fireDesktopPanelCreated(desktopPanel);
            this.currentPanel = desktopPanel;
            desktopPanel.getComponent().requestFocusInWindow();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        this.enableWindowActions();
        return this.currentPanel;
    }

    private JInternalFrame createContentFrame(DesktopPanel desktopPanel) {
        desktopPanel.addPropertyChangeListener(this.desktopPanelPropertyChangeListener);
        JComponent panel = desktopPanel.getComponent();
        panel.setOpaque(true);
        String title = desktopPanel.getTitle();
        JInternalFrame frame = new JInternalFrame(title, true, true, true, true);
        frame.addInternalFrameListener(this.internalFrameListener);
        frame.setContentPane(panel);
        frame.setLocation(30 * (this.desktop.getComponentCount() % 10), 30 * (this.desktop.getComponentCount() % 10));
        Point location = frame.getLocation();
        Dimension frameSize = this.calculateDesktopPanelSize(panel, location);
        frame.setSize(frameSize);
        frame.setVisible(true);
        frame.setFrameIcon(desktopPanel.getIcon());
        frame.setToolTipText(desktopPanel.getDescription());
        frame.setDefaultCloseOperation(0);
        if (!SoapUI.getSettings().getBoolean(UISettings.NATIVE_LAF)) {
            frame.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        } else if (!UISupport.isMac()) {
            frame.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 3));
        }
        return frame;
    }

    private Dimension calculateDesktopPanelSize(JComponent panel, Point location) {
        Dimension preferredSize = panel.getPreferredSize();
        Dimension frameSize = this.desktop.getBounds().contains(new Rectangle(location, preferredSize)) ? preferredSize : new Dimension((int)((double)(this.desktop.getWidth() - location.x) * 0.95), (int)((double)(this.desktop.getHeight() - location.y) * 0.95));
        return frameSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closeDesktopPanel(ModelItem modelItem) {
        try {
            if (this.modelItemToInternalFrameMap.containsKey(modelItem)) {
                JInternalFrame frame = this.modelItemToInternalFrameMap.get(modelItem);
                frame.doDefaultCloseAction();
                boolean bl = frame.isClosed();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.enableWindowActions();
        }
    }

    @Override
    public ActionList getActions() {
        return this.actions;
    }

    @Override
    public DesktopPanel[] getDesktopPanels() {
        return this.internalFrameToDesktopPanelMap.values().toArray(new DesktopPanel[this.internalFrameToDesktopPanelMap.size()]);
    }

    @Override
    public DesktopPanel getDesktopPanel(ModelItem modelItem) {
        for (DesktopPanel panel : this.internalFrameToDesktopPanelMap.values()) {
            if (panel.getModelItem() != modelItem) continue;
            return panel;
        }
        return null;
    }

    @Override
    public DesktopPanel showDesktopPanel(DesktopPanel desktopPanel) {
        if (this.desktop.getBounds().width == 0) {
            this.deferredDesktopPanels.add(desktopPanel);
            return desktopPanel;
        }
        JInternalFrame frame = this.getFrameForDesktopPanel(desktopPanel);
        if (frame != null) {
            try {
                this.desktop.getDesktopManager().deiconifyFrame(frame);
                frame.setSelected(true);
                frame.moveToFront();
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        } else {
            frame = this.createContentFrame(desktopPanel);
            this.desktop.add(frame);
            if (desktopPanel.getModelItem() != null) {
                this.modelItemToInternalFrameMap.put(desktopPanel.getModelItem(), frame);
            }
            this.internalFrameToDesktopPanelMap.put(frame, desktopPanel);
            this.fireDesktopPanelCreated(desktopPanel);
            frame.moveToFront();
            desktopPanel.getComponent().requestFocusInWindow();
        }
        this.currentPanel = desktopPanel;
        this.enableWindowActions();
        return desktopPanel;
    }

    @Override
    public void transferTo(SoapUIDesktop newDesktop) {
        this.transferring = true;
        ArrayList<DesktopPanel> values = new ArrayList<DesktopPanel>(this.internalFrameToDesktopPanelMap.values());
        for (DesktopPanel desktopPanel : values) {
            this.closeDesktopPanel(desktopPanel);
            newDesktop.showDesktopPanel(desktopPanel);
        }
        this.transferring = false;
    }

    @Override
    public boolean closeAll() {
        JInternalFrame[] allFrames;
        while (this.internalFrameToDesktopPanelMap.size() > 0) {
            Iterator<JInternalFrame> i = this.internalFrameToDesktopPanelMap.keySet().iterator();
            try {
                i.next().setClosed(true);
            }
            catch (PropertyVetoException e1) {
                SoapUI.logError(e1);
            }
        }
        this.internalFrameToDesktopPanelMap.clear();
        this.modelItemToInternalFrameMap.clear();
        for (JInternalFrame frame : allFrames = this.desktop.getAllFrames()) {
            frame.doDefaultCloseAction();
        }
        this.enableWindowActions();
        return true;
    }

    @Override
    public void minimize(DesktopPanel desktopPanel) {
        try {
            this.getFrameForDesktopPanel(desktopPanel).setIcon(true);
        }
        catch (PropertyVetoException e) {
            SoapUI.logError(e);
        }
    }

    @Override
    public void maximize(DesktopPanel desktopPanel) {
        this.desktop.getDesktopManager().maximizeFrame(this.getFrameForDesktopPanel(desktopPanel));
    }

    private class DesktopPanelPropertyChangeListener
    implements PropertyChangeListener {
        private DesktopPanelPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DesktopPanel desktopPanel = (DesktopPanel)evt.getSource();
            JInternalFrame frame = StandaloneDesktop.this.getFrameForDesktopPanel(desktopPanel);
            if (frame != null) {
                if (evt.getPropertyName().equals(DesktopPanel.TITLE_PROPERTY)) {
                    frame.setTitle(desktopPanel.getTitle());
                } else if (evt.getPropertyName().equals(DesktopPanel.ICON_PROPERTY)) {
                    frame.setFrameIcon(desktopPanel.getIcon());
                }
            }
        }
    }

    private class InternalDesktopFrameListener
    extends InternalFrameAdapter {
        private InternalDesktopFrameListener() {
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent e) {
            DesktopPanel desktopPanel = (DesktopPanel)StandaloneDesktop.this.internalFrameToDesktopPanelMap.get(e.getInternalFrame());
            if (!StandaloneDesktop.this.transferring && !desktopPanel.onClose(true)) {
                return;
            }
            desktopPanel.removePropertyChangeListener(StandaloneDesktop.this.desktopPanelPropertyChangeListener);
            StandaloneDesktop.this.modelItemToInternalFrameMap.remove(desktopPanel.getModelItem());
            StandaloneDesktop.this.internalFrameToDesktopPanelMap.remove(e.getInternalFrame());
            e.getInternalFrame().setContentPane(new JPanel());
            e.getInternalFrame().dispose();
            if (!StandaloneDesktop.this.transferring) {
                StandaloneDesktop.this.fireDesktopPanelClosed(desktopPanel);
            }
            if (StandaloneDesktop.this.currentPanel == desktopPanel) {
                StandaloneDesktop.this.currentPanel = null;
            }
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            StandaloneDesktop.this.currentPanel = (DesktopPanel)StandaloneDesktop.this.internalFrameToDesktopPanelMap.get(e.getInternalFrame());
            if (StandaloneDesktop.this.currentPanel != null) {
                StandaloneDesktop.this.fireDesktopPanelSelected(StandaloneDesktop.this.currentPanel);
            }
            StandaloneDesktop.this.enableWindowActions();
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent e) {
            StandaloneDesktop.this.currentPanel = null;
            StandaloneDesktop.this.enableWindowActions();
        }
    }

    public class CloseCurrentAction
    extends AbstractAction {
        public CloseCurrentAction() {
            super("Close Current");
            this.putValue("ShortDescription", "Closes the current window");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu F4"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JInternalFrame frame = StandaloneDesktop.this.desktop.getSelectedFrame();
            if (frame != null) {
                StandaloneDesktop.this.closeDesktopPanel((DesktopPanel)StandaloneDesktop.this.internalFrameToDesktopPanelMap.get(frame));
            }
        }
    }

    public class CloseOtherAction
    extends AbstractAction {
        public CloseOtherAction() {
            super("Close Others");
            this.putValue("ShortDescription", "Closes all windows except the current one");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu alt O"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JInternalFrame[] frames;
            JInternalFrame frame = StandaloneDesktop.this.desktop.getSelectedFrame();
            if (frame == null) {
                return;
            }
            for (JInternalFrame f : frames = StandaloneDesktop.this.internalFrameToDesktopPanelMap.keySet().toArray(new JInternalFrame[StandaloneDesktop.this.internalFrameToDesktopPanelMap.size()])) {
                if (f == frame) continue;
                StandaloneDesktop.this.closeDesktopPanel((DesktopPanel)StandaloneDesktop.this.internalFrameToDesktopPanelMap.get(f));
            }
        }
    }

    public class CloseAllAction
    extends AbstractAction {
        public CloseAllAction() {
            super("Close All");
            this.putValue("ShortDescription", "Closes all windows");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu alt L"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StandaloneDesktop.this.closeAll();
        }
    }

    private class DesktopResizeListener
    implements ComponentListener {
        private DesktopResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Iterator iterator = StandaloneDesktop.this.deferredDesktopPanels.iterator();
            while (iterator.hasNext()) {
                DesktopPanel nextPanel = (DesktopPanel)iterator.next();
                StandaloneDesktop.this.showDesktopPanel(nextPanel);
                iterator.remove();
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }

    private class BoundsAwareDesktopManager
    implements DesktopManager {
        private DesktopManager delegate;
        private int horizontalInsetFactor = 6;
        private int verticalInsetFactor = 6;
        private Dimension desktopSize;

        private BoundsAwareDesktopManager(DesktopManager delegate) {
            this.delegate = delegate;
            this.desktopSize = StandaloneDesktop.this.desktop.getSize();
            if (UISupport.isMac()) {
                this.horizontalInsetFactor = 3;
                this.verticalInsetFactor = 1;
            }
        }

        @Override
        public void dragFrame(JComponent f, int newX, int newY) {
            if (this.outsideDesktop(f, newX, newY)) {
                Point positionWherePanelReachable = this.findPositionWherePanelReachable(f, newX, newY);
                this.delegate.dragFrame(f, positionWherePanelReachable.x, positionWherePanelReachable.y);
            } else {
                this.delegate.dragFrame(f, newX, newY);
            }
        }

        @Override
        public void setBoundsForFrame(JComponent desktopPanel, int newX, int newY, int newWidth, int newHeight) {
            if (this.outsideDesktop(desktopPanel, newX, newY)) {
                Point pointInsideDesktop = this.findPositionInsideDesktop(desktopPanel, newX, newY);
                this.delegate.setBoundsForFrame(desktopPanel, pointInsideDesktop.x, pointInsideDesktop.y, newWidth, newHeight);
            } else {
                this.delegate.setBoundsForFrame(desktopPanel, newX, newY, newWidth, newHeight);
            }
        }

        @Override
        public void openFrame(JInternalFrame f) {
            this.delegate.openFrame(f);
        }

        @Override
        public void closeFrame(JInternalFrame f) {
            this.delegate.closeFrame(f);
        }

        @Override
        public void maximizeFrame(JInternalFrame f) {
            this.delegate.maximizeFrame(f);
        }

        @Override
        public void minimizeFrame(JInternalFrame f) {
            this.delegate.minimizeFrame(f);
        }

        @Override
        public void iconifyFrame(JInternalFrame f) {
            this.delegate.iconifyFrame(f);
        }

        @Override
        public void deiconifyFrame(JInternalFrame f) {
            this.delegate.deiconifyFrame(f);
        }

        @Override
        public void activateFrame(JInternalFrame f) {
            this.delegate.activateFrame(f);
        }

        @Override
        public void deactivateFrame(JInternalFrame f) {
            this.delegate.deactivateFrame(f);
        }

        @Override
        public void beginDraggingFrame(JComponent f) {
            this.desktopSize = StandaloneDesktop.this.desktop.getSize();
            this.delegate.beginDraggingFrame(f);
        }

        @Override
        public void endDraggingFrame(JComponent f) {
            this.delegate.endDraggingFrame(f);
        }

        @Override
        public void beginResizingFrame(JComponent f, int direction) {
            this.delegate.beginResizingFrame(f, direction);
        }

        @Override
        public void resizeFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
            this.delegate.resizeFrame(f, newX, newY, newWidth, newHeight);
        }

        @Override
        public void endResizingFrame(JComponent f) {
            this.delegate.endResizingFrame(f);
        }

        private boolean outsideDesktop(JComponent panel, int newX, int newY) {
            int smallestReachableX = -(panel.getWidth() - this.horizontalInsetFactor * panel.getInsets().right);
            int biggestReachableX = (int)this.desktopSize.getWidth() - this.horizontalInsetFactor * panel.getInsets().left;
            int biggestReachableY = (int)this.desktopSize.getHeight() - this.verticalInsetFactor * panel.getInsets().top;
            boolean xCoordinateOutside = newX > biggestReachableX || newX < smallestReachableX;
            boolean yCoordinateOutside = newY < 0 || newY > biggestReachableY;
            return xCoordinateOutside || yCoordinateOutside;
        }

        private Point findPositionWherePanelReachable(JComponent panel, int newX, int newY) {
            int smallestReachableX = -(panel.getWidth() - this.horizontalInsetFactor * panel.getInsets().right);
            int biggestReachableX = (int)this.desktopSize.getWidth() - this.horizontalInsetFactor * panel.getInsets().left;
            int biggestReachableY = (int)this.desktopSize.getHeight() - this.verticalInsetFactor * panel.getInsets().top;
            int boundedX = newX <= 0 ? Math.max(smallestReachableX, newX) : Math.min(biggestReachableX, newX);
            int boundedY = newY <= 0 ? 0 : Math.min(biggestReachableY, newY);
            return new Point(boundedX, boundedY);
        }

        private Point findPositionInsideDesktop(JComponent f, int newX, int newY) {
            Container desktop = f.getParent();
            Dimension desktopSize = desktop.getSize();
            int boundedX = (int)Math.min((double)Math.max(0, newX), desktopSize.getWidth());
            int boundedY = (int)Math.min((double)Math.max(0, newY), desktopSize.getHeight());
            return new Point(boundedX, boundedY);
        }
    }

    class SoapUIDesktopPane
    extends JDesktopPane {
        Image img;
        private int imageWidth;
        private int imageHeight;

        public SoapUIDesktopPane() {
            try {
                File file = new File("soapui-background.gif");
                if (!file.exists()) {
                    file = new File("soapui-background.jpg");
                }
                if (!file.exists()) {
                    file = new File("/soapui-background.png");
                }
                if (file.exists()) {
                    this.img = ImageIO.read(file);
                    this.imageWidth = this.img.getWidth(this);
                    this.imageHeight = this.img.getHeight(this);
                }
            }
            catch (Exception e) {
                SoapUI.logError(e, "Could not load graphics for desktop");
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.img == null) {
                return;
            }
            int x = (this.getWidth() - this.imageWidth) / 2;
            int y = (this.getHeight() - this.imageHeight) / 2;
            g.drawImage(this.img, x, y, this.imageWidth, this.imageHeight, this);
        }
    }
}

