/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.tools;

import com.eviware.soapui.DefaultSoapUICore;
import com.eviware.soapui.SoapUI;
import com.eviware.soapui.SoapUICore;
import com.eviware.soapui.SoapUIExtensionClassLoader;
import com.eviware.soapui.StandaloneSoapUICore;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.submit.filters.GlobalHttpHeadersRequestFilter;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.tools.CmdLineRunner;
import com.smartbear.soapui.core.Logging;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.layout.PatternLayout;

public abstract class AbstractSoapUIRunner
implements CmdLineRunner {
    public static final int NORMAL_TERMINATION = 0;
    public static final int ABNORMAL_TERMINATION = -1;
    public static final int PROJECT_NOT_FOUND_EXIT_CODE = 1;
    private boolean groovyLogInitialized;
    private String projectFile;
    protected final Logger log = LogManager.getLogger(this.getClass());
    private String settingsFile;
    private String soapUISettingsPassword;
    private String projectPassword;
    private int exitCode = 0;
    private boolean enableUI;
    private String outputFolder;
    private String[] projectProperties;
    private Map<String, String> runnerGlobalProperties = new HashMap<String, String>();

    public AbstractSoapUIRunner(String title) {
        if (title != null) {
            System.out.println(title);
        }
        SoapUI.setCmdLineRunner(this);
    }

    protected void initGroovyLog() {
        if (!this.groovyLogInitialized) {
            this.ensureConsoleAppenderIsDefined(LogManager.getLogger((String)"groovy.log"));
            this.groovyLogInitialized = true;
        }
    }

    protected void ensureConsoleAppenderIsDefined(Logger logger) {
        if (logger != null) {
            Map appenderMap = ((org.apache.logging.log4j.core.Logger)logger).getAppenders();
            for (Map.Entry appenderEntry : appenderMap.entrySet()) {
                if (!(appenderEntry.getValue() instanceof ConsoleAppender)) continue;
                return;
            }
            PatternLayout patternLayout = PatternLayout.newBuilder().withPattern("%d{ABSOLUTE} %-5p [%c{1}] %m%n").build();
            ConsoleAppender consoleAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("ConsoleAppender")).setLayout((Layout)patternLayout)).build();
            Logging.addAppender(logger.getName(), (Appender)consoleAppender);
        }
    }

    public int runFromCommandLine(String[] args) {
        if (this.validateCommandLineArgument(args)) {
            this.exitCode = this.run(args);
        }
        if (this.exitCode == 0) {
            return this.exitCode;
        }
        if (this.exitCode != 1) {
            this.exitCode = -1;
        }
        return this.exitCode;
    }

    public boolean validateCommandLineArgument(String[] args) {
        boolean commandLineArgumentsAreValid = false;
        try {
            commandLineArgumentsAreValid = this.initFromCommandLine(args, true);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            SoapUI.logError(e);
        }
        return commandLineArgumentsAreValid;
    }

    public int run(String[] args) {
        try {
            if (this.run()) {
                return 0;
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            SoapUI.logError(e);
        }
        return -1;
    }

    public boolean initFromCommandLine(String[] args, boolean printHelp) throws Exception {
        PosixParser parser = new PosixParser();
        SoapUIOptions options = this.initCommandLineOptions();
        CommandLine cmd = parser.parse((Options)options, args);
        if (this.requiresProjectArgument(cmd)) {
            args = cmd.getArgs();
            if (args.length != 1) {
                if (printHelp) {
                    HelpFormatter formatter = new HelpFormatter();
                    formatter.printHelp(options.getRunnerName() + " [options] <soapui-project-file>", (Options)options);
                }
                System.err.println("Missing SoapUI project file..");
                return false;
            }
            String projectFile = args[0];
            boolean projectFileExists = false;
            try {
                projectFileExists = Files.exists(Paths.get(projectFile, new String[0]), new LinkOption[0]);
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
            if (!projectFileExists) {
                System.err.println(String.format("The specified project file '%s' doesn't exist.", projectFile));
                this.exitCode = 1;
                return false;
            }
            this.setProjectFile(projectFile);
        }
        return this.processCommandLine(cmd);
    }

    protected boolean requiresProjectArgument(CommandLine cmd) {
        return true;
    }

    public final boolean run() throws Exception {
        if (SoapUI.getSoapUICore() == null) {
            SoapUI.setSoapUICore(this.createSoapUICore(), true);
            SoapUI.initGCTimer();
        }
        for (String name : this.runnerGlobalProperties.keySet()) {
            PropertyExpansionUtils.getGlobalProperties().setPropertyValue(name, this.runnerGlobalProperties.get(name));
        }
        SoapUIExtensionClassLoader.SoapUIClassLoaderState state = SoapUIExtensionClassLoader.ensure();
        try {
            boolean bl = this.runRunner();
            return bl;
        }
        finally {
            state.restore();
        }
    }

    protected SoapUICore createSoapUICore() {
        if (this.enableUI) {
            StandaloneSoapUICore core = new StandaloneSoapUICore(this.settingsFile);
            this.log.info("Enabling UI Components");
            core.prepareUI();
            UISupport.setMainFrame(null);
            return core;
        }
        return new DefaultSoapUICore(null, this.settingsFile, this.soapUISettingsPassword);
    }

    protected abstract boolean processCommandLine(CommandLine var1);

    protected abstract SoapUIOptions initCommandLineOptions();

    protected abstract boolean runRunner() throws Exception;

    protected String getCommandLineOptionSubstSpace(CommandLine cmd, String key) {
        return cmd.getOptionValue(key).replaceAll("%20", " ");
    }

    @Override
    public String getProjectFile() {
        return this.projectFile;
    }

    @Override
    public String getSettingsFile() {
        return this.settingsFile;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    @Override
    public String getOutputFolder() {
        return this.outputFolder;
    }

    public String getAbsoluteOutputFolder(ModelItem modelItem) {
        String folder = PropertyExpander.expandProperties(modelItem, this.outputFolder);
        if (StringUtils.isNullOrEmpty(folder)) {
            folder = PathUtils.getExpandedResourceRoot(modelItem);
        } else if (PathUtils.isRelativePath(folder)) {
            folder = PathUtils.resolveResourcePath(folder, modelItem);
        }
        return folder;
    }

    public String getModelItemOutputFolder(ModelItem modelItem) {
        ArrayList<ModelItem> chain = new ArrayList<ModelItem>();
        ModelItem p = modelItem;
        while (!(p instanceof Project)) {
            chain.add(0, p);
            p = p.getParent();
        }
        File dir = new File(this.getAbsoluteOutputFolder(modelItem));
        dir.mkdir();
        for (ModelItem item : chain) {
            dir = new File(dir, StringUtils.createFileName(item.getName(), '-'));
            dir.mkdir();
        }
        return dir.getAbsolutePath();
    }

    protected void ensureOutputFolder(ModelItem modelItem) {
        this.ensureFolder(this.getAbsoluteOutputFolder(modelItem));
    }

    public void ensureFolder(String path) {
        if (path == null) {
            return;
        }
        File folder = new File(path);
        if (!folder.exists() || !folder.isDirectory()) {
            folder.mkdirs();
        }
    }

    public void setProjectFile(String projectFile) {
        this.projectFile = projectFile;
    }

    public void setSettingsFile(String settingsFile) {
        this.settingsFile = settingsFile;
    }

    public void setEnableUI(boolean enableUI) {
        this.enableUI = enableUI;
    }

    public String getSoapUISettingsPassword() {
        return this.soapUISettingsPassword;
    }

    public void setSoapUISettingsPassword(String soapUISettingsPassword) {
        this.soapUISettingsPassword = soapUISettingsPassword;
    }

    public void setSystemProperties(String[] optionValues) {
        for (String option : optionValues) {
            int ix = option.indexOf(61);
            if (ix == -1) continue;
            System.setProperty(option.substring(0, ix), option.substring(ix + 1));
        }
    }

    public void setCustomHeaders(String[] optionValues) {
        for (String option : optionValues) {
            int ix = option.indexOf(61);
            if (ix == -1) continue;
            String name = option.substring(0, ix);
            String value = option.substring(ix + 1);
            this.log.info("Adding global HTTP Header [" + name + "] = [" + value + "]");
            GlobalHttpHeadersRequestFilter.addGlobalHeader(name, value);
        }
    }

    public void setGlobalProperties(String[] optionValues) {
        for (String option : optionValues) {
            int ix = option.indexOf(61);
            if (ix == -1) continue;
            String name = option.substring(0, ix);
            String value = option.substring(ix + 1);
            this.log.info("Setting global property [" + name + "] to [" + value + "]");
            this.runnerGlobalProperties.put(name, value);
        }
    }

    public void setProjectProperties(String[] projectProperties) {
        this.projectProperties = projectProperties;
    }

    @Override
    public Logger getLog() {
        return this.log;
    }

    @Override
    public String[] getProjectProperties() {
        return this.projectProperties;
    }

    protected void initProjectProperties(WsdlProject project) {
        if (this.projectProperties != null) {
            for (String option : this.projectProperties) {
                int ix = option.indexOf(61);
                if (ix == -1) continue;
                String name = option.substring(0, ix);
                String value = option.substring(ix + 1);
                this.log.info("Setting project property [" + name + "] to [" + value + "]");
                project.setPropertyValue(name, value);
            }
        }
    }

    public boolean isEnableUI() {
        return this.enableUI;
    }

    public String getProjectPassword() {
        return this.projectPassword;
    }

    public void setProjectPassword(String projectPassword) {
        this.projectPassword = projectPassword;
    }

    public static class SoapUIOptions
    extends Options {
        private final String runnerName;

        public SoapUIOptions(String runnerName) {
            this.runnerName = runnerName;
        }

        public String getRunnerName() {
            return this.runnerName;
        }
    }
}

